/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.security.DSpaceRestPermission;
import org.dspace.app.rest.security.OrcidQueueAndHistoryRestPermissionEvaluatorPlugin;
import org.dspace.app.rest.security.RestObjectPermissionEvaluatorPlugin;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.services.RequestService;
import org.dspace.services.model.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class OrcidQueueSearchRestPermissionEvaluatorPlugin
extends RestObjectPermissionEvaluatorPlugin {
    private static final Logger log = LoggerFactory.getLogger(OrcidQueueAndHistoryRestPermissionEvaluatorPlugin.class);
    public static final String ORCID_QUEUE_SEARCH = "ORCID_QUEUE_SEARCH";
    @Autowired
    private RequestService requestService;
    @Autowired
    private ItemService itemService;

    @Override
    public boolean hasDSpacePermission(Authentication authentication, Serializable targetId, String targetType, DSpaceRestPermission permission) {
        DSpaceRestPermission restPermission = DSpaceRestPermission.convert((Object)permission);
        if (!DSpaceRestPermission.READ.equals((Object)restPermission)) {
            return false;
        }
        if (!targetType.equals(ORCID_QUEUE_SEARCH)) {
            return false;
        }
        Request request = this.requestService.getCurrentRequest();
        Context context = ContextUtil.obtainContext(request.getHttpServletRequest());
        EPerson ePerson = null;
        try {
            ePerson = context.getCurrentUser();
            UUID ownerUUID = UUID.fromString(targetId.toString());
            Item owner = (Item)this.itemService.find(context, ownerUUID);
            if (ePerson == null) {
                return false;
            }
            if (owner == null || StringUtils.isBlank((CharSequence)targetId.toString()) || ownerUUID == null) {
                return false;
            }
            if (this.hasAccess(ePerson, owner)) {
                return true;
            }
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private boolean hasAccess(EPerson ePerson, Item owner) {
        List values = this.itemService.getMetadata((DSpaceObject)owner, "dspace", "object", "owner", "*");
        return ((MetadataValue)values.get(0)).getAuthority().equals(ePerson.getID().toString());
    }
}

