/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import java.io.Serializable;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.security.DSpaceRestPermission;
import org.dspace.app.rest.security.RestObjectPermissionEvaluatorPlugin;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.services.RequestService;
import org.dspace.services.model.Request;
import org.dspace.util.UUIDUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class ResearcherProfileRestPermissionEvaluatorPlugin
extends RestObjectPermissionEvaluatorPlugin {
    @Autowired
    private RequestService requestService;

    @Override
    public boolean hasDSpacePermission(Authentication authentication, Serializable targetId, String targetType, DSpaceRestPermission restPermission) {
        if (!(DSpaceRestPermission.READ.equals((Object)restPermission) || DSpaceRestPermission.WRITE.equals((Object)restPermission) || DSpaceRestPermission.DELETE.equals((Object)restPermission))) {
            return false;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)targetType, (CharSequence)"profile")) {
            return false;
        }
        UUID id = UUIDUtils.fromString((String)targetId.toString());
        if (id == null) {
            return false;
        }
        Request request = this.requestService.getCurrentRequest();
        Context context = ContextUtil.obtainContext((HttpServletRequest)request.getServletRequest());
        EPerson currentUser = context.getCurrentUser();
        if (currentUser == null) {
            return false;
        }
        return id.equals(currentUser.getID());
    }
}

