/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.rest.security.DSpaceAuthentication;
import org.dspace.app.rest.security.EPersonRestAuthenticationProvider;
import org.dspace.app.rest.security.RestAuthenticationService;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.RequestService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.util.UUIDUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

public class StatelessAuthenticationFilter
extends BasicAuthenticationFilter {
    private static final Logger log = LoggerFactory.getLogger(StatelessAuthenticationFilter.class);
    private static final String ON_BEHALF_OF_REQUEST_PARAM = "X-On-Behalf-Of";
    private RestAuthenticationService restAuthenticationService;
    private EPersonRestAuthenticationProvider authenticationProvider;
    private RequestService requestService;
    private AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    private EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    private ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    public StatelessAuthenticationFilter(AuthenticationManager authenticationManager, RestAuthenticationService restAuthenticationService, EPersonRestAuthenticationProvider authenticationProvider, RequestService requestService) {
        super(authenticationManager);
        this.requestService = requestService;
        this.restAuthenticationService = restAuthenticationService;
        this.authenticationProvider = authenticationProvider;
    }

    protected void doFilterInternal(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        Authentication authentication;
        try {
            authentication = this.getAuthentication(req, res);
        }
        catch (AuthorizeException e) {
            res.sendError(401, "Authentication is required");
            return;
        }
        catch (IllegalArgumentException | SQLException e) {
            res.sendError(400, "Authentication request is invalid or incorrect");
            log.error("Authentication request is invalid or incorrect (status:{})", (Object)400, (Object)e);
            return;
        }
        catch (AccessDeniedException e) {
            res.sendError(403, "Access is denied");
            log.error("Access is denied (status:{})", (Object)403, (Object)e);
            return;
        }
        if (authentication != null) {
            SecurityContextHolder.getContext().setAuthentication(authentication);
        }
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    private Authentication getAuthentication(HttpServletRequest request, HttpServletResponse res) throws AuthorizeException, SQLException {
        if (this.restAuthenticationService.hasAuthenticationData(request)) {
            Context context = ContextUtil.obtainContext(request);
            EPerson eperson = this.restAuthenticationService.getAuthenticatedEPerson(request, res, context);
            if (eperson != null) {
                log.debug("Found authentication data in request for EPerson {}", (Object)eperson.getEmail());
                this.requestService.setCurrentUserId(eperson.getID());
                List<GrantedAuthority> authorities = this.authenticationProvider.getGrantedAuthorities(context);
                String onBehalfOfParameterValue = request.getHeader(ON_BEHALF_OF_REQUEST_PARAM);
                if (onBehalfOfParameterValue != null) {
                    if (this.configurationService.getBooleanProperty("webui.user.assumelogin")) {
                        return this.getOnBehalfOfAuthentication(context, onBehalfOfParameterValue, res);
                    }
                    throw new IllegalArgumentException("The 'login as' feature is not allowed due to the current configuration");
                }
                return new DSpaceAuthentication(eperson, authorities);
            }
            return null;
        }
        if (request.getHeader(ON_BEHALF_OF_REQUEST_PARAM) != null) {
            throw new AuthorizeException("Must be logged in (as an admin) to use the 'login as' feature");
        }
        return null;
    }

    private Authentication getOnBehalfOfAuthentication(Context context, String onBehalfOfParameterValue, HttpServletResponse res) throws SQLException {
        if (!this.authorizeService.isAdmin(context)) {
            throw new AccessDeniedException("Only admins are allowed to use the login as feature");
        }
        UUID epersonUuid = UUIDUtils.fromString((String)onBehalfOfParameterValue);
        if (epersonUuid == null) {
            throw new IllegalArgumentException("The given UUID in the X-On-Behalf-Of header was not a proper UUID");
        }
        EPerson onBehalfOfEPerson = (EPerson)this.ePersonService.find(context, epersonUuid);
        if (onBehalfOfEPerson == null) {
            throw new IllegalArgumentException("The given UUID in the X-On-Behalf-Of header was not a proper EPerson UUID");
        }
        if (!this.authorizeService.isAdmin(context, onBehalfOfEPerson)) {
            this.requestService.setCurrentUserId(epersonUuid);
            context.switchContextUser(onBehalfOfEPerson);
            log.debug("Found 'on-behalf-of' authentication data in request for EPerson {}", (Object)onBehalfOfEPerson.getEmail());
            return new DSpaceAuthentication(onBehalfOfEPerson, this.authenticationProvider.getGrantedAuthorities(context));
        }
        throw new IllegalArgumentException("You're unable to use the login as feature to log in as another admin");
    }
}

