/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security.jwt;

import com.nimbusds.jwt.JWTClaimsSet;
import java.sql.SQLException;
import java.text.ParseException;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.security.jwt.JWTClaimProvider;
import org.dspace.authenticate.service.AuthenticationService;
import org.dspace.core.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuthenticationMethodClaimProvider
implements JWTClaimProvider {
    public static final String AUTHENTICATION_METHOD = "authenticationMethod";
    private static final Logger log = LoggerFactory.getLogger(AuthenticationMethodClaimProvider.class);
    @Autowired
    private AuthenticationService authenticationService;

    @Override
    public String getKey() {
        return AUTHENTICATION_METHOD;
    }

    @Override
    public Object getValue(Context context, HttpServletRequest request) {
        if (context.getAuthenticationMethod() != null) {
            return context.getAuthenticationMethod();
        }
        return this.authenticationService.getAuthenticationMethod(context, request);
    }

    @Override
    public void parseClaim(Context context, HttpServletRequest request, JWTClaimsSet jwtClaimsSet) throws SQLException {
        try {
            context.setAuthenticationMethod(jwtClaimsSet.getStringClaim(AUTHENTICATION_METHOD));
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

