/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.signposting.controller;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.signposting.converter.LinksetRestMessageConverter;
import org.dspace.app.rest.signposting.model.LinksetNode;
import org.dspace.app.rest.signposting.model.LinksetRest;
import org.dspace.app.rest.signposting.model.TypedLinkRest;
import org.dspace.app.rest.signposting.service.LinksetService;
import org.dspace.app.rest.signposting.utils.LinksetMapper;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.core.service.PluginService;
import org.dspace.services.ConfigurationService;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/${signposting.path:signposting}"})
@ConditionalOnProperty(value={"signposting.enabled"})
public class LinksetRestController {
    @Autowired
    private Utils utils;
    @Autowired
    private BitstreamService bitstreamService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private ConverterService converter;
    @Autowired
    private LinksetService linksetService;
    @Autowired
    private ConfigurationService configurationService;
    private final PluginService pluginService = CoreServiceFactory.getInstance().getPluginService();

    @PreAuthorize(value="permitAll()")
    @RequestMapping(method={RequestMethod.GET})
    public ResponseEntity getAll() {
        return ResponseEntity.status((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED).build();
    }

    @PreAuthorize(value="hasPermission(#uuid, 'ITEM', 'READ')")
    @RequestMapping(value={"/linksets/{uuid:[0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12}}/json"}, method={RequestMethod.GET}, produces={"application/linkset+json"})
    public LinksetRest getJson(HttpServletRequest request, @PathVariable UUID uuid) {
        try {
            Context context = ContextUtil.obtainContext(request);
            Item item = (Item)this.itemService.find(context, uuid);
            if (item == null) {
                throw new ResourceNotFoundException("No such Item: " + uuid);
            }
            LinksetRestController.verifyItemIsDiscoverable(item);
            List<List<LinksetNode>> linksetNodes = this.linksetService.createLinksetNodesForMultipleLinksets(request, context, item);
            List linksets = linksetNodes.stream().map(LinksetMapper::map).collect(Collectors.toList());
            return (LinksetRest)this.converter.toRest(linksets, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @PreAuthorize(value="hasPermission(#uuid, 'ITEM', 'READ')")
    @RequestMapping(value={"/linksets/{uuid:[0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12}}"}, method={RequestMethod.GET}, produces={"application/linkset"})
    public String getLset(HttpServletRequest request, @PathVariable UUID uuid) {
        try {
            Context context = ContextUtil.obtainContext(request);
            Item item = (Item)this.itemService.find(context, uuid);
            if (item == null) {
                throw new ResourceNotFoundException("No such Item: " + uuid);
            }
            LinksetRestController.verifyItemIsDiscoverable(item);
            List<List<LinksetNode>> linksetNodes = this.linksetService.createLinksetNodesForMultipleLinksets(request, context, item);
            return LinksetRestMessageConverter.convert(linksetNodes);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @PreAuthorize(value="hasPermission(#uuid, 'ITEM', 'READ') && hasPermission(#uuid, 'BITSTREAM', 'READ')")
    @RequestMapping(value={"/links/{uuid:[0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12}}"}, method={RequestMethod.GET})
    public List<TypedLinkRest> getHeader(HttpServletRequest request, @PathVariable UUID uuid) {
        Context context = ContextUtil.obtainContext(request);
        DSpaceObject dso = this.findObject(context, uuid);
        List<LinksetNode> linksetNodes = this.linksetService.createLinksetNodesForSingleLinkset(request, context, dso);
        return linksetNodes.stream().map(node -> new TypedLinkRest(node.getLink(), node.getRelation(), node.getType())).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasPermission(#uuid, 'ITEM', 'READ')")
    @RequestMapping(value={"/describedby/{uuid:[0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12}}"}, method={RequestMethod.GET})
    public String getDescribedBy(HttpServletRequest request, HttpServletResponse response, @PathVariable UUID uuid) throws SQLException, AuthorizeException, IOException, CrosswalkException {
        Context context = ContextUtil.obtainContext(request);
        String xwalkName = this.configurationService.getProperty("signposting.describedby.crosswalk-name");
        String responseMimeType = this.configurationService.getProperty("signposting.describedby.mime-type");
        response.addHeader("Content-Type", responseMimeType);
        DSpaceObject object = this.findObject(context, uuid);
        DisseminationCrosswalk xwalk = (DisseminationCrosswalk)this.pluginService.getNamedPlugin(DisseminationCrosswalk.class, xwalkName);
        List elements = xwalk.disseminateList(context, object);
        XMLOutputter outputter = new XMLOutputter(Format.getCompactFormat());
        return outputter.outputString(elements);
    }

    private DSpaceObject findObject(Context context, UUID uuid) {
        try {
            DSpaceObject object = this.itemService.find(context, uuid);
            if (Objects.isNull(object)) {
                object = this.bitstreamService.find(context, uuid);
                if (Objects.isNull(object)) {
                    throw new ResourceNotFoundException("No such resource: " + uuid);
                }
            } else {
                LinksetRestController.verifyItemIsDiscoverable((Item)object);
            }
            return object;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static void verifyItemIsDiscoverable(Item item) {
        if (!item.isDiscoverable()) {
            String message = String.format("Item with uuid [%s] is not Discoverable", item.getID().toString());
            throw new AccessDeniedException(message);
        }
    }
}

