/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.submit.factory.impl;

import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.AccessConditionDTO;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.submit.model.AccessConditionOption;

public class AccessConditionResourcePolicyUtils {
    private AccessConditionResourcePolicyUtils() {
    }

    public static void findApplyResourcePolicy(Context context, List<AccessConditionOption> accessConditionOptions, DSpaceObject obj, List<AccessConditionDTO> newAccessConditions) throws SQLException, AuthorizeException, ParseException {
        for (AccessConditionDTO newAccessCondition : newAccessConditions) {
            String name = newAccessCondition.getName();
            String description = newAccessCondition.getDescription();
            Date startDate = newAccessCondition.getStartDate();
            Date endDate = newAccessCondition.getEndDate();
            AccessConditionResourcePolicyUtils.findApplyResourcePolicy(context, accessConditionOptions, obj, name, description, startDate, endDate);
        }
    }

    public static void findApplyResourcePolicy(Context context, List<AccessConditionOption> accessConditionOptions, DSpaceObject obj, String name, String description, Date startDate, Date endDate) throws SQLException, AuthorizeException, ParseException {
        boolean found = false;
        for (AccessConditionOption accessConditionOption : accessConditionOptions) {
            if (found || !accessConditionOption.getName().equalsIgnoreCase(name)) continue;
            accessConditionOption.createResourcePolicy(context, obj, name, description, startDate, endDate);
            found = true;
        }
        if (!found) {
            throw new UnprocessableEntityException("The provided policy: " + name + " is not supported!");
        }
    }

    public static void canApplyResourcePolicy(Context context, List<AccessConditionOption> accessConditionOptions, String name, Date startDate, Date endDate) throws SQLException, AuthorizeException, ParseException {
        boolean found = false;
        for (AccessConditionOption ac : accessConditionOptions) {
            if (!ac.getName().equalsIgnoreCase(name)) continue;
            found = true;
        }
        if (!found) {
            throw new UnprocessableEntityException("The provided policy: " + name + " is not supported!");
        }
    }
}

