/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import org.dspace.app.rest.link.HalLinkService;
import org.dspace.app.rest.model.ExternalSourceEntryRest;
import org.dspace.app.rest.model.hateoas.ExternalSourceEntryResource;
import org.dspace.app.rest.model.hateoas.HALResource;
import org.dspace.app.rest.repository.ExternalSourceRestRepository;
import org.dspace.app.rest.utils.Utils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.PagedModel;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/integration/externalsources/{externalSourceName}"})
public class ExternalSourcesRestController {
    @Autowired
    private ExternalSourceRestRepository externalSourceRestRepository;
    @Autowired
    protected Utils utils;
    @Autowired
    HalLinkService linkService;

    @RequestMapping(method={RequestMethod.GET}, value={"/entries"})
    public PagedModel<ExternalSourceEntryResource> getExternalSourceEntries(@PathVariable(value="externalSourceName") String externalSourceName, @RequestParam(name="query") String query, @RequestParam(name="parent", required=false) String parent, Pageable pageable, PagedResourcesAssembler assembler) {
        Page externalSourceEntryRestPage = this.externalSourceRestRepository.getExternalSourceEntries(externalSourceName, query, parent, pageable);
        Page externalSourceEntryResources = externalSourceEntryRestPage.map(externalSourceEntryRest -> new ExternalSourceEntryResource(externalSourceEntryRest));
        externalSourceEntryResources.forEach(arg_0 -> ((HalLinkService)this.linkService).addLinks(arg_0));
        PagedModel result = assembler.toModel(externalSourceEntryResources);
        return result;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/entryValues/{entryId}"})
    public ExternalSourceEntryResource getExternalSourceEntryValue(@PathVariable(value="externalSourceName") String externalSourceName, @PathVariable(value="entryId") String entryId) {
        ExternalSourceEntryRest externalSourceEntryRest = this.externalSourceRestRepository.getExternalSourceEntryValue(externalSourceName, entryId);
        ExternalSourceEntryResource externalSourceEntryResource = new ExternalSourceEntryResource(externalSourceEntryRest);
        this.linkService.addLinks((HALResource)externalSourceEntryResource);
        return externalSourceEntryResource;
    }
}

