/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.io.Serializable;
import java.util.ArrayList;
import org.dspace.app.rest.converter.DSpaceConverter;
import org.dspace.app.rest.model.BrowseIndexRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.browse.BrowseIndex;
import org.dspace.content.authority.DSpaceControlledVocabularyIndex;
import org.dspace.sort.SortException;
import org.dspace.sort.SortOption;
import org.springframework.stereotype.Component;

@Component
public class BrowseIndexConverter
implements DSpaceConverter<BrowseIndex, BrowseIndexRest> {
    public BrowseIndexRest convert(BrowseIndex obj, Projection projection) {
        BrowseIndexRest bir = new BrowseIndexRest();
        bir.setProjection(projection);
        ArrayList<String> metadataList = new ArrayList<String>();
        String id = obj.getName();
        if (obj instanceof DSpaceControlledVocabularyIndex) {
            String[] vocObj = (String[])obj;
            metadataList = new ArrayList(vocObj.getMetadataFields());
            id = vocObj.getVocabulary().getPluginInstanceName();
            bir.setFacetType(vocObj.getFacetConfig().getIndexFieldName());
            bir.setVocabulary(vocObj.getVocabulary().getPluginInstanceName());
            bir.setBrowseType("hierarchicalBrowse");
        } else if (obj.isMetadataIndex()) {
            for (String s : obj.getMetadata().split(",")) {
                metadataList.add(s.trim());
            }
            bir.setDataType(obj.getDataType());
            bir.setOrder(obj.getDefaultOrder());
            bir.setBrowseType("valueList");
        } else {
            metadataList.add(obj.getSortOption().getMetadata());
            bir.setDataType(obj.getDataType());
            bir.setOrder(obj.getDefaultOrder());
            bir.setBrowseType("flatBrowse");
        }
        bir.setId((Serializable)((Object)id));
        bir.setMetadataList(metadataList);
        ArrayList<BrowseIndexRest.SortOption> sortOptionsList = new ArrayList<BrowseIndexRest.SortOption>();
        try {
            for (SortOption so : SortOption.getSortOptions()) {
                sortOptionsList.add(new BrowseIndexRest.SortOption(so.getName(), so.getMetadata()));
            }
        }
        catch (SortException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (!bir.getBrowseType().equals("hierarchicalBrowse")) {
            bir.setSortOptions(sortOptionsList);
        }
        return bir;
    }

    public Class<BrowseIndex> getModelClass() {
        return BrowseIndex.class;
    }
}

