/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.dspace.app.rest.converter.DSpaceConverter;
import org.dspace.app.rest.model.SearchConfigurationRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoverySearchFilter;
import org.dspace.discovery.configuration.DiscoverySearchFilterFacet;
import org.dspace.discovery.configuration.DiscoverySortConfiguration;
import org.dspace.discovery.configuration.DiscoverySortFieldConfiguration;
import org.springframework.stereotype.Component;

@Component
public class DiscoverConfigurationConverter
implements DSpaceConverter<DiscoveryConfiguration, SearchConfigurationRest> {
    public SearchConfigurationRest convert(DiscoveryConfiguration configuration, Projection projection) {
        SearchConfigurationRest searchConfigurationRest = new SearchConfigurationRest();
        searchConfigurationRest.setProjection(projection);
        if (configuration != null) {
            this.addSearchFilters(searchConfigurationRest, configuration.getSearchFilters(), configuration.getSidebarFacets());
            this.addSortOptions(searchConfigurationRest, configuration.getSearchSortConfiguration());
        }
        return searchConfigurationRest;
    }

    public Class<DiscoveryConfiguration> getModelClass() {
        return DiscoveryConfiguration.class;
    }

    public void addSearchFilters(SearchConfigurationRest searchConfigurationRest, List<DiscoverySearchFilter> searchFilterList, List<DiscoverySearchFilterFacet> facetList) {
        List facetFieldNames = facetList.stream().map(DiscoverySearchFilter::getIndexFieldName).collect(Collectors.toList());
        for (DiscoverySearchFilter discoverySearchFilter : CollectionUtils.emptyIfNull(searchFilterList)) {
            SearchConfigurationRest.Filter filter = new SearchConfigurationRest.Filter();
            filter.setFilter(discoverySearchFilter.getIndexFieldName());
            if (facetFieldNames.stream().anyMatch(str -> str.equals(discoverySearchFilter.getIndexFieldName()))) {
                filter.setHasFacets(true);
            }
            filter.setType(discoverySearchFilter.getType());
            filter.setOpenByDefault(discoverySearchFilter.isOpenByDefault());
            filter.addDefaultOperatorsToList();
            filter.setPageSize(discoverySearchFilter.getPageSize());
            searchConfigurationRest.addFilter(filter);
        }
    }

    private void addSortOptions(SearchConfigurationRest searchConfigurationRest, DiscoverySortConfiguration searchSortConfiguration) {
        if (searchSortConfiguration != null) {
            for (DiscoverySortFieldConfiguration discoverySearchSortConfiguration : CollectionUtils.emptyIfNull((Collection)searchSortConfiguration.getSortFields())) {
                SearchConfigurationRest.SortOption sortOption = new SearchConfigurationRest.SortOption();
                if (StringUtils.isBlank((String)discoverySearchSortConfiguration.getMetadataField())) {
                    sortOption.setName("score");
                } else {
                    sortOption.setName(discoverySearchSortConfiguration.getMetadataField());
                }
                sortOption.setActualName(discoverySearchSortConfiguration.getType());
                sortOption.setSortOrder(discoverySearchSortConfiguration.getDefaultSortOrder().name());
                searchConfigurationRest.addSortOption(sortOption);
            }
            DiscoverySortFieldConfiguration defaultSortField = searchSortConfiguration.getDefaultSortField();
            if (defaultSortField != null) {
                SearchConfigurationRest.SortOption sortOption = new SearchConfigurationRest.SortOption();
                sortOption.setName(defaultSortField.getMetadataField());
                sortOption.setActualName(defaultSortField.getType());
                sortOption.setSortOrder(defaultSortField.getDefaultSortOrder().name());
                searchConfigurationRest.setDefaultSortOption(sortOption);
            }
        }
    }
}

