/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.dspace.app.rest.model.PageRest;
import org.dspace.app.rest.model.SearchEventRest;
import org.dspace.app.rest.model.SearchResultsRest;
import org.dspace.app.rest.utils.ScopeResolver;
import org.dspace.app.util.service.DSpaceObjectUtils;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.discovery.IndexableObject;
import org.dspace.usage.UsageEvent;
import org.dspace.usage.UsageSearchEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchEventConverter {
    private static final Logger log = Logger.getLogger(SearchEventConverter.class);
    @Autowired
    private ScopeResolver scopeResolver;
    @Autowired
    private DSpaceObjectUtils dSpaceObjectUtils;
    private final Integer[] allowedClickedObjectTypes = new Integer[]{4, 3, 2};

    public UsageSearchEvent convert(Context context, HttpServletRequest request, SearchEventRest searchEventRest) {
        IndexableObject scopeObject;
        UsageSearchEvent usageSearchEvent = new UsageSearchEvent(UsageEvent.Action.SEARCH, request, context, null);
        usageSearchEvent.setQuery(searchEventRest.getQuery());
        usageSearchEvent.setDsoType(searchEventRest.getDsoType());
        if (searchEventRest.getClickedObject() != null) {
            try {
                DSpaceObject clickedObject = this.dSpaceObjectUtils.findDSpaceObject(context, searchEventRest.getClickedObject());
                if (clickedObject == null || !Arrays.asList(this.allowedClickedObjectTypes).contains(clickedObject.getType())) {
                    throw new IllegalArgumentException("UUID " + searchEventRest.getClickedObject() + " was expected to resolve to a Community, Collection or Item, but didn't resolve to any");
                }
                usageSearchEvent.setObject(clickedObject);
            }
            catch (SQLException e) {
                log.warn((Object)("Unable to retrieve DSpace Object with ID " + searchEventRest.getClickedObject() + " from the database"), (Throwable)e);
            }
        }
        if (searchEventRest.getScope() != null && (scopeObject = this.scopeResolver.resolveScope(context, String.valueOf(searchEventRest.getScope()))) instanceof DSpaceObject) {
            usageSearchEvent.setScope((DSpaceObject)scopeObject);
        }
        usageSearchEvent.setConfiguration(searchEventRest.getConfiguration());
        if (searchEventRest.getAppliedFilters() != null) {
            usageSearchEvent.setAppliedFilters(this.convertAppliedFilters(searchEventRest.getAppliedFilters()));
        }
        usageSearchEvent.setSort(this.convertSort(searchEventRest.getSort()));
        usageSearchEvent.setPage(this.convertPage(searchEventRest.getPage()));
        return usageSearchEvent;
    }

    private UsageSearchEvent.Page convertPage(PageRest page) {
        return new UsageSearchEvent.Page(page.getSize(), page.getTotalElements(), page.getTotalPages(), page.getNumber());
    }

    private UsageSearchEvent.Sort convertSort(SearchResultsRest.Sorting sort) {
        return new UsageSearchEvent.Sort(sort.getBy(), sort.getOrder());
    }

    private List<UsageSearchEvent.AppliedFilter> convertAppliedFilters(List<SearchResultsRest.AppliedFilter> appliedFilters) {
        LinkedList<UsageSearchEvent.AppliedFilter> listToReturn = new LinkedList<UsageSearchEvent.AppliedFilter>();
        for (SearchResultsRest.AppliedFilter appliedFilter : appliedFilters) {
            UsageSearchEvent.AppliedFilter convertedAppliedFilter = new UsageSearchEvent.AppliedFilter(appliedFilter.getFilter(), appliedFilter.getOperator(), appliedFilter.getValue(), appliedFilter.getLabel());
            listToReturn.add(convertedAppliedFilter);
        }
        return listToReturn;
    }
}

