/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.converter.DSpaceConverter;
import org.dspace.app.rest.model.ScopeEnum;
import org.dspace.app.rest.model.SubmissionFormFieldRest;
import org.dspace.app.rest.model.SubmissionFormInputTypeRest;
import org.dspace.app.rest.model.SubmissionFormRest;
import org.dspace.app.rest.model.SubmissionFormRowRest;
import org.dspace.app.rest.model.SubmissionVisibilityRest;
import org.dspace.app.rest.model.VisibilityEnum;
import org.dspace.app.rest.model.submit.SelectableMetadata;
import org.dspace.app.rest.model.submit.SelectableRelationship;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.SubmissionFormRestRepository;
import org.dspace.app.rest.utils.AuthorityUtils;
import org.dspace.app.util.DCInput;
import org.dspace.app.util.DCInputSet;
import org.dspace.core.Utils;
import org.dspace.submit.model.LanguageFormField;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SubmissionFormConverter
implements DSpaceConverter<DCInputSet, SubmissionFormRest> {
    private static final String INPUT_TYPE_ONEBOX = "onebox";
    private static final String INPUT_TYPE_NAME = "name";
    private static final String INPUT_TYPE_LOOKUP = "lookup";
    private static final String INPUT_TYPE_LOOKUP_NAME = "lookup-name";
    @Autowired
    private AuthorityUtils authorityUtils;
    @Autowired
    private SubmissionFormRestRepository submissionFormRestRepository;

    public SubmissionFormRest convert(DCInputSet obj, Projection projection) {
        SubmissionFormRest sd = new SubmissionFormRest();
        sd.setProjection(projection);
        sd.setName(obj.getFormName());
        DCInput[][] step = obj.getFields();
        List rows = this.getPage(step, obj.getFormName());
        sd.setRows(rows);
        return sd;
    }

    private List<SubmissionFormRowRest> getPage(DCInput[][] page, String formName) {
        LinkedList<SubmissionFormRowRest> rows = new LinkedList<SubmissionFormRowRest>();
        for (DCInput[] row : page) {
            LinkedList<SubmissionFormFieldRest> fields = new LinkedList<SubmissionFormFieldRest>();
            SubmissionFormRowRest rowRest = new SubmissionFormRowRest();
            rowRest.setFields(fields);
            rows.add(rowRest);
            for (DCInput dcinput : row) {
                fields.add(this.getField(dcinput, formName));
            }
        }
        return rows;
    }

    private SubmissionFormFieldRest getField(DCInput dcinput, String formName) {
        SubmissionFormFieldRest inputField = new SubmissionFormFieldRest();
        ArrayList<SelectableMetadata> selectableMetadata = new ArrayList<SelectableMetadata>();
        inputField.setLabel(dcinput.getLabel());
        inputField.setHints(dcinput.getHints());
        inputField.setStyle(dcinput.getStyle());
        inputField.setMandatoryMessage(dcinput.getWarning());
        inputField.setMandatory(dcinput.isRequired());
        inputField.setScope(ScopeEnum.fromString((String)dcinput.getScope()));
        inputField.setVisibility(new SubmissionVisibilityRest(VisibilityEnum.fromString((String)(dcinput.isReadOnly("submission") ? "read-only" : null)), VisibilityEnum.fromString((String)(dcinput.isReadOnly("workflow") ? "read-only" : null))));
        inputField.setRepeatable(dcinput.isRepeatable());
        if (dcinput.getLanguage()) {
            int idx = 1;
            for (String code : dcinput.getValueLanguageList()) {
                if (idx % 2 == 0) {
                    String display = (String)dcinput.getValueLanguageList().get(idx - 2);
                    LanguageFormField lang = new LanguageFormField(code, display);
                    inputField.getLanguageCodes().add(lang);
                }
                ++idx;
            }
        }
        SubmissionFormInputTypeRest inputRest = new SubmissionFormInputTypeRest();
        inputRest.setRegex(dcinput.getRegex());
        if (dcinput.isMetadataField()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)dcinput.getInputType(), (CharSequence)"qualdrop_value")) {
                String inputType = dcinput.getInputType();
                SelectableMetadata selMd = new SelectableMetadata();
                if (this.isChoice(dcinput.getSchema(), dcinput.getElement(), dcinput.getQualifier(), dcinput.getPairsType(), dcinput.getVocabulary())) {
                    inputRest.setType(this.getPresentation(dcinput.getSchema(), dcinput.getElement(), dcinput.getQualifier(), inputType));
                    selMd.setControlledVocabulary(this.getAuthorityName(dcinput.getSchema(), dcinput.getElement(), dcinput.getQualifier(), dcinput.getPairsType(), dcinput.getVocabulary()));
                    selMd.setClosed(Boolean.valueOf(this.isClosed(dcinput.getSchema(), dcinput.getElement(), dcinput.getQualifier(), dcinput.getPairsType(), dcinput.getVocabulary())));
                } else {
                    inputRest.setType(inputType);
                }
                selMd.setMetadata(Utils.standardize((String)dcinput.getSchema(), (String)dcinput.getElement(), (String)dcinput.getQualifier(), (String)"."));
                selectableMetadata.add(selMd);
            } else {
                inputRest.setType(INPUT_TYPE_ONEBOX);
                List pairs = dcinput.getPairs();
                for (int idx = 0; idx < pairs.size(); idx += 2) {
                    SelectableMetadata selMd = new SelectableMetadata();
                    selMd.setLabel((String)pairs.get(idx));
                    selMd.setMetadata(Utils.standardize((String)dcinput.getSchema(), (String)dcinput.getElement(), (String)((String)pairs.get(idx + 1)), (String)"."));
                    if (this.authorityUtils.isChoice(dcinput.getSchema(), dcinput.getElement(), dcinput.getQualifier())) {
                        selMd.setControlledVocabulary(this.getAuthorityName(dcinput.getSchema(), dcinput.getElement(), (String)pairs.get(idx + 1), dcinput.getPairsType(), dcinput.getVocabulary()));
                        selMd.setClosed(Boolean.valueOf(this.isClosed(dcinput.getSchema(), dcinput.getElement(), dcinput.getQualifier(), null, dcinput.getVocabulary())));
                    }
                    selectableMetadata.add(selMd);
                }
            }
        }
        inputField.setInput(inputRest);
        if (dcinput.isMetadataField()) {
            inputField.setSelectableMetadata(selectableMetadata);
            inputField.setTypeBind(dcinput.getTypeBindList());
        }
        if (dcinput.isRelationshipField()) {
            SelectableRelationship selectableRelationship = this.getSelectableRelationships(dcinput);
            inputField.setSelectableRelationship(selectableRelationship);
        }
        return inputField;
    }

    private SelectableRelationship getSelectableRelationships(DCInput dcinput) {
        SelectableRelationship selectableRelationship = new SelectableRelationship();
        selectableRelationship.setRelationshipType(dcinput.getRelationshipType());
        selectableRelationship.setFilter(dcinput.getFilter());
        selectableRelationship.setSearchConfiguration(dcinput.getSearchConfiguration());
        selectableRelationship.setNameVariants(String.valueOf(dcinput.areNameVariantsAllowed()));
        if (CollectionUtils.isNotEmpty((Collection)dcinput.getExternalSources())) {
            selectableRelationship.setExternalSources(dcinput.getExternalSources());
        }
        return selectableRelationship;
    }

    private String getPresentation(String schema, String element, String qualifier, String inputType) {
        String presentation = this.authorityUtils.getPresentation(schema, element, qualifier);
        if (StringUtils.isNotBlank((CharSequence)presentation)) {
            if (INPUT_TYPE_ONEBOX.equals(inputType)) {
                if ("suggest".equals(presentation)) {
                    return INPUT_TYPE_ONEBOX;
                }
                if (INPUT_TYPE_LOOKUP.equals(presentation)) {
                    return INPUT_TYPE_LOOKUP;
                }
            } else if (INPUT_TYPE_NAME.equals(inputType) && (INPUT_TYPE_LOOKUP.equals(presentation) || "authorLookup".equals(presentation))) {
                return INPUT_TYPE_LOOKUP_NAME;
            }
        }
        return inputType;
    }

    private String getAuthorityName(String schema, String element, String qualifier, String valuePairsName, String vocabularyName) {
        if (StringUtils.isNotBlank((CharSequence)valuePairsName)) {
            return valuePairsName;
        }
        if (StringUtils.isNotBlank((CharSequence)vocabularyName)) {
            return vocabularyName;
        }
        return this.authorityUtils.getAuthorityName(schema, element, qualifier);
    }

    private boolean isClosed(String schema, String element, String qualifier, String valuePairsName, String vocabularyName) {
        if (StringUtils.isNotBlank((CharSequence)valuePairsName) || StringUtils.isNotBlank((CharSequence)vocabularyName)) {
            return true;
        }
        return this.authorityUtils.isClosed(schema, element, qualifier);
    }

    private boolean isChoice(String schema, String element, String qualifier, String valuePairsName, String vocabularyName) {
        if (StringUtils.isNotBlank((CharSequence)valuePairsName) || StringUtils.isNotBlank((CharSequence)vocabularyName)) {
            return true;
        }
        return this.authorityUtils.isChoice(schema, element, qualifier);
    }

    public Class<DCInputSet> getModelClass() {
        return DCInputSet.class;
    }
}

