/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation.resourcePolicy;

import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.core.Context;
import org.springframework.stereotype.Component;

@Component
public class ResourcePolicyPolicyTypeReplaceOperation<R>
extends PatchOperation<R> {
    public R perform(Context context, R resource, Operation operation) {
        this.checkOperationValue(operation.getValue());
        if (this.supports(resource, operation)) {
            ResourcePolicy resourcePolicy = (ResourcePolicy)resource;
            this.checkResourcePolicyForExistingPolicyTypeValue(resourcePolicy, operation);
            this.replace(resourcePolicy, operation);
            return resource;
        }
        throw new DSpaceBadRequestException(this.getClass() + " does not support this operation");
    }

    private void replace(ResourcePolicy resourcePolicy, Operation operation) {
        String newPolicyType = (String)operation.getValue();
        resourcePolicy.setRpType(newPolicyType);
    }

    public boolean supports(Object objectToMatch, Operation operation) {
        return objectToMatch instanceof ResourcePolicy && operation.getOp().trim().equalsIgnoreCase("replace") && operation.getPath().trim().equalsIgnoreCase("/policyType");
    }

    private void checkResourcePolicyForExistingPolicyTypeValue(ResourcePolicy resource, Operation operation) {
        if (resource.getRpType() == null) {
            throw new DSpaceBadRequestException("Attempting to " + operation.getOp() + " a non-existent policyType value.");
        }
    }
}

