/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.scripts.handler.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.ProcessStatus;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.scripts.DSpaceCommandLineParameter;
import org.dspace.scripts.DSpaceRunnable;
import org.dspace.scripts.Process;
import org.dspace.scripts.ProcessLogLevel;
import org.dspace.scripts.factory.ScriptServiceFactory;
import org.dspace.scripts.handler.DSpaceRunnableHandler;
import org.dspace.scripts.service.ProcessService;
import org.dspace.utils.DSpace;
import org.springframework.core.task.TaskExecutor;

public class RestDSpaceRunnableHandler
implements DSpaceRunnableHandler {
    private static final Logger log = LogManager.getLogger(RestDSpaceRunnableHandler.class);
    private BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    private ProcessService processService = ScriptServiceFactory.getInstance().getProcessService();
    private EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    private Integer processId;
    private String scriptName;
    private UUID ePersonId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestDSpaceRunnableHandler(EPerson ePerson, String scriptName, List<DSpaceCommandLineParameter> parameters, Set<Group> specialGroups) {
        Context context = new Context();
        try {
            this.ePersonId = ePerson.getID();
            Process process = this.processService.create(context, ePerson, scriptName, parameters, specialGroups);
            this.processId = process.getID();
            this.scriptName = process.getName();
            context.complete();
        }
        catch (SQLException e) {
            log.error("RestDSpaceRunnableHandler with ePerson: " + ePerson.getEmail() + " for Script with name: " + scriptName + " and parameters: " + parameters + " could nto be created", (Throwable)e);
        }
        finally {
            if (context.isValid()) {
                context.abort();
            }
        }
    }

    public void start() {
        Context context = new Context();
        try {
            Process process = this.processService.find(context, this.processId.intValue());
            this.processService.start(context, process);
            context.complete();
            this.logInfo("The script has started");
        }
        catch (SQLException e) {
            log.error("RestDSpaceRunnableHandler with process: " + this.processId + " could not be started", (Throwable)e);
        }
        finally {
            if (context.isValid()) {
                context.abort();
            }
        }
    }

    public void handleCompletion() {
        Context context = new Context();
        try {
            Process process = this.processService.find(context, this.processId.intValue());
            this.processService.complete(context, process);
            this.logInfo("The script has completed");
            this.addLogBitstreamToProcess(context);
            context.complete();
        }
        catch (SQLException e) {
            log.error("RestDSpaceRunnableHandler with process: " + this.processId + " could not be completed", (Throwable)e);
        }
        catch (IOException | AuthorizeException e) {
            log.error("RestDSpaceRunnableHandler with process: " + this.processId + " could not be completed due to an error with the logging bitstream", e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (context.isValid()) {
                context.abort();
            }
        }
    }

    public void handleException(Exception e) {
        this.handleException(null, e);
    }

    public void handleException(String message) {
        this.handleException(message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleException(String message, Exception e) {
        this.logError(message, (Throwable)e);
        Context context = new Context();
        try {
            Process process = this.processService.find(context, this.processId.intValue());
            this.processService.fail(context, process);
            this.addLogBitstreamToProcess(context);
            context.complete();
        }
        catch (SQLException sqlException) {
            log.error("SQL exception while handling another exception", (Throwable)e);
        }
        catch (IOException | AuthorizeException ioException) {
            log.error("RestDSpaceRunnableHandler with process: " + this.processId + " could not be completed due to an error with the logging bitstream", (Throwable)e);
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
        }
        finally {
            if (context.isValid()) {
                context.abort();
            }
        }
        throw new RuntimeException(e);
    }

    public void logDebug(String message) {
        String logMessage = this.getLogMessage(message);
        log.debug(logMessage);
    }

    private String getLogMessage(String message) {
        return String.format("Process id: %d, script name: %s, message: %s", this.processId, this.scriptName, message);
    }

    public void logInfo(String message) {
        String logMessage = this.getLogMessage(message);
        log.info(logMessage);
        this.appendLogToProcess(message, ProcessLogLevel.INFO);
    }

    public void logWarning(String message) {
        String logMessage = this.getLogMessage(message);
        log.warn(logMessage);
        this.appendLogToProcess(message, ProcessLogLevel.WARNING);
    }

    public void logError(String message) {
        String logMessage = this.getLogMessage(message);
        log.error(logMessage);
        this.appendLogToProcess(message, ProcessLogLevel.ERROR);
    }

    public void logError(String message, Throwable throwable) {
        String logMessage = this.getLogMessage(message);
        log.error(logMessage, throwable);
        this.appendLogToProcess(message, ProcessLogLevel.ERROR);
        if (throwable != null) {
            this.appendLogToProcess(ExceptionUtils.getStackTrace((Throwable)throwable), ProcessLogLevel.ERROR);
        }
    }

    public void printHelp(Options options, String name) {
        if (options != null) {
            HelpFormatter formatter = new HelpFormatter();
            StringWriter out = new StringWriter();
            PrintWriter pw = new PrintWriter(out);
            formatter.printHelp(pw, 1000, name, null, options, formatter.getLeftPadding(), formatter.getDescPadding(), null, false);
            pw.flush();
            String helpString = out.toString();
            this.logInfo(helpString);
        }
    }

    public Optional<InputStream> getFileStream(Context context, String fileName) throws IOException, AuthorizeException {
        try {
            Process process = this.processService.find(context, this.processId.intValue());
            Bitstream bitstream = this.processService.getBitstreamByName(context, process, fileName);
            InputStream inputStream = this.bitstreamService.retrieve(context, bitstream);
            if (inputStream == null) {
                return Optional.empty();
            }
            return Optional.of(inputStream);
        }
        catch (SQLException sqlException) {
            log.error("SQL exception while attempting to find process", (Throwable)sqlException);
            return null;
        }
    }

    public void writeFilestream(Context context, String fileName, InputStream inputStream, String type) throws IOException, SQLException, AuthorizeException {
        Process process = this.processService.find(context, this.processId.intValue());
        this.processService.appendFile(context, process, inputStream, type, fileName);
    }

    public Process getProcess(Context context) {
        try {
            return this.processService.find(context, this.processId.intValue());
        }
        catch (SQLException e) {
            log.error("RestDSpaceRunnableHandler with process: " + this.processId + " could not be found", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(DSpaceRunnable script) {
        TaskExecutor taskExecutor = (TaskExecutor)new DSpace().getServiceManager().getServiceByName("dspaceRunnableThreadExecutor", TaskExecutor.class);
        Context context = new Context();
        try {
            Process process = this.processService.find(context, this.processId.intValue());
            process.setProcessStatus(ProcessStatus.SCHEDULED);
            this.processService.update(context, process);
            context.complete();
        }
        catch (SQLException e) {
            log.error("RestDSpaceRunnableHandler with process: " + this.processId + " ran into an SQLException", (Throwable)e);
        }
        finally {
            if (context.isValid()) {
                context.abort();
            }
        }
        taskExecutor.execute((Runnable)script);
    }

    private void appendLogToProcess(String message, ProcessLogLevel error) {
        try {
            this.processService.appendLog(this.processId.intValue(), this.scriptName, message, error);
        }
        catch (IOException e) {
            log.error("RestDSpaceRunnableHandler with process: " + this.processId + " could not write log to process", (Throwable)e);
        }
    }

    private void addLogBitstreamToProcess(Context context) throws SQLException, IOException, AuthorizeException {
        try {
            EPerson ePerson = (EPerson)this.ePersonService.find(context, this.ePersonId);
            Process process = this.processService.find(context, this.processId.intValue());
            context.setCurrentUser(ePerson);
            this.processService.createLogBitstream(context, process);
        }
        catch (IOException | SQLException | AuthorizeException e) {
            log.error("RestDSpaceRunnableHandler with process: " + this.processId + " could not write log to process", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UUID> getSpecialGroups() {
        Context context = new Context();
        ArrayList<UUID> specialGroups = new ArrayList<UUID>();
        try {
            Process process = this.processService.find(context, this.processId.intValue());
            for (Group group : process.getGroups()) {
                specialGroups.add(group.getID());
            }
        }
        catch (SQLException e) {
            log.error("RestDSpaceRunnableHandler with process: " + this.processId + " could not find the process", (Throwable)e);
        }
        finally {
            if (context.isValid()) {
                context.abort();
            }
        }
        return specialGroups;
    }
}

