/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DSpaceCsrfAuthenticationStrategy
implements SessionAuthenticationStrategy {
    private final CsrfTokenRepository csrfTokenRepository;

    public DSpaceCsrfAuthenticationStrategy(CsrfTokenRepository csrfTokenRepository) {
        Assert.notNull((Object)csrfTokenRepository, (String)"csrfTokenRepository cannot be null");
        this.csrfTokenRepository = csrfTokenRepository;
    }

    public void onAuthentication(Authentication authentication, HttpServletRequest request, HttpServletResponse response) throws SessionAuthenticationException {
        boolean containsParameter;
        boolean containsToken;
        CsrfToken token = this.csrfTokenRepository.loadToken(request);
        boolean bl = containsToken = token != null;
        if (containsToken && (containsParameter = StringUtils.hasLength((String)request.getParameter(token.getParameterName())))) {
            this.csrfTokenRepository.saveToken(null, request, response);
            CsrfToken newToken = this.csrfTokenRepository.generateToken(request);
            this.csrfTokenRepository.saveToken(newToken, request, response);
            request.setAttribute(CsrfToken.class.getName(), (Object)newToken);
            request.setAttribute(newToken.getParameterName(), (Object)newToken);
        }
    }
}

