/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.security.DSpaceRestPermission;
import org.dspace.app.rest.security.RestObjectPermissionEvaluatorPlugin;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.rest.utils.DSpaceObjectUtils;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.services.RequestService;
import org.dspace.services.model.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class DSpaceObjectAdminPermissionEvaluatorPlugin
extends RestObjectPermissionEvaluatorPlugin {
    private static final Logger log = LoggerFactory.getLogger(DSpaceObjectAdminPermissionEvaluatorPlugin.class);
    public static final String DSPACE_OBJECT = "dspaceObject";
    @Autowired
    AuthorizeService authorizeService;
    @Autowired
    private RequestService requestService;
    @Autowired
    private DSpaceObjectUtils dspaceObjectUtil;

    public boolean hasDSpacePermission(Authentication authentication, Serializable targetId, String targetType, DSpaceRestPermission permission) {
        DSpaceRestPermission restPermission = DSpaceRestPermission.convert((Object)permission);
        if (!DSpaceRestPermission.ADMIN.equals((Object)restPermission) || !StringUtils.equalsIgnoreCase((CharSequence)targetType, (CharSequence)DSPACE_OBJECT)) {
            return false;
        }
        Request request = this.requestService.getCurrentRequest();
        Context context = ContextUtil.obtainContext((HttpServletRequest)request.getHttpServletRequest());
        try {
            UUID dsoUuid = UUID.fromString(targetId.toString());
            DSpaceObject dso = this.dspaceObjectUtil.findDSpaceObject(context, dsoUuid);
            return this.authorizeService.isAdmin(context, dso);
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

