/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.utils;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.converter.query.SearchQueryConverter;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.InvalidSearchRequestException;
import org.dspace.app.rest.parameter.SearchFilter;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.utils.DiscoverQueryBuilder;
import org.dspace.discovery.utils.parameter.QueryBuilderSearchFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;

@Component
public class RestDiscoverQueryBuilder {
    private static final Logger log = LogManager.getLogger(RestDiscoverQueryBuilder.class);
    @Autowired
    private DiscoverQueryBuilder discoverQueryBuilder;

    public DiscoverQuery buildQuery(Context context, IndexableObject scope, DiscoveryConfiguration discoveryConfiguration, String query, List<SearchFilter> searchFilters, String dsoType, Pageable page) throws DSpaceBadRequestException {
        List<Object> dsoTypes = dsoType != null ? Collections.singletonList(dsoType) : Collections.emptyList();
        return this.buildQuery(context, scope, discoveryConfiguration, query, searchFilters, dsoTypes, page);
    }

    public DiscoverQuery buildQuery(Context context, IndexableObject scope, DiscoveryConfiguration discoveryConfiguration, String query, List<SearchFilter> searchFilters, List<String> dsoTypes, Pageable page) throws DSpaceBadRequestException {
        try {
            List transformedFilters = this.transformRestFilters(searchFilters);
            if (page != null) {
                String sortBy = null;
                String sortOrder = null;
                Sort sort = page.getSort();
                if (sort != null && sort.iterator().hasNext()) {
                    Sort.Order order = (Sort.Order)sort.iterator().next();
                    sortBy = order.getProperty();
                    sortOrder = order.getDirection().name();
                }
                return this.discoverQueryBuilder.buildQuery(context, scope, discoveryConfiguration, query, transformedFilters, dsoTypes, Integer.valueOf(page.getPageSize()), Long.valueOf(page.getOffset()), sortBy, sortOrder);
            }
            return this.discoverQueryBuilder.buildQuery(context, scope, discoveryConfiguration, query, transformedFilters, dsoTypes, null, null, null, null);
        }
        catch (IllegalArgumentException e) {
            throw new DSpaceBadRequestException(e.getMessage());
        }
        catch (SearchServiceException e) {
            throw new InvalidSearchRequestException(e.getMessage());
        }
    }

    public DiscoverQuery buildFacetQuery(Context context, IndexableObject scope, DiscoveryConfiguration discoveryConfiguration, String prefix, String query, List<SearchFilter> searchFilters, String dsoType, Pageable page, String facetName) throws DSpaceBadRequestException {
        List<Object> dsoTypes = dsoType != null ? Collections.singletonList(dsoType) : Collections.emptyList();
        return this.buildFacetQuery(context, scope, discoveryConfiguration, prefix, query, searchFilters, dsoTypes, page, facetName);
    }

    public DiscoverQuery buildFacetQuery(Context context, IndexableObject scope, DiscoveryConfiguration discoveryConfiguration, String prefix, String query, List<SearchFilter> searchFilters, List<String> dsoTypes, Pageable page, String facetName) throws DSpaceBadRequestException {
        try {
            List transformedFilters = this.transformRestFilters(searchFilters);
            if (page != null) {
                return this.discoverQueryBuilder.buildFacetQuery(context, scope, discoveryConfiguration, prefix, query, transformedFilters, dsoTypes, Integer.valueOf(page.getPageSize()), Long.valueOf(page.getOffset()), facetName);
            }
            return this.discoverQueryBuilder.buildFacetQuery(context, scope, discoveryConfiguration, prefix, query, transformedFilters, dsoTypes, null, null, facetName);
        }
        catch (IllegalArgumentException e) {
            throw new DSpaceBadRequestException(e.getMessage());
        }
    }

    private List<QueryBuilderSearchFilter> transformRestFilters(List<SearchFilter> searchFilters) throws DSpaceBadRequestException {
        SearchQueryConverter searchQueryConverter = new SearchQueryConverter();
        List filters = searchQueryConverter.convert(searchFilters);
        return filters.stream().map(searchFilter -> new QueryBuilderSearchFilter(searchFilter.getName(), searchFilter.getOperator(), searchFilter.getValue())).collect(Collectors.toList());
    }
}

