/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import jakarta.el.MethodNotFoundException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.dspace.app.rest.AbstractLiveImportIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.importer.external.ads.ADSImportMetadataSourceServiceImpl;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.datamodel.Query;
import org.dspace.importer.external.liveimportclient.service.LiveImportClientImpl;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;

public class ADSImportMetadataSourceServiceIT
extends AbstractLiveImportIntegrationTest {
    @Autowired
    private LiveImportClientImpl liveImportClient;
    @Autowired
    private ADSImportMetadataSourceServiceImpl adsServiceImpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void adsImportMetadataGetRecordsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        CloseableHttpClient originalHttpClient = this.liveImportClient.getHttpClient();
        CloseableHttpClient httpClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        try (InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("ads-ex.json");){
            String adsJsonResp = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            this.liveImportClient.setHttpClient(httpClient);
            CloseableHttpResponse response = this.mockResponse(adsJsonResp, 200, "OK");
            Mockito.when((Object)httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)response);
            this.context.restoreAuthSystemState();
            ArrayList<ImportRecord> collection2match = this.getRecords();
            Collection recordsImported = this.adsServiceImpl.getRecords("test query", 0, 2);
            Assert.assertEquals((long)2L, (long)recordsImported.size());
            this.matchRecords(new ArrayList<ImportRecord>(recordsImported), collection2match);
        }
        finally {
            this.liveImportClient.setHttpClient(originalHttpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void adsImportMetadataGetRecordsCountTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        CloseableHttpClient originalHttpClient = this.liveImportClient.getHttpClient();
        CloseableHttpClient httpClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        try (InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("ads-ex.json");){
            String adsResp = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            this.liveImportClient.setHttpClient(httpClient);
            CloseableHttpResponse response = this.mockResponse(adsResp, 200, "OK");
            Mockito.when((Object)httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)response);
            this.context.restoreAuthSystemState();
            int tot = this.adsServiceImpl.getRecordsCount("test query");
            Assert.assertEquals((long)9383L, (long)tot);
        }
        finally {
            this.liveImportClient.setHttpClient(originalHttpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void adsImportMetadataGetRecordsCountByQueryTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        CloseableHttpClient originalHttpClient = this.liveImportClient.getHttpClient();
        CloseableHttpClient httpClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        try (InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("ads-ex.json");){
            String adsResp = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            this.liveImportClient.setHttpClient(httpClient);
            CloseableHttpResponse response = this.mockResponse(adsResp, 200, "OK");
            Mockito.when((Object)httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)response);
            this.context.restoreAuthSystemState();
            Query q = new Query();
            q.addParameter("query", (Object)"test");
            int tot = this.adsServiceImpl.getRecordsCount(q);
            Assert.assertEquals((long)9383L, (long)tot);
        }
        finally {
            this.liveImportClient.setHttpClient(originalHttpClient);
        }
    }

    @Test(expected=MethodNotFoundException.class)
    public void adsImportMetadataFindMatchingRecordsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        org.dspace.content.Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item testItem = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)col1).withTitle("test item").withIssueDate("2021").build();
        this.context.restoreAuthSystemState();
        this.adsServiceImpl.findMatchingRecords(testItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void adsImportMetadataGetRecordByIdTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        CloseableHttpClient originalHttpClient = this.liveImportClient.getHttpClient();
        CloseableHttpClient httpClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        try (InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("ads-single-obj.json");){
            String adsJsonResp = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            this.liveImportClient.setHttpClient(httpClient);
            CloseableHttpResponse response = this.mockResponse(adsJsonResp, 200, "OK");
            Mockito.when((Object)httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)response);
            this.context.restoreAuthSystemState();
            ArrayList<ImportRecord> collection2match = this.getRecords();
            collection2match.remove(1);
            ImportRecord recordImported = this.adsServiceImpl.getRecord("2017PhRvL.119p1101A");
            Assert.assertNotNull((Object)recordImported);
            this.matchRecords(new ArrayList<ImportRecord>(Arrays.asList(recordImported)), collection2match);
        }
        finally {
            this.liveImportClient.setHttpClient(originalHttpClient);
        }
    }

    private ArrayList<ImportRecord> getRecords() {
        ArrayList<ImportRecord> records = new ArrayList<ImportRecord>();
        ArrayList<MetadatumDTO> metadatums = new ArrayList<MetadatumDTO>();
        MetadatumDTO author = this.createMetadatumDTO("dc", "contributor", "author", "Abbott, B. P.");
        MetadatumDTO author2 = this.createMetadatumDTO("dc", "contributor", "author", "Babak, S.");
        MetadatumDTO author3 = this.createMetadatumDTO("dc", "contributor", "author", "Di Fiore, L.");
        MetadatumDTO author4 = this.createMetadatumDTO("dc", "contributor", "author", "Virgo Collaboration");
        MetadatumDTO doi = this.createMetadatumDTO("dc", "identifier", "doi", "10.1103/PhysRevLett.116.061102");
        MetadatumDTO type = this.createMetadatumDTO("dc", "type", null, "article");
        MetadatumDTO adsbibcode = this.createMetadatumDTO("dc", "identifier", "other", "2016PhRvL.116f1102A");
        MetadatumDTO date = this.createMetadatumDTO("dc", "date", "issued", "2016");
        MetadatumDTO subject = this.createMetadatumDTO("dc", "subject", null, "General Relativity and Quantum Cosmology");
        MetadatumDTO subject2 = this.createMetadatumDTO("dc", "subject", null, "Astrophysics - High Energy Astrophysical Phenomena");
        MetadatumDTO source = this.createMetadatumDTO("dc", "source", null, "Physical Review Letters");
        MetadatumDTO title = this.createMetadatumDTO("dc", "title", null, "Observation of Gravitational Waves from a Binary Black Hole Merger");
        MetadatumDTO description = this.createMetadatumDTO("dc", "description", "abstract", "On September 14, 2015 at 09:50:45 UTC the two detectors of the Laser Interferometer Gravitational-Wave Observatory simultaneously observed a transient gravitational-wave signal. The signal sweeps upwards in frequency from 35 to 250 Hz with a peak gravitational-wave strain of 1.0 \u00d710<SUP>-21</SUP>. It matches the waveform predicted by general relativity for the inspiral and merger of a pair of black holes and the ringdown of the resulting single black hole. The signal was observed with a matched-filter signal-to-noise ratio of 24 and a false alarm rate estimated to be less than 1 event per 203 000 years, equivalent to a significance greater than 5.1 \u03c3 . The source lies at a luminosity distance of 41 0<SUB>-180</SUB><SUP>+160</SUP> Mpc corresponding to a redshift z =0.0 9<SUB>-0.04</SUB><SUP>+0.03</SUP> . In the source frame, the initial black hole masses are 3 6<SUB>-4</SUB><SUP>+5</SUP>M<SUB>\u2299</SUB> and 2 9<SUB>-4</SUB><SUP>+4</SUP>M<SUB>\u2299</SUB> , and the final black hole mass is 6 2<SUB>-4</SUB><SUP>+4</SUP>M<SUB>\u2299</SUB> , with 3. 0<SUB>-0.5</SUB><SUP>+0.5</SUP>M<SUB>\u2299</SUB> c<SUP>2</SUP> radiated in gravitational waves. All uncertainties define 90% credible intervals. These observations demonstrate the existence of binary stellar-mass black hole systems. This is the first direct detection of gravitational waves and the first observation of a binary black hole merger.");
        metadatums.add(description);
        metadatums.add(author);
        metadatums.add(author2);
        metadatums.add(author3);
        metadatums.add(author4);
        metadatums.add(doi);
        metadatums.add(type);
        metadatums.add(adsbibcode);
        metadatums.add(date);
        metadatums.add(subject);
        metadatums.add(subject2);
        metadatums.add(source);
        metadatums.add(title);
        ImportRecord firstrRecord = new ImportRecord(metadatums);
        ArrayList<MetadatumDTO> metadatums2 = new ArrayList<MetadatumDTO>();
        MetadatumDTO author5 = this.createMetadatumDTO("dc", "contributor", "author", "Abbott, B. P.");
        MetadatumDTO author6 = this.createMetadatumDTO("dc", "contributor", "author", "Babak, S.");
        MetadatumDTO author7 = this.createMetadatumDTO("dc", "contributor", "author", "Vorvick, C.");
        MetadatumDTO author8 = this.createMetadatumDTO("dc", "contributor", "author", "Wade, M.");
        MetadatumDTO doi2 = this.createMetadatumDTO("dc", "identifier", "doi", "10.1103/PhysRevLett.119.161101");
        MetadatumDTO type2 = this.createMetadatumDTO("dc", "type", null, "article");
        MetadatumDTO adsbibcode2 = this.createMetadatumDTO("dc", "identifier", "other", "2017PhRvL.119p1101A");
        MetadatumDTO date2 = this.createMetadatumDTO("dc", "date", "issued", "2017");
        MetadatumDTO subject3 = this.createMetadatumDTO("dc", "subject", null, "General Relativity and Quantum Cosmology");
        MetadatumDTO subject4 = this.createMetadatumDTO("dc", "subject", null, "Astrophysics - High Energy Astrophysical Phenomena");
        MetadatumDTO source2 = this.createMetadatumDTO("dc", "source", null, "Physical Review Letters");
        MetadatumDTO title2 = this.createMetadatumDTO("dc", "title", null, "GW170817: Observation of Gravitational Waves from a Binary Neutron Star Inspiral");
        MetadatumDTO description2 = this.createMetadatumDTO("dc", "description", "abstract", "On August 17, 2017 at 12\u223641:04 UTC the Advanced LIGO and Advanced Virgo gravitational-wave detectors made their first observation of a binary neutron star inspiral. The signal, GW170817, was detected with a combined signal-to-noise ratio of 32.4 and a false-alarm-rate estimate of less than one per 8.0 \u00d710<SUP>4</SUP> years . We infer the component masses of the binary to be between 0.86 and 2.26 M<SUB>\u2299</SUB> , in agreement with masses of known neutron stars. Restricting the component spins to the range inferred in binary neutron stars, we find the component masses to be in the range 1.17 - 1.60 M<SUB>\u2299</SUB> , with the total mass of the system 2.7 4<SUB>-0.01</SUB><SUP>+0.04</SUP>M<SUB>\u2299</SUB> . The source was localized within a sky region of 28 deg<SUP>2</SUP> (90% probability) and had a luminosity distance of 4 0<SUB>-14</SUB><SUP>+8</SUP> Mpc , the closest and most precisely localized gravitational-wave signal yet. The association with the \u03b3 -ray burst GRB 170817A, detected by Fermi-GBM 1.7 s after the coalescence, corroborates the hypothesis of a neutron star merger and provides the first direct evidence of a link between these mergers and short \u03b3 -ray bursts. Subsequent identification of transient counterparts across the electromagnetic spectrum in the same location further supports the interpretation of this event as a neutron star merger. This unprecedented joint gravitational and electromagnetic observation provides insight into astrophysics, dense matter, gravitation, and cosmology.");
        metadatums2.add(description2);
        metadatums2.add(author5);
        metadatums2.add(author6);
        metadatums2.add(author7);
        metadatums2.add(author8);
        metadatums2.add(doi2);
        metadatums2.add(type2);
        metadatums2.add(adsbibcode2);
        metadatums2.add(date2);
        metadatums2.add(subject3);
        metadatums2.add(subject4);
        metadatums2.add(source2);
        metadatums2.add(title2);
        ImportRecord secondRecord = new ImportRecord(metadatums2);
        records.add(firstrRecord);
        records.add(secondRecord);
        return records;
    }
}

