/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.dspace.app.rest.AbstractLiveImportIntegrationTest;
import org.dspace.importer.external.cinii.CiniiImportMetadataSourceServiceImpl;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.liveimportclient.service.LiveImportClientImpl;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;

public class CiniiImportMetadataSourceServiceIT
extends AbstractLiveImportIntegrationTest {
    @Autowired
    private LiveImportClientImpl liveImportClientImpl;
    @Autowired
    private CiniiImportMetadataSourceServiceImpl ciniiServiceImpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void ciniiImportMetadataGetRecordsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        CloseableHttpClient originalHttpClient = this.liveImportClientImpl.getHttpClient();
        CloseableHttpClient httpClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        InputStream ciniiRefResp = null;
        InputStream ciniiRefResp2 = null;
        InputStream ciniiRefResp3 = null;
        try {
            ciniiRefResp = ((Object)((Object)this)).getClass().getResourceAsStream("cinii-responce-ids.xml");
            ciniiRefResp2 = ((Object)((Object)this)).getClass().getResourceAsStream("cinii-first.xml");
            ciniiRefResp3 = ((Object)((Object)this)).getClass().getResourceAsStream("cinii-second.xml");
            String ciniiIdsXmlResp = IOUtils.toString((InputStream)ciniiRefResp, (Charset)Charset.defaultCharset());
            String ciniiFirstXmlResp = IOUtils.toString((InputStream)ciniiRefResp2, (Charset)Charset.defaultCharset());
            String ciniiSecondXmlResp = IOUtils.toString((InputStream)ciniiRefResp3, (Charset)Charset.defaultCharset());
            this.liveImportClientImpl.setHttpClient(httpClient);
            CloseableHttpResponse response = this.mockResponse(ciniiIdsXmlResp, 200, "OK");
            CloseableHttpResponse response2 = this.mockResponse(ciniiFirstXmlResp, 200, "OK");
            CloseableHttpResponse response3 = this.mockResponse(ciniiSecondXmlResp, 200, "OK");
            Mockito.when((Object)httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)response, (Object[])new CloseableHttpResponse[]{response2, response3});
            this.context.restoreAuthSystemState();
            ArrayList<ImportRecord> collection2match = this.getRecords();
            Collection recordsImported = this.ciniiServiceImpl.getRecords("test query", 0, 2);
            Assert.assertEquals((long)2L, (long)recordsImported.size());
            this.matchRecords(new ArrayList<ImportRecord>(recordsImported), collection2match);
        }
        finally {
            this.liveImportClientImpl.setHttpClient(originalHttpClient);
            if (Objects.nonNull(ciniiRefResp)) {
                ciniiRefResp.close();
            }
            if (Objects.nonNull(ciniiRefResp2)) {
                ciniiRefResp2.close();
            }
            if (Objects.nonNull(ciniiRefResp3)) {
                ciniiRefResp3.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void ciniiImportMetadataGetRecordsCountTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        CloseableHttpClient originalHttpClient = this.liveImportClientImpl.getHttpClient();
        CloseableHttpClient httpClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        try (InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("cinii-responce-ids.xml");){
            String ciniiXmlResp = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            this.liveImportClientImpl.setHttpClient(httpClient);
            CloseableHttpResponse response = this.mockResponse(ciniiXmlResp, 200, "OK");
            Mockito.when((Object)httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)response);
            this.context.restoreAuthSystemState();
            int tot = this.ciniiServiceImpl.getRecordsCount("test query");
            Assert.assertEquals((long)32L, (long)tot);
        }
        finally {
            this.liveImportClientImpl.setHttpClient(originalHttpClient);
        }
    }

    private ArrayList<ImportRecord> getRecords() {
        ArrayList<ImportRecord> records = new ArrayList<ImportRecord>();
        ArrayList<MetadatumDTO> metadatums = new ArrayList<MetadatumDTO>();
        MetadatumDTO title = this.createMetadatumDTO("dc", "title", null, "Understanding the impact of mandatory accrual accounting on management practices: Interpretation of Japanese local governments\u2019 behavior");
        MetadatumDTO identifier = this.createMetadatumDTO("dc", "identifier", "other", "1010572092222310146");
        metadatums.add(title);
        metadatums.add(identifier);
        ImportRecord firstrRecord = new ImportRecord(metadatums);
        ArrayList<MetadatumDTO> metadatums2 = new ArrayList<MetadatumDTO>();
        MetadatumDTO title2 = this.createMetadatumDTO("dc", "title", null, "Band structures of passive films on titanium in simulated bioliquids determined by photoelectrochemical response: principle governing the biocompatibility");
        MetadatumDTO language = this.createMetadatumDTO("dc", "language", "iso", "en");
        MetadatumDTO identifier2 = this.createMetadatumDTO("dc", "identifier", "other", "1050010687833449984");
        metadatums2.add(title2);
        metadatums2.add(language);
        metadatums2.add(identifier2);
        ImportRecord secondRecord = new ImportRecord(metadatums2);
        records.add(firstrRecord);
        records.add(secondRecord);
        return records;
    }
}

