/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import jakarta.el.MethodNotFoundException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.dspace.app.rest.AbstractLiveImportIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.importer.external.crossref.CrossRefImportMetadataSourceServiceImpl;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.liveimportclient.service.LiveImportClientImpl;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;

public class CrossRefImportMetadataSourceServiceIT
extends AbstractLiveImportIntegrationTest {
    @Autowired
    private LiveImportClientImpl liveImportClientImpl;
    @Autowired
    private CrossRefImportMetadataSourceServiceImpl crossRefServiceImpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void crossRefImportMetadataGetNoRecordsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        CloseableHttpClient originalHttpClient = this.liveImportClientImpl.getHttpClient();
        CloseableHttpClient httpClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        try {
            this.liveImportClientImpl.setHttpClient(httpClient);
            CloseableHttpResponse response = this.mockResponse("", 404, "Not Found");
            Mockito.when((Object)httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)response);
            this.context.restoreAuthSystemState();
            Collection recordsImported = this.crossRefServiceImpl.getRecords("test query", 0, 2);
            Assert.assertEquals((long)0L, (long)recordsImported.size());
        }
        finally {
            this.liveImportClientImpl.setHttpClient(originalHttpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void crossRefImportMetadataGetRecordsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        CloseableHttpClient originalHttpClient = this.liveImportClientImpl.getHttpClient();
        CloseableHttpClient httpClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        try (InputStream crossRefResp = ((Object)((Object)this)).getClass().getResourceAsStream("crossRef-test.json");){
            String crossRefRespXmlResp = IOUtils.toString((InputStream)crossRefResp, (Charset)Charset.defaultCharset());
            this.liveImportClientImpl.setHttpClient(httpClient);
            CloseableHttpResponse response = this.mockResponse(crossRefRespXmlResp, 200, "OK");
            Mockito.when((Object)httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)response);
            this.context.restoreAuthSystemState();
            ArrayList<ImportRecord> collection2match = this.getRecords();
            Collection recordsImported = this.crossRefServiceImpl.getRecords("test query", 0, 2);
            Assert.assertEquals((long)2L, (long)recordsImported.size());
            this.matchRecords(new ArrayList<ImportRecord>(recordsImported), collection2match);
        }
        finally {
            this.liveImportClientImpl.setHttpClient(originalHttpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void crossRefImportMetadataGetRecordsCountTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        CloseableHttpClient originalHttpClient = this.liveImportClientImpl.getHttpClient();
        CloseableHttpClient httpClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        try (InputStream crossRefResp = ((Object)((Object)this)).getClass().getResourceAsStream("crossRef-test.json");){
            String crossRefRespXmlResp = IOUtils.toString((InputStream)crossRefResp, (Charset)Charset.defaultCharset());
            this.liveImportClientImpl.setHttpClient(httpClient);
            CloseableHttpResponse response = this.mockResponse(crossRefRespXmlResp, 200, "OK");
            Mockito.when((Object)httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)response);
            this.context.restoreAuthSystemState();
            int tot = this.crossRefServiceImpl.getRecordsCount("test query");
            Assert.assertEquals((long)10L, (long)tot);
        }
        finally {
            this.liveImportClientImpl.setHttpClient(originalHttpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void crossRefImportMetadataGetRecordByIdTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        CloseableHttpClient originalHttpClient = this.liveImportClientImpl.getHttpClient();
        CloseableHttpClient httpClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        try (InputStream crossRefResp = ((Object)((Object)this)).getClass().getResourceAsStream("crossRef-by-id.json");){
            String crossRefRespXmlResp = IOUtils.toString((InputStream)crossRefResp, (Charset)Charset.defaultCharset());
            this.liveImportClientImpl.setHttpClient(httpClient);
            CloseableHttpResponse response = this.mockResponse(crossRefRespXmlResp, 200, "OK");
            Mockito.when((Object)httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)response);
            this.context.restoreAuthSystemState();
            ArrayList<ImportRecord> collection2match = this.getRecords();
            collection2match.remove(1);
            ImportRecord recordImported = this.crossRefServiceImpl.getRecord("10.26693/jmbs01.02.184");
            Assert.assertNotNull((Object)recordImported);
            List<ImportRecord> recordsImported = Arrays.asList(recordImported);
            this.matchRecords(new ArrayList<ImportRecord>(recordsImported), collection2match);
        }
        finally {
            this.liveImportClientImpl.setHttpClient(originalHttpClient);
        }
    }

    @Test(expected=MethodNotFoundException.class)
    public void crossRefImportMetadataFindMatchingRecordsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        org.dspace.content.Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item testItem = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)col1).withTitle("test item").withIssueDate("2021").build();
        this.context.restoreAuthSystemState();
        this.crossRefServiceImpl.findMatchingRecords(testItem);
    }

    private ArrayList<ImportRecord> getRecords() {
        ArrayList<ImportRecord> records = new ArrayList<ImportRecord>();
        ArrayList<MetadatumDTO> metadatums = new ArrayList<MetadatumDTO>();
        MetadatumDTO title = this.createMetadatumDTO("dc", "title", null, "State of Awareness of Freshers\u2019 Groups Chortkiv State Medical College of Prevention of Iodine Deficiency Diseases");
        MetadatumDTO author = this.createMetadatumDTO("dc", "contributor", "author", "L.V. Senyuk");
        MetadatumDTO type = this.createMetadatumDTO("dc", "type", null, "journal-article");
        MetadatumDTO date = this.createMetadatumDTO("dc", "date", "issued", "2016-05-19");
        MetadatumDTO ispartof = this.createMetadatumDTO("dc", "relation", "ispartof", "Ukra\u00efns\u02b9kij \u017eurnal medicini, b\u00ecolog\u00ec\u00ef ta sportu");
        MetadatumDTO doi = this.createMetadatumDTO("dc", "identifier", "doi", "10.26693/jmbs01.02.184");
        MetadatumDTO issn = this.createMetadatumDTO("dc", "identifier", "issn", "2415-3060");
        MetadatumDTO volume = this.createMetadatumDTO("oaire", "citation", "volume", "1");
        MetadatumDTO issue = this.createMetadatumDTO("oaire", "citation", "issue", "2");
        MetadatumDTO publisher = this.createMetadatumDTO("dc", "publisher", null, "Petro Mohyla Black Sea National University");
        metadatums.add(title);
        metadatums.add(author);
        metadatums.add(date);
        metadatums.add(type);
        metadatums.add(ispartof);
        metadatums.add(doi);
        metadatums.add(issn);
        metadatums.add(volume);
        metadatums.add(issue);
        metadatums.add(publisher);
        ImportRecord firstrRecord = new ImportRecord(metadatums);
        ArrayList<MetadatumDTO> metadatums2 = new ArrayList<MetadatumDTO>();
        MetadatumDTO title2 = this.createMetadatumDTO("dc", "title", null, "Ischemic Heart Disease and Role of Nurse of Cardiology Department");
        MetadatumDTO author2 = this.createMetadatumDTO("dc", "contributor", "author", "K. \u0406. Kozak");
        MetadatumDTO type2 = this.createMetadatumDTO("dc", "type", null, "journal-article");
        MetadatumDTO date2 = this.createMetadatumDTO("dc", "date", "issued", "2016-05-19");
        MetadatumDTO ispartof2 = this.createMetadatumDTO("dc", "relation", "ispartof", "Ukra\u00efns\u02b9kij \u017eurnal medicini, b\u00ecolog\u00ec\u00ef ta sportu");
        MetadatumDTO doi2 = this.createMetadatumDTO("dc", "identifier", "doi", "10.26693/jmbs01.02.105");
        MetadatumDTO issn2 = this.createMetadatumDTO("dc", "identifier", "issn", "2415-3060");
        MetadatumDTO volume2 = this.createMetadatumDTO("oaire", "citation", "volume", "1");
        MetadatumDTO issue2 = this.createMetadatumDTO("oaire", "citation", "issue", "2");
        MetadatumDTO publisher2 = this.createMetadatumDTO("dc", "publisher", null, "Petro Mohyla Black Sea National University");
        metadatums2.add(title2);
        metadatums2.add(author2);
        metadatums2.add(date2);
        metadatums2.add(type2);
        metadatums2.add(ispartof2);
        metadatums2.add(doi2);
        metadatums2.add(issn2);
        metadatums2.add(volume2);
        metadatums2.add(issue2);
        metadatums2.add(publisher2);
        ImportRecord secondRecord = new ImportRecord(metadatums2);
        records.add(firstrRecord);
        records.add(secondRecord);
        return records;
    }
}

