/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import jakarta.el.MethodNotFoundException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.dspace.app.rest.AbstractLiveImportIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.importer.external.datacite.DataCiteImportMetadataSourceServiceImpl;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.liveimportclient.service.LiveImportClientImpl;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;

public class DataCiteImportMetadataSourceServiceIT
extends AbstractLiveImportIntegrationTest {
    @Autowired
    private LiveImportClientImpl liveImportClientImpl;
    @Autowired
    private DataCiteImportMetadataSourceServiceImpl dataCiteServiceImpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void dataCiteImportMetadataGetRecordsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        CloseableHttpClient originalHttpClient = this.liveImportClientImpl.getHttpClient();
        CloseableHttpClient httpClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        try (InputStream dataCiteResp = ((Object)((Object)this)).getClass().getResourceAsStream("dataCite-test.json");){
            String dataCiteRespXmlResp = IOUtils.toString((InputStream)dataCiteResp, (Charset)Charset.defaultCharset());
            this.liveImportClientImpl.setHttpClient(httpClient);
            CloseableHttpResponse response = this.mockResponse(dataCiteRespXmlResp, 200, "OK");
            Mockito.when((Object)httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)response);
            this.context.restoreAuthSystemState();
            ArrayList<ImportRecord> collection2match = this.getRecords();
            Collection recordsImported = this.dataCiteServiceImpl.getRecords("10.48550/arxiv.2207.04779", 0, -1);
            Assert.assertEquals((long)1L, (long)recordsImported.size());
            this.matchRecords(new ArrayList<ImportRecord>(recordsImported), collection2match);
        }
        finally {
            this.liveImportClientImpl.setHttpClient(originalHttpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void dataCiteImportMetadataGetRecordsCountTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        CloseableHttpClient originalHttpClient = this.liveImportClientImpl.getHttpClient();
        CloseableHttpClient httpClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        try (InputStream dataciteResp = ((Object)((Object)this)).getClass().getResourceAsStream("dataCite-test.json");){
            String dataciteTextResp = IOUtils.toString((InputStream)dataciteResp, (Charset)Charset.defaultCharset());
            this.liveImportClientImpl.setHttpClient(httpClient);
            CloseableHttpResponse response = this.mockResponse(dataciteTextResp, 200, "OK");
            Mockito.when((Object)httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)response);
            this.context.restoreAuthSystemState();
            int tot = this.dataCiteServiceImpl.getRecordsCount("10.48550/arxiv.2207.04779");
            Assert.assertEquals((long)1L, (long)tot);
        }
        finally {
            this.liveImportClientImpl.setHttpClient(originalHttpClient);
        }
    }

    @Test(expected=MethodNotFoundException.class)
    public void dataCiteImportMetadataFindMatchingRecordsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        org.dspace.content.Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item testItem = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)col1).withTitle("test item").withIssueDate("2021").build();
        this.context.restoreAuthSystemState();
        this.dataCiteServiceImpl.findMatchingRecords(testItem);
    }

    private ArrayList<ImportRecord> getRecords() {
        ArrayList<ImportRecord> records = new ArrayList<ImportRecord>();
        ArrayList<MetadatumDTO> metadatums = new ArrayList<MetadatumDTO>();
        MetadatumDTO title = this.createMetadatumDTO("dc", "title", null, "Mathematical Proof Between Generations");
        MetadatumDTO doi = this.createMetadatumDTO("dc", "identifier", "doi", "10.48550/arxiv.2207.04779");
        MetadatumDTO author1 = this.createMetadatumDTO("dc", "contributor", "author", "Bayer, Jonas");
        MetadatumDTO author2 = this.createMetadatumDTO("dc", "contributor", "author", "Benzm\u00fcller, Christoph");
        MetadatumDTO author3 = this.createMetadatumDTO("dc", "contributor", "author", "Buzzard, Kevin");
        MetadatumDTO author4 = this.createMetadatumDTO("dc", "contributor", "author", "David, Marco");
        MetadatumDTO author5 = this.createMetadatumDTO("dc", "contributor", "author", "Lamport, Leslie");
        MetadatumDTO author6 = this.createMetadatumDTO("dc", "contributor", "author", "Matiyasevich, Yuri");
        MetadatumDTO author7 = this.createMetadatumDTO("dc", "contributor", "author", "Paulson, Lawrence");
        MetadatumDTO author8 = this.createMetadatumDTO("dc", "contributor", "author", "Schleicher, Dierk");
        MetadatumDTO author9 = this.createMetadatumDTO("dc", "contributor", "author", "Stock, Benedikt");
        MetadatumDTO author10 = this.createMetadatumDTO("dc", "contributor", "author", "Zelmanov, Efim");
        metadatums.add(title);
        metadatums.add(doi);
        metadatums.add(author1);
        metadatums.add(author2);
        metadatums.add(author3);
        metadatums.add(author4);
        metadatums.add(author5);
        metadatums.add(author6);
        metadatums.add(author7);
        metadatums.add(author8);
        metadatums.add(author9);
        metadatums.add(author10);
        ImportRecord firstRecord = new ImportRecord(metadatums);
        records.add(firstRecord);
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void dataCiteImportMetadataNoResultsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        CloseableHttpClient originalHttpClient = this.liveImportClientImpl.getHttpClient();
        CloseableHttpClient httpClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        try (InputStream dataciteResp = ((Object)((Object)this)).getClass().getResourceAsStream("dataCite-noResults.json");){
            String dataciteTextResp = IOUtils.toString((InputStream)dataciteResp, (Charset)Charset.defaultCharset());
            this.liveImportClientImpl.setHttpClient(httpClient);
            CloseableHttpResponse response = this.mockResponse(dataciteTextResp, 200, "OK");
            Mockito.when((Object)httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)response);
            this.context.restoreAuthSystemState();
            int tot = this.dataCiteServiceImpl.getRecordsCount("nocontent");
            Assert.assertEquals((long)0L, (long)tot);
            Collection importRecords = this.dataCiteServiceImpl.getRecords("nocontent", 0, -1);
            Assert.assertEquals((long)0L, (long)importRecords.size());
        }
        finally {
            this.liveImportClientImpl.setHttpClient(originalHttpClient);
        }
    }
}

