/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.function.FailableFunction;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.dspace.app.rest.matcher.MetadataMatcher;
import org.dspace.app.rest.matcher.PageMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EntityTypeBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.RelationshipBuilder;
import org.dspace.builder.RelationshipTypeBuilder;
import org.dspace.builder.VersionBuilder;
import org.dspace.builder.WorkflowItemBuilder;
import org.dspace.builder.WorkspaceItemBuilder;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.EntityType;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipType;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.RelationshipService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.IndexingService;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SolrSearchCore;
import org.dspace.discovery.indexobject.IndexableItem;
import org.dspace.util.RelationshipVersioningTestUtils;
import org.dspace.versioning.Version;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class DiscoveryVersioningIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private SearchService searchService;
    @Autowired
    private IndexingService indexingService;
    @Autowired
    private SolrSearchCore solrSearchCore;
    @Autowired
    private ItemService itemService;
    @Autowired
    private InstallItemService installItemService;
    @Autowired
    private WorkspaceItemService workspaceItemService;
    @Autowired
    private RelationshipService relationshipService;
    protected Community community;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.community = CommunityBuilder.createCommunity((Context)this.context).withName("community").build();
        this.context.restoreAuthSystemState();
    }

    @After
    public void destroy() throws Exception {
        super.destroy();
    }

    protected Matcher<? super Object> matchSearchResult(Item item, String title) {
        return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.indexableObject.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + item.getID()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.indexableObject", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{MetadataMatcher.matchMetadata("dc.title", title)})))));
    }

    protected Matcher<? super Object> matchSearchResult(Community community) {
        return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.indexableObject.href", (Matcher)Matchers.containsString((String)("/api/core/communities/" + community.getID()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.indexableObject", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)community.getID().toString()))})));
    }

    protected Matcher<? super Object> matchSearchResult(org.dspace.content.Collection collection) {
        return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.indexableObject.href", (Matcher)Matchers.containsString((String)("/api/core/collections/" + collection.getID()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.indexableObject", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)collection.getID().toString()))})));
    }

    protected void verifyRestSearchObjects(String configuration, List<Matcher<? super Object>> searchResultMatchers) throws Exception {
        this.verifyRestSearchObjects(null, configuration, searchResultMatchers);
    }

    protected void verifyRestSearchObjects(String authToken, String configuration, List<Matcher<? super Object>> searchResultMatchers) throws Exception {
        this.verifyRestSearchObjects(authToken, configuration, (FailableFunction<MockHttpServletRequestBuilder, MockHttpServletRequestBuilder, Exception>)((FailableFunction)r -> r), searchResultMatchers);
    }

    protected void verifyRestSearchObjects(String authToken, String configuration, FailableFunction<MockHttpServletRequestBuilder, MockHttpServletRequestBuilder, Exception> modifyRequest, List<Matcher<? super Object>> searchResultMatchers) throws Exception {
        MockHttpServletRequestBuilder minRequest = MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{configuration});
        MockHttpServletRequestBuilder modifiedRequest = (MockHttpServletRequestBuilder)modifyRequest.apply((Object)minRequest);
        this.getClient(authToken).perform((RequestBuilder)modifiedRequest).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, searchResultMatchers.size() == 0 ? 0 : 1, searchResultMatchers.size())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.containsInAnyOrder(searchResultMatchers)));
    }

    protected DiscoverResult getItemSearchResult(Item item) throws Exception {
        DiscoverQuery query = new DiscoverQuery();
        query.setQuery(String.format("search.resourcetype:\"Item\" AND search.resourceid:\"%s\"", item.getID()));
        return this.searchService.search(this.context, query);
    }

    protected void verifyIndexed(Item item) throws Exception {
        DiscoverResult searchResult = this.getItemSearchResult(item);
        Assert.assertEquals((long)1L, (long)searchResult.getTotalSearchResults());
    }

    protected void verifyNotIndexed(Item item) throws Exception {
        DiscoverResult searchResult = this.getItemSearchResult(item);
        Assert.assertEquals((long)0L, (long)searchResult.getTotalSearchResults());
    }

    protected void verifySolrField(Item item, String fieldName, List<Object> expectedValues) throws Exception {
        QueryResponse result = this.solrSearchCore.getSolr().query((SolrParams)new SolrQuery(String.format("search.resourcetype:\"Item\" AND search.resourceid:\"%s\"", item.getID())));
        SolrDocumentList docs = result.getResults();
        Assert.assertEquals((long)1L, (long)docs.size());
        SolrDocument doc = (SolrDocument)docs.get(0);
        Collection actualValues = doc.getFieldValues(fieldName);
        if (expectedValues == null) {
            Assert.assertNull((Object)actualValues);
        } else {
            MatcherAssert.assertThat((Object)actualValues, (Matcher)Matchers.containsInAnyOrder((Object[])expectedValues.toArray()));
        }
    }

    protected Item createNewVersion(Item currentItem, String newTitle) throws Exception {
        return this.createNewVersion(currentItem, newTitle, null);
    }

    protected Item createNewVersion(Item currentItem, String newTitle, Boolean isDiscoverable) throws Exception {
        this.context.turnOffAuthorisationSystem();
        Version v2 = VersionBuilder.createVersion((Context)this.context, (Item)currentItem, (String)("create: " + newTitle)).build();
        Item newItem = v2.getItem();
        Assert.assertNotEquals((Object)currentItem, (Object)newItem);
        if (isDiscoverable != null) {
            newItem.setDiscoverable(isDiscoverable.booleanValue());
        }
        this.itemService.replaceMetadata(this.context, (DSpaceObject)newItem, "dc", "title", null, "*", newTitle, null, -1, 0);
        this.itemService.update(this.context, (DSpaceObject)newItem);
        this.context.commit();
        this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.findByItem(this.context, newItem));
        this.context.commit();
        this.indexingService.commit();
        this.context.restoreAuthSystemState();
        return newItem;
    }

    protected org.dspace.content.Collection createCollection() {
        return this.createCollection("collection without entity type", null);
    }

    protected org.dspace.content.Collection createCollection(String entityType) {
        return this.createCollection("collection: " + entityType, entityType);
    }

    protected org.dspace.content.Collection createCollection(String name, String entityType) {
        this.context.turnOffAuthorisationSystem();
        CollectionBuilder builder = CollectionBuilder.createCollection((Context)this.context, (Community)this.community);
        if (name != null) {
            builder.withName(name);
        }
        if (entityType != null) {
            builder.withEntityType(entityType);
        }
        org.dspace.content.Collection collection = builder.build();
        this.context.restoreAuthSystemState();
        return collection;
    }

    @Test
    public void test_discoveryXml_default_expectLatestVersionsOnly() throws Exception {
        String configuration = null;
        org.dspace.content.Collection collection = this.createCollection();
        this.context.turnOffAuthorisationSystem();
        Item i1_1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).withTitle("item 1.1").build();
        this.context.restoreAuthSystemState();
        this.verifyIndexed(i1_1);
        this.verifyRestSearchObjects(configuration, List.of(this.matchSearchResult(this.community), this.matchSearchResult(collection), this.matchSearchResult(i1_1, "item 1.1")));
        Item i1_2 = this.createNewVersion(i1_1, "item 1.2");
        this.verifyIndexed(i1_1);
        this.verifyIndexed(i1_2);
        this.verifyRestSearchObjects(configuration, List.of(this.matchSearchResult(this.community), this.matchSearchResult(collection), this.matchSearchResult(i1_2, "item 1.2")));
    }

    @Test
    public void test_discoveryXml_defaultRelationships_allVersions() throws Exception {
        String configuration = "default-relationships";
        org.dspace.content.Collection collection = this.createCollection();
        this.context.turnOffAuthorisationSystem();
        Item i1_1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).withTitle("item 1.1").build();
        this.context.restoreAuthSystemState();
        this.verifyIndexed(i1_1);
        this.verifyRestSearchObjects("default-relationships", List.of(this.matchSearchResult(this.community), this.matchSearchResult(collection), this.matchSearchResult(i1_1, "item 1.1")));
        Item i1_2 = this.createNewVersion(i1_1, "item 1.2");
        this.verifyIndexed(i1_1);
        this.verifyIndexed(i1_2);
        this.verifyRestSearchObjects("default-relationships", List.of(this.matchSearchResult(this.community), this.matchSearchResult(collection), this.matchSearchResult(i1_1, "item 1.1"), this.matchSearchResult(i1_2, "item 1.2")));
    }

    @Test
    public void test_discoveryXml_site_expectLatestVersionsOnly() throws Exception {
        String configuration = "site";
        org.dspace.content.Collection collection = this.createCollection();
        this.context.turnOffAuthorisationSystem();
        Item i1_1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).withTitle("item 1.1").build();
        this.context.restoreAuthSystemState();
        this.verifyIndexed(i1_1);
        this.verifyRestSearchObjects("site", List.of(this.matchSearchResult(this.community), this.matchSearchResult(collection), this.matchSearchResult(i1_1, "item 1.1")));
        Item i1_2 = this.createNewVersion(i1_1, "item 1.2");
        this.verifyIndexed(i1_1);
        this.verifyIndexed(i1_2);
        this.verifyRestSearchObjects("site", List.of(this.matchSearchResult(this.community), this.matchSearchResult(collection), this.matchSearchResult(i1_2, "item 1.2")));
    }

    @Test
    public void test_discoveryXml_workspace_expectLatestVersionsOnly() throws Exception {
        String configuration = "workspace";
        org.dspace.content.Collection collection = this.createCollection();
        this.context.setCurrentUser(this.admin);
        this.context.turnOffAuthorisationSystem();
        Item i1_1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).withTitle("item 1.1").build();
        this.context.restoreAuthSystemState();
        this.verifyIndexed(i1_1);
        this.verifyRestSearchObjects(this.getAuthToken(this.admin.getEmail(), this.password), "workspace", List.of(this.matchSearchResult(i1_1, "item 1.1")));
        Item i1_2 = this.createNewVersion(i1_1, "item 1.2");
        this.verifyIndexed(i1_1);
        this.verifyIndexed(i1_2);
        this.verifyRestSearchObjects(this.getAuthToken(this.admin.getEmail(), this.password), "workspace", List.of(this.matchSearchResult(i1_2, "item 1.2")));
    }

    @Test
    public void test_discoveryXml_undiscoverable_expectLatestVersionsOnly() throws Exception {
        String configuration = "undiscoverable";
        org.dspace.content.Collection collection = this.createCollection();
        this.context.setCurrentUser(this.admin);
        this.context.turnOffAuthorisationSystem();
        Item i1_1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).withTitle("item 1.1").makeUnDiscoverable().build();
        this.context.restoreAuthSystemState();
        this.verifyIndexed(i1_1);
        this.verifyRestSearchObjects(this.getAuthToken(this.admin.getEmail(), this.password), "undiscoverable", List.of(this.matchSearchResult(i1_1, "item 1.1")));
        Item i1_2 = this.createNewVersion(i1_1, "item 1.2", false);
        this.verifyIndexed(i1_1);
        this.verifyIndexed(i1_2);
        this.verifyRestSearchObjects(this.getAuthToken(this.admin.getEmail(), this.password), "undiscoverable", List.of(this.matchSearchResult(i1_2, "item 1.2")));
    }

    @Test
    public void test_discoveryXml_administrativeView_expectLatestVersionsOnly() throws Exception {
        String configuration = "administrativeView";
        org.dspace.content.Collection collection = this.createCollection();
        this.context.turnOffAuthorisationSystem();
        Item i1_1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).withTitle("item 1.1").build();
        this.context.restoreAuthSystemState();
        this.verifyIndexed(i1_1);
        this.verifyRestSearchObjects("administrativeView", List.of(this.matchSearchResult(i1_1, "item 1.1")));
        Item i1_2 = this.createNewVersion(i1_1, "item 1.2");
        this.verifyIndexed(i1_1);
        this.verifyIndexed(i1_2);
        this.verifyRestSearchObjects("administrativeView", List.of(this.matchSearchResult(i1_2, "item 1.2")));
    }

    @Test
    public void test_discoveryXml_publication_expectLatestVersionsOnly() throws Exception {
        String configuration = "publication";
        org.dspace.content.Collection collection = this.createCollection("Publication");
        this.context.turnOffAuthorisationSystem();
        Item i1_1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).withTitle("item 1.1").build();
        this.context.restoreAuthSystemState();
        this.verifyIndexed(i1_1);
        this.verifyRestSearchObjects("publication", List.of(this.matchSearchResult(i1_1, "item 1.1")));
        Item i1_2 = this.createNewVersion(i1_1, "item 1.2");
        this.verifyIndexed(i1_1);
        this.verifyIndexed(i1_2);
        this.verifyRestSearchObjects("publication", List.of(this.matchSearchResult(i1_2, "item 1.2")));
    }

    @Test
    public void test_discoveryXml_publicationRelationships_allVersions() throws Exception {
        String configuration = "publication-relationships";
        org.dspace.content.Collection collection = this.createCollection("Publication");
        this.context.turnOffAuthorisationSystem();
        Item i1_1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).withTitle("item 1.1").build();
        this.context.restoreAuthSystemState();
        this.verifyIndexed(i1_1);
        this.verifyRestSearchObjects("publication-relationships", List.of(this.matchSearchResult(i1_1, "item 1.1")));
        Item i1_2 = this.createNewVersion(i1_1, "item 1.2");
        this.verifyIndexed(i1_1);
        this.verifyIndexed(i1_2);
        this.verifyRestSearchObjects("publication-relationships", List.of(this.matchSearchResult(i1_1, "item 1.1"), this.matchSearchResult(i1_2, "item 1.2")));
    }

    @Test
    public void test_discoveryXml_person_expectLatestVersionsOnly() throws Exception {
        String configuration = "person";
        org.dspace.content.Collection collection = this.createCollection("Person");
        this.context.turnOffAuthorisationSystem();
        Item i1_1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).withTitle("item 1.1").build();
        this.context.restoreAuthSystemState();
        this.verifyIndexed(i1_1);
        this.verifyRestSearchObjects("person", List.of(this.matchSearchResult(i1_1, "item 1.1")));
        Item i1_2 = this.createNewVersion(i1_1, "item 1.2");
        this.verifyIndexed(i1_1);
        this.verifyIndexed(i1_2);
        this.verifyRestSearchObjects("person", List.of(this.matchSearchResult(i1_2, "item 1.2")));
    }

    @Test
    public void test_discoveryXml_personRelationships_allVersions() throws Exception {
        String configuration = "person-relationships";
        org.dspace.content.Collection collection = this.createCollection("Person");
        this.context.turnOffAuthorisationSystem();
        Item i1_1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).withTitle("item 1.1").build();
        this.context.restoreAuthSystemState();
        this.verifyIndexed(i1_1);
        this.verifyRestSearchObjects("person-relationships", List.of(this.matchSearchResult(i1_1, "item 1.1")));
        Item i1_2 = this.createNewVersion(i1_1, "item 1.2");
        this.verifyIndexed(i1_1);
        this.verifyIndexed(i1_2);
        this.verifyRestSearchObjects("person-relationships", List.of(this.matchSearchResult(i1_1, "item 1.1"), this.matchSearchResult(i1_2, "item 1.2")));
    }

    @Test
    public void test_discoveryXml_orgunit_expectLatestVersionsOnly() throws Exception {
        String configuration = "orgunit";
        org.dspace.content.Collection collection = this.createCollection("OrgUnit");
        this.context.turnOffAuthorisationSystem();
        Item i1_1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).withTitle("item 1.1").build();
        this.context.restoreAuthSystemState();
        this.verifyIndexed(i1_1);
        this.verifyRestSearchObjects("orgunit", List.of(this.matchSearchResult(i1_1, "item 1.1")));
        Item i1_2 = this.createNewVersion(i1_1, "item 1.2");
        this.verifyIndexed(i1_1);
        this.verifyIndexed(i1_2);
        this.verifyRestSearchObjects("orgunit", List.of(this.matchSearchResult(i1_2, "item 1.2")));
    }

    @Test
    public void test_discoveryXml_orgunitRelationships_allVersions() throws Exception {
        String configuration = "orgunit-relationships";
        org.dspace.content.Collection collection = this.createCollection("OrgUnit");
        this.context.turnOffAuthorisationSystem();
        Item i1_1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).withTitle("item 1.1").build();
        this.context.restoreAuthSystemState();
        this.verifyIndexed(i1_1);
        this.verifyRestSearchObjects("orgunit-relationships", List.of(this.matchSearchResult(i1_1, "item 1.1")));
        Item i1_2 = this.createNewVersion(i1_1, "item 1.2");
        this.verifyIndexed(i1_1);
        this.verifyIndexed(i1_2);
        this.verifyRestSearchObjects("orgunit-relationships", List.of(this.matchSearchResult(i1_1, "item 1.1"), this.matchSearchResult(i1_2, "item 1.2")));
    }

    @Test
    public void test_discoveryXml_journalissue_expectLatestVersionsOnly() throws Exception {
        String configuration = "journalissue";
        org.dspace.content.Collection collection = this.createCollection("JournalIssue");
        this.context.turnOffAuthorisationSystem();
        Item i1_1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).withTitle("item 1.1").build();
        this.context.restoreAuthSystemState();
        this.verifyIndexed(i1_1);
        this.verifyRestSearchObjects("journalissue", List.of(this.matchSearchResult(i1_1, "item 1.1")));
        Item i1_2 = this.createNewVersion(i1_1, "item 1.2");
        this.verifyIndexed(i1_1);
        this.verifyIndexed(i1_2);
        this.verifyRestSearchObjects("journalissue", List.of(this.matchSearchResult(i1_2, "item 1.2")));
    }

    @Test
    public void test_discoveryXml_journalissueRelationships_allVersions() throws Exception {
        String configuration = "journalissue-relationships";
        org.dspace.content.Collection collection = this.createCollection("JournalIssue");
        this.context.turnOffAuthorisationSystem();
        Item i1_1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).withTitle("item 1.1").build();
        this.context.restoreAuthSystemState();
        this.verifyIndexed(i1_1);
        this.verifyRestSearchObjects("journalissue-relationships", List.of(this.matchSearchResult(i1_1, "item 1.1")));
        Item i1_2 = this.createNewVersion(i1_1, "item 1.2");
        this.verifyIndexed(i1_1);
        this.verifyIndexed(i1_2);
        this.verifyRestSearchObjects("journalissue-relationships", List.of(this.matchSearchResult(i1_1, "item 1.1"), this.matchSearchResult(i1_2, "item 1.2")));
    }

    @Test
    public void test_discoveryXml_journalvolume_expectLatestVersionsOnly() throws Exception {
        String configuration = "journalvolume";
        org.dspace.content.Collection collection = this.createCollection("JournalVolume");
        this.context.turnOffAuthorisationSystem();
        Item i1_1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).withTitle("item 1.1").build();
        this.context.restoreAuthSystemState();
        this.verifyIndexed(i1_1);
        this.verifyRestSearchObjects("journalvolume", List.of(this.matchSearchResult(i1_1, "item 1.1")));
        Item i1_2 = this.createNewVersion(i1_1, "item 1.2");
        this.verifyIndexed(i1_1);
        this.verifyIndexed(i1_2);
        this.verifyRestSearchObjects("journalvolume", List.of(this.matchSearchResult(i1_2, "item 1.2")));
    }

    @Test
    public void test_discoveryXml_journalvolumeRelationships_allVersions() throws Exception {
        String configuration = "journalvolume-relationships";
        org.dspace.content.Collection collection = this.createCollection("JournalVolume");
        this.context.turnOffAuthorisationSystem();
        Item i1_1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).withTitle("item 1.1").build();
        this.context.restoreAuthSystemState();
        this.verifyIndexed(i1_1);
        this.verifyRestSearchObjects("journalvolume-relationships", List.of(this.matchSearchResult(i1_1, "item 1.1")));
        Item i1_2 = this.createNewVersion(i1_1, "item 1.2");
        this.verifyIndexed(i1_1);
        this.verifyIndexed(i1_2);
        this.verifyRestSearchObjects("journalvolume-relationships", List.of(this.matchSearchResult(i1_1, "item 1.1"), this.matchSearchResult(i1_2, "item 1.2")));
    }

    @Test
    public void test_discoveryXml_journal_expectLatestVersionsOnly() throws Exception {
        String configuration = "journal";
        org.dspace.content.Collection collection = this.createCollection("Journal");
        this.context.turnOffAuthorisationSystem();
        Item i1_1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).withTitle("item 1.1").build();
        this.context.restoreAuthSystemState();
        this.verifyIndexed(i1_1);
        this.verifyRestSearchObjects("journal", List.of(this.matchSearchResult(i1_1, "item 1.1")));
        Item i1_2 = this.createNewVersion(i1_1, "item 1.2");
        this.verifyIndexed(i1_1);
        this.verifyIndexed(i1_2);
        this.verifyRestSearchObjects("journal", List.of(this.matchSearchResult(i1_2, "item 1.2")));
    }

    @Test
    public void test_discoveryXml_journalRelationships_allVersions() throws Exception {
        String configuration = "journal-relationships";
        org.dspace.content.Collection collection = this.createCollection("Journal");
        this.context.turnOffAuthorisationSystem();
        Item i1_1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).withTitle("item 1.1").build();
        this.context.restoreAuthSystemState();
        this.verifyIndexed(i1_1);
        this.verifyRestSearchObjects("journal-relationships", List.of(this.matchSearchResult(i1_1, "item 1.1")));
        Item i1_2 = this.createNewVersion(i1_1, "item 1.2");
        this.verifyIndexed(i1_1);
        this.verifyIndexed(i1_2);
        this.verifyRestSearchObjects("journal-relationships", List.of(this.matchSearchResult(i1_1, "item 1.1"), this.matchSearchResult(i1_2, "item 1.2")));
    }

    @Test
    public void test_discoveryXml_project_expectLatestVersionsOnly() throws Exception {
        String configuration = "project";
        org.dspace.content.Collection collection = this.createCollection("Project");
        this.context.turnOffAuthorisationSystem();
        Item i1_1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).withTitle("item 1.1").build();
        this.context.restoreAuthSystemState();
        this.verifyIndexed(i1_1);
        this.verifyRestSearchObjects("project", List.of(this.matchSearchResult(i1_1, "item 1.1")));
        Item i1_2 = this.createNewVersion(i1_1, "item 1.2");
        this.verifyIndexed(i1_1);
        this.verifyIndexed(i1_2);
        this.verifyRestSearchObjects("project", List.of(this.matchSearchResult(i1_2, "item 1.2")));
    }

    @Test
    public void test_discoveryXml_projectRelationships_allVersions() throws Exception {
        String configuration = "project-relationships";
        org.dspace.content.Collection collection = this.createCollection("Project");
        this.context.turnOffAuthorisationSystem();
        Item i1_1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).withTitle("item 1.1").build();
        this.context.restoreAuthSystemState();
        this.verifyIndexed(i1_1);
        this.verifyRestSearchObjects("project-relationships", List.of(this.matchSearchResult(i1_1, "item 1.1")));
        Item i1_2 = this.createNewVersion(i1_1, "item 1.2");
        this.verifyIndexed(i1_1);
        this.verifyIndexed(i1_2);
        this.verifyRestSearchObjects("project-relationships", List.of(this.matchSearchResult(i1_1, "item 1.1"), this.matchSearchResult(i1_2, "item 1.2")));
    }

    @Test
    public void test_discoveryXml_personOrOrgunit_expectLatestVersionsOnly() throws Exception {
        String configuration = "personOrOrgunit";
        org.dspace.content.Collection collection = this.createCollection("Person");
        this.context.turnOffAuthorisationSystem();
        Item i1_1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).withTitle("item 1.1").build();
        this.context.restoreAuthSystemState();
        this.verifyIndexed(i1_1);
        this.verifyRestSearchObjects("personOrOrgunit", List.of(this.matchSearchResult(i1_1, "item 1.1")));
        Item i1_2 = this.createNewVersion(i1_1, "item 1.2");
        this.verifyIndexed(i1_1);
        this.verifyIndexed(i1_2);
        this.verifyRestSearchObjects("personOrOrgunit", List.of(this.matchSearchResult(i1_2, "item 1.2")));
    }

    @Test
    public void test_discoveryXml_openaireFundingAgency_expectLatestVersionsOnly() throws Exception {
        String configuration = "openaireFundingAgency";
        org.dspace.content.Collection collection = this.createCollection("OrgUnit");
        this.context.turnOffAuthorisationSystem();
        Item i1_1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).withTitle("item 1.1").withType("FundingOrganization").build();
        this.context.restoreAuthSystemState();
        this.verifyIndexed(i1_1);
        this.verifyRestSearchObjects("openaireFundingAgency", List.of(this.matchSearchResult(i1_1, "item 1.1")));
        Item i1_2 = this.createNewVersion(i1_1, "item 1.2");
        this.verifyIndexed(i1_1);
        this.verifyIndexed(i1_2);
        this.verifyRestSearchObjects("openaireFundingAgency", List.of(this.matchSearchResult(i1_2, "item 1.2")));
    }

    @Test
    public void test_reindexAfterUpdatingLatestVersionStatus() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EntityType publicationEntityType = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Publication").build();
        EntityType projectEntityType = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Project").build();
        RelationshipType isProjectOfPublication = RelationshipTypeBuilder.createRelationshipTypeBuilder((Context)this.context, (EntityType)publicationEntityType, (EntityType)projectEntityType, (String)"isProjectOfPublication", (String)"isPublicationOfProject", null, null, null, null).withCopyToLeft(false).withCopyToRight(false).build();
        org.dspace.content.Collection publicationCollection = this.createCollection(publicationEntityType.getLabel());
        Item pub1_1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)publicationCollection).withTitle("publication 1").build();
        String idPub1_1 = pub1_1.getID().toString();
        org.dspace.content.Collection projectCollection = this.createCollection(projectEntityType.getLabel());
        Item pro1_1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)projectCollection).withTitle("project 1").build();
        String idPro1_1 = pro1_1.getID().toString();
        RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)pub1_1, (Item)pro1_1, (RelationshipType)isProjectOfPublication).build();
        this.context.restoreAuthSystemState();
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pub1_1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel((Item)pub1_1, (RelationshipType)isProjectOfPublication, (Item)pro1_1, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.BOTH, (int)0, (int)0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pro1_1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel((Item)pub1_1, (RelationshipType)isProjectOfPublication, (Item)pro1_1, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.BOTH, (int)0, (int)0))));
        List mdvs1 = this.itemService.getMetadata((DSpaceObject)pub1_1, "relation", "isProjectOfPublication", null, "*");
        Assert.assertEquals((long)1L, (long)mdvs1.size());
        Assert.assertEquals((Object)pro1_1.getID().toString(), (Object)((MetadataValue)mdvs1.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs1.get(0)).getPlace());
        List mdvs1a = this.itemService.getMetadata((DSpaceObject)pub1_1, "relation", "isProjectOfPublication", "latestForDiscovery", "*");
        Assert.assertEquals((long)1L, (long)mdvs1a.size());
        Assert.assertEquals((Object)pro1_1.getID().toString(), (Object)((MetadataValue)mdvs1a.get(0)).getValue());
        Assert.assertEquals((long)-1L, (long)((MetadataValue)mdvs1a.get(0)).getPlace());
        List mdvs2 = this.itemService.getMetadata((DSpaceObject)pro1_1, "relation", "isPublicationOfProject", null, "*");
        Assert.assertEquals((long)1L, (long)mdvs2.size());
        Assert.assertEquals((Object)pub1_1.getID().toString(), (Object)((MetadataValue)mdvs2.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs2.get(0)).getPlace());
        List mdvs2a = this.itemService.getMetadata((DSpaceObject)pro1_1, "relation", "isPublicationOfProject", "latestForDiscovery", "*");
        Assert.assertEquals((long)1L, (long)mdvs2a.size());
        Assert.assertEquals((Object)pub1_1.getID().toString(), (Object)((MetadataValue)mdvs2a.get(0)).getValue());
        Assert.assertEquals((long)-1L, (long)((MetadataValue)mdvs2a.get(0)).getPlace());
        this.verifyRestSearchObjects(null, "project-relationships", (FailableFunction<MockHttpServletRequestBuilder, MockHttpServletRequestBuilder, Exception>)((FailableFunction)r -> r.param("f.isPublicationOfProject", new String[]{idPub1_1 + ",equals"})), List.of(this.matchSearchResult(pro1_1, "project 1")));
        this.verifyRestSearchObjects(null, "publication-relationships", (FailableFunction<MockHttpServletRequestBuilder, MockHttpServletRequestBuilder, Exception>)((FailableFunction)r -> r.param("f.isProjectOfPublication", new String[]{idPro1_1 + ",equals"})), List.of(this.matchSearchResult(pub1_1, "publication 1")));
        this.context.turnOffAuthorisationSystem();
        Item pub1_2 = VersionBuilder.createVersion((Context)this.context, (Item)pub1_1, (String)"pub 1.2").build().getItem();
        String idPub1_2 = pub1_2.getID().toString();
        this.context.commit();
        this.indexingService.commit();
        Assert.assertNotEquals((Object)pub1_1, (Object)pub1_2);
        this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.findByItem(this.context, pub1_2));
        this.context.commit();
        this.indexingService.commit();
        this.context.restoreAuthSystemState();
        pub1_1 = (Item)this.context.reloadEntity((ReloadableEntity)pub1_1);
        pub1_2 = (Item)this.context.reloadEntity((ReloadableEntity)pub1_2);
        pro1_1 = (Item)this.context.reloadEntity((ReloadableEntity)pro1_1);
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pub1_1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel((Item)pub1_1, (RelationshipType)isProjectOfPublication, (Item)pro1_1, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.RIGHT_ONLY, (int)0, (int)0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pub1_2, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel((Item)pub1_2, (RelationshipType)isProjectOfPublication, (Item)pro1_1, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.BOTH, (int)0, (int)0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pro1_1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel((Item)pub1_1, (RelationshipType)isProjectOfPublication, (Item)pro1_1, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.RIGHT_ONLY, (int)0, (int)0), RelationshipVersioningTestUtils.isRel((Item)pub1_2, (RelationshipType)isProjectOfPublication, (Item)pro1_1, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.BOTH, (int)0, (int)0))));
        List mdvs3 = this.itemService.getMetadata((DSpaceObject)pub1_1, "relation", "isProjectOfPublication", null, "*");
        Assert.assertEquals((long)1L, (long)mdvs3.size());
        Assert.assertEquals((Object)pro1_1.getID().toString(), (Object)((MetadataValue)mdvs3.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs3.get(0)).getPlace());
        this.verifySolrField(pub1_1, "relation.isProjectOfPublication", List.of(pro1_1.getID().toString()));
        this.verifySolrField(pub1_1, "archived", List.of("false"));
        this.verifySolrField(pub1_1, "latestVersion", List.of(Boolean.valueOf(false)));
        List mdvs3a = this.itemService.getMetadata((DSpaceObject)pub1_1, "relation", "isProjectOfPublication", "latestForDiscovery", "*");
        Assert.assertEquals((long)0L, (long)mdvs3a.size());
        this.verifySolrField(pub1_1, "relation.isProjectOfPublication.latestForDiscovery", null);
        List mdvs4 = this.itemService.getMetadata((DSpaceObject)pub1_2, "relation", "isProjectOfPublication", null, "*");
        Assert.assertEquals((long)1L, (long)mdvs4.size());
        Assert.assertEquals((Object)pro1_1.getID().toString(), (Object)((MetadataValue)mdvs4.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs4.get(0)).getPlace());
        this.verifySolrField(pub1_2, "relation.isProjectOfPublication", List.of(pro1_1.getID().toString()));
        this.verifySolrField(pub1_2, "archived", List.of("true"));
        this.verifySolrField(pub1_2, "latestVersion", List.of(Boolean.valueOf(true)));
        List mdvs4a = this.itemService.getMetadata((DSpaceObject)pub1_2, "relation", "isProjectOfPublication", "latestForDiscovery", "*");
        Assert.assertEquals((long)1L, (long)mdvs4a.size());
        Assert.assertEquals((Object)pro1_1.getID().toString(), (Object)((MetadataValue)mdvs4a.get(0)).getValue());
        Assert.assertEquals((long)-1L, (long)((MetadataValue)mdvs4a.get(0)).getPlace());
        this.verifySolrField(pub1_2, "relation.isProjectOfPublication.latestForDiscovery", List.of(pro1_1.getID().toString()));
        List mdvs5 = this.itemService.getMetadata((DSpaceObject)pro1_1, "relation", "isPublicationOfProject", null, "*");
        Assert.assertEquals((long)1L, (long)mdvs5.size());
        Assert.assertEquals((Object)pub1_2.getID().toString(), (Object)((MetadataValue)mdvs5.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs5.get(0)).getPlace());
        this.verifySolrField(pro1_1, "relation.isPublicationOfProject", List.of(pub1_2.getID().toString()));
        this.verifySolrField(pro1_1, "archived", List.of("true"));
        this.verifySolrField(pro1_1, "latestVersion", List.of(Boolean.valueOf(true)));
        List mdvs5a = this.itemService.getMetadata((DSpaceObject)pro1_1, "relation", "isPublicationOfProject", "latestForDiscovery", "*");
        Assert.assertEquals((long)2L, (long)mdvs5a.size());
        MatcherAssert.assertThat((Object)mdvs5a, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.hasProperty((String)"value", (Matcher)Matchers.is((Object)pub1_1.getID().toString())), (Matcher)Matchers.hasProperty((String)"place", (Matcher)Matchers.is((Object)-1))), Matchers.allOf((Matcher)Matchers.hasProperty((String)"value", (Matcher)Matchers.is((Object)pub1_2.getID().toString())), (Matcher)Matchers.hasProperty((String)"place", (Matcher)Matchers.is((Object)-1)))}));
        this.verifySolrField(pro1_1, "relation.isPublicationOfProject.latestForDiscovery", List.of(pub1_1.getID().toString(), pub1_2.getID().toString()));
        this.verifyRestSearchObjects(null, "project-relationships", (FailableFunction<MockHttpServletRequestBuilder, MockHttpServletRequestBuilder, Exception>)((FailableFunction)r -> r.param("f.isPublicationOfProject", new String[]{idPub1_1 + ",equals"})), List.of(this.matchSearchResult(pro1_1, "project 1")));
        this.verifyRestSearchObjects(null, "project-relationships", (FailableFunction<MockHttpServletRequestBuilder, MockHttpServletRequestBuilder, Exception>)((FailableFunction)r -> r.param("f.isPublicationOfProject", new String[]{idPub1_2 + ",equals"})), List.of(this.matchSearchResult(pro1_1, "project 1")));
        this.verifyRestSearchObjects(null, "publication-relationships", (FailableFunction<MockHttpServletRequestBuilder, MockHttpServletRequestBuilder, Exception>)((FailableFunction)r -> r.param("f.isProjectOfPublication", new String[]{idPro1_1 + ",equals"})), List.of(this.matchSearchResult(pub1_2, "publication 1")));
        this.context.turnOffAuthorisationSystem();
        Item pro1_2 = VersionBuilder.createVersion((Context)this.context, (Item)((Item)this.context.reloadEntity((ReloadableEntity)pro1_1)), (String)"pro 1.2").build().getItem();
        String idPro1_2 = pro1_2.getID().toString();
        this.context.commit();
        this.indexingService.commit();
        Assert.assertNotEquals((Object)pro1_1, (Object)pro1_2);
        this.context.restoreAuthSystemState();
        pub1_1 = (Item)this.context.reloadEntity((ReloadableEntity)pub1_1);
        pub1_2 = (Item)this.context.reloadEntity((ReloadableEntity)pub1_2);
        pro1_1 = (Item)this.context.reloadEntity((ReloadableEntity)pro1_1);
        pro1_2 = (Item)this.context.reloadEntity((ReloadableEntity)pro1_2);
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pub1_1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel((Item)pub1_1, (RelationshipType)isProjectOfPublication, (Item)pro1_1, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.RIGHT_ONLY, (int)0, (int)0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pub1_2, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel((Item)pub1_2, (RelationshipType)isProjectOfPublication, (Item)pro1_1, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.BOTH, (int)0, (int)0), RelationshipVersioningTestUtils.isRel((Item)pub1_2, (RelationshipType)isProjectOfPublication, (Item)pro1_2, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.LEFT_ONLY, (int)0, (int)0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pro1_1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel((Item)pub1_1, (RelationshipType)isProjectOfPublication, (Item)pro1_1, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.RIGHT_ONLY, (int)0, (int)0), RelationshipVersioningTestUtils.isRel((Item)pub1_2, (RelationshipType)isProjectOfPublication, (Item)pro1_1, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.BOTH, (int)0, (int)0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pro1_2, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel((Item)pub1_2, (RelationshipType)isProjectOfPublication, (Item)pro1_2, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.LEFT_ONLY, (int)0, (int)0))));
        List mdvs6 = this.itemService.getMetadata((DSpaceObject)pub1_1, "relation", "isProjectOfPublication", null, "*");
        Assert.assertEquals((long)1L, (long)mdvs6.size());
        Assert.assertEquals((Object)pro1_1.getID().toString(), (Object)((MetadataValue)mdvs6.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs6.get(0)).getPlace());
        this.verifySolrField(pub1_1, "relation.isProjectOfPublication", List.of(pro1_1.getID().toString()));
        this.verifySolrField(pub1_1, "archived", List.of("false"));
        this.verifySolrField(pub1_1, "latestVersion", List.of(Boolean.valueOf(false)));
        List mdvs6a = this.itemService.getMetadata((DSpaceObject)pub1_1, "relation", "isProjectOfPublication", "latestForDiscovery", "*");
        Assert.assertEquals((long)0L, (long)mdvs6a.size());
        this.verifySolrField(pub1_1, "relation.isProjectOfPublication.latestForDiscovery", null);
        List mdvs7 = this.itemService.getMetadata((DSpaceObject)pub1_2, "relation", "isProjectOfPublication", null, "*");
        Assert.assertEquals((long)1L, (long)mdvs7.size());
        Assert.assertEquals((Object)pro1_1.getID().toString(), (Object)((MetadataValue)mdvs7.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs7.get(0)).getPlace());
        this.verifySolrField(pub1_2, "relation.isProjectOfPublication", List.of(pro1_1.getID().toString()));
        this.verifySolrField(pub1_2, "archived", List.of("true"));
        this.verifySolrField(pub1_2, "latestVersion", List.of(Boolean.valueOf(true)));
        List mdvs7a = this.itemService.getMetadata((DSpaceObject)pub1_2, "relation", "isProjectOfPublication", "latestForDiscovery", "*");
        Assert.assertEquals((long)2L, (long)mdvs7a.size());
        MatcherAssert.assertThat((Object)mdvs7a, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.hasProperty((String)"value", (Matcher)Matchers.is((Object)pro1_1.getID().toString())), (Matcher)Matchers.hasProperty((String)"place", (Matcher)Matchers.is((Object)-1))), Matchers.allOf((Matcher)Matchers.hasProperty((String)"value", (Matcher)Matchers.is((Object)pro1_2.getID().toString())), (Matcher)Matchers.hasProperty((String)"place", (Matcher)Matchers.is((Object)-1)))}));
        this.verifySolrField(pub1_2, "relation.isProjectOfPublication.latestForDiscovery", List.of(pro1_1.getID().toString(), pro1_2.getID().toString()));
        List mdvs8 = this.itemService.getMetadata((DSpaceObject)pro1_1, "relation", "isPublicationOfProject", null, "*");
        Assert.assertEquals((long)1L, (long)mdvs8.size());
        Assert.assertEquals((Object)pub1_2.getID().toString(), (Object)((MetadataValue)mdvs8.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs8.get(0)).getPlace());
        this.verifySolrField(pro1_1, "relation.isPublicationOfProject", List.of(pub1_2.getID().toString()));
        this.verifySolrField(pro1_1, "archived", List.of("true"));
        this.verifySolrField(pro1_1, "latestVersion", List.of(Boolean.valueOf(true)));
        List mdvs8a = this.itemService.getMetadata((DSpaceObject)pro1_1, "relation", "isPublicationOfProject", "latestForDiscovery", "*");
        Assert.assertEquals((long)2L, (long)mdvs8a.size());
        MatcherAssert.assertThat((Object)mdvs8a, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.hasProperty((String)"value", (Matcher)Matchers.is((Object)pub1_1.getID().toString())), (Matcher)Matchers.hasProperty((String)"place", (Matcher)Matchers.is((Object)-1))), Matchers.allOf((Matcher)Matchers.hasProperty((String)"value", (Matcher)Matchers.is((Object)pub1_2.getID().toString())), (Matcher)Matchers.hasProperty((String)"place", (Matcher)Matchers.is((Object)-1)))}));
        this.verifySolrField(pro1_1, "relation.isPublicationOfProject.latestForDiscovery", List.of(pub1_1.getID().toString(), pub1_2.getID().toString()));
        List mdvs9 = this.itemService.getMetadata((DSpaceObject)pro1_2, "relation", "isPublicationOfProject", null, "*");
        Assert.assertEquals((long)1L, (long)mdvs9.size());
        Assert.assertEquals((Object)pub1_2.getID().toString(), (Object)((MetadataValue)mdvs9.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs9.get(0)).getPlace());
        this.verifyNotIndexed(pro1_2);
        List mdvs9a = this.itemService.getMetadata((DSpaceObject)pro1_2, "relation", "isPublicationOfProject", "latestForDiscovery", "*");
        Assert.assertEquals((long)0L, (long)mdvs9a.size());
        this.verifyNotIndexed(pro1_2);
        this.verifyRestSearchObjects(null, "project-relationships", (FailableFunction<MockHttpServletRequestBuilder, MockHttpServletRequestBuilder, Exception>)((FailableFunction)r -> r.param("f.isPublicationOfProject", new String[]{idPub1_1 + ",equals"})), List.of(this.matchSearchResult(pro1_1, "project 1")));
        this.verifyRestSearchObjects(null, "project-relationships", (FailableFunction<MockHttpServletRequestBuilder, MockHttpServletRequestBuilder, Exception>)((FailableFunction)r -> r.param("f.isPublicationOfProject", new String[]{idPub1_2 + ",equals"})), List.of(this.matchSearchResult(pro1_1, "project 1")));
        this.verifyRestSearchObjects(null, "publication-relationships", (FailableFunction<MockHttpServletRequestBuilder, MockHttpServletRequestBuilder, Exception>)((FailableFunction)r -> r.param("f.isProjectOfPublication", new String[]{idPro1_1 + ",equals"})), List.of(this.matchSearchResult(pub1_2, "publication 1")));
        this.verifyRestSearchObjects(null, "publication-relationships", (FailableFunction<MockHttpServletRequestBuilder, MockHttpServletRequestBuilder, Exception>)((FailableFunction)r -> r.param("f.isProjectOfPublication", new String[]{idPro1_2 + ",equals"})), List.of(this.matchSearchResult(pub1_2, "publication 1")));
        this.context.turnOffAuthorisationSystem();
        this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.findByItem(this.context, pro1_2));
        this.context.commit();
        this.indexingService.commit();
        this.context.restoreAuthSystemState();
        pub1_1 = (Item)this.context.reloadEntity((ReloadableEntity)pub1_1);
        pub1_2 = (Item)this.context.reloadEntity((ReloadableEntity)pub1_2);
        pro1_1 = (Item)this.context.reloadEntity((ReloadableEntity)pro1_1);
        pro1_2 = (Item)this.context.reloadEntity((ReloadableEntity)pro1_2);
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pub1_1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel((Item)pub1_1, (RelationshipType)isProjectOfPublication, (Item)pro1_1, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.RIGHT_ONLY, (int)0, (int)0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pub1_2, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel((Item)pub1_2, (RelationshipType)isProjectOfPublication, (Item)pro1_1, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.LEFT_ONLY, (int)0, (int)0), RelationshipVersioningTestUtils.isRel((Item)pub1_2, (RelationshipType)isProjectOfPublication, (Item)pro1_2, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.BOTH, (int)0, (int)0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pro1_1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel((Item)pub1_1, (RelationshipType)isProjectOfPublication, (Item)pro1_1, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.RIGHT_ONLY, (int)0, (int)0), RelationshipVersioningTestUtils.isRel((Item)pub1_2, (RelationshipType)isProjectOfPublication, (Item)pro1_1, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.LEFT_ONLY, (int)0, (int)0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pro1_2, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel((Item)pub1_2, (RelationshipType)isProjectOfPublication, (Item)pro1_2, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.BOTH, (int)0, (int)0))));
        List mdvs10 = this.itemService.getMetadata((DSpaceObject)pub1_1, "relation", "isProjectOfPublication", null, "*");
        Assert.assertEquals((long)1L, (long)mdvs10.size());
        Assert.assertEquals((Object)pro1_1.getID().toString(), (Object)((MetadataValue)mdvs10.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs10.get(0)).getPlace());
        this.verifySolrField(pub1_1, "relation.isProjectOfPublication", List.of(pro1_1.getID().toString()));
        this.verifySolrField(pub1_1, "archived", List.of("false"));
        this.verifySolrField(pub1_1, "latestVersion", List.of(Boolean.valueOf(false)));
        List mdvs10a = this.itemService.getMetadata((DSpaceObject)pub1_1, "relation", "isProjectOfPublication", "latestForDiscovery", "*");
        Assert.assertEquals((long)0L, (long)mdvs10a.size());
        this.verifySolrField(pub1_1, "relation.isProjectOfPublication.latestForDiscovery", null);
        List mdvs11 = this.itemService.getMetadata((DSpaceObject)pub1_2, "relation", "isProjectOfPublication", null, "*");
        Assert.assertEquals((long)1L, (long)mdvs11.size());
        Assert.assertEquals((Object)pro1_2.getID().toString(), (Object)((MetadataValue)mdvs11.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs11.get(0)).getPlace());
        this.verifySolrField(pub1_2, "relation.isProjectOfPublication", List.of(pro1_2.getID().toString()));
        this.verifySolrField(pub1_2, "archived", List.of("true"));
        this.verifySolrField(pub1_2, "latestVersion", List.of(Boolean.valueOf(true)));
        List mdvs11a = this.itemService.getMetadata((DSpaceObject)pub1_2, "relation", "isProjectOfPublication", "latestForDiscovery", "*");
        Assert.assertEquals((long)2L, (long)mdvs11a.size());
        MatcherAssert.assertThat((Object)mdvs11a, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.hasProperty((String)"value", (Matcher)Matchers.is((Object)pro1_1.getID().toString())), (Matcher)Matchers.hasProperty((String)"place", (Matcher)Matchers.is((Object)-1))), Matchers.allOf((Matcher)Matchers.hasProperty((String)"value", (Matcher)Matchers.is((Object)pro1_2.getID().toString())), (Matcher)Matchers.hasProperty((String)"place", (Matcher)Matchers.is((Object)-1)))}));
        this.verifySolrField(pub1_2, "relation.isProjectOfPublication.latestForDiscovery", List.of(pro1_1.getID().toString(), pro1_2.getID().toString()));
        List mdvs12 = this.itemService.getMetadata((DSpaceObject)pro1_1, "relation", "isPublicationOfProject", null, "*");
        Assert.assertEquals((long)1L, (long)mdvs12.size());
        Assert.assertEquals((Object)pub1_2.getID().toString(), (Object)((MetadataValue)mdvs12.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs12.get(0)).getPlace());
        this.verifySolrField(pro1_1, "relation.isPublicationOfProject", List.of(pub1_2.getID().toString()));
        this.verifySolrField(pro1_1, "archived", List.of("false"));
        this.verifySolrField(pro1_1, "latestVersion", List.of(Boolean.valueOf(false)));
        List mdvs12a = this.itemService.getMetadata((DSpaceObject)pro1_1, "relation", "isPublicationOfProject", "latestForDiscovery", "*");
        Assert.assertEquals((long)1L, (long)mdvs12a.size());
        Assert.assertEquals((Object)pub1_1.getID().toString(), (Object)((MetadataValue)mdvs12a.get(0)).getValue());
        Assert.assertEquals((long)-1L, (long)((MetadataValue)mdvs12a.get(0)).getPlace());
        this.verifySolrField(pro1_1, "relation.isPublicationOfProject.latestForDiscovery", List.of(pub1_1.getID().toString()));
        List mdvs13 = this.itemService.getMetadata((DSpaceObject)pro1_2, "relation", "isPublicationOfProject", null, "*");
        Assert.assertEquals((long)1L, (long)mdvs13.size());
        Assert.assertEquals((Object)pub1_2.getID().toString(), (Object)((MetadataValue)mdvs13.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs13.get(0)).getPlace());
        this.verifySolrField(pro1_2, "relation.isPublicationOfProject", List.of(pub1_2.getID().toString()));
        this.verifySolrField(pro1_2, "archived", List.of("true"));
        this.verifySolrField(pro1_2, "latestVersion", List.of(Boolean.valueOf(true)));
        List mdvs13a = this.itemService.getMetadata((DSpaceObject)pro1_2, "relation", "isPublicationOfProject", "latestForDiscovery", "*");
        Assert.assertEquals((long)1L, (long)mdvs13a.size());
        Assert.assertEquals((Object)pub1_2.getID().toString(), (Object)((MetadataValue)mdvs13a.get(0)).getValue());
        Assert.assertEquals((long)-1L, (long)((MetadataValue)mdvs13a.get(0)).getPlace());
        this.verifySolrField(pro1_2, "relation.isPublicationOfProject.latestForDiscovery", List.of(pub1_2.getID().toString()));
        this.verifyRestSearchObjects(null, "project-relationships", (FailableFunction<MockHttpServletRequestBuilder, MockHttpServletRequestBuilder, Exception>)((FailableFunction)r -> r.param("f.isPublicationOfProject", new String[]{idPub1_1 + ",equals"})), List.of(this.matchSearchResult(pro1_1, "project 1")));
        this.verifyRestSearchObjects(null, "project-relationships", (FailableFunction<MockHttpServletRequestBuilder, MockHttpServletRequestBuilder, Exception>)((FailableFunction)r -> r.param("f.isPublicationOfProject", new String[]{idPub1_2 + ",equals"})), List.of(this.matchSearchResult(pro1_2, "project 1")));
        this.verifyRestSearchObjects(null, "publication-relationships", (FailableFunction<MockHttpServletRequestBuilder, MockHttpServletRequestBuilder, Exception>)((FailableFunction)r -> r.param("f.isProjectOfPublication", new String[]{idPro1_1 + ",equals"})), List.of(this.matchSearchResult(pub1_2, "publication 1")));
        this.verifyRestSearchObjects(null, "publication-relationships", (FailableFunction<MockHttpServletRequestBuilder, MockHttpServletRequestBuilder, Exception>)((FailableFunction)r -> r.param("f.isProjectOfPublication", new String[]{idPro1_2 + ",equals"})), List.of(this.matchSearchResult(pub1_2, "publication 1")));
    }

    @Test
    public void test_forceReindexAfterNewVersionInWorkspace() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EntityType publicationEntityType = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Publication").build();
        EntityType projectEntityType = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Project").build();
        RelationshipType isProjectOfPublication = RelationshipTypeBuilder.createRelationshipTypeBuilder((Context)this.context, (EntityType)publicationEntityType, (EntityType)projectEntityType, (String)"isProjectOfPublication", (String)"isPublicationOfProject", null, null, null, null).withCopyToLeft(false).withCopyToRight(false).build();
        org.dspace.content.Collection publicationCollection = this.createCollection(publicationEntityType.getLabel());
        Item pub1_1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)publicationCollection).withTitle("publication 1").build();
        String idPub1_1 = pub1_1.getID().toString();
        org.dspace.content.Collection projectCollection = this.createCollection(projectEntityType.getLabel());
        Item pro1_1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)projectCollection).withTitle("project 1").build();
        String idPro1_1 = pro1_1.getID().toString();
        RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)pub1_1, (Item)pro1_1, (RelationshipType)isProjectOfPublication).build();
        this.context.restoreAuthSystemState();
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pub1_1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel((Item)pub1_1, (RelationshipType)isProjectOfPublication, (Item)pro1_1, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.BOTH, (int)0, (int)0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pro1_1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel((Item)pub1_1, (RelationshipType)isProjectOfPublication, (Item)pro1_1, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.BOTH, (int)0, (int)0))));
        List mdvs1 = this.itemService.getMetadata((DSpaceObject)pub1_1, "relation", "isProjectOfPublication", null, "*");
        Assert.assertEquals((long)1L, (long)mdvs1.size());
        Assert.assertEquals((Object)pro1_1.getID().toString(), (Object)((MetadataValue)mdvs1.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs1.get(0)).getPlace());
        List mdvs1a = this.itemService.getMetadata((DSpaceObject)pub1_1, "relation", "isProjectOfPublication", "latestForDiscovery", "*");
        Assert.assertEquals((long)1L, (long)mdvs1a.size());
        Assert.assertEquals((Object)pro1_1.getID().toString(), (Object)((MetadataValue)mdvs1a.get(0)).getValue());
        Assert.assertEquals((long)-1L, (long)((MetadataValue)mdvs1a.get(0)).getPlace());
        List mdvs2 = this.itemService.getMetadata((DSpaceObject)pro1_1, "relation", "isPublicationOfProject", null, "*");
        Assert.assertEquals((long)1L, (long)mdvs2.size());
        Assert.assertEquals((Object)pub1_1.getID().toString(), (Object)((MetadataValue)mdvs2.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs2.get(0)).getPlace());
        List mdvs2a = this.itemService.getMetadata((DSpaceObject)pro1_1, "relation", "isPublicationOfProject", "latestForDiscovery", "*");
        Assert.assertEquals((long)1L, (long)mdvs2a.size());
        Assert.assertEquals((Object)pub1_1.getID().toString(), (Object)((MetadataValue)mdvs2a.get(0)).getValue());
        Assert.assertEquals((long)-1L, (long)((MetadataValue)mdvs2a.get(0)).getPlace());
        this.verifyRestSearchObjects(null, "project-relationships", (FailableFunction<MockHttpServletRequestBuilder, MockHttpServletRequestBuilder, Exception>)((FailableFunction)r -> r.param("f.isPublicationOfProject", new String[]{idPub1_1 + ",equals"})), List.of(this.matchSearchResult(pro1_1, "project 1")));
        this.verifyRestSearchObjects(null, "publication-relationships", (FailableFunction<MockHttpServletRequestBuilder, MockHttpServletRequestBuilder, Exception>)((FailableFunction)r -> r.param("f.isProjectOfPublication", new String[]{idPro1_1 + ",equals"})), List.of(this.matchSearchResult(pub1_1, "publication 1")));
        this.context.turnOffAuthorisationSystem();
        Item pub1_2 = VersionBuilder.createVersion((Context)this.context, (Item)pub1_1, (String)"pub 1.2").build().getItem();
        String idPub1_2 = pub1_2.getID().toString();
        this.context.commit();
        this.indexingService.commit();
        Assert.assertNotEquals((Object)pub1_1, (Object)pub1_2);
        this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.findByItem(this.context, pub1_2));
        this.context.commit();
        this.indexingService.commit();
        this.context.restoreAuthSystemState();
        pub1_1 = (Item)this.context.reloadEntity((ReloadableEntity)pub1_1);
        pub1_2 = (Item)this.context.reloadEntity((ReloadableEntity)pub1_2);
        pro1_1 = (Item)this.context.reloadEntity((ReloadableEntity)pro1_1);
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pub1_1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel((Item)pub1_1, (RelationshipType)isProjectOfPublication, (Item)pro1_1, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.RIGHT_ONLY, (int)0, (int)0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pub1_2, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel((Item)pub1_2, (RelationshipType)isProjectOfPublication, (Item)pro1_1, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.BOTH, (int)0, (int)0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pro1_1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel((Item)pub1_1, (RelationshipType)isProjectOfPublication, (Item)pro1_1, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.RIGHT_ONLY, (int)0, (int)0), RelationshipVersioningTestUtils.isRel((Item)pub1_2, (RelationshipType)isProjectOfPublication, (Item)pro1_1, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.BOTH, (int)0, (int)0))));
        List mdvs3 = this.itemService.getMetadata((DSpaceObject)pub1_1, "relation", "isProjectOfPublication", null, "*");
        Assert.assertEquals((long)1L, (long)mdvs3.size());
        Assert.assertEquals((Object)pro1_1.getID().toString(), (Object)((MetadataValue)mdvs3.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs3.get(0)).getPlace());
        this.verifySolrField(pub1_1, "relation.isProjectOfPublication", List.of(pro1_1.getID().toString()));
        this.verifySolrField(pub1_1, "archived", List.of("false"));
        this.verifySolrField(pub1_1, "latestVersion", List.of(Boolean.valueOf(false)));
        List mdvs3a = this.itemService.getMetadata((DSpaceObject)pub1_1, "relation", "isProjectOfPublication", "latestForDiscovery", "*");
        Assert.assertEquals((long)0L, (long)mdvs3a.size());
        this.verifySolrField(pub1_1, "relation.isProjectOfPublication.latestForDiscovery", null);
        List mdvs4 = this.itemService.getMetadata((DSpaceObject)pub1_2, "relation", "isProjectOfPublication", null, "*");
        Assert.assertEquals((long)1L, (long)mdvs4.size());
        Assert.assertEquals((Object)pro1_1.getID().toString(), (Object)((MetadataValue)mdvs4.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs4.get(0)).getPlace());
        this.verifySolrField(pub1_2, "relation.isProjectOfPublication", List.of(pro1_1.getID().toString()));
        this.verifySolrField(pub1_2, "archived", List.of("true"));
        this.verifySolrField(pub1_2, "latestVersion", List.of(Boolean.valueOf(true)));
        List mdvs4a = this.itemService.getMetadata((DSpaceObject)pub1_2, "relation", "isProjectOfPublication", "latestForDiscovery", "*");
        Assert.assertEquals((long)1L, (long)mdvs4a.size());
        Assert.assertEquals((Object)pro1_1.getID().toString(), (Object)((MetadataValue)mdvs4a.get(0)).getValue());
        Assert.assertEquals((long)-1L, (long)((MetadataValue)mdvs4a.get(0)).getPlace());
        this.verifySolrField(pub1_2, "relation.isProjectOfPublication.latestForDiscovery", List.of(pro1_1.getID().toString()));
        List mdvs5 = this.itemService.getMetadata((DSpaceObject)pro1_1, "relation", "isPublicationOfProject", null, "*");
        Assert.assertEquals((long)1L, (long)mdvs5.size());
        Assert.assertEquals((Object)pub1_2.getID().toString(), (Object)((MetadataValue)mdvs5.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs5.get(0)).getPlace());
        this.verifySolrField(pro1_1, "relation.isPublicationOfProject", List.of(pub1_2.getID().toString()));
        this.verifySolrField(pro1_1, "archived", List.of("true"));
        this.verifySolrField(pro1_1, "latestVersion", List.of(Boolean.valueOf(true)));
        List mdvs5a = this.itemService.getMetadata((DSpaceObject)pro1_1, "relation", "isPublicationOfProject", "latestForDiscovery", "*");
        Assert.assertEquals((long)2L, (long)mdvs5a.size());
        MatcherAssert.assertThat((Object)mdvs5a, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.hasProperty((String)"value", (Matcher)Matchers.is((Object)pub1_1.getID().toString())), (Matcher)Matchers.hasProperty((String)"place", (Matcher)Matchers.is((Object)-1))), Matchers.allOf((Matcher)Matchers.hasProperty((String)"value", (Matcher)Matchers.is((Object)pub1_2.getID().toString())), (Matcher)Matchers.hasProperty((String)"place", (Matcher)Matchers.is((Object)-1)))}));
        this.verifySolrField(pro1_1, "relation.isPublicationOfProject.latestForDiscovery", List.of(pub1_1.getID().toString(), pub1_2.getID().toString()));
        this.verifyRestSearchObjects(null, "project-relationships", (FailableFunction<MockHttpServletRequestBuilder, MockHttpServletRequestBuilder, Exception>)((FailableFunction)r -> r.param("f.isPublicationOfProject", new String[]{idPub1_1 + ",equals"})), List.of(this.matchSearchResult(pro1_1, "project 1")));
        this.verifyRestSearchObjects(null, "project-relationships", (FailableFunction<MockHttpServletRequestBuilder, MockHttpServletRequestBuilder, Exception>)((FailableFunction)r -> r.param("f.isPublicationOfProject", new String[]{idPub1_2 + ",equals"})), List.of(this.matchSearchResult(pro1_1, "project 1")));
        this.verifyRestSearchObjects(null, "publication-relationships", (FailableFunction<MockHttpServletRequestBuilder, MockHttpServletRequestBuilder, Exception>)((FailableFunction)r -> r.param("f.isProjectOfPublication", new String[]{idPro1_1 + ",equals"})), List.of(this.matchSearchResult(pub1_2, "publication 1")));
        this.context.turnOffAuthorisationSystem();
        Item pro1_2 = VersionBuilder.createVersion((Context)this.context, (Item)((Item)this.context.reloadEntity((ReloadableEntity)pro1_1)), (String)"pro 1.2").build().getItem();
        String idPro1_2 = pro1_2.getID().toString();
        this.context.commit();
        this.indexingService.commit();
        Assert.assertNotEquals((Object)pro1_1, (Object)pro1_2);
        this.context.restoreAuthSystemState();
        pub1_1 = (Item)this.context.reloadEntity((ReloadableEntity)pub1_1);
        pub1_2 = (Item)this.context.reloadEntity((ReloadableEntity)pub1_2);
        pro1_1 = (Item)this.context.reloadEntity((ReloadableEntity)pro1_1);
        pro1_2 = (Item)this.context.reloadEntity((ReloadableEntity)pro1_2);
        this.indexingService.indexContent(this.context, (IndexableObject)new IndexableItem(pub1_1), true);
        this.indexingService.indexContent(this.context, (IndexableObject)new IndexableItem(pub1_2), true);
        this.indexingService.indexContent(this.context, (IndexableObject)new IndexableItem(pro1_1), true);
        this.indexingService.commit();
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pub1_1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel((Item)pub1_1, (RelationshipType)isProjectOfPublication, (Item)pro1_1, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.RIGHT_ONLY, (int)0, (int)0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pub1_2, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel((Item)pub1_2, (RelationshipType)isProjectOfPublication, (Item)pro1_1, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.BOTH, (int)0, (int)0), RelationshipVersioningTestUtils.isRel((Item)pub1_2, (RelationshipType)isProjectOfPublication, (Item)pro1_2, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.LEFT_ONLY, (int)0, (int)0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pro1_1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel((Item)pub1_1, (RelationshipType)isProjectOfPublication, (Item)pro1_1, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.RIGHT_ONLY, (int)0, (int)0), RelationshipVersioningTestUtils.isRel((Item)pub1_2, (RelationshipType)isProjectOfPublication, (Item)pro1_1, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.BOTH, (int)0, (int)0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pro1_2, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel((Item)pub1_2, (RelationshipType)isProjectOfPublication, (Item)pro1_2, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.LEFT_ONLY, (int)0, (int)0))));
        List mdvs6 = this.itemService.getMetadata((DSpaceObject)pub1_1, "relation", "isProjectOfPublication", null, "*");
        Assert.assertEquals((long)1L, (long)mdvs6.size());
        Assert.assertEquals((Object)pro1_1.getID().toString(), (Object)((MetadataValue)mdvs6.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs6.get(0)).getPlace());
        this.verifySolrField(pub1_1, "relation.isProjectOfPublication", List.of(pro1_1.getID().toString()));
        this.verifySolrField(pub1_1, "archived", List.of("false"));
        this.verifySolrField(pub1_1, "latestVersion", List.of(Boolean.valueOf(false)));
        List mdvs6a = this.itemService.getMetadata((DSpaceObject)pub1_1, "relation", "isProjectOfPublication", "latestForDiscovery", "*");
        Assert.assertEquals((long)0L, (long)mdvs6a.size());
        this.verifySolrField(pub1_1, "relation.isProjectOfPublication.latestForDiscovery", null);
        List mdvs7 = this.itemService.getMetadata((DSpaceObject)pub1_2, "relation", "isProjectOfPublication", null, "*");
        Assert.assertEquals((long)1L, (long)mdvs7.size());
        Assert.assertEquals((Object)pro1_1.getID().toString(), (Object)((MetadataValue)mdvs7.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs7.get(0)).getPlace());
        this.verifySolrField(pub1_2, "relation.isProjectOfPublication", List.of(pro1_1.getID().toString()));
        this.verifySolrField(pub1_2, "archived", List.of("true"));
        this.verifySolrField(pub1_2, "latestVersion", List.of(Boolean.valueOf(true)));
        List mdvs7a = this.itemService.getMetadata((DSpaceObject)pub1_2, "relation", "isProjectOfPublication", "latestForDiscovery", "*");
        Assert.assertEquals((long)2L, (long)mdvs7a.size());
        MatcherAssert.assertThat((Object)mdvs7a, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.hasProperty((String)"value", (Matcher)Matchers.is((Object)pro1_1.getID().toString())), (Matcher)Matchers.hasProperty((String)"place", (Matcher)Matchers.is((Object)-1))), Matchers.allOf((Matcher)Matchers.hasProperty((String)"value", (Matcher)Matchers.is((Object)pro1_2.getID().toString())), (Matcher)Matchers.hasProperty((String)"place", (Matcher)Matchers.is((Object)-1)))}));
        this.verifySolrField(pub1_2, "relation.isProjectOfPublication.latestForDiscovery", List.of(pro1_1.getID().toString(), pro1_2.getID().toString()));
        List mdvs8 = this.itemService.getMetadata((DSpaceObject)pro1_1, "relation", "isPublicationOfProject", null, "*");
        Assert.assertEquals((long)1L, (long)mdvs8.size());
        Assert.assertEquals((Object)pub1_2.getID().toString(), (Object)((MetadataValue)mdvs8.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs8.get(0)).getPlace());
        this.verifySolrField(pro1_1, "relation.isPublicationOfProject", List.of(pub1_2.getID().toString()));
        this.verifySolrField(pro1_1, "archived", List.of("true"));
        this.verifySolrField(pro1_1, "latestVersion", List.of(Boolean.valueOf(true)));
        List mdvs8a = this.itemService.getMetadata((DSpaceObject)pro1_1, "relation", "isPublicationOfProject", "latestForDiscovery", "*");
        Assert.assertEquals((long)2L, (long)mdvs8a.size());
        MatcherAssert.assertThat((Object)mdvs8a, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.hasProperty((String)"value", (Matcher)Matchers.is((Object)pub1_1.getID().toString())), (Matcher)Matchers.hasProperty((String)"place", (Matcher)Matchers.is((Object)-1))), Matchers.allOf((Matcher)Matchers.hasProperty((String)"value", (Matcher)Matchers.is((Object)pub1_2.getID().toString())), (Matcher)Matchers.hasProperty((String)"place", (Matcher)Matchers.is((Object)-1)))}));
        this.verifySolrField(pro1_1, "relation.isPublicationOfProject.latestForDiscovery", List.of(pub1_1.getID().toString(), pub1_2.getID().toString()));
        List mdvs9 = this.itemService.getMetadata((DSpaceObject)pro1_2, "relation", "isPublicationOfProject", null, "*");
        Assert.assertEquals((long)1L, (long)mdvs9.size());
        Assert.assertEquals((Object)pub1_2.getID().toString(), (Object)((MetadataValue)mdvs9.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs9.get(0)).getPlace());
        this.verifyNotIndexed(pro1_2);
        List mdvs9a = this.itemService.getMetadata((DSpaceObject)pro1_2, "relation", "isPublicationOfProject", "latestForDiscovery", "*");
        Assert.assertEquals((long)0L, (long)mdvs9a.size());
        this.verifyNotIndexed(pro1_2);
        this.verifyRestSearchObjects(null, "project-relationships", (FailableFunction<MockHttpServletRequestBuilder, MockHttpServletRequestBuilder, Exception>)((FailableFunction)r -> r.param("f.isPublicationOfProject", new String[]{idPub1_1 + ",equals"})), List.of(this.matchSearchResult(pro1_1, "project 1")));
        this.verifyRestSearchObjects(null, "project-relationships", (FailableFunction<MockHttpServletRequestBuilder, MockHttpServletRequestBuilder, Exception>)((FailableFunction)r -> r.param("f.isPublicationOfProject", new String[]{idPub1_2 + ",equals"})), List.of(this.matchSearchResult(pro1_1, "project 1")));
        this.verifyRestSearchObjects(null, "publication-relationships", (FailableFunction<MockHttpServletRequestBuilder, MockHttpServletRequestBuilder, Exception>)((FailableFunction)r -> r.param("f.isProjectOfPublication", new String[]{idPro1_1 + ",equals"})), List.of(this.matchSearchResult(pub1_2, "publication 1")));
        this.verifyRestSearchObjects(null, "publication-relationships", (FailableFunction<MockHttpServletRequestBuilder, MockHttpServletRequestBuilder, Exception>)((FailableFunction)r -> r.param("f.isProjectOfPublication", new String[]{idPro1_2 + ",equals"})), List.of(this.matchSearchResult(pub1_2, "publication 1")));
        this.context.turnOffAuthorisationSystem();
        this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.findByItem(this.context, pro1_2));
        this.context.commit();
        this.indexingService.commit();
        this.context.restoreAuthSystemState();
        pub1_1 = (Item)this.context.reloadEntity((ReloadableEntity)pub1_1);
        pub1_2 = (Item)this.context.reloadEntity((ReloadableEntity)pub1_2);
        pro1_1 = (Item)this.context.reloadEntity((ReloadableEntity)pro1_1);
        pro1_2 = (Item)this.context.reloadEntity((ReloadableEntity)pro1_2);
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pub1_1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel((Item)pub1_1, (RelationshipType)isProjectOfPublication, (Item)pro1_1, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.RIGHT_ONLY, (int)0, (int)0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pub1_2, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel((Item)pub1_2, (RelationshipType)isProjectOfPublication, (Item)pro1_1, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.LEFT_ONLY, (int)0, (int)0), RelationshipVersioningTestUtils.isRel((Item)pub1_2, (RelationshipType)isProjectOfPublication, (Item)pro1_2, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.BOTH, (int)0, (int)0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pro1_1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel((Item)pub1_1, (RelationshipType)isProjectOfPublication, (Item)pro1_1, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.RIGHT_ONLY, (int)0, (int)0), RelationshipVersioningTestUtils.isRel((Item)pub1_2, (RelationshipType)isProjectOfPublication, (Item)pro1_1, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.LEFT_ONLY, (int)0, (int)0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pro1_2, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel((Item)pub1_2, (RelationshipType)isProjectOfPublication, (Item)pro1_2, (Relationship.LatestVersionStatus)Relationship.LatestVersionStatus.BOTH, (int)0, (int)0))));
        List mdvs10 = this.itemService.getMetadata((DSpaceObject)pub1_1, "relation", "isProjectOfPublication", null, "*");
        Assert.assertEquals((long)1L, (long)mdvs10.size());
        Assert.assertEquals((Object)pro1_1.getID().toString(), (Object)((MetadataValue)mdvs10.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs10.get(0)).getPlace());
        this.verifySolrField(pub1_1, "relation.isProjectOfPublication", List.of(pro1_1.getID().toString()));
        this.verifySolrField(pub1_1, "archived", List.of("false"));
        this.verifySolrField(pub1_1, "latestVersion", List.of(Boolean.valueOf(false)));
        List mdvs10a = this.itemService.getMetadata((DSpaceObject)pub1_1, "relation", "isProjectOfPublication", "latestForDiscovery", "*");
        Assert.assertEquals((long)0L, (long)mdvs10a.size());
        this.verifySolrField(pub1_1, "relation.isProjectOfPublication.latestForDiscovery", null);
        List mdvs11 = this.itemService.getMetadata((DSpaceObject)pub1_2, "relation", "isProjectOfPublication", null, "*");
        Assert.assertEquals((long)1L, (long)mdvs11.size());
        Assert.assertEquals((Object)pro1_2.getID().toString(), (Object)((MetadataValue)mdvs11.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs11.get(0)).getPlace());
        this.verifySolrField(pub1_2, "relation.isProjectOfPublication", List.of(pro1_2.getID().toString()));
        this.verifySolrField(pub1_2, "archived", List.of("true"));
        this.verifySolrField(pub1_2, "latestVersion", List.of(Boolean.valueOf(true)));
        List mdvs11a = this.itemService.getMetadata((DSpaceObject)pub1_2, "relation", "isProjectOfPublication", "latestForDiscovery", "*");
        Assert.assertEquals((long)2L, (long)mdvs11a.size());
        MatcherAssert.assertThat((Object)mdvs11a, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.hasProperty((String)"value", (Matcher)Matchers.is((Object)pro1_1.getID().toString())), (Matcher)Matchers.hasProperty((String)"place", (Matcher)Matchers.is((Object)-1))), Matchers.allOf((Matcher)Matchers.hasProperty((String)"value", (Matcher)Matchers.is((Object)pro1_2.getID().toString())), (Matcher)Matchers.hasProperty((String)"place", (Matcher)Matchers.is((Object)-1)))}));
        this.verifySolrField(pub1_2, "relation.isProjectOfPublication.latestForDiscovery", List.of(pro1_1.getID().toString(), pro1_2.getID().toString()));
        List mdvs12 = this.itemService.getMetadata((DSpaceObject)pro1_1, "relation", "isPublicationOfProject", null, "*");
        Assert.assertEquals((long)1L, (long)mdvs12.size());
        Assert.assertEquals((Object)pub1_2.getID().toString(), (Object)((MetadataValue)mdvs12.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs12.get(0)).getPlace());
        this.verifySolrField(pro1_1, "relation.isPublicationOfProject", List.of(pub1_2.getID().toString()));
        this.verifySolrField(pro1_1, "archived", List.of("false"));
        this.verifySolrField(pro1_1, "latestVersion", List.of(Boolean.valueOf(false)));
        List mdvs12a = this.itemService.getMetadata((DSpaceObject)pro1_1, "relation", "isPublicationOfProject", "latestForDiscovery", "*");
        Assert.assertEquals((long)1L, (long)mdvs12a.size());
        Assert.assertEquals((Object)pub1_1.getID().toString(), (Object)((MetadataValue)mdvs12a.get(0)).getValue());
        Assert.assertEquals((long)-1L, (long)((MetadataValue)mdvs12a.get(0)).getPlace());
        this.verifySolrField(pro1_1, "relation.isPublicationOfProject.latestForDiscovery", List.of(pub1_1.getID().toString()));
        List mdvs13 = this.itemService.getMetadata((DSpaceObject)pro1_2, "relation", "isPublicationOfProject", null, "*");
        Assert.assertEquals((long)1L, (long)mdvs13.size());
        Assert.assertEquals((Object)pub1_2.getID().toString(), (Object)((MetadataValue)mdvs13.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs13.get(0)).getPlace());
        this.verifySolrField(pro1_2, "relation.isPublicationOfProject", List.of(pub1_2.getID().toString()));
        this.verifySolrField(pro1_2, "archived", List.of("true"));
        this.verifySolrField(pro1_2, "latestVersion", List.of(Boolean.valueOf(true)));
        List mdvs13a = this.itemService.getMetadata((DSpaceObject)pro1_2, "relation", "isPublicationOfProject", "latestForDiscovery", "*");
        Assert.assertEquals((long)1L, (long)mdvs13a.size());
        Assert.assertEquals((Object)pub1_2.getID().toString(), (Object)((MetadataValue)mdvs13a.get(0)).getValue());
        Assert.assertEquals((long)-1L, (long)((MetadataValue)mdvs13a.get(0)).getPlace());
        this.verifySolrField(pro1_2, "relation.isPublicationOfProject.latestForDiscovery", List.of(pub1_2.getID().toString()));
        this.verifyRestSearchObjects(null, "project-relationships", (FailableFunction<MockHttpServletRequestBuilder, MockHttpServletRequestBuilder, Exception>)((FailableFunction)r -> r.param("f.isPublicationOfProject", new String[]{idPub1_1 + ",equals"})), List.of(this.matchSearchResult(pro1_1, "project 1")));
        this.verifyRestSearchObjects(null, "project-relationships", (FailableFunction<MockHttpServletRequestBuilder, MockHttpServletRequestBuilder, Exception>)((FailableFunction)r -> r.param("f.isPublicationOfProject", new String[]{idPub1_2 + ",equals"})), List.of(this.matchSearchResult(pro1_2, "project 1")));
        this.verifyRestSearchObjects(null, "publication-relationships", (FailableFunction<MockHttpServletRequestBuilder, MockHttpServletRequestBuilder, Exception>)((FailableFunction)r -> r.param("f.isProjectOfPublication", new String[]{idPro1_1 + ",equals"})), List.of(this.matchSearchResult(pub1_2, "publication 1")));
        this.verifyRestSearchObjects(null, "publication-relationships", (FailableFunction<MockHttpServletRequestBuilder, MockHttpServletRequestBuilder, Exception>)((FailableFunction)r -> r.param("f.isProjectOfPublication", new String[]{idPro1_2 + ",equals"})), List.of(this.matchSearchResult(pub1_2, "publication 1")));
    }

    @Test
    public void test_rebuildIndexAllVersionsShouldStillBePresentInSolrCore() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EntityType publicationEntityType = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Publication").build();
        EntityType projectEntityType = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Project").build();
        RelationshipType isProjectOfPublication = RelationshipTypeBuilder.createRelationshipTypeBuilder((Context)this.context, (EntityType)publicationEntityType, (EntityType)projectEntityType, (String)"isProjectOfPublication", (String)"isPublicationOfProject", null, null, null, null).withCopyToLeft(false).withCopyToRight(false).build();
        org.dspace.content.Collection publicationCollection = this.createCollection(publicationEntityType.getLabel());
        org.dspace.content.Collection projectCollection = this.createCollection(projectEntityType.getLabel());
        Item pub1_1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)publicationCollection).withTitle("pub 1.1").build();
        Item pro1_1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)projectCollection).withTitle("pro 1.1").build();
        RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)pub1_1, (Item)pro1_1, (RelationshipType)isProjectOfPublication).build();
        this.context.restoreAuthSystemState();
        Item pub1_2 = this.createNewVersion((Item)this.context.reloadEntity((ReloadableEntity)pub1_1), "pub 1.2");
        Item pub1_3 = this.createNewVersion((Item)this.context.reloadEntity((ReloadableEntity)pub1_2), "pub 1.3");
        Item pub1_4 = this.createNewVersion((Item)this.context.reloadEntity((ReloadableEntity)pub1_3), "pub 1.4");
        pub1_1 = (Item)this.context.reloadEntity((ReloadableEntity)pub1_1);
        pub1_2 = (Item)this.context.reloadEntity((ReloadableEntity)pub1_2);
        pub1_3 = (Item)this.context.reloadEntity((ReloadableEntity)pub1_3);
        pub1_4 = (Item)this.context.reloadEntity((ReloadableEntity)pub1_4);
        pro1_1 = (Item)this.context.reloadEntity((ReloadableEntity)pro1_1);
        this.verifyIndexed(pub1_1);
        this.verifySolrField(pub1_1, "archived", List.of("false"));
        this.verifySolrField(pub1_1, "latestVersion", List.of(Boolean.valueOf(false)));
        this.verifySolrField(pub1_1, "relation.isProjectOfPublication", List.of(pro1_1.getID().toString()));
        this.verifySolrField(pub1_1, "relation.isProjectOfPublication.latestForDiscovery", null);
        this.verifyIndexed(pub1_2);
        this.verifySolrField(pub1_2, "archived", List.of("false"));
        this.verifySolrField(pub1_2, "latestVersion", List.of(Boolean.valueOf(false)));
        this.verifySolrField(pub1_2, "relation.isProjectOfPublication", List.of(pro1_1.getID().toString()));
        this.verifySolrField(pub1_2, "relation.isProjectOfPublication.latestForDiscovery", null);
        this.verifyIndexed(pub1_3);
        this.verifySolrField(pub1_3, "archived", List.of("false"));
        this.verifySolrField(pub1_3, "latestVersion", List.of(Boolean.valueOf(false)));
        this.verifySolrField(pub1_3, "relation.isProjectOfPublication", List.of(pro1_1.getID().toString()));
        this.verifySolrField(pub1_3, "relation.isProjectOfPublication.latestForDiscovery", null);
        this.verifyIndexed(pub1_4);
        this.verifySolrField(pub1_4, "archived", List.of("true"));
        this.verifySolrField(pub1_4, "latestVersion", List.of(Boolean.valueOf(true)));
        this.verifySolrField(pub1_4, "relation.isProjectOfPublication", List.of(pro1_1.getID().toString()));
        this.verifySolrField(pub1_4, "relation.isProjectOfPublication.latestForDiscovery", List.of(pro1_1.getID().toString()));
        this.verifyIndexed(pro1_1);
        this.verifySolrField(pro1_1, "archived", List.of("true"));
        this.verifySolrField(pro1_1, "latestVersion", List.of(Boolean.valueOf(true)));
        this.verifySolrField(pro1_1, "relation.isPublicationOfProject", List.of(pub1_4.getID().toString()));
        this.verifySolrField(pro1_1, "relation.isPublicationOfProject.latestForDiscovery", List.of(pub1_1.getID().toString(), pub1_2.getID().toString(), pub1_3.getID().toString(), pub1_4.getID().toString()));
        this.indexingService.deleteIndex();
        this.indexingService.createIndex(this.context);
        this.verifyIndexed(pub1_1);
        this.verifySolrField(pub1_1, "archived", List.of("false"));
        this.verifySolrField(pub1_1, "latestVersion", List.of(Boolean.valueOf(false)));
        this.verifySolrField(pub1_1, "relation.isProjectOfPublication", List.of(pro1_1.getID().toString()));
        this.verifySolrField(pub1_1, "relation.isProjectOfPublication.latestForDiscovery", null);
        this.verifyIndexed(pub1_2);
        this.verifySolrField(pub1_2, "archived", List.of("false"));
        this.verifySolrField(pub1_2, "latestVersion", List.of(Boolean.valueOf(false)));
        this.verifySolrField(pub1_2, "relation.isProjectOfPublication", List.of(pro1_1.getID().toString()));
        this.verifySolrField(pub1_2, "relation.isProjectOfPublication.latestForDiscovery", null);
        this.verifyIndexed(pub1_3);
        this.verifySolrField(pub1_3, "archived", List.of("false"));
        this.verifySolrField(pub1_3, "latestVersion", List.of(Boolean.valueOf(false)));
        this.verifySolrField(pub1_3, "relation.isProjectOfPublication", List.of(pro1_1.getID().toString()));
        this.verifySolrField(pub1_3, "relation.isProjectOfPublication.latestForDiscovery", null);
        this.verifyIndexed(pub1_4);
        this.verifySolrField(pub1_4, "archived", List.of("true"));
        this.verifySolrField(pub1_4, "latestVersion", List.of(Boolean.valueOf(true)));
        this.verifySolrField(pub1_4, "relation.isProjectOfPublication", List.of(pro1_1.getID().toString()));
        this.verifySolrField(pub1_4, "relation.isProjectOfPublication.latestForDiscovery", List.of(pro1_1.getID().toString()));
        this.verifyIndexed(pro1_1);
        this.verifySolrField(pro1_1, "archived", List.of("true"));
        this.verifySolrField(pro1_1, "latestVersion", List.of(Boolean.valueOf(true)));
        this.verifySolrField(pro1_1, "relation.isPublicationOfProject", List.of(pub1_4.getID().toString()));
        this.verifySolrField(pro1_1, "relation.isPublicationOfProject.latestForDiscovery", List.of(pub1_1.getID().toString(), pub1_2.getID().toString(), pub1_3.getID().toString(), pub1_4.getID().toString()));
    }

    @Test
    public void test_rebuildIndex_itemInWorkspaceNotIndexed() throws Exception {
        org.dspace.content.Collection collection = this.createCollection();
        this.context.turnOffAuthorisationSystem();
        WorkspaceItem wsi = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (org.dspace.content.Collection)collection).withTitle("item 1").build();
        this.context.restoreAuthSystemState();
        this.verifyNotIndexed(wsi.getItem());
        this.indexingService.deleteIndex();
        this.indexingService.createIndex(this.context);
        this.verifyNotIndexed(wsi.getItem());
    }

    @Test
    public void test_rebuildIndex_itemInWorkflowNotIndexed() throws Exception {
        this.context.turnOffAuthorisationSystem();
        org.dspace.content.Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.community, (String)"123456789/workflow-test-1").withName("collection").build();
        GroupBuilder.createGroup((Context)this.context).withName("ReviewManagers").addMember(this.admin).build();
        XmlWorkflowItem wfi = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (org.dspace.content.Collection)collection).withTitle("item 1").build();
        this.context.restoreAuthSystemState();
        this.verifyNotIndexed(wfi.getItem());
        this.indexingService.deleteIndex();
        this.indexingService.createIndex(this.context);
        this.verifyNotIndexed(wfi.getItem());
    }

    @Test
    public void test_rebuildIndex_templateItemNotIndexed() throws Exception {
        org.dspace.content.Collection collection = this.createCollection();
        this.context.turnOffAuthorisationSystem();
        Item templateItem = this.itemService.createTemplateItem(this.context, collection);
        this.context.restoreAuthSystemState();
        this.verifyNotIndexed(templateItem);
        this.indexingService.deleteIndex();
        this.indexingService.createIndex(this.context);
        this.verifyNotIndexed(templateItem);
    }
}

