/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.sql.SQLException;
import org.dspace.app.rest.matcher.VocabularyMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.EPersonBuilder;
import org.dspace.core.Context;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class EPersonAuthorityIT
extends AbstractControllerIntegrationTest {
    @Test
    public void testEPersonAuthorityWithFirstName() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String firstEPersonId = this.createEPerson("Luca", "Giamminonni");
        String secondEPersonId = this.createEPerson("Andrea", "Bollini");
        String thirdEPersonId = this.createEPerson("Luca", "Bollini");
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularies/EPersonAuthority/entries", (Object[])new Object[0]).param("filter", new String[]{"Luca"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{VocabularyMatcher.matchVocabularyEntry("Luca Giamminonni", "Luca Giamminonni", "vocabularyEntry", firstEPersonId), VocabularyMatcher.matchVocabularyEntry("Luca Bollini", "Luca Bollini", "vocabularyEntry", thirdEPersonId)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularies/EPersonAuthority/entries", (Object[])new Object[0]).param("filter", new String[]{"Andrea"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{VocabularyMatcher.matchVocabularyEntry("Andrea Bollini", "Andrea Bollini", "vocabularyEntry", secondEPersonId)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void testEPersonAuthorityWithLastName() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String firstEPersonId = this.createEPerson("Luca", "Giamminonni");
        String secondEPersonId = this.createEPerson("Andrea", "Bollini");
        String thirdEPersonId = this.createEPerson("Luca", "Bollini");
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularies/EPersonAuthority/entries", (Object[])new Object[0]).param("filter", new String[]{"Giamminonni"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{VocabularyMatcher.matchVocabularyEntry("Luca Giamminonni", "Luca Giamminonni", "vocabularyEntry", firstEPersonId)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularies/EPersonAuthority/entries", (Object[])new Object[0]).param("filter", new String[]{"Bollini"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{VocabularyMatcher.matchVocabularyEntry("Andrea Bollini", "Andrea Bollini", "vocabularyEntry", secondEPersonId), VocabularyMatcher.matchVocabularyEntry("Luca Bollini", "Luca Bollini", "vocabularyEntry", thirdEPersonId)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
    }

    @Test
    public void testEPersonAuthorityWithId() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String firstEPersonId = this.createEPerson("Luca", "Giamminonni");
        String secondEPersonId = this.createEPerson("Andrea", "Bollini");
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularies/EPersonAuthority/entries", (Object[])new Object[0]).param("filter", new String[]{firstEPersonId})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{VocabularyMatcher.matchVocabularyEntry("Luca Giamminonni", "Luca Giamminonni", "vocabularyEntry", firstEPersonId)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularies/EPersonAuthority/entries", (Object[])new Object[0]).param("filter", new String[]{secondEPersonId})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{VocabularyMatcher.matchVocabularyEntry("Andrea Bollini", "Andrea Bollini", "vocabularyEntry", secondEPersonId)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void testEPersonAuthorityWithAnonymousUser() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.createEPerson("Luca", "Giamminonni");
        this.createEPerson("Andrea", "Bollini");
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularies/EPersonAuthority/entries", (Object[])new Object[0]).param("filter", new String[]{"Luca"})).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void testEPersonAuthorityWithNotAdminUser() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.createEPerson("Luca", "Giamminonni");
        this.createEPerson("Andrea", "Bollini");
        this.createEPerson("Luca", "Bollini");
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularies/EPersonAuthority/entries", (Object[])new Object[0]).param("filter", new String[]{"Luca"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries", (Matcher)Matchers.empty())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    private String createEPerson(String firstName, String lastName) throws SQLException {
        return EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata(firstName, lastName).build().getID().toString();
    }
}

