/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.dspace.app.ldn.NotifyServiceEntity;
import org.dspace.app.ldn.model.Notification;
import org.dspace.app.ldn.service.LDNMessageService;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.NotifyServiceBuilder;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class LDNMessageRestControllerIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private LDNMessageService ldnMessageService;

    @Test
    public void findByItemUnAuthorizedTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/ldn/messages/urn:uuid:668f26e0-2c8d-4117-a0d2-ee713523bcb4/enqueueretry", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findByItemIsForbiddenTest() throws Exception {
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/ldn/messages/urn:uuid:668f26e0-2c8d-4117-a0d2-ee713523bcb4/enqueueretry", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findByItemNotFoundTest() throws Exception {
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/ldn/messages/urn:uuid:668f26e0-2c8d-4117-a0d2-ee713523bcb4/enqueueretry", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findByItemTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("community").build();
        org.dspace.content.Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).build();
        Item item = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).withTitle("item title").build();
        String object = this.configurationService.getProperty("dspace.ui.url") + "/handle/" + item.getHandle();
        NotifyServiceEntity notifyService = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("service url").withLdnUrl("https://overlay-journal.com/inbox/").build();
        this.context.restoreAuthSystemState();
        InputStream announceEndorsementStream = ((Object)((Object)this)).getClass().getResourceAsStream("ldn_announce_endorsement.json");
        String announceEndorsement = IOUtils.toString((InputStream)announceEndorsementStream, (Charset)Charset.defaultCharset());
        announceEndorsementStream.close();
        String message = announceEndorsement.replaceAll("<<object>>", object);
        message = message.replaceAll("<<object_handle>>", object);
        ObjectMapper mapper = new ObjectMapper();
        Notification notification = (Notification)mapper.readValue(message, Notification.class);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/ldn/inbox", (Object[])new Object[0]).contentType("application/ld+json").content(message)).andExpect(MockMvcResultMatchers.status().isAccepted());
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/ldn/messages/" + notification.getId() + "/enqueueretry"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)notification.getId()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notificationId", (Matcher)Matchers.is((Object)notification.getId()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.queueStatus", (Matcher)Matchers.is((Object)7))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.queueStatusLabel", (Matcher)Matchers.is((Object)"QUEUE_STATUS_QUEUED_FOR_RETRY"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.context", (Matcher)Matchers.is((Object)item.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.object", (Matcher)Matchers.is((Object)item.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.target", (Matcher)Matchers.nullValue())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.origin", (Matcher)Matchers.is((Object)notifyService.getID()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inReplyTo", (Matcher)Matchers.nullValue())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.activityStreamType", (Matcher)Matchers.is((Object)"Announce"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.coarNotifyType", (Matcher)Matchers.is((Object)"coar-notify:EndorsementAction"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.queueAttempts", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notificationType", (Matcher)Matchers.is((Object)"Incoming")));
    }

    @After
    public void destroy() throws Exception {
        List ldnMessageEntities = this.ldnMessageService.findAll(this.context);
        if (CollectionUtils.isNotEmpty((Collection)ldnMessageEntities)) {
            ldnMessageEntities.forEach(ldnMessage -> {
                try {
                    this.ldnMessageService.delete(this.context, ldnMessage);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        super.destroy();
    }
}

