/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.dspace.app.ldn.NotifyServiceEntity;
import org.dspace.app.ldn.model.Notification;
import org.dspace.app.ldn.service.LDNMessageService;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.NotifyServiceBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class NotifyRequestStatusRestControllerIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private LDNMessageService ldnMessageService;

    @Test
    public void oneStatusReviewedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).build();
        String object = this.configurationService.getProperty("dspace.ui.url") + "/handle/" + item.getHandle();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://review-service.com/inbox/about/").withLdnUrl("https://review-service.com/inbox/").withStatus(true).withScore(BigDecimal.valueOf(0.6)).build();
        InputStream offerReviewStream = ((Object)((Object)this)).getClass().getResourceAsStream("ldn_offer_review.json");
        String announceReview = IOUtils.toString((InputStream)offerReviewStream, (Charset)Charset.defaultCharset());
        offerReviewStream.close();
        String message = announceReview.replaceAll("<<object_handle>>", object);
        ObjectMapper mapper = new ObjectMapper();
        Notification notification = (Notification)mapper.readValue(message, Notification.class);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/ldn/inbox", (Object[])new Object[0]).contentType("application/ld+json").content(message)).andExpect(MockMvcResultMatchers.status().isAccepted());
        int processed = this.ldnMessageService.extractAndProcessMessageFromQueue(this.context);
        Assert.assertEquals((long)processed, (long)1L);
        processed = this.ldnMessageService.extractAndProcessMessageFromQueue(this.context);
        Assert.assertEquals((long)processed, (long)0L);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/ldn/notifyrequests/" + item.getID()), (Object[])new Object[0]).contentType("application/ld+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyStatus", (Object[])new Object[0]).isArray()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyStatus", (Object[])new Object[0]).isNotEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyStatus[0].status", (Object[])new Object[0]).value((Object)"REQUESTED")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyStatus[0].serviceUrl", (Object[])new Object[0]).value((Object)"https://review-service.com/inbox/about/"));
    }

    @Test
    public void oneStatusAnnounceEndorsementTestDisabledService() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).build();
        String object = this.configurationService.getProperty("dspace.ui.url") + "/handle/" + item.getHandle();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://review-service.com/inbox/about/").withLdnUrl("https://review-service.com/inbox/").withStatus(false).withScore(BigDecimal.valueOf(0.6)).build();
        InputStream offerReviewStream = ((Object)((Object)this)).getClass().getResourceAsStream("ldn_offer_review3.json");
        String announceReview = IOUtils.toString((InputStream)offerReviewStream, (Charset)Charset.defaultCharset());
        offerReviewStream.close();
        String message = announceReview.replaceAll("<<object_handle>>", object);
        ObjectMapper mapper = new ObjectMapper();
        Notification notification = (Notification)mapper.readValue(message, Notification.class);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/ldn/inbox", (Object[])new Object[0]).contentType("application/ld+json").content(message)).andExpect(MockMvcResultMatchers.status().isAccepted());
        int processed = this.ldnMessageService.extractAndProcessMessageFromQueue(this.context);
        Assert.assertEquals((long)processed, (long)0L);
        processed = this.ldnMessageService.extractAndProcessMessageFromQueue(this.context);
        Assert.assertEquals((long)processed, (long)0L);
    }

    @Test
    public void oneStatusRejectedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).build();
        String object = this.configurationService.getProperty("dspace.ui.url") + "/handle/" + item.getHandle();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://review-service.com/inbox/about/").withLdnUrl("https://review-service.com/inbox/").withStatus(true).withScore(BigDecimal.valueOf(0.6)).build();
        InputStream offerReviewStream = ((Object)((Object)this)).getClass().getResourceAsStream("ldn_offer_review2.json");
        String announceReview = IOUtils.toString((InputStream)offerReviewStream, (Charset)Charset.defaultCharset());
        offerReviewStream.close();
        String message = announceReview.replaceAll("<<object_handle>>", object);
        ObjectMapper mapper = new ObjectMapper();
        Notification notification = (Notification)mapper.readValue(message, Notification.class);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/ldn/inbox", (Object[])new Object[0]).contentType("application/ld+json").content(message)).andExpect(MockMvcResultMatchers.status().isAccepted());
        int processed = this.ldnMessageService.extractAndProcessMessageFromQueue(this.context);
        Assert.assertEquals((long)processed, (long)1L);
        processed = this.ldnMessageService.extractAndProcessMessageFromQueue(this.context);
        Assert.assertEquals((long)processed, (long)0L);
        InputStream ackReviewStream = ((Object)((Object)this)).getClass().getResourceAsStream("ldn_ack_review_reject.json");
        String ackReview = IOUtils.toString((InputStream)ackReviewStream, (Charset)Charset.defaultCharset());
        ackReviewStream.close();
        String ackMessage = ackReview.replaceAll("<<object_handle>>", object);
        ackMessage = ackMessage.replaceAll("<<ldn_offer_review_uuid>>", "urn:uuid:0370c0fb-bb78-4a9b-87f5-bed307a509df");
        ObjectMapper ackMapper = new ObjectMapper();
        Notification ackNotification = (Notification)ackMapper.readValue(ackMessage, Notification.class);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/ldn/inbox", (Object[])new Object[0]).contentType("application/ld+json").content(ackMessage)).andExpect(MockMvcResultMatchers.status().isAccepted());
        int ackProcessed = this.ldnMessageService.extractAndProcessMessageFromQueue(this.context);
        Assert.assertEquals((long)ackProcessed, (long)1L);
        ackProcessed = this.ldnMessageService.extractAndProcessMessageFromQueue(this.context);
        Assert.assertEquals((long)ackProcessed, (long)0L);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/ldn/notifyrequests/" + item.getID()), (Object[])new Object[0]).contentType("application/ld+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyStatus", (Object[])new Object[0]).isArray()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyStatus", (Object[])new Object[0]).isNotEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyStatus[0].status", (Object[])new Object[0]).value((Object)"REJECTED")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyStatus[0].serviceUrl", (Object[])new Object[0]).value((Object)"https://review-service.com/inbox/about/")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyStatus[0].offerType", (Object[])new Object[0]).value((Object)"Review"));
    }
}

