/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.InputStream;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.dspace.app.rest.matcher.BitstreamMatcher;
import org.dspace.app.rest.matcher.BundleMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.BundleBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.EPerson;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class PrimaryBitstreamControllerIT
extends AbstractControllerIntegrationTest {
    @Autowired
    BundleService bundleService;
    @Autowired
    BitstreamService bitstreamService;
    Item item;
    Bitstream bitstream;
    Bundle bundle;
    Community community;
    Collection collection;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.community = CommunityBuilder.createCommunity((Context)this.context).build();
        this.collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.community).build();
        this.item = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).build();
        String bitstreamContent = "TEST CONTENT";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            this.bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)this.item, (InputStream)is).withName("Bitstream").withMimeType("text/plain").build();
        }
        this.bundle = (Bundle)this.item.getBundles("ORIGINAL").get(0);
        this.context.restoreAuthSystemState();
    }

    @Test
    public void testGetPrimaryBitstream() throws Exception {
        this.bundle.setPrimaryBitstreamID(this.bitstream);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)this.getBundlePrimaryBitstreamUrl(this.bundle.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BitstreamMatcher.matchProperties(this.bitstream)));
    }

    @Test
    public void testGetPrimaryBitstreamBundleNotFound() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)this.getBundlePrimaryBitstreamUrl(UUID.randomUUID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void testGetPrimaryBitstreamNonExisting() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)this.getBundlePrimaryBitstreamUrl(this.bundle.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testPostPrimaryBitstream() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)this.getBundlePrimaryBitstreamUrl(this.bundle.getID()), (Object[])new Object[0]).contentType(this.textUriContentType).content(this.getBitstreamUrl(this.bitstream.getID()))).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BundleMatcher.matchProperties(this.bundle.getName(), this.bundle.getID(), this.bundle.getHandle(), this.bundle.getType())));
        this.bundle = (Bundle)this.context.reloadEntity((ReloadableEntity)this.bundle);
        Assert.assertEquals((Object)this.bitstream, (Object)this.bundle.getPrimaryBitstream());
    }

    @Test
    public void testPostPrimaryBitstreamBundleNotFound() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)this.getBundlePrimaryBitstreamUrl(UUID.randomUUID()), (Object[])new Object[0]).contentType(this.textUriContentType).content(this.getBitstreamUrl(this.bitstream.getID()))).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.bundle = (Bundle)this.context.reloadEntity((ReloadableEntity)this.bundle);
        Assert.assertNull((Object)this.bundle.getPrimaryBitstream());
    }

    @Test
    public void testPostPrimaryBitstreamInvalidBitstream() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)this.getBundlePrimaryBitstreamUrl(this.bundle.getID()), (Object[])new Object[0]).contentType(this.textUriContentType).content(this.getBitstreamUrl(UUID.randomUUID()))).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.bundle = (Bundle)this.context.reloadEntity((ReloadableEntity)this.bundle);
        Assert.assertNull((Object)this.bundle.getPrimaryBitstream());
    }

    @Test
    public void testPostPrimaryBitstreamAlreadyExists() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.bundle.setPrimaryBitstreamID(this.bitstream);
        Bitstream bitstream2 = this.createBitstream(this.bundle);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)this.getBundlePrimaryBitstreamUrl(this.bundle.getID()), (Object[])new Object[0]).contentType(this.textUriContentType).content(this.getBitstreamUrl(bitstream2.getID()))).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.bundle = (Bundle)this.context.reloadEntity((ReloadableEntity)this.bundle);
        Assert.assertEquals((Object)this.bitstream, (Object)this.bundle.getPrimaryBitstream());
    }

    @Test
    public void testPostPrimaryBitstreamNotInBundle() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bundle bundle2 = BundleBuilder.createBundle((Context)this.context, (Item)this.item).withName("Bundle2").build();
        Bitstream bitstream2 = this.createBitstream(bundle2);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)this.getBundlePrimaryBitstreamUrl(this.bundle.getID()), (Object[])new Object[0]).contentType(this.textUriContentType).content(this.getBitstreamUrl(bitstream2.getID()))).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.bundle = (Bundle)this.context.reloadEntity((ReloadableEntity)this.bundle);
        Assert.assertNull((Object)this.bundle.getPrimaryBitstream());
    }

    @Test
    public void testPostPrimaryBitstreamCommunityAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community com2 = CommunityBuilder.createCommunity((Context)this.context).withAdminGroup(new EPerson[]{this.eperson}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)com2).build();
        Item item2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).build();
        Bundle bundle2 = BundleBuilder.createBundle((Context)this.context, (Item)item2).withName("ORIGINAL").build();
        Bitstream bitstream2 = this.createBitstream(bundle2);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)this.getBundlePrimaryBitstreamUrl(bundle2.getID()), (Object[])new Object[0]).contentType(this.textUriContentType).content(this.getBitstreamUrl(bitstream2.getID()))).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BundleMatcher.matchProperties(bundle2.getName(), bundle2.getID(), bundle2.getHandle(), bundle2.getType())));
        bundle2 = (Bundle)this.context.reloadEntity((ReloadableEntity)bundle2);
        Assert.assertEquals((Object)bitstream2, (Object)bundle2.getPrimaryBitstream());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)this.getBundlePrimaryBitstreamUrl(this.bundle.getID()), (Object[])new Object[0]).contentType(this.textUriContentType).content(this.getBitstreamUrl(this.bitstream.getID()))).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void testPostPrimaryBitstreamCollectionAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.community).withAdminGroup(new EPerson[]{this.eperson}).build();
        Item item2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).build();
        Bundle bundle2 = BundleBuilder.createBundle((Context)this.context, (Item)item2).withName("ORIGINAL").build();
        Bitstream bitstream2 = this.createBitstream(bundle2);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)this.getBundlePrimaryBitstreamUrl(bundle2.getID()), (Object[])new Object[0]).contentType(this.textUriContentType).content(this.getBitstreamUrl(bitstream2.getID()))).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BundleMatcher.matchProperties(bundle2.getName(), bundle2.getID(), bundle2.getHandle(), bundle2.getType())));
        bundle2 = (Bundle)this.context.reloadEntity((ReloadableEntity)bundle2);
        Assert.assertEquals((Object)bitstream2, (Object)bundle2.getPrimaryBitstream());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)this.getBundlePrimaryBitstreamUrl(this.bundle.getID()), (Object[])new Object[0]).contentType(this.textUriContentType).content(this.getBitstreamUrl(this.bitstream.getID()))).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void testPostPrimaryBitstreamItemAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item2 = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withAdminUser(this.eperson).build();
        Bundle bundle2 = BundleBuilder.createBundle((Context)this.context, (Item)item2).withName("ORIGINAL").build();
        Bitstream bitstream2 = this.createBitstream(bundle2);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)this.getBundlePrimaryBitstreamUrl(bundle2.getID()), (Object[])new Object[0]).contentType(this.textUriContentType).content(this.getBitstreamUrl(bitstream2.getID()))).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BundleMatcher.matchProperties(bundle2.getName(), bundle2.getID(), bundle2.getHandle(), bundle2.getType())));
        bundle2 = (Bundle)this.context.reloadEntity((ReloadableEntity)bundle2);
        Assert.assertEquals((Object)bitstream2, (Object)bundle2.getPrimaryBitstream());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)this.getBundlePrimaryBitstreamUrl(this.bundle.getID()), (Object[])new Object[0]).contentType(this.textUriContentType).content(this.getBitstreamUrl(this.bitstream.getID()))).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void testPostPrimaryBitstreamForbidden() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)this.getBundlePrimaryBitstreamUrl(this.bundle.getID()), (Object[])new Object[0]).contentType(this.textUriContentType).content(this.getBitstreamUrl(this.bitstream.getID()))).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void testPostPrimaryBitstreamUnauthenticated() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)this.getBundlePrimaryBitstreamUrl(this.bundle.getID()), (Object[])new Object[0]).contentType(this.textUriContentType).content(this.getBitstreamUrl(this.bitstream.getID()))).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void testUpdatePrimaryBitstream() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.bundle.setPrimaryBitstreamID(this.bitstream);
        Bitstream bitstream2 = this.createBitstream(this.bundle);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)this.getBundlePrimaryBitstreamUrl(this.bundle.getID()), (Object[])new Object[0]).contentType(this.textUriContentType).content(this.getBitstreamUrl(bitstream2.getID()))).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BundleMatcher.matchProperties(this.bundle.getName(), this.bundle.getID(), this.bundle.getHandle(), this.bundle.getType())));
        this.bundle = (Bundle)this.context.reloadEntity((ReloadableEntity)this.bundle);
        Assert.assertEquals((Object)bitstream2, (Object)this.bundle.getPrimaryBitstream());
    }

    @Test
    public void testUpdatePrimaryBitstreamBundleNotFound() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)this.getBundlePrimaryBitstreamUrl(UUID.randomUUID()), (Object[])new Object[0]).contentType(this.textUriContentType).content(this.getBitstreamUrl(this.bitstream.getID()))).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void testUpdatePrimaryBitstreamInvalidBitstream() throws Exception {
        this.bundle.setPrimaryBitstreamID(this.bitstream);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)this.getBundlePrimaryBitstreamUrl(this.bundle.getID()), (Object[])new Object[0]).contentType(this.textUriContentType).content(this.getBitstreamUrl(UUID.randomUUID()))).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.bundle = (Bundle)this.context.reloadEntity((ReloadableEntity)this.bundle);
        Assert.assertEquals((Object)this.bitstream, (Object)this.bundle.getPrimaryBitstream());
    }

    @Test
    public void testUpdatePrimaryBitstreamNonExisting() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)this.getBundlePrimaryBitstreamUrl(this.bundle.getID()), (Object[])new Object[0]).contentType(this.textUriContentType).content(this.getBitstreamUrl(this.bitstream.getID()))).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.bundle = (Bundle)this.context.reloadEntity((ReloadableEntity)this.bundle);
        Assert.assertNull((Object)this.bundle.getPrimaryBitstream());
    }

    @Test
    public void testUpdatePrimaryBitstreamNotInBundle() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.bundle.setPrimaryBitstreamID(this.bitstream);
        Bundle bundle2 = BundleBuilder.createBundle((Context)this.context, (Item)this.item).withName("Bundle2").build();
        Bitstream bitstream2 = this.createBitstream(bundle2);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)this.getBundlePrimaryBitstreamUrl(this.bundle.getID()), (Object[])new Object[0]).contentType(this.textUriContentType).content(this.getBitstreamUrl(bitstream2.getID()))).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.bundle = (Bundle)this.context.reloadEntity((ReloadableEntity)this.bundle);
        Assert.assertEquals((Object)this.bitstream, (Object)this.bundle.getPrimaryBitstream());
    }

    @Test
    public void testUpdatePrimaryBitstreamCommunityAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community com2 = CommunityBuilder.createCommunity((Context)this.context).withAdminGroup(new EPerson[]{this.eperson}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)com2).build();
        Item item2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).build();
        Bundle bundle2 = BundleBuilder.createBundle((Context)this.context, (Item)item2).withName("ORIGINAL").build();
        Bitstream bitstream2 = this.createBitstream(bundle2);
        bundle2.setPrimaryBitstreamID(bitstream2);
        Bitstream bitstream3 = this.createBitstream(bundle2);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)this.getBundlePrimaryBitstreamUrl(bundle2.getID()), (Object[])new Object[0]).contentType(this.textUriContentType).content(this.getBitstreamUrl(bitstream3.getID()))).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BundleMatcher.matchProperties(bundle2.getName(), bundle2.getID(), bundle2.getHandle(), bundle2.getType())));
        bundle2 = (Bundle)this.context.reloadEntity((ReloadableEntity)bundle2);
        Assert.assertEquals((Object)bitstream3, (Object)bundle2.getPrimaryBitstream());
        this.bundle.setPrimaryBitstreamID(this.bitstream);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)this.getBundlePrimaryBitstreamUrl(this.bundle.getID()), (Object[])new Object[0]).contentType(this.textUriContentType).content(this.getBitstreamUrl(this.bitstream.getID()))).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void testUpdatePrimaryBitstreamCollectionAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.community).withAdminGroup(new EPerson[]{this.eperson}).build();
        Item item2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).build();
        Bundle bundle2 = BundleBuilder.createBundle((Context)this.context, (Item)item2).withName("ORIGINAL").build();
        Bitstream bitstream2 = this.createBitstream(bundle2);
        bundle2.setPrimaryBitstreamID(bitstream2);
        Bitstream bitstream3 = this.createBitstream(bundle2);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)this.getBundlePrimaryBitstreamUrl(bundle2.getID()), (Object[])new Object[0]).contentType(this.textUriContentType).content(this.getBitstreamUrl(bitstream3.getID()))).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BundleMatcher.matchProperties(bundle2.getName(), bundle2.getID(), bundle2.getHandle(), bundle2.getType())));
        bundle2 = (Bundle)this.context.reloadEntity((ReloadableEntity)bundle2);
        Assert.assertEquals((Object)bitstream3, (Object)bundle2.getPrimaryBitstream());
        this.bundle.setPrimaryBitstreamID(this.bitstream);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)this.getBundlePrimaryBitstreamUrl(this.bundle.getID()), (Object[])new Object[0]).contentType(this.textUriContentType).content(this.getBitstreamUrl(this.bitstream.getID()))).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void testUpdatePrimaryBitstreamItemAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item2 = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withAdminUser(this.eperson).build();
        Bundle bundle2 = BundleBuilder.createBundle((Context)this.context, (Item)item2).withName("ORIGINAL").build();
        Bitstream bitstream2 = this.createBitstream(bundle2);
        bundle2.setPrimaryBitstreamID(bitstream2);
        Bitstream bitstream3 = this.createBitstream(bundle2);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)this.getBundlePrimaryBitstreamUrl(bundle2.getID()), (Object[])new Object[0]).contentType(this.textUriContentType).content(this.getBitstreamUrl(bitstream3.getID()))).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BundleMatcher.matchProperties(bundle2.getName(), bundle2.getID(), bundle2.getHandle(), bundle2.getType())));
        bundle2 = (Bundle)this.context.reloadEntity((ReloadableEntity)bundle2);
        Assert.assertEquals((Object)bitstream3, (Object)bundle2.getPrimaryBitstream());
        this.bundle.setPrimaryBitstreamID(this.bitstream);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)this.getBundlePrimaryBitstreamUrl(this.bundle.getID()), (Object[])new Object[0]).contentType(this.textUriContentType).content(this.getBitstreamUrl(this.bitstream.getID()))).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void testUpdatePrimaryBitstreamForbidden() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.bundle.setPrimaryBitstreamID(this.bitstream);
        Bitstream bitstream2 = this.createBitstream(this.bundle);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)this.getBundlePrimaryBitstreamUrl(this.bundle.getID()), (Object[])new Object[0]).contentType(this.textUriContentType).content(this.getBitstreamUrl(bitstream2.getID()))).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void testUpdatePrimaryBitstreamUnauthenticated() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.bundle.setPrimaryBitstreamID(this.bitstream);
        Bitstream bitstream2 = this.createBitstream(this.bundle);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.put((String)this.getBundlePrimaryBitstreamUrl(this.bundle.getID()), (Object[])new Object[0]).contentType(this.textUriContentType).content(this.getBitstreamUrl(bitstream2.getID()))).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void testDeletePrimaryBitstream() throws Exception {
        this.bundle.setPrimaryBitstreamID(this.bitstream);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)this.getBundlePrimaryBitstreamUrl(this.bundle.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.bundle = (Bundle)this.context.reloadEntity((ReloadableEntity)this.bundle);
        Assert.assertNull((Object)this.bundle.getPrimaryBitstream());
        Assert.assertEquals((long)1L, (long)this.bundle.getBitstreams().size());
        Assert.assertEquals((Object)this.bitstream, this.bundle.getBitstreams().get(0));
    }

    @Test
    public void testDeletePrimaryBitstreamBundleNotFound() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)this.getBundlePrimaryBitstreamUrl(UUID.randomUUID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void testDeletePrimaryBitstreamBundleNonExisting() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)this.getBundlePrimaryBitstreamUrl(this.bundle.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.bundle = (Bundle)this.context.reloadEntity((ReloadableEntity)this.bundle);
        Assert.assertNull((Object)this.bundle.getPrimaryBitstream());
    }

    @Test
    public void testDeletePrimaryBitstreamCommunityAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community com2 = CommunityBuilder.createCommunity((Context)this.context).withAdminGroup(new EPerson[]{this.eperson}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)com2).build();
        Item item2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).build();
        Bundle bundle2 = BundleBuilder.createBundle((Context)this.context, (Item)item2).withName("ORIGINAL").build();
        Bitstream bitstream2 = this.createBitstream(bundle2);
        bundle2.setPrimaryBitstreamID(bitstream2);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)this.getBundlePrimaryBitstreamUrl(bundle2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        bundle2 = (Bundle)this.context.reloadEntity((ReloadableEntity)bundle2);
        Assert.assertNull((Object)bundle2.getPrimaryBitstream());
        Assert.assertEquals((long)1L, (long)bundle2.getBitstreams().size());
        Assert.assertEquals((Object)bitstream2, bundle2.getBitstreams().get(0));
        this.bundle.setPrimaryBitstreamID(this.bitstream);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)this.getBundlePrimaryBitstreamUrl(this.bundle.getID()), (Object[])new Object[0]).contentType(this.textUriContentType).content(this.getBitstreamUrl(this.bitstream.getID()))).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void testDeletePrimaryBitstreamCollectionAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.community).withAdminGroup(new EPerson[]{this.eperson}).build();
        Item item2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).build();
        Bundle bundle2 = BundleBuilder.createBundle((Context)this.context, (Item)item2).withName("ORIGINAL").build();
        Bitstream bitstream2 = this.createBitstream(bundle2);
        bundle2.setPrimaryBitstreamID(bitstream2);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)this.getBundlePrimaryBitstreamUrl(bundle2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        bundle2 = (Bundle)this.context.reloadEntity((ReloadableEntity)bundle2);
        Assert.assertNull((Object)bundle2.getPrimaryBitstream());
        Assert.assertEquals((long)1L, (long)bundle2.getBitstreams().size());
        Assert.assertEquals((Object)bitstream2, bundle2.getBitstreams().get(0));
        this.bundle.setPrimaryBitstreamID(this.bitstream);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)this.getBundlePrimaryBitstreamUrl(this.bundle.getID()), (Object[])new Object[0]).contentType(this.textUriContentType).content(this.getBitstreamUrl(this.bitstream.getID()))).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void testDeletePrimaryBitstreamItemAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item2 = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withAdminUser(this.eperson).build();
        Bundle bundle2 = BundleBuilder.createBundle((Context)this.context, (Item)item2).withName("ORIGINAL").build();
        Bitstream bitstream2 = this.createBitstream(bundle2);
        bundle2.setPrimaryBitstreamID(bitstream2);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)this.getBundlePrimaryBitstreamUrl(bundle2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        bundle2 = (Bundle)this.context.reloadEntity((ReloadableEntity)bundle2);
        Assert.assertNull((Object)bundle2.getPrimaryBitstream());
        Assert.assertEquals((long)1L, (long)bundle2.getBitstreams().size());
        Assert.assertEquals((Object)bitstream2, bundle2.getBitstreams().get(0));
        this.bundle.setPrimaryBitstreamID(this.bitstream);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)this.getBundlePrimaryBitstreamUrl(this.bundle.getID()), (Object[])new Object[0]).contentType(this.textUriContentType).content(this.getBitstreamUrl(this.bitstream.getID()))).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void testDeletePrimaryBitstreamForbidden() throws Exception {
        this.bundle.setPrimaryBitstreamID(this.bitstream);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)this.getBundlePrimaryBitstreamUrl(this.bundle.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void testDeletePrimaryBitstreamUnauthenticated() throws Exception {
        this.bundle.setPrimaryBitstreamID(this.bitstream);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.delete((String)this.getBundlePrimaryBitstreamUrl(this.bundle.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    private String getBundlePrimaryBitstreamUrl(UUID uuid) {
        return "/api/core/bundles/" + uuid + "/primaryBitstream";
    }

    private String getBitstreamUrl(UUID uuid) {
        return "/api/core/bitstreams/" + uuid;
    }

    private Bitstream createBitstream(Bundle bundle) throws Exception {
        String bitstreamContent = "Bitstream Content";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            Bitstream bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle, (InputStream)is).withName("Bitstream").withMimeType("text/plain").build();
            return bitstream;
        }
    }
}

