/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.dspace.app.ldn.NotifyServiceEntity;
import org.dspace.app.rest.matcher.ItemMatcher;
import org.dspace.app.rest.matcher.MetadataMatcher;
import org.dspace.app.rest.matcher.QAEventMatcher;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.model.patch.ReplaceOperation;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.EntityTypeBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.NotifyServiceBuilder;
import org.dspace.builder.QAEventBuilder;
import org.dspace.builder.RelationshipTypeBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.EntityType;
import org.dspace.content.Item;
import org.dspace.content.QAEvent;
import org.dspace.content.QAEventProcessed;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.qaevent.action.ASimpleMetadataAction;
import org.dspace.qaevent.dao.QAEventsDAO;
import org.dspace.qaevent.service.dto.CorrectionTypeMessageDTO;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class QAEventRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private QAEventsDAO qaEventsDao;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private ASimpleMetadataAction AddReviewMetadataAction;
    @Autowired
    private ASimpleMetadataAction AddEndorsedMetadataAction;

    @Test
    public void findAllNotImplementedTest() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassuranceevents", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isMethodNotAllowed());
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassuranceevents", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isMethodNotAllowed());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassuranceevents", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isMethodNotAllowed());
    }

    @Test
    public void findOneTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        QAEvent event1 = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"doi\",\"pids[0].value\":\"10.2307/2144300\"}").build();
        QAEvent event2 = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 4").withTopic("ENRICH/MISSING/ABSTRACT").withMessage("{\"abstracts[0]\": \"Descrizione delle caratteristiche...\"}").build();
        EPerson anotherSubmitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("another-submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(anotherSubmitter);
        QAEvent event3 = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom").withSource("coar-notify").withTopic("ENRICH/MORE/REVIEW").withMessage("{\"abstracts[0]\": \"Descrizione delle caratteristiche...\"}").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/qualityassuranceevents/" + event1.getEventId()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", QAEventMatcher.matchQAEventEntry(event1)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/qualityassuranceevents/" + event2.getEventId()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", QAEventMatcher.matchQAEventEntry(event2)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/qualityassuranceevents/" + event3.getEventId()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", QAEventMatcher.matchQAEventEntry(event3)));
        authToken = this.getAuthToken(anotherSubmitter.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/qualityassuranceevents/" + event3.getEventId()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", QAEventMatcher.matchQAEventEntry(event3)));
    }

    @Test
    public void findOneWithProjectionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        QAEvent event1 = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"doi\",\"pids[0].value\":\"10.2307/2144300\"}").build();
        QAEvent event5 = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 5").withTopic("ENRICH/MISSING/PROJECT").withMessage("{\"projects[0].acronym\":\"PAThs\",\"projects[0].code\":\"687567\",\"projects[0].funder\":\"EC\",\"projects[0].fundingProgram\":\"H2020\",\"projects[0].jurisdiction\":\"EU\",\"projects[0].openaireId\":\"40|corda__h2020::6e32f5eb912688f2424c68b851483ea4\",\"projects[0].title\":\"Tracking Papyrus and Parchment Paths: An Archaeological Atlas of Coptic Literature.\\nLiterary Texts in their Geographical Context: Production, Copying, Usage, Dissemination and Storage\"}").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/qualityassuranceevents/" + event1.getEventId()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", QAEventMatcher.matchQAEventFullEntry(event1)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/qualityassuranceevents/" + event5.getEventId()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", QAEventMatcher.matchQAEventFullEntry(event5)));
    }

    @Test
    public void findOneUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        QAEvent event1 = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"doi\",\"pids[0].value\":\"10.2307/2144300\"}").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/qualityassuranceevents/" + event1.getEventId()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOneForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        QAEvent event1 = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"doi\",\"pids[0].value\":\"10.2307/2144300\"}").build();
        EPerson anotherSubmitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("another_submitter@example.com").build();
        this.context.setCurrentUser(anotherSubmitter);
        QAEvent event2 = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom").withSource("coar-notify").withTopic("ENRICH/MORE/REVIEW").withMessage("{\"href\":\"https://doi.org/10.2307/2144300\"}").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/qualityassuranceevents/" + event1.getEventId()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/qualityassuranceevents/" + event2.getEventId()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findByTopicAndTargetTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        String uuid = UUID.randomUUID().toString();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Tracking Papyrus and Parchment Paths").build();
        QAEvent event1 = QAEventBuilder.createTarget((Context)this.context, (Item)item).withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"doi\",\"pids[0].value\":\"10.2307/2144300\"}").build();
        QAEvent event2 = QAEventBuilder.createTarget((Context)this.context, (Item)item).withSource("coar-notify").withTopic("ENRICH/MORE/REVIEW").withMessage("{\"href\":\"https://doi.org/10.2307/2144301\"}").build();
        EPerson anotherSubmitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("another-submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(anotherSubmitter);
        QAEvent event3 = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom").withSource("coar-notify").withTopic("ENRICH/MORE/REVIEW").withMessage("{\"href\":\"https://doi.org/10.2307/2144300\"}").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassuranceevents/search/findByTopic", (Object[])new Object[0]).param("topic", new String[]{"openaire:ENRICH!MISSING!PID:" + uuid.toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        uuid = item.getID().toString();
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassuranceevents/search/findByTopic", (Object[])new Object[0]).param("topic", new String[]{"openaire:not-existing:" + uuid.toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassuranceevents/search/findByTopic", (Object[])new Object[0]).param("topic", new String[]{"coar-notify:ENRICH!MISSING!PID"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassuranceevents/search/findByTopic", (Object[])new Object[0]).param("topic", new String[]{"openaire:ENRICH!MISSING!PID:" + uuid.toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassuranceevents", (Matcher)Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassuranceevents", (Matcher)Matchers.contains(QAEventMatcher.matchQAEventEntry(event1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassuranceevents/search/findByTopic", (Object[])new Object[0]).param("topic", new String[]{"coar-notify:ENRICH!MORE!REVIEW:" + uuid.toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassuranceevents", (Matcher)Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassuranceevents", (Matcher)Matchers.contains(QAEventMatcher.matchQAEventEntry(event2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassuranceevents/search/findByTopic", (Object[])new Object[0]).param("topic", new String[]{"openaire:ENRICH!MISSING!PID"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassuranceevents", (Matcher)Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassuranceevents", (Matcher)Matchers.contains(QAEventMatcher.matchQAEventEntry(event1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassuranceevents/search/findByTopic", (Object[])new Object[0]).param("topic", new String[]{"coar-notify:ENRICH!MORE!REVIEW"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassuranceevents", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassuranceevents", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{QAEventMatcher.matchQAEventEntry(event2), QAEventMatcher.matchQAEventEntry(event3)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassuranceevents/search/findByTopic", (Object[])new Object[0]).param("topic", new String[]{"openaire:ENRICH!MISSING!PID:" + uuid.toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassuranceevents/search/findByTopic", (Object[])new Object[0]).param("topic", new String[]{"coar-notify:ENRICH!MORE!REVIEW:" + uuid.toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassuranceevents", (Matcher)Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassuranceevents", (Matcher)Matchers.contains(QAEventMatcher.matchQAEventEntry(event2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassuranceevents/search/findByTopic", (Object[])new Object[0]).param("topic", new String[]{"openaire:ENRICH!MISSING!PID"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findByTopicTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        QAEvent event1 = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"doi\",\"pids[0].value\":\"10.2307/2144300\"}").build();
        QAEvent event2 = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 2").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"doi\",\"pids[0].value\":\"10.2307/2144301\"}").build();
        QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 3").withTopic("ENRICH/MORE/PID").withMessage("{\"pids[0].type\":\"pmid\",\"pids[0].value\":\"10.2307/2144302\"}").build();
        QAEvent event4 = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 4").withTopic("ENRICH/MISSING/ABSTRACT").withMessage("{\"abstracts[0]\": \"Descrizione delle caratteristiche...\"}").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassuranceevents/search/findByTopic", (Object[])new Object[0]).param("topic", new String[]{"openaire:ENRICH!MISSING!PID"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassuranceevents", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassuranceevents", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{QAEventMatcher.matchQAEventEntry(event1), QAEventMatcher.matchQAEventEntry(event2)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassuranceevents/search/findByTopic", (Object[])new Object[0]).param("topic", new String[]{"openaire:ENRICH!MISSING!ABSTRACT"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassuranceevents", (Matcher)Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassuranceevents", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{QAEventMatcher.matchQAEventEntry(event4)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassuranceevents/search/findByTopic", (Object[])new Object[0]).param("topic", new String[]{"not-existing"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findByTopicPaginatedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        QAEvent event1 = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"doi\",\"pids[0].value\":\"10.2307/2144300\"}").build();
        QAEvent event2 = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 2").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"doi\",\"pids[0].value\":\"10.2307/2144301\"}").build();
        QAEvent event3 = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 3").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"doi\",\"pids[0].value\":\"10.2307/2144302\"}").build();
        QAEvent event4 = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 4").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"pmc\",\"pids[0].value\":\"2144303\"}").build();
        QAEvent event5 = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 5").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"pmid\",\"pids[0].value\":\"2144304\"}").build();
        QAEvent event6 = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom").withSource("openaire").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"doi\",\"pids[0].value\":\"10.2307/2144300\"}").build();
        QAEvent event7 = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 2").withSource("openaire").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"doi\",\"pids[0].value\":\"10.2307/2144301\"}").build();
        QAEvent event8 = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 3").withSource("openaire").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"doi\",\"pids[0].value\":\"10.2307/2144302\"}").build();
        QAEvent event9 = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 4").withSource("openaire").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"pmc\",\"pids[0].value\":\"2144303\"}").build();
        QAEvent event10 = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 5").withSource("openaire").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"pmid\",\"pids[0].value\":\"2144304\"}").build();
        this.context.setCurrentUser(this.admin);
        QAEvent event11 = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 5").withSource("openaire").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"pmid\",\"pids[0].value\":\"2144304\"}").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassuranceevents/search/findByTopic", (Object[])new Object[0]).param("topic", new String[]{"openaire:ENRICH!MISSING!PID"}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassuranceevents", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassuranceevents", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{QAEventMatcher.matchQAEventEntry(event1), QAEventMatcher.matchQAEventEntry(event2)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/qualityassuranceevents/search/findByTopic?"), (Matcher)Matchers.containsString((String)"topic=openaire:ENRICH!MISSING!PID"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/qualityassuranceevents/search/findByTopic?"), (Matcher)Matchers.containsString((String)"topic=openaire:ENRICH!MISSING!PID"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/qualityassuranceevents/search/findByTopic?"), (Matcher)Matchers.containsString((String)"topic=openaire:ENRICH!MISSING!PID"), (Matcher)Matchers.containsString((String)"page=5"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/qualityassuranceevents/search/findByTopic?"), (Matcher)Matchers.containsString((String)"topic=openaire:ENRICH!MISSING!PID"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)6))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)11)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassuranceevents/search/findByTopic", (Object[])new Object[0]).param("topic", new String[]{"openaire:ENRICH!MISSING!PID"}).param("size", new String[]{"2"}).param("page", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassuranceevents", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassuranceevents", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{QAEventMatcher.matchQAEventEntry(event3), QAEventMatcher.matchQAEventEntry(event4)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/qualityassuranceevents/search/findByTopic?"), (Matcher)Matchers.containsString((String)"topic=openaire:ENRICH!MISSING!PID"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/qualityassuranceevents/search/findByTopic?"), (Matcher)Matchers.containsString((String)"topic=openaire:ENRICH!MISSING!PID"), (Matcher)Matchers.containsString((String)"page=2"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/qualityassuranceevents/search/findByTopic?"), (Matcher)Matchers.containsString((String)"topic=openaire:ENRICH!MISSING!PID"), (Matcher)Matchers.containsString((String)"page=5"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/qualityassuranceevents/search/findByTopic?"), (Matcher)Matchers.containsString((String)"topic=openaire:ENRICH!MISSING!PID"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/qualityassuranceevents/search/findByTopic?"), (Matcher)Matchers.containsString((String)"topic=openaire:ENRICH!MISSING!PID"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)6))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)11)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassuranceevents/search/findByTopic", (Object[])new Object[0]).param("topic", new String[]{"openaire:ENRICH!MISSING!PID"}).param("size", new String[]{"2"}).param("page", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassuranceevents", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassuranceevents", (Matcher)Matchers.hasItem(QAEventMatcher.matchQAEventEntry(event5)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/qualityassuranceevents/search/findByTopic?"), (Matcher)Matchers.containsString((String)"topic=openaire:ENRICH!MISSING!PID"), (Matcher)Matchers.containsString((String)"page=2"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/qualityassuranceevents/search/findByTopic?"), (Matcher)Matchers.containsString((String)"topic=openaire:ENRICH!MISSING!PID"), (Matcher)Matchers.containsString((String)"page=3"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/qualityassuranceevents/search/findByTopic?"), (Matcher)Matchers.containsString((String)"topic=openaire:ENRICH!MISSING!PID"), (Matcher)Matchers.containsString((String)"page=5"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/qualityassuranceevents/search/findByTopic?"), (Matcher)Matchers.containsString((String)"topic=openaire:ENRICH!MISSING!PID"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/qualityassuranceevents/search/findByTopic?"), (Matcher)Matchers.containsString((String)"topic=openaire:ENRICH!MISSING!PID"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)6))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)11)));
        authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassuranceevents/search/findByTopic", (Object[])new Object[0]).param("topic", new String[]{"openaire:ENRICH!MISSING!PID"}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)JsonPathMatchers.hasNoJsonPath((String)"$._embedded.qualityassuranceevents"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findByTopicUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"doi\",\"pids[0].value\":\"10.2307/2144300\"}").build();
        QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 2").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"doi\",\"pids[0].value\":\"10.2307/2144301\"}").build();
        QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 3").withTopic("ENRICH/MORE/PID").withMessage("{\"pids[0].type\":\"pmid\",\"pids[0].value\":\"10.2307/2144302\"}").build();
        QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 4").withTopic("ENRICH/MISSING/ABSTRACT").withMessage("{\"abstracts[0]\": \"Descrizione delle caratteristiche...\"}").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassuranceevents/search/findByTopic", (Object[])new Object[0]).param("topic", new String[]{"openaire:ENRICH!MISSING!PID"})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findByTopicBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"doi\",\"pids[0].value\":\"10.2307/2144300\"}").build();
        QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 2").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"doi\",\"pids[0].value\":\"10.2307/2144301\"}").build();
        QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 3").withTopic("ENRICH/MORE/PID").withMessage("{\"pids[0].type\":\"pmid\",\"pids[0].value\":\"10.2307/2144302\"}").build();
        QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 4").withTopic("ENRICH/MISSING/ABSTRACT").withMessage("{\"abstracts[0]\": \"Descrizione delle caratteristiche...\"}").build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassuranceevents/search/findByTopic", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void recordDecisionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EntityType publication = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Publication").build();
        EntityType project = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Project").build();
        RelationshipTypeBuilder.createRelationshipTypeBuilder((Context)this.context, (EntityType)publication, (EntityType)project, (String)"isProjectOfPublication", (String)"isPublicationOfProject", (Integer)0, null, (Integer)0, null).withCopyToRight(true).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Publication").withName("Collection 1").build();
        Collection colFunding = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection Fundings").withEntityType("Project").build();
        Item funding = ItemBuilder.createItem((Context)this.context, (Collection)colFunding).withTitle("Tracking Papyrus and Parchment Paths").build();
        QAEvent eventProjectBound = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom with project").withTopic("ENRICH/MISSING/PROJECT").withMessage("{\"projects[0].acronym\":\"PAThs\",\"projects[0].code\":\"687567\",\"projects[0].funder\":\"EC\",\"projects[0].fundingProgram\":\"H2020\",\"projects[0].jurisdiction\":\"EU\",\"projects[0].openaireId\":\"40|corda__h2020::6e32f5eb912688f2424c68b851483ea4\",\"projects[0].title\":\"Tracking Papyrus and Parchment Paths: An Archaeological Atlas of Coptic Literature.\\nLiterary Texts in their Geographical Context: Production, Copying, Usage, Dissemination and Storage\"}").withRelatedItem(funding.getID().toString()).build();
        QAEvent eventProjectNoBound = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom with unrelated project").withTopic("ENRICH/MISSING/PROJECT").withMessage("{\"projects[0].acronym\":\"NEW\",\"projects[0].code\":\"123456\",\"projects[0].funder\":\"EC\",\"projects[0].fundingProgram\":\"H2020\",\"projects[0].jurisdiction\":\"EU\",\"projects[0].openaireId\":\"newProjectID\",\"projects[0].title\":\"A new project\"}").build();
        QAEvent eventMissingPID1 = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"doi\",\"pids[0].value\":\"10.2307/2144300\"}").build();
        QAEvent eventMissingPID2 = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 2").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"doi\",\"pids[0].value\":\"10.2307/2144301\"}").build();
        QAEvent eventMissingUnknownPID = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom URN PID").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"urn\",\"pids[0].value\":\"http://thesis2.sba.units.it/store/handle/item/12937\"}").build();
        QAEvent eventMorePID = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 3").withTopic("ENRICH/MORE/PID").withMessage("{\"pids[0].type\":\"pmid\",\"pids[0].value\":\"2144302\"}").build();
        QAEvent eventAbstract = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 4").withTopic("ENRICH/MISSING/ABSTRACT").withMessage("{\"abstracts[0]\": \"An abstract to add...\"}").build();
        QAEvent eventAbstractToDiscard = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 7").withTopic("ENRICH/MISSING/ABSTRACT").withMessage("{\"abstracts[0]\": \"Abstract to discard...\"}").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> acceptOp = new ArrayList<Operation>();
        acceptOp.add((Operation)new ReplaceOperation("/status", (Object)"accepted"));
        ArrayList<Operation> acceptOpUppercase = new ArrayList<Operation>();
        acceptOpUppercase.add((Operation)new ReplaceOperation("/status", (Object)"accepted"));
        ArrayList<Operation> discardOp = new ArrayList<Operation>();
        discardOp.add((Operation)new ReplaceOperation("/status", (Object)"discarded"));
        ArrayList<Operation> rejectOp = new ArrayList<Operation>();
        rejectOp.add((Operation)new ReplaceOperation("/status", (Object)"rejected"));
        String patchAccept = this.getPatchContent(acceptOp);
        String patchAcceptUppercase = this.getPatchContent(acceptOpUppercase);
        String patchDiscard = this.getPatchContent(discardOp);
        String patchReject = this.getPatchContent(rejectOp);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        eventMissingPID1.setStatus("accepted");
        eventMorePID.setStatus("accepted");
        eventMissingUnknownPID.setStatus("accepted");
        eventMissingUnknownPID.setStatus("accepted");
        eventProjectBound.setStatus("accepted");
        eventProjectNoBound.setStatus("accepted");
        eventAbstract.setStatus("accepted");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/integration/qualityassuranceevents/" + eventMissingPID1.getEventId()), (Object[])new Object[0]).content(patchAccept).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", QAEventMatcher.matchQAEventEntry(eventMissingPID1)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/integration/qualityassuranceevents/" + eventMorePID.getEventId()), (Object[])new Object[0]).content(patchAcceptUppercase).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", QAEventMatcher.matchQAEventEntry(eventMorePID)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/integration/qualityassuranceevents/" + eventMissingUnknownPID.getEventId()), (Object[])new Object[0]).content(patchAccept).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", QAEventMatcher.matchQAEventEntry(eventMissingUnknownPID)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/integration/qualityassuranceevents/" + eventProjectBound.getEventId()), (Object[])new Object[0]).content(patchAccept).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", QAEventMatcher.matchQAEventEntry(eventProjectBound)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/integration/qualityassuranceevents/" + eventProjectNoBound.getEventId()), (Object[])new Object[0]).content(patchAccept).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", QAEventMatcher.matchQAEventEntry(eventProjectNoBound)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/integration/qualityassuranceevents/" + eventAbstract.getEventId()), (Object[])new Object[0]).content(patchAccept).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", QAEventMatcher.matchQAEventEntry(eventAbstract)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + eventMissingPID1.getTarget()), (Object[])new Object[0]).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata['dc.identifier.other'][0].value", (Matcher)Matchers.is((Object)"10.2307/2144300"))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + eventMorePID.getTarget()), (Object[])new Object[0]).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata['dc.identifier.other'][0].value", (Matcher)Matchers.is((Object)"2144302"))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + eventMissingUnknownPID.getTarget()), (Object[])new Object[0]).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata['dc.identifier.other'][0].value", (Matcher)Matchers.is((Object)"http://thesis2.sba.units.it/store/handle/item/12937"))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + eventProjectBound.getTarget()), (Object[])new Object[0]).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata['relation.isProjectOfPublication'][0].value", (Matcher)Matchers.is((Object)funding.getID().toString()))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + eventProjectNoBound.getTarget()), (Object[])new Object[0]).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata['relation.isProjectOfPublication'][0].value", (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + eventAbstract.getTarget()), (Object[])new Object[0]).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata['dc.description.abstract'][0].value", (Matcher)Matchers.is((Object)"An abstract to add..."))));
        eventMissingPID2.setStatus("rejected");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/integration/qualityassuranceevents/" + eventMissingPID2.getEventId()), (Object[])new Object[0]).content(patchReject).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", QAEventMatcher.matchQAEventEntry(eventMissingPID2)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + eventMissingPID2.getTarget()), (Object[])new Object[0]).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)JsonPathMatchers.hasNoJsonPath((String)"$.metadata['dc.identifier.other']")));
        eventAbstractToDiscard.setStatus("discarded");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/integration/qualityassuranceevents/" + eventAbstractToDiscard.getEventId()), (Object[])new Object[0]).content(patchDiscard).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", QAEventMatcher.matchQAEventEntry(eventAbstractToDiscard)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + eventMissingPID2.getTarget()), (Object[])new Object[0]).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)JsonPathMatchers.hasNoJsonPath((String)"$.metadata['dc.description.abstract']")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancesources/openaire", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.totalEvents", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void recordDecisionNotifyTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EntityType publication = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Publication").build();
        EntityType project = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Project").build();
        RelationshipTypeBuilder.createRelationshipTypeBuilder((Context)this.context, (EntityType)publication, (EntityType)project, (String)"isProjectOfPublication", (String)"isPublicationOfProject", (Integer)0, null, (Integer)0, null).withCopyToRight(true).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Publication").withName("Collection 1").build();
        Collection colFunding = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection Fundings").withEntityType("Project").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)colFunding).withTitle("Tracking Papyrus and Parchment Paths").build();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://review-service.com/inbox/about/").withLdnUrl("https://review-service.com/inbox/").withScore(BigDecimal.valueOf(0.6)).build();
        String href = "EC";
        QAEvent eventMoreReview = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom with project").withSource("coar-notify").withTopic("ENRICH/MORE/REVIEW").withMessage("{\"serviceName\":\"" + notifyServiceEntity.getName() + "\",\"serviceId\":\"" + notifyServiceEntity.getID() + "\",\"href\":\"" + href + "\",\"relationship\":\"H2020\"}").withRelatedItem(item.getID().toString()).build();
        QAEvent eventMoreEndorsement = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom with project").withSource("coar-notify").withTopic("ENRICH/MORE/ENDORSEMENT").withMessage("{\"serviceName\":\"" + notifyServiceEntity.getName() + "\",\"serviceId\":\"" + notifyServiceEntity.getID() + "\",\"href\":\"" + href + "\",\"relationship\":\"H2020\"}").withRelatedItem(item.getID().toString()).build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> acceptOp = new ArrayList<Operation>();
        acceptOp.add((Operation)new ReplaceOperation("/status", (Object)"accepted"));
        String patchAccept = this.getPatchContent(acceptOp);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        eventMoreEndorsement.setStatus("accepted");
        eventMoreReview.setStatus("accepted");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/integration/qualityassuranceevents/" + eventMoreReview.getEventId()), (Object[])new Object[0]).content(patchAccept).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", QAEventMatcher.matchQAEventNotifyEntry(eventMoreReview)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + eventMoreReview.getTarget()), (Object[])new Object[0]).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", MetadataMatcher.matchMetadata(this.AddReviewMetadataAction.getMetadata(), href))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/integration/qualityassuranceevents/" + eventMoreEndorsement.getEventId()), (Object[])new Object[0]).content(patchAccept).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", QAEventMatcher.matchQAEventNotifyEntry(eventMoreEndorsement)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + eventMoreEndorsement.getTarget()), (Object[])new Object[0]).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", MetadataMatcher.matchMetadata(this.AddEndorsedMetadataAction.getMetadata(), href))));
    }

    @Test
    public void setRelatedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Collection colFunding = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection Fundings").build();
        QAEvent event = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 5").withTopic("ENRICH/MISSING/PROJECT").withMessage("{\"projects[0].acronym\":\"PAThs\",\"projects[0].code\":\"687567\",\"projects[0].funder\":\"EC\",\"projects[0].fundingProgram\":\"H2020\",\"projects[0].jurisdiction\":\"EU\",\"projects[0].openaireId\":\"40|corda__h2020::6e32f5eb912688f2424c68b851483ea4\",\"projects[0].title\":\"Tracking Papyrus and Parchment Paths: An Archaeological Atlas of Coptic Literature.\\nLiterary Texts in their Geographical Context: Production, Copying, Usage, Dissemination and Storage\"}").build();
        Item funding = ItemBuilder.createItem((Context)this.context, (Collection)colFunding).withTitle("Tracking Papyrus and Parchment Paths").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/qualityassuranceevents/" + event.getEventId()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", QAEventMatcher.matchQAEventFullEntry(event)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/integration/qualityassuranceevents/" + event.getEventId() + "/related"), (Object[])new Object[0]).param("item", new String[]{funding.getID().toString()})).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ItemMatcher.matchItemProperties(funding)));
        event.setRelated(funding.getID().toString());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/qualityassuranceevents/" + event.getEventId()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", QAEventMatcher.matchQAEventFullEntry(event)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/qualityassuranceevents/" + event.getEventId() + "/related"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ItemMatcher.matchItemProperties(funding)));
    }

    @Test
    public void unsetRelatedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Collection colFunding = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection Fundings").build();
        Item funding = ItemBuilder.createItem((Context)this.context, (Collection)colFunding).withTitle("Tracking Papyrus and Parchment Paths").build();
        QAEvent event = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 5").withTopic("ENRICH/MISSING/PROJECT").withMessage("{\"projects[0].acronym\":\"PAThs\",\"projects[0].code\":\"687567\",\"projects[0].funder\":\"EC\",\"projects[0].fundingProgram\":\"H2020\",\"projects[0].jurisdiction\":\"EU\",\"projects[0].openaireId\":\"40|corda__h2020::6e32f5eb912688f2424c68b851483ea4\",\"projects[0].title\":\"Tracking Papyrus and Parchment Paths: An Archaeological Atlas of Coptic Literature.\\nLiterary Texts in their Geographical Context: Production, Copying, Usage, Dissemination and Storage\"}").withRelatedItem(funding.getID().toString()).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/qualityassuranceevents/" + event.getEventId()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", QAEventMatcher.matchQAEventFullEntry(event)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/integration/qualityassuranceevents/" + event.getEventId() + "/related"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        event.setRelated(null);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/qualityassuranceevents/" + event.getEventId()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", QAEventMatcher.matchQAEventFullEntry(event)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/qualityassuranceevents/" + event.getEventId() + "/related"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void setInvalidRelatedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Collection colFunding = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection Fundings").build();
        QAEvent event = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"doi\",\"pids[0].value\":\"10.2307/2144300\"}").build();
        Item funding = ItemBuilder.createItem((Context)this.context, (Collection)colFunding).withTitle("Tracking Papyrus and Parchment Paths").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/qualityassuranceevents/" + event.getEventId()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", QAEventMatcher.matchQAEventFullEntry(event)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/integration/qualityassuranceevents/" + event.getEventId() + "/related"), (Object[])new Object[0]).param("item", new String[]{funding.getID().toString()})).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/qualityassuranceevents/" + event.getEventId()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", QAEventMatcher.matchQAEventFullEntry(event)));
    }

    @Test
    public void deleteItemWithEventTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        QAEvent event1 = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"doi\",\"pids[0].value\":\"10.2307/2144300\"}").build();
        QAEvent event2 = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 2").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"doi\",\"pids[0].value\":\"10.2307/2144301\"}").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassuranceevents/search/findByTopic", (Object[])new Object[0]).param("topic", new String[]{"openaire:ENRICH!MISSING!PID"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassuranceevents", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassuranceevents", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{QAEventMatcher.matchQAEventEntry(event1), QAEventMatcher.matchQAEventEntry(event2)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + event1.getTarget()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(204));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + event1.getTarget()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(404));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassuranceevents/search/findByTopic", (Object[])new Object[0]).param("topic", new String[]{"openaire:ENRICH!MISSING!PID"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassuranceevents", (Matcher)Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassuranceevents", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{QAEventMatcher.matchQAEventEntry(event2)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void testEventDeletion() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        QAEvent event = QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"doi\",\"pids[0].value\":\"10.2307/2144300\"}").build();
        QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"doi\",\"pids[0].value\":\"10.2307/2144300\"}").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/qualityassuranceevents/" + event.getEventId()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", QAEventMatcher.matchQAEventEntry(event)));
        List processedEvents = this.qaEventsDao.findAll(this.context);
        MatcherAssert.assertThat((Object)processedEvents, (Matcher)Matchers.empty());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/integration/qualityassuranceevents/" + event.getEventId()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/qualityassuranceevents/" + event.getEventId()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        processedEvents = this.qaEventsDao.findAll(this.context);
        MatcherAssert.assertThat((Object)processedEvents, (Matcher)Matchers.hasSize((int)1));
        QAEventProcessed processedEvent = (QAEventProcessed)processedEvents.get(0);
        MatcherAssert.assertThat((Object)processedEvent.getEventId(), (Matcher)Matchers.is((Object)event.getEventId()));
        MatcherAssert.assertThat((Object)processedEvent.getItem(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)processedEvent.getItem().getID().toString(), (Matcher)Matchers.is((Object)event.getTarget()));
        MatcherAssert.assertThat((Object)processedEvent.getEventTimestamp(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)processedEvent.getEperson().getID(), (Matcher)Matchers.is((Object)this.admin.getID()));
    }

    @Test
    public void createQAEventByCorrectionTypeUnAuthorizedTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/integration/qualityassuranceevents", (Object[])new Object[0]).param("correctionType", new String[]{"request-withdrawn"}).param("target", new String[]{UUID.randomUUID().toString()}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void createQAEventByCorrectionTypeWithMissingTargetTest() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/integration/qualityassuranceevents", (Object[])new Object[0]).param("correctionType", new String[]{"request-withdrawn"}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void createQAEventsAndIgnoreAutomaticallyByScoreAndFilterTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("demo").build();
        QAEvent event = QAEventBuilder.createTarget((Context)this.context, (Item)item).withSource("coar-notify").withTrust(0.4).withTopic("ENRICH/MORE/REVIEW").withMessage("{\"abstracts[0]\": \"https://doi.org/10.3214/987654\"}").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata['datacite.relation.isReviewedBy']", (Object[])new Object[0]).doesNotExist());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/qualityassuranceevents/" + event.getEventId()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void createQAEventsAndRejectAutomaticallyByScoreAndFilterTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("demo").build();
        QAEvent event = QAEventBuilder.createTarget((Context)this.context, (Item)item).withSource("coar-notify").withTrust(0.3).withTopic("ENRICH/MORE/REVIEW").withMessage("{\"abstracts[0]\": \"https://doi.org/10.3214/987654\"}").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata['datacite.relation.isReviewedBy']", (Object[])new Object[0]).doesNotExist());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/qualityassuranceevents/" + event.getEventId()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void createQAEventsAndDoNothingScoreNotInRangTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("demo").build();
        QAEvent event = QAEventBuilder.createTarget((Context)this.context, (Item)item).withSource("coar-notify").withTrust(0.7).withTopic("ENRICH/MORE/REVIEW").withMessage("{\"abstracts[0]\": \"https://doi.org/10.3214/987654\"}").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata['datacite.relation.isReviewedBy']", (Object[])new Object[0]).doesNotExist());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/qualityassuranceevents/" + event.getEventId()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", QAEventMatcher.matchQAEventFullEntry(event)));
    }

    @Test
    public void createQAEventsAndDoNothingFilterNotCompatibleWithItemTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("item title").build();
        QAEvent event = QAEventBuilder.createTarget((Context)this.context, (Item)item).withSource("coar-notify").withTrust(0.8).withTopic("ENRICH/MORE/REVIEW").withMessage("{\"abstracts[0]\": \"https://doi.org/10.3214/987654\"}").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata['datacite.relation.isReviewedBy']", (Object[])new Object[0]).doesNotExist());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/qualityassuranceevents/" + event.getEventId()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", QAEventMatcher.matchQAEventFullEntry(event)));
    }

    @Test
    public void createQAEventByCorrectionTypeWithdrawnRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.configurationService.setProperty("qaevents.withdraw-reinstate.group", (Object)"Anonymous");
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection for Publications").withEntityType("Publication").build();
        Item publication = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Publication archived item").build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publication.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.withdrawn", (Matcher)Matchers.is((Object)false)));
        AtomicReference idRef = new AtomicReference();
        CorrectionTypeMessageDTO message = new CorrectionTypeMessageDTO("reasone");
        String ePersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(ePersonToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/integration/qualityassuranceevents", (Object[])new Object[0]).param("correctionType", new String[]{"request-withdrawn"}).param("target", new String[]{publication.getID().toString()}).content(new ObjectMapper().writeValueAsBytes((Object)message)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/qualityassuranceevents/" + (String)idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)((String)idRef.get())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.source", (Matcher)Matchers.is((Object)"DSpaceUsers"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.title", (Matcher)Matchers.is((Object)publication.getName()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.topic", (Matcher)Matchers.is((Object)"REQUEST/WITHDRAWN"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.trust", (Matcher)Matchers.is((Object)"1.000"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.status", (Matcher)Matchers.is((Object)"PENDING")));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publication.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.withdrawn", (Matcher)Matchers.is((Object)false)));
        ArrayList<Operation> acceptOp = new ArrayList<Operation>();
        acceptOp.add((Operation)new ReplaceOperation("/status", (Object)"accepted"));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/integration/qualityassuranceevents/" + (String)idRef.get()), (Object[])new Object[0]).content(this.getPatchContent(acceptOp)).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publication.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.withdrawn", (Matcher)Matchers.is((Object)true)));
    }

    @Test
    public void createQAEventByCorrectionTypeReinstateRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.configurationService.setProperty("qaevents.withdraw-reinstate.group", (Object)"Anonymous");
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection for Publications").withEntityType("Publication").build();
        Item publication = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Publication archived item").withdrawn().build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String ePersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publication.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.withdrawn", (Matcher)Matchers.is((Object)true)));
        AtomicReference idRef = new AtomicReference();
        ObjectMapper mapper = new ObjectMapper();
        CorrectionTypeMessageDTO dto = new CorrectionTypeMessageDTO("provided reason!");
        this.getClient(ePersonToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/integration/qualityassuranceevents", (Object[])new Object[0]).param("correctionType", new String[]{"request-reinstate"}).param("target", new String[]{publication.getID().toString()}).contentType(this.contentType).content(mapper.writeValueAsBytes((Object)dto))).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/qualityassuranceevents/" + (String)idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)((String)idRef.get())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.source", (Matcher)Matchers.is((Object)"DSpaceUsers"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.title", (Matcher)Matchers.is((Object)publication.getName()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.topic", (Matcher)Matchers.is((Object)"REQUEST/REINSTATE"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.trust", (Matcher)Matchers.is((Object)"1.000"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.status", (Matcher)Matchers.is((Object)"PENDING")));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publication.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.withdrawn", (Matcher)Matchers.is((Object)true)));
        ArrayList<Operation> acceptOp = new ArrayList<Operation>();
        acceptOp.add((Operation)new ReplaceOperation("/status", (Object)"accepted"));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/integration/qualityassuranceevents/" + (String)idRef.get()), (Object[])new Object[0]).content(this.getPatchContent(acceptOp)).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publication.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.withdrawn", (Matcher)Matchers.is((Object)false)));
    }

    @Test
    public void createQAEventOnlyUserPresentInWithdrawalReinstateGroupTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson user1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson-test@mail.com").withPassword(this.password).build();
        Group withdrawalGroup = GroupBuilder.createGroup((Context)this.context).withName("WithdrawGroup").addMember(user1).build();
        this.configurationService.setProperty("qaevents.withdraw-reinstate.group", (Object)withdrawalGroup.getName());
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection for Publications").withEntityType("Publication").build();
        Item publication = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Publication archived item").build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        CorrectionTypeMessageDTO message = new CorrectionTypeMessageDTO("reasone");
        String ePersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(ePersonToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/integration/qualityassuranceevents", (Object[])new Object[0]).param("correctionType", new String[]{"request-withdrawn"}).param("target", new String[]{publication.getID().toString()}).content(new ObjectMapper().writeValueAsBytes((Object)message)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        String user1Token = this.getAuthToken(user1.getEmail(), this.password);
        this.getClient(user1Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/integration/qualityassuranceevents", (Object[])new Object[0]).param("correctionType", new String[]{"request-withdrawn"}).param("target", new String[]{publication.getID().toString()}).content(new ObjectMapper().writeValueAsBytes((Object)message)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/qualityassuranceevents/" + (String)idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)((String)idRef.get())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.source", (Matcher)Matchers.is((Object)"DSpaceUsers"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.title", (Matcher)Matchers.is((Object)publication.getName()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.topic", (Matcher)Matchers.is((Object)"REQUEST/WITHDRAWN"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.trust", (Matcher)Matchers.is((Object)"1.000"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.status", (Matcher)Matchers.is((Object)"PENDING")));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publication.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.withdrawn", (Matcher)Matchers.is((Object)false)));
        ArrayList<Operation> acceptOp = new ArrayList<Operation>();
        acceptOp.add((Operation)new ReplaceOperation("/status", (Object)"accepted"));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/integration/qualityassuranceevents/" + (String)idRef.get()), (Object[])new Object[0]).content(this.getPatchContent(acceptOp)).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publication.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.withdrawn", (Matcher)Matchers.is((Object)true)));
    }
}

