/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.params.SolrParams;
import org.dspace.app.rest.matcher.MetadataMatcher;
import org.dspace.app.rest.matcher.PageMatcher;
import org.dspace.app.rest.matcher.RelationshipMatcher;
import org.dspace.app.rest.model.RelationshipRest;
import org.dspace.app.rest.model.patch.AddOperation;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.test.AbstractEntityIntegrationTest;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.EntityTypeBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.MetadataFieldBuilder;
import org.dspace.builder.RelationshipBuilder;
import org.dspace.builder.RelationshipTypeBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.EntityType;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.MetadataValue;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipType;
import org.dspace.content.service.EntityTypeService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.MetadataSchemaService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.discovery.MockSolrSearchCore;
import org.dspace.eperson.EPerson;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class RelationshipRestRepositoryIT
extends AbstractEntityIntegrationTest {
    @Autowired
    protected RelationshipTypeService relationshipTypeService;
    @Autowired
    protected EntityTypeService entityTypeService;
    @Autowired
    protected AuthorizeService authorizeService;
    @Autowired
    protected ItemService itemService;
    @Autowired
    protected MetadataFieldService metadataFieldService;
    @Autowired
    protected MetadataSchemaService metadataSchemaService;
    @Autowired
    MockSolrSearchCore mockSolrSearchCore;
    protected Community parentCommunity;
    protected Community child1;
    protected Collection col1;
    protected Collection col2;
    protected Collection col3;
    protected Collection col4;
    protected Collection col5;
    protected Collection col6;
    protected Collection col7;
    protected Item author1;
    protected Item author2;
    protected Item author3;
    protected Item orgUnit1;
    protected Item orgUnit2;
    protected Item orgUnit3;
    protected Item project1;
    protected Item publication1;
    protected Item publication2;
    protected RelationshipType isAuthorOfPublicationRelationshipType;
    protected RelationshipType isOrgUnitOfPersonRelationshipType;
    protected EPerson user1;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        this.child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        this.col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.child1).withName("Collection 1").withEntityType("Person").build();
        this.col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.child1).withName("Collection 2").withEntityType("Publication").build();
        this.col3 = CollectionBuilder.createCollection((Context)this.context, (Community)this.child1).withName("OrgUnits").withEntityType("OrgUnit").build();
        this.col4 = CollectionBuilder.createCollection((Context)this.context, (Community)this.child1).withName("Projects").withEntityType("Project").build();
        this.col5 = CollectionBuilder.createCollection((Context)this.context, (Community)this.child1).withName("Projects").withEntityType("Journal").build();
        this.col6 = CollectionBuilder.createCollection((Context)this.context, (Community)this.child1).withName("Projects").withEntityType("JournalVolume").build();
        this.col7 = CollectionBuilder.createCollection((Context)this.context, (Community)this.child1).withName("Projects").withEntityType("JournalIssue").build();
        this.author1 = ItemBuilder.createItem((Context)this.context, (Collection)this.col1).withTitle("Author1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withPersonIdentifierLastName("Smith").withPersonIdentifierFirstName("Donald").build();
        this.author2 = ItemBuilder.createItem((Context)this.context, (Collection)this.col1).withTitle("Author2").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withPersonIdentifierLastName("Smith").withPersonIdentifierFirstName("Maria").build();
        this.author3 = ItemBuilder.createItem((Context)this.context, (Collection)this.col1).withTitle("Author3").withIssueDate("2016-02-13").withPersonIdentifierFirstName("Maybe").withPersonIdentifierLastName("Maybe").build();
        this.publication1 = ItemBuilder.createItem((Context)this.context, (Collection)this.col2).withTitle("Publication1").withAuthor("Testy, TEst").withIssueDate("2015-01-01").build();
        this.publication2 = ItemBuilder.createItem((Context)this.context, (Collection)this.col2).withTitle("Publication2").withAuthor("Testy, TEst").withIssueDate("2015-01-01").build();
        this.orgUnit1 = ItemBuilder.createItem((Context)this.context, (Collection)this.col3).withTitle("OrgUnit1").withAuthor("Testy, TEst").withIssueDate("2015-01-01").build();
        this.orgUnit2 = ItemBuilder.createItem((Context)this.context, (Collection)this.col3).withTitle("OrgUnit2").withAuthor("Testy, TEst").withIssueDate("2015-01-01").build();
        this.orgUnit3 = ItemBuilder.createItem((Context)this.context, (Collection)this.col3).withTitle("OrgUnit3").withAuthor("Test, Testy").withIssueDate("2015-02-01").build();
        this.project1 = ItemBuilder.createItem((Context)this.context, (Collection)this.col4).withTitle("Project1").withAuthor("Testy, TEst").withIssueDate("2015-01-01").build();
        this.isAuthorOfPublicationRelationshipType = this.relationshipTypeService.findbyTypesAndTypeName(this.context, this.entityTypeService.findByEntityType(this.context, "Publication"), this.entityTypeService.findByEntityType(this.context, "Person"), "isAuthorOfPublication", "isPublicationOfAuthor");
        this.isOrgUnitOfPersonRelationshipType = this.relationshipTypeService.findbyTypesAndTypeName(this.context, this.entityTypeService.findByEntityType(this.context, "Person"), this.entityTypeService.findByEntityType(this.context, "OrgUnit"), "isOrgUnitOfPerson", "isPersonOfOrgUnit");
        this.user1 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("first", "last").withEmail("testaze@gmail.com").withPassword(this.password).withLanguage(I18nUtil.getDefaultLocale().getLanguage()).build();
        this.context.restoreAuthSystemState();
    }

    @Test
    public void findAllRelationshipTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        RelationshipType isOrgUnitOfPersonRelationshipType = this.relationshipTypeService.findbyTypesAndTypeName(this.context, this.entityTypeService.findByEntityType(this.context, "Person"), this.entityTypeService.findByEntityType(this.context, "OrgUnit"), "isOrgUnitOfPerson", "isPersonOfOrgUnit");
        RelationshipType isOrgUnitOfProjectRelationshipType = this.relationshipTypeService.findbyTypesAndTypeName(this.context, this.entityTypeService.findByEntityType(this.context, "Project"), this.entityTypeService.findByEntityType(this.context, "OrgUnit"), "isOrgUnitOfProject", "isProjectOfOrgUnit");
        RelationshipType isAuthorOfPublicationRelationshipType = this.relationshipTypeService.findbyTypesAndTypeName(this.context, this.entityTypeService.findByEntityType(this.context, "Publication"), this.entityTypeService.findByEntityType(this.context, "Person"), "isAuthorOfPublication", "isPublicationOfAuthor");
        Relationship relationship1 = RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.author1, (Item)this.orgUnit1, (RelationshipType)isOrgUnitOfPersonRelationshipType).build();
        Relationship relationship2 = RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.project1, (Item)this.orgUnit1, (RelationshipType)isOrgUnitOfProjectRelationshipType).build();
        Relationship relationship3 = RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.publication1, (Item)this.author1, (RelationshipType)isAuthorOfPublicationRelationshipType).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/relationships", (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 3)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.relationships", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{RelationshipMatcher.matchRelationship(relationship1), RelationshipMatcher.matchRelationship(relationship2), RelationshipMatcher.matchRelationship(relationship3)})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/relationships", (Object[])new Object[0]).param("size", new String[]{"2"}).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 2, 2, 3)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.relationships", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{RelationshipMatcher.matchRelationship(relationship1), RelationshipMatcher.matchRelationship(relationship2)})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/relationships", (Object[])new Object[0]).param("size", new String[]{"2"}).param("page", new String[]{"1"}).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(1, 2, 2, 3)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.relationships", (Matcher)Matchers.contains(RelationshipMatcher.matchRelationship(relationship3))));
    }

    @Test
    public void createRelationshipWriteAccessLeftItem() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.context.setCurrentUser(this.user1);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.publication1, 1, this.user1);
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        try {
            String token = this.getAuthToken(this.user1.getEmail(), this.password);
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isAuthorOfPublicationRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.publication1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.author1.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.leftItem.href", (Matcher)Matchers.containsString((String)this.publication1.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.rightItem.href", (Matcher)Matchers.containsString((String)this.author1.getID().toString())));
        }
        finally {
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef.get()));
        }
    }

    @Test
    public void createRelationshipWriteAccessRightItem() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.context.setCurrentUser(this.user1);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.author1, 1, this.user1);
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        try {
            String token = this.getAuthToken(this.user1.getEmail(), this.password);
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isAuthorOfPublicationRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.publication1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.author1.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.leftItem.href", (Matcher)Matchers.containsString((String)this.publication1.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.rightItem.href", (Matcher)Matchers.containsString((String)this.author1.getID().toString())));
        }
        finally {
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef.get()));
        }
    }

    @Test
    public void createRelationshipNoWriteAccess() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.context.setCurrentUser(this.user1);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.user1.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isAuthorOfPublicationRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.publication1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.author1.getID())).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createRelationshipWithLeftWardValue() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.publication1, 1, this.user1);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.author1, 1, this.user1);
        this.context.setCurrentUser(this.user1);
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        try {
            String token = this.getAuthToken(this.user1.getEmail(), this.password);
            String leftwardValue = "Name variant test left";
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isAuthorOfPublicationRelationshipType.getID().toString()}).param("leftwardValue", new String[]{leftwardValue}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.publication1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.author1.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)((Integer)idRef.get())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.leftwardValue", (Matcher)Matchers.containsString((String)leftwardValue))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rightwardValue", (Matcher)Matchers.is((Matcher)Matchers.nullValue())));
        }
        finally {
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createRelationshipWithRightwardValue() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.publication1, 1, this.user1);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.author1, 1, this.user1);
        this.context.setCurrentUser(this.user1);
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        try {
            String token = this.getAuthToken(this.user1.getEmail(), this.password);
            String rightwardValue = "Name variant test right";
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isAuthorOfPublicationRelationshipType.getID().toString()}).param("rightwardValue", new String[]{rightwardValue}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.publication1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.author1.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)((Integer)idRef.get())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.leftwardValue", (Matcher)Matchers.is((Matcher)Matchers.nullValue()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rightwardValue", (Matcher)Matchers.containsString((String)rightwardValue)));
        }
        finally {
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createRelationshipWithRightwardValueAndLeftWardValue() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.publication1, 1, this.user1);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.author1, 1, this.user1);
        this.context.setCurrentUser(this.user1);
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        try {
            String token = this.getAuthToken(this.user1.getEmail(), this.password);
            String leftwardValue = "Name variant test left";
            String rightwardValue = "Name variant test right";
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isAuthorOfPublicationRelationshipType.getID().toString()}).param("leftwardValue", new String[]{leftwardValue}).param("rightwardValue", new String[]{rightwardValue}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.publication1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.author1.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)((Integer)idRef.get())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.leftwardValue", (Matcher)Matchers.containsString((String)leftwardValue))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rightwardValue", (Matcher)Matchers.containsString((String)rightwardValue)));
        }
        finally {
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createMultipleRelationshipsAppendToEndTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.publication1, 1, this.user1);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.author1, 1, this.user1);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.author2, 1, this.user1);
        this.context.setCurrentUser(this.user1);
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        AtomicReference idRef2 = new AtomicReference();
        try {
            String token = this.getAuthToken(this.user1.getEmail(), this.password);
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isAuthorOfPublicationRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.publication1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.author1.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)((Integer)idRef.get())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.leftPlace", (Matcher)Matchers.is((Object)1)));
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isAuthorOfPublicationRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.publication1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.author2.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef2.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef2), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)((Integer)idRef2.get())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.leftPlace", (Matcher)Matchers.is((Object)2)));
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.publication1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.contributor.author", "Testy, TEst", 0), MetadataMatcher.matchMetadata("dc.contributor.author", "Smith, Donald", 1), MetadataMatcher.matchMetadata("dc.contributor.author", "Smith, Maria", 2))));
        }
        finally {
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef.get()));
            if (idRef2.get() != null) {
                RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef2.get()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createRelationshipAndAddLeftWardValueAfterwards() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.publication1, 1, this.user1);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.author1, 1, this.user1);
        this.context.setCurrentUser(this.user1);
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        try {
            String token = this.getAuthToken(this.user1.getEmail(), this.password);
            String leftwardValue = "Name variant test label";
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isAuthorOfPublicationRelationshipType.getID().toString()}).param("projection", new String[]{"full"}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.publication1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.author1.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", RelationshipMatcher.matchFullEmbeds())).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)((Integer)idRef.get())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.leftwardValue", (Matcher)Matchers.is((Matcher)Matchers.nullValue()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rightwardValue", (Matcher)Matchers.is((Matcher)Matchers.nullValue())));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("leftwardValue", leftwardValue);
            String json = new ObjectMapper().writeValueAsString(map);
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/relationships/" + idRef), (Object[])new Object[0]).contentType("application/json").content(json)).andExpect(MockMvcResultMatchers.status().isOk());
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)((Integer)idRef.get())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.leftwardValue", (Matcher)Matchers.containsString((String)leftwardValue))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rightwardValue", (Matcher)Matchers.is((Matcher)Matchers.nullValue())));
        }
        finally {
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createRelationshipThenAddLabelsAndRemoveThem() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.publication1, 1, this.user1);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.author1, 1, this.user1);
        this.context.setCurrentUser(this.user1);
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        try {
            String token = this.getAuthToken(this.user1.getEmail(), this.password);
            String leftwardValue = "Name variant test left";
            String rightwardValue = "Name variant test right";
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isAuthorOfPublicationRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.publication1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.author1.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)((Integer)idRef.get())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.leftwardValue", (Matcher)Matchers.is((Matcher)Matchers.nullValue()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rightwardValue", (Matcher)Matchers.is((Matcher)Matchers.nullValue())));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("leftwardValue", leftwardValue);
            map.put("rightwardValue", rightwardValue);
            String json = new ObjectMapper().writeValueAsString(map);
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/relationships/" + idRef), (Object[])new Object[0]).contentType("application/json").content(json)).andExpect(MockMvcResultMatchers.status().isOk());
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)((Integer)idRef.get())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.leftwardValue", (Matcher)Matchers.containsString((String)leftwardValue))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rightwardValue", (Matcher)Matchers.containsString((String)rightwardValue)));
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/relationships/" + idRef), (Object[])new Object[0]).contentType("application/json").content("{}")).andExpect(MockMvcResultMatchers.status().isOk());
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)((Integer)idRef.get())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.leftwardValue", (Matcher)Matchers.is((Matcher)Matchers.nullValue()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rightwardValue", (Matcher)Matchers.is((Matcher)Matchers.nullValue())));
        }
        finally {
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addRelationshipsAndMetadataToValidatePlaceTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item author1 = ItemBuilder.createItem((Context)this.context, (Collection)this.col1).withTitle("Author1").withIssueDate("2017-10-17").withPersonIdentifierFirstName("Donald").withPersonIdentifierLastName("Smith").build();
        Item author2 = ItemBuilder.createItem((Context)this.context, (Collection)this.col1).withTitle("Author2").withIssueDate("2016-02-13").withPersonIdentifierFirstName("Maria").withPersonIdentifierLastName("Smith").build();
        Item author3 = ItemBuilder.createItem((Context)this.context, (Collection)this.col1).withTitle("Author3").withIssueDate("2016-02-13").withPersonIdentifierFirstName("Maybe").withPersonIdentifierLastName("Maybe").build();
        Item publication1 = ItemBuilder.createItem((Context)this.context, (Collection)this.col2).withTitle("Publication1").withIssueDate("2015-01-01").build();
        RelationshipType isAuthorOfPublicationRelationshipType = this.relationshipTypeService.findbyTypesAndTypeName(this.context, this.entityTypeService.findByEntityType(this.context, "Publication"), this.entityTypeService.findByEntityType(this.context, "Person"), "isAuthorOfPublication", "isPublicationOfAuthor");
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.context.restoreAuthSystemState();
        AtomicReference idRef1 = new AtomicReference();
        AtomicReference idRef2 = new AtomicReference();
        AtomicReference idRef3 = new AtomicReference();
        try {
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{isAuthorOfPublicationRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + publication1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + author1.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef1.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef1), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"leftPlace", (Matcher)Matchers.is((Object)0)));
            this.context.turnOffAuthorisationSystem();
            publication1 = (Item)this.itemService.find(this.context, publication1.getID());
            this.itemService.addMetadata(this.context, (DSpaceObject)publication1, "dc", "contributor", "author", "*", "plain text");
            this.itemService.update(this.context, (DSpaceObject)publication1);
            List list = this.itemService.getMetadata((DSpaceObject)publication1, "dc", "contributor", "author", "*");
            Assert.assertEquals((long)2L, (long)list.size());
            for (MetadataValue mdv : list) {
                if (!StringUtils.equals((CharSequence)mdv.getValue(), (CharSequence)"plain text")) continue;
                Assert.assertEquals((long)1L, (long)mdv.getPlace());
            }
            MetadataValue author0MD = (MetadataValue)list.get(0);
            Assert.assertEquals((Object)"Smith, Donald", (Object)author0MD.getValue());
            MetadataValue author1MD = (MetadataValue)list.get(1);
            Assert.assertEquals((Object)"plain text", (Object)author1MD.getValue());
            this.context.restoreAuthSystemState();
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef1), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"leftPlace", (Matcher)Matchers.is((Object)0)));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{isAuthorOfPublicationRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + publication1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + author2.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef2.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            publication1 = (Item)this.itemService.find(this.context, publication1.getID());
            list = this.itemService.getMetadata((DSpaceObject)publication1, "dc", "contributor", "author", "*");
            Assert.assertEquals((long)3L, (long)list.size());
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef2), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"leftPlace", (Matcher)Matchers.is((Object)2)));
            author0MD = (MetadataValue)list.get(0);
            Assert.assertEquals((Object)"Smith, Donald", (Object)author0MD.getValue());
            author1MD = (MetadataValue)list.get(1);
            Assert.assertEquals((Object)"plain text", (Object)author1MD.getValue());
            MetadataValue author2MD = (MetadataValue)list.get(2);
            Assert.assertEquals((Object)"Smith, Maria", (Object)author2MD.getValue());
            this.context.turnOffAuthorisationSystem();
            publication1 = (Item)this.itemService.find(this.context, publication1.getID());
            this.itemService.addMetadata(this.context, (DSpaceObject)publication1, "dc", "contributor", "author", "*", "plain text two");
            this.itemService.update(this.context, (DSpaceObject)publication1);
            this.context.restoreAuthSystemState();
            publication1 = (Item)this.itemService.find(this.context, publication1.getID());
            list = this.itemService.getMetadata((DSpaceObject)publication1, "dc", "contributor", "author", "*");
            Assert.assertEquals((long)4L, (long)list.size());
            for (MetadataValue mdv : list) {
                if (!StringUtils.equals((CharSequence)mdv.getValue(), (CharSequence)"plain text two")) continue;
                Assert.assertEquals((long)3L, (long)mdv.getPlace());
            }
            author0MD = (MetadataValue)list.get(0);
            Assert.assertEquals((Object)"Smith, Donald", (Object)author0MD.getValue());
            author1MD = (MetadataValue)list.get(1);
            Assert.assertEquals((Object)"plain text", (Object)author1MD.getValue());
            author2MD = (MetadataValue)list.get(2);
            Assert.assertEquals((Object)"Smith, Maria", (Object)author2MD.getValue());
            MetadataValue author3MD = (MetadataValue)list.get(3);
            Assert.assertEquals((Object)"plain text two", (Object)author3MD.getValue());
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{isAuthorOfPublicationRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + publication1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + author3.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef3.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            publication1 = (Item)this.itemService.find(this.context, publication1.getID());
            list = this.itemService.getMetadata((DSpaceObject)publication1, "dc", "contributor", "author", "*");
            Assert.assertEquals((long)5L, (long)list.size());
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef3), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"leftPlace", (Matcher)Matchers.is((Object)4)));
            author0MD = (MetadataValue)list.get(0);
            Assert.assertEquals((Object)"Smith, Donald", (Object)author0MD.getValue());
            author1MD = (MetadataValue)list.get(1);
            Assert.assertEquals((Object)"plain text", (Object)author1MD.getValue());
            author2MD = (MetadataValue)list.get(2);
            Assert.assertEquals((Object)"Smith, Maria", (Object)author2MD.getValue());
            author3MD = (MetadataValue)list.get(3);
            Assert.assertEquals((Object)"plain text two", (Object)author3MD.getValue());
            MetadataValue author4MD = (MetadataValue)list.get(4);
            Assert.assertEquals((Object)"Maybe, Maybe", (Object)author4MD.getValue());
            this.context.turnOffAuthorisationSystem();
            publication1 = (Item)this.itemService.find(this.context, publication1.getID());
            this.itemService.addMetadata(this.context, (DSpaceObject)publication1, "dc", "contributor", "author", "*", "plain text three");
            this.itemService.update(this.context, (DSpaceObject)publication1);
            this.context.restoreAuthSystemState();
            list = this.itemService.getMetadata((DSpaceObject)publication1, "dc", "contributor", "author", "*");
            Assert.assertEquals((long)6L, (long)list.size());
            for (Object mdv : list) {
                if (!StringUtils.equals((CharSequence)mdv.getValue(), (CharSequence)"plain text three")) continue;
                Assert.assertEquals((long)5L, (long)mdv.getPlace());
            }
            author0MD = (MetadataValue)list.get(0);
            Assert.assertEquals((Object)"Smith, Donald", (Object)author0MD.getValue());
            author1MD = (MetadataValue)list.get(1);
            Assert.assertEquals((Object)"plain text", (Object)author1MD.getValue());
            author2MD = (MetadataValue)list.get(2);
            Assert.assertEquals((Object)"Smith, Maria", (Object)author2MD.getValue());
            author3MD = (MetadataValue)list.get(3);
            Assert.assertEquals((Object)"plain text two", (Object)author3MD.getValue());
            author4MD = (MetadataValue)list.get(4);
            Assert.assertEquals((Object)"Maybe, Maybe", (Object)author4MD.getValue());
            MetadataValue author5MD = (MetadataValue)list.get(5);
            Assert.assertEquals((Object)"plain text three", (Object)author5MD.getValue());
            this.context.turnOffAuthorisationSystem();
            publication1 = (Item)this.itemService.find(this.context, publication1.getID());
            this.itemService.addMetadata(this.context, (DSpaceObject)publication1, "dc", "contributor", "author", "*", "plain text four");
            this.itemService.addMetadata(this.context, (DSpaceObject)publication1, "dc", "contributor", "author", "*", "plain text five");
            this.itemService.addMetadata(this.context, (DSpaceObject)publication1, "dc", "contributor", "author", "*", "plain text six");
            this.itemService.addMetadata(this.context, (DSpaceObject)publication1, "dc", "contributor", "author", "*", "plain text seven");
            this.itemService.update(this.context, (DSpaceObject)publication1);
            this.context.restoreAuthSystemState();
            publication1 = (Item)this.itemService.find(this.context, publication1.getID());
            list = this.itemService.getMetadata((DSpaceObject)publication1, "dc", "contributor", "author", "*");
            Assert.assertEquals((long)10L, (long)list.size());
            for (MetadataValue mdv : list) {
                if (StringUtils.equals((CharSequence)mdv.getValue(), (CharSequence)"plain text four")) {
                    Assert.assertEquals((long)6L, (long)mdv.getPlace());
                }
                if (StringUtils.equals((CharSequence)mdv.getValue(), (CharSequence)"plain text five")) {
                    Assert.assertEquals((long)7L, (long)mdv.getPlace());
                }
                if (StringUtils.equals((CharSequence)mdv.getValue(), (CharSequence)"plain text six")) {
                    Assert.assertEquals((long)8L, (long)mdv.getPlace());
                }
                if (!StringUtils.equals((CharSequence)mdv.getValue(), (CharSequence)"plain text seven")) continue;
                Assert.assertEquals((long)9L, (long)mdv.getPlace());
            }
            author0MD = (MetadataValue)list.get(0);
            Assert.assertEquals((Object)"Smith, Donald", (Object)author0MD.getValue());
            author1MD = (MetadataValue)list.get(1);
            Assert.assertEquals((Object)"plain text", (Object)author1MD.getValue());
            author2MD = (MetadataValue)list.get(2);
            Assert.assertEquals((Object)"Smith, Maria", (Object)author2MD.getValue());
            author3MD = (MetadataValue)list.get(3);
            Assert.assertEquals((Object)"plain text two", (Object)author3MD.getValue());
            author4MD = (MetadataValue)list.get(4);
            Assert.assertEquals((Object)"Maybe, Maybe", (Object)author4MD.getValue());
            author5MD = (MetadataValue)list.get(5);
            Assert.assertEquals((Object)"plain text three", (Object)author5MD.getValue());
            MetadataValue author6MD = (MetadataValue)list.get(6);
            Assert.assertEquals((Object)"plain text four", (Object)author6MD.getValue());
            MetadataValue author7MD = (MetadataValue)list.get(7);
            Assert.assertEquals((Object)"plain text five", (Object)author7MD.getValue());
            MetadataValue author8MD = (MetadataValue)list.get(8);
            Assert.assertEquals((Object)"plain text six", (Object)author8MD.getValue());
            MetadataValue author9MD = (MetadataValue)list.get(9);
            Assert.assertEquals((Object)"plain text seven", (Object)author9MD.getValue());
            list = this.itemService.getMetadata((DSpaceObject)publication1, "dc", "contributor", "*", "*");
            Assert.assertEquals((long)10L, (long)list.size());
            list = this.itemService.getMetadata((DSpaceObject)publication1, "dc", "*", "*", "*");
            Assert.assertEquals((long)15L, (long)list.size());
            list = this.itemService.getMetadata((DSpaceObject)publication1, "*", "*", "*", "*");
            Assert.assertEquals((long)22L, (long)list.size());
        }
        finally {
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef1.get()));
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef2.get()));
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef3.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void deleteMetadataValueAndValidatePlace() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item publication1 = ItemBuilder.createItem((Context)this.context, (Collection)this.col2).withTitle("Publication1").withIssueDate("2015-01-01").build();
        Item author2 = ItemBuilder.createItem((Context)this.context, (Collection)this.col1).withTitle("Author2").withIssueDate("2016-02-13").withPersonIdentifierFirstName("Maria").withPersonIdentifierLastName("Smith").build();
        Item author3 = ItemBuilder.createItem((Context)this.context, (Collection)this.col1).withTitle("Author3").withIssueDate("2016-02-13").withPersonIdentifierFirstName("Maybe").withPersonIdentifierLastName("Maybe").build();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.context.restoreAuthSystemState();
        AtomicReference idRef1 = new AtomicReference();
        AtomicReference idRef2 = new AtomicReference();
        AtomicReference idRef3 = new AtomicReference();
        try {
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isAuthorOfPublicationRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + publication1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.author1.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef1.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef1), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"leftPlace", (Matcher)Matchers.is((Object)0)));
            this.context.turnOffAuthorisationSystem();
            publication1 = (Item)this.itemService.find(this.context, publication1.getID());
            this.itemService.addMetadata(this.context, (DSpaceObject)publication1, "dc", "contributor", "author", "*", "plain text");
            this.itemService.update(this.context, (DSpaceObject)publication1);
            this.context.restoreAuthSystemState();
            List list = this.itemService.getMetadata((DSpaceObject)publication1, "dc", "contributor", "author", "*");
            for (MetadataValue mdv : list) {
                if (!StringUtils.equals((CharSequence)mdv.getValue(), (CharSequence)"plain text")) continue;
                Assert.assertEquals((long)1L, (long)mdv.getPlace());
            }
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef1), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"leftPlace", (Matcher)Matchers.is((Object)0)));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isAuthorOfPublicationRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + publication1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + author2.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef2.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef2), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"leftPlace", (Matcher)Matchers.is((Object)2)));
            this.context.turnOffAuthorisationSystem();
            publication1 = (Item)this.itemService.find(this.context, publication1.getID());
            this.itemService.addMetadata(this.context, (DSpaceObject)publication1, "dc", "contributor", "author", "*", "plain text two");
            this.itemService.update(this.context, (DSpaceObject)publication1);
            this.context.restoreAuthSystemState();
            list = this.itemService.getMetadata((DSpaceObject)publication1, "dc", "contributor", "author", "*");
            for (MetadataValue mdv : list) {
                if (!StringUtils.equals((CharSequence)mdv.getValue(), (CharSequence)"plain text two")) continue;
                Assert.assertEquals((long)3L, (long)mdv.getPlace());
            }
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isAuthorOfPublicationRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + publication1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + author3.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef3.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef3), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"leftPlace", (Matcher)Matchers.is((Object)4)));
            this.context.turnOffAuthorisationSystem();
            publication1 = (Item)this.itemService.find(this.context, publication1.getID());
            this.itemService.addMetadata(this.context, (DSpaceObject)publication1, "dc", "contributor", "author", "*", "plain text three");
            this.itemService.update(this.context, (DSpaceObject)publication1);
            this.context.restoreAuthSystemState();
            list = this.itemService.getMetadata((DSpaceObject)publication1, "dc", "contributor", "author", "*");
            for (MetadataValue mdv : list) {
                if (!StringUtils.equals((CharSequence)mdv.getValue(), (CharSequence)"plain text three")) continue;
                Assert.assertEquals((long)5L, (long)mdv.getPlace());
            }
            List authors = this.itemService.getMetadata((DSpaceObject)publication1, "dc", "contributor", "author", "*");
            LinkedList<MetadataValue> listToRemove = new LinkedList<MetadataValue>();
            for (MetadataValue metadataValue : authors) {
                if (!StringUtils.equals((CharSequence)metadataValue.getValue(), (CharSequence)"plain text two")) continue;
                listToRemove.add(metadataValue);
            }
            this.context.turnOffAuthorisationSystem();
            this.itemService.removeMetadataValues(this.context, (DSpaceObject)publication1, listToRemove);
            this.itemService.update(this.context, (DSpaceObject)publication1);
            this.context.restoreAuthSystemState();
            list = this.itemService.getMetadata((DSpaceObject)publication1, "dc", "contributor", "author", "*");
            for (MetadataValue mdv : list) {
                if (!StringUtils.equals((CharSequence)mdv.getValue(), (CharSequence)"plain text")) continue;
                Assert.assertEquals((long)1L, (long)mdv.getPlace());
            }
            list = this.itemService.getMetadata((DSpaceObject)publication1, "dc", "contributor", "author", "*");
            for (MetadataValue mdv : list) {
                if (!StringUtils.equals((CharSequence)mdv.getValue(), (CharSequence)"plain text three")) continue;
                Assert.assertEquals((long)4L, (long)mdv.getPlace());
            }
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef1), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"leftPlace", (Matcher)Matchers.is((Object)0)));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef2), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"leftPlace", (Matcher)Matchers.is((Object)2)));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef3), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"leftPlace", (Matcher)Matchers.is((Object)3)));
        }
        finally {
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef1.get()));
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef2.get()));
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef3.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void deleteRelationshipsAndValidatePlace() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item publication1 = ItemBuilder.createItem((Context)this.context, (Collection)this.col2).withTitle("Publication1").withIssueDate("2015-01-01").build();
        Item author2 = ItemBuilder.createItem((Context)this.context, (Collection)this.col1).withTitle("Author2").withIssueDate("2016-02-13").withPersonIdentifierFirstName("Maria").withPersonIdentifierLastName("Smith").build();
        Item author3 = ItemBuilder.createItem((Context)this.context, (Collection)this.col1).withTitle("Author3").withIssueDate("2016-02-13").withPersonIdentifierFirstName("Maybe").withPersonIdentifierLastName("Maybe").build();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.context.restoreAuthSystemState();
        AtomicReference idRef1 = new AtomicReference();
        AtomicReference idRef2 = new AtomicReference();
        AtomicReference idRef3 = new AtomicReference();
        try {
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isAuthorOfPublicationRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + publication1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.author1.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef1.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef1), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"leftPlace", (Matcher)Matchers.is((Object)0)));
            this.context.turnOffAuthorisationSystem();
            publication1 = (Item)this.itemService.find(this.context, publication1.getID());
            this.itemService.addMetadata(this.context, (DSpaceObject)publication1, "dc", "contributor", "author", "*", "plain text");
            this.itemService.update(this.context, (DSpaceObject)publication1);
            this.context.restoreAuthSystemState();
            List list = this.itemService.getMetadata((DSpaceObject)publication1, "dc", "contributor", "author", "*");
            for (MetadataValue mdv : list) {
                if (!StringUtils.equals((CharSequence)mdv.getValue(), (CharSequence)"plain text")) continue;
                Assert.assertEquals((long)1L, (long)mdv.getPlace());
            }
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef1), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"leftPlace", (Matcher)Matchers.is((Object)0)));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isAuthorOfPublicationRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + publication1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + author2.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef2.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef2), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"leftPlace", (Matcher)Matchers.is((Object)2)));
            this.context.turnOffAuthorisationSystem();
            publication1 = (Item)this.itemService.find(this.context, publication1.getID());
            this.itemService.addMetadata(this.context, (DSpaceObject)publication1, "dc", "contributor", "author", "*", "plain text two");
            this.itemService.update(this.context, (DSpaceObject)publication1);
            this.context.restoreAuthSystemState();
            list = this.itemService.getMetadata((DSpaceObject)publication1, "dc", "contributor", "author", "*");
            for (MetadataValue mdv : list) {
                if (!StringUtils.equals((CharSequence)mdv.getValue(), (CharSequence)"plain text two")) continue;
                Assert.assertEquals((long)3L, (long)mdv.getPlace());
            }
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isAuthorOfPublicationRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + publication1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + author3.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef3.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef3), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"leftPlace", (Matcher)Matchers.is((Object)4)));
            this.context.turnOffAuthorisationSystem();
            publication1 = (Item)this.itemService.find(this.context, publication1.getID());
            this.itemService.addMetadata(this.context, (DSpaceObject)publication1, "dc", "contributor", "author", "*", "plain text three");
            this.itemService.update(this.context, (DSpaceObject)publication1);
            this.context.restoreAuthSystemState();
            list = this.itemService.getMetadata((DSpaceObject)publication1, "dc", "contributor", "author", "*");
            for (MetadataValue mdv : list) {
                if (!StringUtils.equals((CharSequence)mdv.getValue(), (CharSequence)"plain text three")) continue;
                Assert.assertEquals((long)5L, (long)mdv.getPlace());
            }
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/relationships/" + idRef2), (Object[])new Object[0]));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef1), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"leftPlace", (Matcher)Matchers.is((Object)0)));
            publication1 = (Item)this.itemService.find(this.context, publication1.getID());
            list = this.itemService.getMetadata((DSpaceObject)publication1, "dc", "contributor", "author", "*");
            for (MetadataValue mdv : list) {
                if (!StringUtils.equals((CharSequence)mdv.getValue(), (CharSequence)"plain text")) continue;
                Assert.assertEquals((long)1L, (long)mdv.getPlace());
            }
            list = this.itemService.getMetadata((DSpaceObject)publication1, "dc", "contributor", "author", "*");
            for (MetadataValue mdv : list) {
                if (!StringUtils.equals((CharSequence)mdv.getValue(), (CharSequence)"plain text two")) continue;
                Assert.assertEquals((long)2L, (long)mdv.getPlace());
            }
            list = this.itemService.getMetadata((DSpaceObject)publication1, "dc", "contributor", "author", "*");
            for (MetadataValue mdv : list) {
                if (!StringUtils.equals((CharSequence)mdv.getValue(), (CharSequence)"plain text three")) continue;
                Assert.assertEquals((long)4L, (long)mdv.getPlace());
            }
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef3), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"leftPlace", (Matcher)Matchers.is((Object)3)));
        }
        finally {
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef1.get()));
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef2.get()));
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef3.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void deleteRelationship() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item author2 = ItemBuilder.createItem((Context)this.context, (Collection)this.col1).withTitle("Author2").withIssueDate("2016-02-13").withPersonIdentifierFirstName("Maria").withPersonIdentifierLastName("Smith").build();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.context.restoreAuthSystemState();
        AtomicReference idRef1 = new AtomicReference();
        AtomicReference idRef2 = new AtomicReference();
        try {
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isAuthorOfPublicationRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/spring-rest/api/core/items/" + this.publication1.getID() + "\nhttps://localhost:8080/spring-rest/api/core/items/" + this.author1.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef1.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.publication1.getID() + "/relationships"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"page.totalElements", (Matcher)Matchers.is((Object)1)));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.author1.getID() + "/relationships"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"page.totalElements", (Matcher)Matchers.is((Object)1)));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + author2.getID() + "/relationships"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"page.totalElements", (Matcher)Matchers.is((Object)0)));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isAuthorOfPublicationRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/spring-rest/api/core/items/" + this.publication1.getID() + "\nhttps://localhost:8080/spring-rest/api/core/items/" + author2.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef2.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.publication1.getID() + "/relationships"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"page.totalElements", (Matcher)Matchers.is((Object)2)));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.author1.getID() + "/relationships"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"page.totalElements", (Matcher)Matchers.is((Object)1)));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + author2.getID() + "/relationships"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"page.totalElements", (Matcher)Matchers.is((Object)1)));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/relationships/" + idRef1), (Object[])new Object[0]));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.publication1.getID() + "/relationships"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"page.totalElements", (Matcher)Matchers.is((Object)1)));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.author1.getID() + "/relationships"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"page.totalElements", (Matcher)Matchers.is((Object)0)));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + author2.getID() + "/relationships"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"page.totalElements", (Matcher)Matchers.is((Object)1)));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/relationships/" + idRef2), (Object[])new Object[0]));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.publication1.getID() + "/relationships"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"page.totalElements", (Matcher)Matchers.is((Object)0)));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.author1.getID() + "/relationships"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"page.totalElements", (Matcher)Matchers.is((Object)0)));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + author2.getID() + "/relationships"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"page.totalElements", (Matcher)Matchers.is((Object)0)));
        }
        finally {
            if (idRef1.get() != null) {
                RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef1.get()));
            }
            if (idRef2.get() != null) {
                RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef2.get()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addRelationshipsNotUseForPlace() throws Exception {
        AtomicReference idRef1 = new AtomicReference();
        AtomicReference idRef2 = new AtomicReference();
        AtomicReference idRef3 = new AtomicReference();
        try {
            String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isOrgUnitOfPersonRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.author1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.orgUnit1.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef1.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef1), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"rightPlace", (Matcher)Matchers.is((Object)0)));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isOrgUnitOfPersonRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.author2.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.orgUnit1.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef2.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef2), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"rightPlace", (Matcher)Matchers.is((Object)1)));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isOrgUnitOfPersonRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.author3.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.orgUnit1.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef3.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef3), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"rightPlace", (Matcher)Matchers.is((Object)2)));
        }
        finally {
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef1.get()));
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef2.get()));
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef3.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addAndDeleteRelationshipsNotUseForPlace() throws Exception {
        AtomicReference idRef1 = new AtomicReference();
        AtomicReference idRef2 = new AtomicReference();
        AtomicReference idRef3 = new AtomicReference();
        try {
            String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isOrgUnitOfPersonRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.author1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.orgUnit1.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef1.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef1), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"rightPlace", (Matcher)Matchers.is((Object)0)));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isOrgUnitOfPersonRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.author2.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.orgUnit1.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef2.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef2), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"rightPlace", (Matcher)Matchers.is((Object)1)));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isOrgUnitOfPersonRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.author3.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.orgUnit1.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef3.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef3), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"rightPlace", (Matcher)Matchers.is((Object)2)));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/relationships/" + idRef2), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef1), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"rightPlace", (Matcher)Matchers.is((Object)0)));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef3), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"rightPlace", (Matcher)Matchers.is((Object)1)));
        }
        finally {
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef1.get()));
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef2.get()));
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef3.get()));
        }
    }

    @Test
    public void putRelationshipAdminAccess() throws Exception {
        AtomicReference idRef1 = new AtomicReference();
        try {
            String token = this.getAuthToken(this.admin.getEmail(), this.password);
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isAuthorOfPublicationRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.publication1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.author1.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef1.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/relationships/" + idRef1 + "/leftItem"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.publication2.getID())).andExpect(MockMvcResultMatchers.status().isOk());
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef1), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.leftItem.href", (Matcher)Matchers.containsString((String)this.publication2.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.rightItem.href", (Matcher)Matchers.containsString((String)this.author1.getID().toString())));
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/relationships/" + idRef1 + "/rightItem"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.author2.getID())).andExpect(MockMvcResultMatchers.status().isOk());
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef1), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.rightItem.href", (Matcher)Matchers.containsString((String)this.author2.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.leftItem.href", (Matcher)Matchers.containsString((String)this.publication2.getID().toString())));
        }
        finally {
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef1.get()));
        }
    }

    @Test
    public void putRelationshipWriteAccessOnAuthors() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.context.setCurrentUser(this.user1);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.author1, 1, this.user1);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.author2, 1, this.user1);
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        try {
            String token = this.getAuthToken(this.user1.getEmail(), this.password);
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isAuthorOfPublicationRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.publication1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.author1.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/relationships/" + idRef + "/rightItem"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.author2.getID())).andExpect(MockMvcResultMatchers.status().isOk());
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.rightItem.href", (Matcher)Matchers.containsString((String)this.author2.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.leftItem.href", (Matcher)Matchers.containsString((String)this.publication1.getID().toString())));
        }
        finally {
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef.get()));
        }
    }

    @Test
    public void putRelationshipWriteAccessOnPublication() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.context.setCurrentUser(this.user1);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.publication1, 1, this.user1);
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        try {
            String token = this.getAuthToken(this.user1.getEmail(), this.password);
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isAuthorOfPublicationRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.publication1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.author1.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/relationships/" + idRef + "/rightItem"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.author2.getID())).andExpect(MockMvcResultMatchers.status().isOk());
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.rightItem.href", (Matcher)Matchers.containsString((String)this.author2.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.leftItem.href", (Matcher)Matchers.containsString((String)this.publication1.getID().toString())));
        }
        finally {
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef.get()));
        }
    }

    @Test
    public void putRelationshipWriteAccessOnPublications() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.context.setCurrentUser(this.user1);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.publication1, 1, this.user1);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.publication2, 1, this.user1);
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        try {
            String token = this.getAuthToken(this.user1.getEmail(), this.password);
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isAuthorOfPublicationRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.publication1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.author1.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/relationships/" + idRef + "/leftItem"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.publication2.getID())).andExpect(MockMvcResultMatchers.status().isOk());
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.leftItem.href", (Matcher)Matchers.containsString((String)this.publication2.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.rightItem.href", (Matcher)Matchers.containsString((String)this.author1.getID().toString())));
        }
        finally {
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef.get()));
        }
    }

    @Test
    public void putRelationshipWriteAccessOnAuthor() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.context.setCurrentUser(this.user1);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.author1, 1, this.user1);
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        try {
            String token = this.getAuthToken(this.user1.getEmail(), this.password);
            this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isAuthorOfPublicationRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.publication1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.author1.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/relationships/" + idRef + "/leftItem"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.publication2.getID())).andExpect(MockMvcResultMatchers.status().isOk());
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.leftItem.href", (Matcher)Matchers.containsString((String)this.publication2.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.rightItem.href", (Matcher)Matchers.containsString((String)this.author1.getID().toString())));
        }
        finally {
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef.get()));
        }
    }

    @Test
    public void putRelationshipNoAccess() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.context.setCurrentUser(this.user1);
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        try {
            String token = this.getAuthToken(this.admin.getEmail(), this.password);
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isAuthorOfPublicationRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.publication1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.author1.getID())).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            token = this.getAuthToken(this.user1.getEmail(), this.password);
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/relationships/" + idRef + "/rightItem"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.author2.getID())).andExpect(MockMvcResultMatchers.status().isForbidden());
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.leftItem.href", (Matcher)Matchers.containsString((String)this.publication1.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.rightItem.href", (Matcher)Matchers.containsString((String)this.author1.getID().toString())));
        }
        finally {
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef.get()));
        }
    }

    @Test
    public void putRelationshipOnlyAccessOnOneAuthor() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.context.setCurrentUser(this.user1);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.author1, 1, this.user1);
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        try {
            String token = this.getAuthToken(this.admin.getEmail(), this.password);
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isAuthorOfPublicationRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.publication1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.author1.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            token = this.getAuthToken(this.user1.getEmail(), this.password);
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/relationships/" + idRef + "/rightItem"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.author2.getID())).andExpect(MockMvcResultMatchers.status().isForbidden());
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.leftItem.href", (Matcher)Matchers.containsString((String)this.publication1.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.rightItem.href", (Matcher)Matchers.containsString((String)this.author1.getID().toString())));
        }
        finally {
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef.get()));
        }
    }

    @Test
    public void putRelationshipOnlyAccessOnOnePublication() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.context.setCurrentUser(this.user1);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.publication1, 1, this.user1);
        String token = this.getAuthToken(this.user1.getEmail(), this.password);
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isAuthorOfPublicationRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.publication1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.author1.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/relationships/" + idRef + "/leftItem"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.publication2.getID())).andExpect(MockMvcResultMatchers.status().isForbidden());
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.leftItem.href", (Matcher)Matchers.containsString((String)this.publication1.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.rightItem.href", (Matcher)Matchers.containsString((String)this.author1.getID().toString())));
        }
        finally {
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef.get()));
        }
    }

    @Test
    public void findRelationshipByLabelTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        RelationshipType isOrgUnitOfPersonRelationshipType = this.relationshipTypeService.findbyTypesAndTypeName(this.context, this.entityTypeService.findByEntityType(this.context, "Person"), this.entityTypeService.findByEntityType(this.context, "OrgUnit"), "isOrgUnitOfPerson", "isPersonOfOrgUnit");
        RelationshipType isOrgUnitOfProjectRelationshipType = this.relationshipTypeService.findbyTypesAndTypeName(this.context, this.entityTypeService.findByEntityType(this.context, "Project"), this.entityTypeService.findByEntityType(this.context, "OrgUnit"), "isOrgUnitOfProject", "isProjectOfOrgUnit");
        RelationshipType isAuthorOfPublicationRelationshipType = this.relationshipTypeService.findbyTypesAndTypeName(this.context, this.entityTypeService.findByEntityType(this.context, "Publication"), this.entityTypeService.findByEntityType(this.context, "Person"), "isAuthorOfPublication", "isPublicationOfAuthor");
        Relationship relationship1 = RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.author1, (Item)this.orgUnit1, (RelationshipType)isOrgUnitOfPersonRelationshipType).build();
        Relationship relationshipOrgunitExtra = RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.author1, (Item)this.orgUnit2, (RelationshipType)isOrgUnitOfPersonRelationshipType).build();
        Relationship relationshipAuthorExtra = RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.author2, (Item)this.orgUnit1, (RelationshipType)isOrgUnitOfPersonRelationshipType).build();
        Relationship relationship2 = RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.project1, (Item)this.orgUnit1, (RelationshipType)isOrgUnitOfProjectRelationshipType).build();
        Relationship relationship3 = RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.publication1, (Item)this.author1, (RelationshipType)isAuthorOfPublicationRelationshipType).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/relationships/search/byLabel", (Object[])new Object[0]).param("label", new String[]{"isOrgUnitOfPerson"}).param("dso", new String[]{this.author1.getID().toString()}).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.relationships", (Matcher)Matchers.hasItem(RelationshipMatcher.matchRelationship(relationship1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.relationships[0]._links.rightItem.href", (Matcher)Matchers.containsString((String)this.orgUnit1.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.relationships[1]._links.rightItem.href", (Matcher)Matchers.containsString((String)this.orgUnit2.getID().toString())));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/relationships/search/byLabel", (Object[])new Object[0]).param("label", new String[]{"isOrgUnitOfPerson"}).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 3)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.relationships", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{RelationshipMatcher.matchRelationship(relationship1), RelationshipMatcher.matchRelationship(relationshipAuthorExtra), RelationshipMatcher.matchRelationship(relationshipOrgunitExtra)})));
    }

    @Test
    public void findRelationshipByLabelWithRelatedEntityTypeTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        RelationshipType isAuthorOfPublicationRelationshipTypePublication = this.relationshipTypeService.findbyTypesAndTypeName(this.context, this.entityTypeService.findByEntityType(this.context, "Publication"), this.entityTypeService.findByEntityType(this.context, "Person"), "isAuthorOfPublication", "isPublicationOfAuthor");
        RelationshipType isAuthorOfPublicationRelationshipTypeOrgUnit = this.relationshipTypeService.findbyTypesAndTypeName(this.context, this.entityTypeService.findByEntityType(this.context, "Publication"), this.entityTypeService.findByEntityType(this.context, "OrgUnit"), "isAuthorOfPublication", "isPublicationOfAuthor");
        Relationship relationship1 = RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.publication1, (Item)this.author1, (RelationshipType)isAuthorOfPublicationRelationshipTypePublication).build();
        Relationship relationship2 = RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.publication1, (Item)this.orgUnit1, (RelationshipType)isAuthorOfPublicationRelationshipTypeOrgUnit).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/relationships/search/byLabel", (Object[])new Object[0]).param("label", new String[]{"isAuthorOfPublication"}).param("dso", new String[]{this.publication1.getID().toString()}).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.relationships", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{RelationshipMatcher.matchRelationship(relationship1), RelationshipMatcher.matchRelationship(relationship2)})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/relationships/search/byLabel", (Object[])new Object[0]).param("label", new String[]{"isAuthorOfPublication"}).param("dso", new String[]{this.publication1.getID().toString()}).param("relatedEntityType", new String[]{"Person"}).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.relationships", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{RelationshipMatcher.matchRelationship(relationship1)})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/relationships/search/byLabel", (Object[])new Object[0]).param("label", new String[]{"isAuthorOfPublication"}).param("dso", new String[]{this.publication1.getID().toString()}).param("relatedEntityType", new String[]{"OrgUnit"}).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.relationships", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{RelationshipMatcher.matchRelationship(relationship2)})));
    }

    @Test
    public void putRelationshipWithNonexistentID() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.context.restoreAuthSystemState();
        int nonexistentRelationshipID = 404404404;
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/relationships/" + nonexistentRelationshipID + "/leftItem"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.publication1.getID())).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void putRelationshipWithInvalidItemIDInBody() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isAuthorOfPublicationRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.publication1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.author1.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            int nonexistentItemID = 404404404;
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/relationships/" + idRef + "/leftItem"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + nonexistentItemID)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        }
        finally {
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef.get()));
        }
    }

    @Test
    public void rightwardValueRelationshipTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        RelationshipType isAuthorOfPublicationRelationshipType = this.relationshipTypeService.findbyTypesAndTypeName(this.context, this.entityTypeService.findByEntityType(this.context, "Publication"), this.entityTypeService.findByEntityType(this.context, "Person"), "isAuthorOfPublication", "isPublicationOfAuthor");
        Relationship relationship3 = RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.publication1, (Item)this.author1, (RelationshipType)isAuthorOfPublicationRelationshipType).withRightwardValue("RightwardValueTest").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/relationships", (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.relationships", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{RelationshipMatcher.matchRelationship(relationship3)})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.publication1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.contributor.author", "RightwardValueTest"), MetadataMatcher.matchMetadata("dc.title", "Publication1"))));
    }

    @Test
    public void nonRightwardValueRelationshipTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        RelationshipType isAuthorOfPublicationRelationshipType = this.relationshipTypeService.findbyTypesAndTypeName(this.context, this.entityTypeService.findByEntityType(this.context, "Publication"), this.entityTypeService.findByEntityType(this.context, "Person"), "isAuthorOfPublication", "isPublicationOfAuthor");
        Relationship relationship3 = RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.publication1, (Item)this.author3, (RelationshipType)isAuthorOfPublicationRelationshipType).withLeftPlace(1).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/relationships", (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.relationships", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{RelationshipMatcher.matchRelationship(relationship3)})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.publication1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.contributor.author", "Maybe, Maybe"), MetadataMatcher.matchMetadata("dc.contributor.author", "Testy, TEst"), MetadataMatcher.matchMetadata("dc.title", "Publication1"))));
    }

    @Test
    public void mixedRightwardValueAndRegularRelationshipTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        RelationshipType isAuthorOfPublicationRelationshipType = this.relationshipTypeService.findbyTypesAndTypeName(this.context, this.entityTypeService.findByEntityType(this.context, "Publication"), this.entityTypeService.findByEntityType(this.context, "Person"), "isAuthorOfPublication", "isPublicationOfAuthor");
        Item author1 = ItemBuilder.createItem((Context)this.context, (Collection)this.col1).withTitle("Author1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withPersonIdentifierFirstName("testingFirstName").withPersonIdentifierLastName("testingLastName").build();
        Relationship relationship3 = RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.publication1, (Item)this.author3, (RelationshipType)isAuthorOfPublicationRelationshipType).withLeftPlace(1).build();
        Relationship relationship2 = RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.publication1, (Item)author1, (RelationshipType)isAuthorOfPublicationRelationshipType).withRightwardValue("TestingRightwardValue").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/relationships", (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.relationships", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{RelationshipMatcher.matchRelationship(relationship3), RelationshipMatcher.matchRelationship(relationship2)})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.publication1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.contributor.author", "Maybe, Maybe"), MetadataMatcher.matchMetadata("dc.contributor.author", "Testy, TEst"), MetadataMatcher.matchMetadata("dc.contributor.author", "TestingRightwardValue"), (Matcher)Matchers.not(MetadataMatcher.matchMetadata("dc.contributor.author", "testingLastName, testingFirstName")), MetadataMatcher.matchMetadata("dc.title", "Publication1"))));
    }

    @Test
    public void leftwardValueRelationshipTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        RelationshipType isAuthorOfPublicationRelationshipType = this.relationshipTypeService.findbyTypesAndTypeName(this.context, this.entityTypeService.findByEntityType(this.context, "Publication"), this.entityTypeService.findByEntityType(this.context, "Person"), "isAuthorOfPublication", "isPublicationOfAuthor");
        Relationship relationship3 = RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.publication1, (Item)this.author3, (RelationshipType)isAuthorOfPublicationRelationshipType).withLeftwardValue("leftwardValue").withLeftPlace(1).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/relationships", (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.relationships", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{RelationshipMatcher.matchRelationship(relationship3)})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.publication1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.contributor.author", "Maybe, Maybe"), MetadataMatcher.matchMetadata("dc.contributor.author", "Testy, TEst"), MetadataMatcher.matchMetadata("dc.title", "Publication1"))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void putRelationshipWithJson() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        Integer idRef = null;
        try {
            MvcResult mvcResult = this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isAuthorOfPublicationRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.publication1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.author1.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andReturn();
            ObjectMapper mapper = new ObjectMapper();
            String content = mvcResult.getResponse().getContentAsString();
            Map map = (Map)mapper.readValue(content, Map.class);
            String id = String.valueOf(map.get("id"));
            idRef = Integer.parseInt(id);
            RelationshipRest relationshipRest = new RelationshipRest();
            relationshipRest.setLeftPlace(0);
            relationshipRest.setRightPlace(1);
            relationshipRest.setLeftwardValue(null);
            relationshipRest.setRightwardValue(null);
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/relationships/" + idRef), (Object[])new Object[0]).contentType(this.contentType).content(mapper.writeValueAsBytes((Object)relationshipRest))).andExpect(MockMvcResultMatchers.status().isOk());
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.leftPlace", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rightPlace", (Matcher)Matchers.is((Object)1)));
        }
        catch (Throwable throwable) {
            RelationshipBuilder.deleteRelationship(idRef);
            throw throwable;
        }
        RelationshipBuilder.deleteRelationship((Integer)idRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void putRelationshipWithJsonMoveInFrontOtherMetadata() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        Integer idRef = null;
        Integer idRef2 = null;
        try {
            MvcResult mvcResult = this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isAuthorOfPublicationRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.publication1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.author1.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andReturn();
            ObjectMapper mapper = new ObjectMapper();
            String content = mvcResult.getResponse().getContentAsString();
            Map map = (Map)mapper.readValue(content, Map.class);
            String id = String.valueOf(map.get("id"));
            idRef = Integer.parseInt(id);
            ArrayList<Operation> ops = new ArrayList<Operation>();
            ops.add((Operation)new AddOperation("/metadata/dc.contributor.author/-", (Object)"Metadata, First"));
            ops.add((Operation)new AddOperation("/metadata/dc.contributor.author/-", (Object)"Metadata, Second"));
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + this.publication1.getID()), (Object[])new Object[0]).content(this.getPatchContent(ops)).contentType("application/json-patch+json"));
            mvcResult = this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isAuthorOfPublicationRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.publication1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.author2.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andReturn();
            content = mvcResult.getResponse().getContentAsString();
            map = (Map)mapper.readValue(content, Map.class);
            id = String.valueOf(map.get("id"));
            idRef2 = Integer.parseInt(id);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.publication1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.contributor.author", "Testy, TEst", 0), MetadataMatcher.matchMetadata("dc.contributor.author", "Smith, Donald", 1), MetadataMatcher.matchMetadata("dc.contributor.author", "Metadata, First", 2), MetadataMatcher.matchMetadata("dc.contributor.author", "Metadata, Second", 3), MetadataMatcher.matchMetadata("dc.contributor.author", "Smith, Maria", 4))));
            RelationshipRest relationshipRest = new RelationshipRest();
            relationshipRest.setLeftPlace(0);
            relationshipRest.setRightPlace(1);
            relationshipRest.setLeftwardValue(null);
            relationshipRest.setRightwardValue(null);
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/relationships/" + idRef2), (Object[])new Object[0]).contentType(this.contentType).content(mapper.writeValueAsBytes((Object)relationshipRest))).andExpect(MockMvcResultMatchers.status().isOk());
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + idRef2), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.leftPlace", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rightPlace", (Matcher)Matchers.is((Object)1)));
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.publication1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.contributor.author", "Smith, Maria", 0), MetadataMatcher.matchMetadata("dc.contributor.author", "Testy, TEst", 1), MetadataMatcher.matchMetadata("dc.contributor.author", "Smith, Donald", 2), MetadataMatcher.matchMetadata("dc.contributor.author", "Metadata, First", 3), MetadataMatcher.matchMetadata("dc.contributor.author", "Metadata, Second", 4))));
        }
        catch (Throwable throwable) {
            RelationshipBuilder.deleteRelationship(idRef);
            RelationshipBuilder.deleteRelationship(idRef2);
            throw throwable;
        }
        RelationshipBuilder.deleteRelationship((Integer)idRef);
        RelationshipBuilder.deleteRelationship((Integer)idRef2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void orgUnitAndOrgUnitRelationshipVirtualMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EntityType orgUnit = this.entityTypeService.findByEntityType(this.context, "OrgUnit");
        RelationshipType isParentOrgUnitOf = this.relationshipTypeService.findbyTypesAndTypeName(this.context, orgUnit, orgUnit, "isParentOrgUnitOf", "isChildOrgUnitOf");
        MetadataSchema metadataSchema = this.metadataSchemaService.find(this.context, "relation");
        MetadataFieldBuilder.createMetadataField((Context)this.context, (MetadataSchema)metadataSchema, (String)"isParentOrgUnitOf", null, null).build();
        MetadataFieldBuilder.createMetadataField((Context)this.context, (MetadataSchema)metadataSchema, (String)"isChildOrgUnitOf", null, null).build();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{isParentOrgUnitOf.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.orgUnit1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.orgUnit2.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.itemService.getMetadata(this.orgUnit1, "*", "*", "*", "*", true);
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.orgUnit1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata['relation.isParentOrgUnitOf'][0].value", (Matcher)Matchers.is((Object)String.valueOf(this.orgUnit2.getID()))));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.orgUnit2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata['relation.isChildOrgUnitOf'][0].value", (Matcher)Matchers.is((Object)String.valueOf(this.orgUnit1.getID()))));
        }
        finally {
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void orgUnitFindByLabelParentChildOfCountTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EntityType orgUnit = this.entityTypeService.findByEntityType(this.context, "OrgUnit");
        RelationshipType isParentOrgUnitOf = this.relationshipTypeService.findbyTypesAndTypeName(this.context, orgUnit, orgUnit, "isParentOrgUnitOf", "isChildOrgUnitOf");
        MetadataSchema metadataSchema = this.metadataSchemaService.find(this.context, "relation");
        MetadataFieldBuilder.createMetadataField((Context)this.context, (MetadataSchema)metadataSchema, (String)"isParentOrgUnitOf", null, null).build();
        MetadataFieldBuilder.createMetadataField((Context)this.context, (MetadataSchema)metadataSchema, (String)"isChildOrgUnitOf", null, null).build();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        AtomicReference idRef2 = new AtomicReference();
        try {
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{isParentOrgUnitOf.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.orgUnit1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.orgUnit2.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{isParentOrgUnitOf.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.orgUnit2.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.orgUnit3.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef2.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/relationships/search/byLabel", (Object[])new Object[0]).param("label", new String[]{"isChildOrgUnitOf"}).param("dso", new String[]{String.valueOf(this.orgUnit2.getID())}).param("page", new String[]{"0"}).param("size", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", PageMatcher.pageEntryWithTotalPagesAndElements(0, 1, 1, 1)));
        }
        finally {
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef.get()));
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef2.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void orgUnitLeftMaxCardinalityTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EntityType orgUnit = this.entityTypeService.findByEntityType(this.context, "OrgUnit");
        RelationshipType isParentOrgUnitOf = this.relationshipTypeService.findbyTypesAndTypeName(this.context, orgUnit, orgUnit, "isParentOrgUnitOf", "isChildOrgUnitOf");
        MetadataSchema metadataSchema = this.metadataSchemaService.find(this.context, "relation");
        MetadataFieldBuilder.createMetadataField((Context)this.context, (MetadataSchema)metadataSchema, (String)"isParentOrgUnitOf", null, null).build();
        MetadataFieldBuilder.createMetadataField((Context)this.context, (MetadataSchema)metadataSchema, (String)"isChildOrgUnitOf", null, null).build();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{isParentOrgUnitOf.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.orgUnit1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.orgUnit2.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{isParentOrgUnitOf.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.orgUnit1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.orgUnit3.getID())).andExpect(MockMvcResultMatchers.status().isBadRequest());
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/relationships/search/byLabel", (Object[])new Object[0]).param("label", new String[]{"isParentOrgUnitOf"}).param("dso", new String[]{String.valueOf(this.orgUnit1.getID())}).param("page", new String[]{"0"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 1)));
        }
        finally {
            RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef.get()));
        }
    }

    @Test
    public void testVirtualMdInRESTAndSolrDoc() throws Exception {
        String journalTitleVirtualMdField;
        MetadataField journalTitleField;
        RelationshipType isIssueOfJournalVolume;
        RelationshipType isPublicationOfJournalIssue;
        EntityType publicationEntityType;
        EntityType journalIssueEntityType;
        EntityType journalVolumeEntityType;
        this.context.turnOffAuthorisationSystem();
        EntityType journalEntityType = this.entityTypeService.findByEntityType(this.context, "Journal");
        if (journalEntityType == null) {
            journalEntityType = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Journal").build();
        }
        if ((journalVolumeEntityType = this.entityTypeService.findByEntityType(this.context, "JournalVolume")) == null) {
            journalVolumeEntityType = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"JournalVolume").build();
        }
        if ((journalIssueEntityType = this.entityTypeService.findByEntityType(this.context, "JournalIssue")) == null) {
            journalIssueEntityType = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"JournalIssue").build();
        }
        if ((publicationEntityType = this.entityTypeService.findByEntityType(this.context, "Publication")) == null) {
            publicationEntityType = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Publication").build();
        }
        if ((isPublicationOfJournalIssue = this.relationshipTypeService.findbyTypesAndTypeName(this.context, journalIssueEntityType, publicationEntityType, "isPublicationOfJournalIssue", "isJournalIssueOfPublication")) == null) {
            isPublicationOfJournalIssue = RelationshipTypeBuilder.createRelationshipTypeBuilder((Context)this.context, (EntityType)journalIssueEntityType, (EntityType)publicationEntityType, (String)"isPublicationOfJournalIssue", (String)"isJournalIssueOfPublication", null, null, null, null).build();
        }
        if ((isIssueOfJournalVolume = this.relationshipTypeService.findbyTypesAndTypeName(this.context, journalVolumeEntityType, journalIssueEntityType, "isIssueOfJournalVolume", "isJournalVolumeOfIssue")) == null) {
            isIssueOfJournalVolume = RelationshipTypeBuilder.createRelationshipTypeBuilder((Context)this.context, (EntityType)journalVolumeEntityType, (EntityType)journalIssueEntityType, (String)"isIssueOfJournalVolume", (String)"isJournalVolumeOfIssue", null, null, null, null).build();
        } else {
            isIssueOfJournalVolume.setRightMinCardinality(Integer.valueOf(0));
        }
        RelationshipType isVolumeOfJournal = this.relationshipTypeService.findbyTypesAndTypeName(this.context, journalEntityType, journalVolumeEntityType, "isVolumeOfJournal", "isJournalOfVolume");
        if (isVolumeOfJournal == null) {
            isVolumeOfJournal = RelationshipTypeBuilder.createRelationshipTypeBuilder((Context)this.context, (EntityType)journalEntityType, (EntityType)journalVolumeEntityType, (String)"isVolumeOfJournal", (String)"isJournalOfVolume", null, null, null, null).build();
        } else {
            isVolumeOfJournal.setRightMinCardinality(Integer.valueOf(0));
        }
        MetadataSchema journalSchema = this.metadataSchemaService.find(this.context, "journal");
        if (journalSchema == null) {
            journalSchema = this.metadataSchemaService.create(this.context, "journal", "journal");
        }
        if ((journalTitleField = this.metadataFieldService.findByString(this.context, journalTitleVirtualMdField = "journal.title", '.')) == null) {
            this.metadataFieldService.create(this.context, journalSchema, "title", null, "Journal Title");
        }
        String journalTitle = "Journal Title Test";
        Item journal = ItemBuilder.createItem((Context)this.context, (Collection)this.col5).withTitle(journalTitle).build();
        Item journalVolume = ItemBuilder.createItem((Context)this.context, (Collection)this.col6).withTitle("JournalVolume").build();
        Item journalIssue = ItemBuilder.createItem((Context)this.context, (Collection)this.col7).withTitle("JournalIssue").build();
        Item publication = ItemBuilder.createItem((Context)this.context, (Collection)this.col2).withTitle("Publication").build();
        RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)journalIssue, (Item)publication, (RelationshipType)isPublicationOfJournalIssue).build();
        RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)journalVolume, (Item)journalIssue, (RelationshipType)isIssueOfJournalVolume).build();
        this.mockSolrSearchCore.getSolr().commit(false, false);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publication.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$.metadata." + journalTitleVirtualMdField), (Object[])new Object[0]).doesNotExist());
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setQuery("search.resourceid:" + publication.getID());
        QueryResponse queryResponse = this.mockSolrSearchCore.getSolr().query((SolrParams)solrQuery);
        MatcherAssert.assertThat((Object)queryResponse.getResults().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertNull((Object)((SolrDocument)queryResponse.getResults().get(0)).getFieldValues(journalTitleVirtualMdField));
        RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)journal, (Item)journalVolume, (RelationshipType)isVolumeOfJournal).build();
        this.mockSolrSearchCore.getSolr().commit(false, false);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publication.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{MetadataMatcher.matchMetadata(journalTitleVirtualMdField, journalTitle)})));
        queryResponse = this.mockSolrSearchCore.getSolr().query((SolrParams)solrQuery);
        MatcherAssert.assertThat((Object)queryResponse.getResults().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertEquals((Object)journalTitle, ((List)((SolrDocument)queryResponse.getResults().get(0)).getFieldValues(journalTitleVirtualMdField)).get(0));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + journalVolume.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{MetadataMatcher.matchMetadata(journalTitleVirtualMdField, journalTitle)})));
        solrQuery.setQuery("search.resourceid:" + journalVolume.getID());
        queryResponse = this.mockSolrSearchCore.getSolr().query((SolrParams)solrQuery);
        MatcherAssert.assertThat((Object)queryResponse.getResults().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertEquals((Object)journalTitle, ((List)((SolrDocument)queryResponse.getResults().get(0)).getFieldValues(journalTitleVirtualMdField)).get(0));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + journalIssue.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{MetadataMatcher.matchMetadata(journalTitleVirtualMdField, journalTitle)})));
        solrQuery.setQuery("search.resourceid:" + journalIssue.getID());
        queryResponse = this.mockSolrSearchCore.getSolr().query((SolrParams)solrQuery);
        MatcherAssert.assertThat((Object)queryResponse.getResults().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertEquals((Object)journalTitle, ((List)((SolrDocument)queryResponse.getResults().get(0)).getFieldValues(journalTitleVirtualMdField)).get(0));
        this.context.restoreAuthSystemState();
    }

    @Test
    public void findOneTestWrongUUID() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/relationships/1000", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void testIsAuthorOfPublicationRelationshipMetadataViaREST() throws Exception {
        this.context.turnOffAuthorisationSystem();
        RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.publication1, (Item)this.author1, (RelationshipType)this.isAuthorOfPublicationRelationshipType).build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/items/{uuid}", (Object[])new Object[]{this.author1.getID()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadata(String.format("%s.isPublicationOfAuthor", MetadataSchemaEnum.RELATION.getName()), this.publication1.getID().toString())));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/items/{uuid}", (Object[])new Object[]{this.publication1.getID()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadata(String.format("%s.isAuthorOfPublication", MetadataSchemaEnum.RELATION.getName()), this.author1.getID().toString())));
    }

    @Test
    public void testIsOrgUnitOfPersonRelationshipMetadataViaREST() throws Exception {
        this.context.turnOffAuthorisationSystem();
        RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.author1, (Item)this.orgUnit1, (RelationshipType)this.isOrgUnitOfPersonRelationshipType).build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/items/{uuid}", (Object[])new Object[]{this.author1.getID()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadata(String.format("%s.isOrgUnitOfPerson", MetadataSchemaEnum.RELATION.getName()), this.orgUnit1.getID().toString())));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/items/{uuid}", (Object[])new Object[]{this.orgUnit1.getID()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadata(String.format("%s.isPersonOfOrgUnit", MetadataSchemaEnum.RELATION.getName()), this.author1.getID().toString())));
    }

    @Test
    public void findByItemsAndTypeTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        RelationshipType isAuthorOfPublicationRelationshipType = this.relationshipTypeService.findbyTypesAndTypeName(this.context, this.entityTypeService.findByEntityType(this.context, "Publication"), this.entityTypeService.findByEntityType(this.context, "Person"), "isAuthorOfPublication", "isPublicationOfAuthor");
        Relationship relationship1 = RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.publication1, (Item)this.author3, (RelationshipType)isAuthorOfPublicationRelationshipType).withLeftPlace(1).build();
        Relationship relationship2 = RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.publication1, (Item)this.author1, (RelationshipType)isAuthorOfPublicationRelationshipType).withLeftPlace(1).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/relationships/search/byItemsAndType", (Object[])new Object[0]).param("typeId", new String[]{isAuthorOfPublicationRelationshipType.getID().toString()}).param("relationshipLabel", new String[]{"isAuthorOfPublication"}).param("focusItem", new String[]{this.publication1.getID().toString()}).param("relatedItem", new String[]{this.author1.getID().toString(), this.author2.getID().toString(), this.author3.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.relationships", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{RelationshipMatcher.matchRelationshipValues(relationship1), RelationshipMatcher.matchRelationshipValues(relationship2)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/relationships/search/byItemsAndType", (Object[])new Object[0]).param("typeId", new String[]{isAuthorOfPublicationRelationshipType.getID().toString()}).param("relationshipLabel", new String[]{"isPublicationOfAuthor"}).param("focusItem", new String[]{this.author1.getID().toString()}).param("relatedItem", new String[]{this.publication1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.relationships", (Matcher)Matchers.contains(RelationshipMatcher.matchRelationshipValues(relationship2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void findByItemsAndTypeBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        RelationshipType isAuthorOfPublicationRelationshipType = this.relationshipTypeService.findbyTypesAndTypeName(this.context, this.entityTypeService.findByEntityType(this.context, "Publication"), this.entityTypeService.findByEntityType(this.context, "Person"), "isAuthorOfPublication", "isPublicationOfAuthor");
        RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.publication1, (Item)this.author3, (RelationshipType)isAuthorOfPublicationRelationshipType).withLeftPlace(1).build();
        RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.publication1, (Item)this.author1, (RelationshipType)isAuthorOfPublicationRelationshipType).withLeftPlace(1).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/relationships/search/byItemsAndType", (Object[])new Object[0]).param("typeId", new String[]{"1"}).param("focusItem", new String[]{this.publication1.getID().toString()}).param("relatedItem", new String[]{this.author1.getID().toString(), this.author2.getID().toString(), this.author3.getID().toString()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/relationships/search/byItemsAndType", (Object[])new Object[0]).param("relationshipLabel", new String[]{"isAuthorOfPublication"}).param("focusItem", new String[]{this.publication1.getID().toString()}).param("relatedItem", new String[]{this.author1.getID().toString(), this.author2.getID().toString(), this.author3.getID().toString()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/relationships/search/byItemsAndType", (Object[])new Object[0]).param("typeId", new String[]{"1"}).param("relationshipLabel", new String[]{"isAuthorOfPublication"}).param("relatedItem", new String[]{this.author1.getID().toString(), this.author2.getID().toString(), this.author3.getID().toString()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/relationships/search/byItemsAndType", (Object[])new Object[0]).param("typeId", new String[]{"1"}).param("relationshipLabel", new String[]{"isAuthorOfPublication"}).param("focusItem", new String[]{this.publication1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void findByItemsAndTypeUnprocessableEntityTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        RelationshipType isAuthorOfPublicationRelationshipType = this.relationshipTypeService.findbyTypesAndTypeName(this.context, this.entityTypeService.findByEntityType(this.context, "Publication"), this.entityTypeService.findByEntityType(this.context, "Person"), "isAuthorOfPublication", "isPublicationOfAuthor");
        RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.publication1, (Item)this.author3, (RelationshipType)isAuthorOfPublicationRelationshipType).withLeftPlace(1).build();
        RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.publication1, (Item)this.author1, (RelationshipType)isAuthorOfPublicationRelationshipType).withLeftPlace(1).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/relationships/search/byItemsAndType", (Object[])new Object[0]).param("typeId", new String[]{isAuthorOfPublicationRelationshipType.getID().toString()}).param("relationshipLabel", new String[]{"wrongLabel"}).param("focusItem", new String[]{this.orgUnit1.getID().toString()}).param("relatedItem", new String[]{this.author1.getID().toString(), this.author2.getID().toString(), this.author3.getID().toString()})).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void findByItemsAndTypeEmptyResponceTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        RelationshipType isAuthorOfPublicationRelationshipType = this.relationshipTypeService.findbyTypesAndTypeName(this.context, this.entityTypeService.findByEntityType(this.context, "Publication"), this.entityTypeService.findByEntityType(this.context, "Person"), "isAuthorOfPublication", "isPublicationOfAuthor");
        RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.publication1, (Item)this.author3, (RelationshipType)isAuthorOfPublicationRelationshipType).withLeftPlace(1).build();
        RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.publication1, (Item)this.author1, (RelationshipType)isAuthorOfPublicationRelationshipType).withLeftPlace(1).build();
        this.context.restoreAuthSystemState();
        Integer typeId = Integer.MAX_VALUE;
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/relationships/search/byItemsAndType", (Object[])new Object[0]).param("typeId", new String[]{typeId.toString()}).param("relationshipLabel", new String[]{"isAuthorOfPublication"}).param("focusItem", new String[]{this.publication1.getID().toString()}).param("relatedItem", new String[]{this.author1.getID().toString(), this.author2.getID().toString(), this.author3.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.relationships", (Object[])new Object[0]).doesNotExist());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/relationships/search/byItemsAndType", (Object[])new Object[0]).param("typeId", new String[]{isAuthorOfPublicationRelationshipType.getID().toString()}).param("relationshipLabel", new String[]{"isAuthorOfPublication"}).param("focusItem", new String[]{UUID.randomUUID().toString()}).param("relatedItem", new String[]{this.author1.getID().toString(), this.author2.getID().toString(), this.author3.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.relationships", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void findByItemsAndTypePaginationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        RelationshipType isAuthorOfPublicationRelationshipType = this.relationshipTypeService.findbyTypesAndTypeName(this.context, this.entityTypeService.findByEntityType(this.context, "Publication"), this.entityTypeService.findByEntityType(this.context, "Person"), "isAuthorOfPublication", "isPublicationOfAuthor");
        Relationship relationship1 = RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.publication1, (Item)this.author3, (RelationshipType)isAuthorOfPublicationRelationshipType).withLeftPlace(2).build();
        Relationship relationship2 = RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.publication1, (Item)this.author1, (RelationshipType)isAuthorOfPublicationRelationshipType).withLeftPlace(2).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/relationships/search/byItemsAndType", (Object[])new Object[0]).param("typeId", new String[]{isAuthorOfPublicationRelationshipType.getID().toString()}).param("relationshipLabel", new String[]{"isAuthorOfPublication"}).param("focusItem", new String[]{this.publication1.getID().toString()}).param("size", new String[]{"1"}).param("relatedItem", new String[]{this.author1.getID().toString(), this.author2.getID().toString(), this.author3.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.relationships", (Matcher)Matchers.contains(RelationshipMatcher.matchRelationshipValues(relationship1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/relationships/search/byItemsAndType", (Object[])new Object[0]).param("typeId", new String[]{isAuthorOfPublicationRelationshipType.getID().toString()}).param("relationshipLabel", new String[]{"isAuthorOfPublication"}).param("focusItem", new String[]{this.publication1.getID().toString()}).param("page", new String[]{"1"}).param("size", new String[]{"1"}).param("relatedItem", new String[]{this.author1.getID().toString(), this.author2.getID().toString(), this.author3.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.relationships", (Matcher)Matchers.contains(RelationshipMatcher.matchRelationshipValues(relationship2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/relationships/search/byItemsAndType", (Object[])new Object[0]).param("typeId", new String[]{isAuthorOfPublicationRelationshipType.getID().toString()}).param("relationshipLabel", new String[]{"isAuthorOfPublication"}).param("focusItem", new String[]{this.publication1.getID().toString()}).param("page", new String[]{"5"}).param("relatedItem", new String[]{this.author1.getID().toString(), this.author2.getID().toString(), this.author3.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.relationships", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)5))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
    }

    @Test
    public void findTheCreatedRelationshipTypeTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship relationship = RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.author1, (Item)this.orgUnit1, (RelationshipType)this.isOrgUnitOfPersonRelationshipType).build();
        this.context.restoreAuthSystemState();
        Integer relationshipId = relationship.getID();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + relationshipId), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)relationship.getID()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.relationships", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.relationshipType.href", (Matcher)Matchers.containsString((String)("/api/core/relationships/" + relationshipId + "/relationshipType"))));
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + relationshipId + "/relationshipType"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }
}

