/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class SitemapRestControllerIT
extends AbstractControllerIntegrationTest {
    @Autowired
    ConfigurationService configurationService;
    @Autowired
    ResourcePolicyService policyService;
    private static final String SITEMAPS_ENDPOINT = "sitemaps";
    private Item item1;
    private Item item2;
    private Item itemRestricted;
    private Item itemUndiscoverable;
    private Item entityPublication;
    private Item entityPublicationRestricted;
    private Item entityPublicationUndiscoverable;
    private Community community;
    private Community communityRestricted;
    private Collection collection;
    private Collection collectionRestricted;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.configurationService.setProperty("sitemap.path", (Object)SITEMAPS_ENDPOINT);
        this.context.turnOffAuthorisationSystem();
        this.community = CommunityBuilder.createCommunity((Context)this.context).build();
        this.communityRestricted = CommunityBuilder.createCommunity((Context)this.context).build();
        this.policyService.removeAllPolicies(this.context, (DSpaceObject)this.communityRestricted);
        this.collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.community).build();
        this.collectionRestricted = CollectionBuilder.createCollection((Context)this.context, (Community)this.community).build();
        Collection publicationCollection = CollectionBuilder.createCollection((Context)this.context, (Community)this.community).withEntityType("Publication").withName("Publication Collection").build();
        this.policyService.removeAllPolicies(this.context, (DSpaceObject)this.collectionRestricted);
        this.item1 = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("Test 1").withIssueDate("2010-10-17").build();
        this.item2 = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("Test 2").withIssueDate("2015-8-3").build();
        this.itemRestricted = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("Test 3").withIssueDate("2015-8-3").build();
        this.policyService.removeAllPolicies(this.context, (DSpaceObject)this.itemRestricted);
        this.itemUndiscoverable = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("Test 4").withIssueDate("2015-8-3").makeUnDiscoverable().build();
        this.entityPublication = ItemBuilder.createItem((Context)this.context, (Collection)publicationCollection).withTitle("Item Publication").withIssueDate("2015-8-3").build();
        this.entityPublicationRestricted = ItemBuilder.createItem((Context)this.context, (Collection)publicationCollection).withTitle("Item Publication Restricted").withIssueDate("2015-8-3").build();
        this.policyService.removeAllPolicies(this.context, (DSpaceObject)this.entityPublicationRestricted);
        this.entityPublicationUndiscoverable = ItemBuilder.createItem((Context)this.context, (Collection)publicationCollection).withTitle("Item Publication").withIssueDate("2015-8-3").makeUnDiscoverable().build();
        this.runDSpaceScript(new String[]{"generate-sitemaps"});
        this.context.restoreAuthSystemState();
    }

    @After
    public void destroy() throws Exception {
        this.runDSpaceScript(new String[]{"generate-sitemaps", "-d"});
        super.destroy();
    }

    @Test
    public void testSitemap_notValidSiteMapFile() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sitemaps/no-such-file", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void testSitemap_fileSystemTraversal_dspaceCfg() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sitemaps/%2e%2e/config/dspace.cfg", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void testSitemap_fileSystemTraversal_dspaceCfg2() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sitemaps/%2e%2e%2fconfig%2fdspace.cfg", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void testSitemap_sitemapIndexHtml() throws Exception {
        MvcResult result = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sitemaps/sitemap_index.html", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType("text/html;charset=UTF-8")).andReturn();
        String response = result.getResponse().getContentAsString();
        Assert.assertTrue((boolean)response.contains("/sitemap0.html"));
    }

    @Test
    public void testSitemap_sitemap0Html() throws Exception {
        MvcResult result = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sitemaps/sitemap0.html", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType("text/html;charset=UTF-8")).andReturn();
        String response = result.getResponse().getContentAsString();
        Assert.assertTrue((boolean)response.contains(this.configurationService.getProperty("dspace.ui.url") + "/communities/" + this.community.getID()));
        Assert.assertTrue((boolean)response.contains(this.configurationService.getProperty("dspace.ui.url") + "/collections/" + this.collection.getID()));
        Assert.assertTrue((boolean)response.contains(this.configurationService.getProperty("dspace.ui.url") + "/items/" + this.item1.getID()));
        Assert.assertTrue((boolean)response.contains(this.configurationService.getProperty("dspace.ui.url") + "/items/" + this.item2.getID()));
        Assert.assertTrue((boolean)response.contains(this.configurationService.getProperty("dspace.ui.url") + "/entities/publication/" + this.entityPublication.getID()));
        Assert.assertFalse((boolean)response.contains(this.configurationService.getProperty("dspace.ui.url") + "/items/" + this.entityPublication.getID()));
        Assert.assertFalse((boolean)response.contains(this.configurationService.getProperty("dspace.ui.url") + "/communities/" + this.communityRestricted.getID()));
        Assert.assertFalse((boolean)response.contains(this.configurationService.getProperty("dspace.ui.url") + "/collections/" + this.collectionRestricted.getID()));
        Assert.assertFalse((boolean)response.contains(this.configurationService.getProperty("dspace.ui.url") + "/items/" + this.itemRestricted.getID()));
        Assert.assertFalse((boolean)response.contains(this.configurationService.getProperty("dspace.ui.url") + "/entities/publication/" + this.entityPublicationRestricted.getID()));
        Assert.assertFalse((boolean)response.contains(this.configurationService.getProperty("dspace.ui.url") + "/items/" + this.entityPublicationRestricted.getID()));
        Assert.assertFalse((boolean)response.contains(this.configurationService.getProperty("dspace.ui.url") + "/items/" + this.itemUndiscoverable.getID()));
        Assert.assertFalse((boolean)response.contains(this.configurationService.getProperty("dspace.ui.url") + "/entities/publication/" + this.entityPublicationUndiscoverable.getID()));
        Assert.assertFalse((boolean)response.contains(this.configurationService.getProperty("dspace.ui.url") + "/items/" + this.entityPublicationUndiscoverable.getID()));
    }

    @Test
    public void testSitemap_sitemapIndexXml() throws Exception {
        MvcResult result = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sitemaps/sitemap_index.xml", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(res -> {
            String actual = res.getResponse().getContentType();
            Assert.assertTrue((String)"Content Type", ("text/xml;charset=UTF-8".equals(actual) || "application/xml;charset=UTF-8".equals(actual) ? 1 : 0) != 0);
        }).andReturn();
        String response = result.getResponse().getContentAsString();
        Assert.assertTrue((boolean)response.contains("/sitemap0.xml"));
    }

    @Test
    public void testSitemap_sitemap0Xml() throws Exception {
        MvcResult result = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sitemaps/sitemap0.xml", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(res -> {
            String actual = res.getResponse().getContentType();
            Assert.assertTrue((String)"Content Type", ("text/xml;charset=UTF-8".equals(actual) || "application/xml;charset=UTF-8".equals(actual) ? 1 : 0) != 0);
        }).andReturn();
        String response = result.getResponse().getContentAsString();
        Assert.assertTrue((boolean)response.contains(this.configurationService.getProperty("dspace.ui.url") + "/communities/" + this.community.getID()));
        Assert.assertTrue((boolean)response.contains(this.configurationService.getProperty("dspace.ui.url") + "/collections/" + this.collection.getID()));
        Assert.assertTrue((boolean)response.contains(this.configurationService.getProperty("dspace.ui.url") + "/items/" + this.item1.getID()));
        Assert.assertTrue((boolean)response.contains(this.configurationService.getProperty("dspace.ui.url") + "/items/" + this.item2.getID()));
        Assert.assertTrue((boolean)response.contains(this.configurationService.getProperty("dspace.ui.url") + "/entities/publication/" + this.entityPublication.getID()));
        Assert.assertFalse((boolean)response.contains(this.configurationService.getProperty("dspace.ui.url") + "/items/" + this.entityPublication.getID()));
        Assert.assertFalse((boolean)response.contains(this.configurationService.getProperty("dspace.ui.url") + "/communities/" + this.communityRestricted.getID()));
        Assert.assertFalse((boolean)response.contains(this.configurationService.getProperty("dspace.ui.url") + "/collections/" + this.collectionRestricted.getID()));
        Assert.assertFalse((boolean)response.contains(this.configurationService.getProperty("dspace.ui.url") + "/items/" + this.itemRestricted.getID()));
        Assert.assertFalse((boolean)response.contains(this.configurationService.getProperty("dspace.ui.url") + "/entities/publication/" + this.entityPublicationRestricted.getID()));
        Assert.assertFalse((boolean)response.contains(this.configurationService.getProperty("dspace.ui.url") + "/items/" + this.entityPublicationRestricted.getID()));
        Assert.assertFalse((boolean)response.contains(this.configurationService.getProperty("dspace.ui.url") + "/items/" + this.itemUndiscoverable.getID()));
        Assert.assertFalse((boolean)response.contains(this.configurationService.getProperty("dspace.ui.url") + "/entities/publication/" + this.entityPublicationUndiscoverable.getID()));
        Assert.assertFalse((boolean)response.contains(this.configurationService.getProperty("dspace.ui.url") + "/items/" + this.entityPublicationUndiscoverable.getID()));
    }
}

