/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.util.Map;
import java.util.UUID;
import org.dspace.app.rest.matcher.MetadataMatcher;
import org.dspace.app.rest.matcher.SuggestionMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.suggestion.SuggestionTarget;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.SuggestionTargetBuilder;
import org.dspace.builder.WorkspaceItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class SuggestionRestRepositoryIT
extends AbstractControllerIntegrationTest {
    private Collection colPeople;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        this.colPeople = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("People").withEntityType("Person").build();
        this.context.restoreAuthSystemState();
    }

    @Test
    public void findAllTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item itemFirst = ItemBuilder.createItem((Context)this.context, (Collection)this.colPeople).withTitle("Bollini, Andrea").build();
        SuggestionTarget targetFirstScopus = SuggestionTargetBuilder.createTarget((Context)this.context, (Item)itemFirst).withSuggestionCount("scopus", 3).build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestions", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isMethodNotAllowed());
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestions", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isMethodNotAllowed());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestions", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isMethodNotAllowed());
    }

    @Test
    public void findByTargetAndSourceTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item itemFirst = ItemBuilder.createItem((Context)this.context, (Collection)this.colPeople).withTitle("Bollini, Andrea").build();
        SuggestionTarget targetFirstReciter = SuggestionTargetBuilder.createTarget((Context)this.context, (Item)itemFirst).withSuggestionCount("reciter", 31).build();
        SuggestionTarget targetFirstScopus = SuggestionTargetBuilder.createTarget((Context)this.context, (Item)itemFirst).withSuggestionCount("scopus", 3).build();
        SuggestionTarget targetSecond = SuggestionTargetBuilder.createTarget((Context)this.context, (Collection)this.colPeople, (String)"Digilio, Giuseppe", (EPerson)this.eperson).withSuggestionCount("reciter", 11).build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestions/search/findByTargetAndSource", (Object[])new Object[0]).param("source", new String[]{"scopus"}).param("target", new String[]{itemFirst.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.suggestions", (Matcher)Matchers.contains((Matcher[])new Matcher[]{SuggestionMatcher.matchSuggestion("scopus", itemFirst, "Suggestion scopus 1", "1", 100.0, "MockEvidence", 100.0, "Generated for testing purpose..."), SuggestionMatcher.matchSuggestion("scopus", itemFirst, "Suggestion scopus 3", "3", 98.0, "MockEvidence", 98.0, "Generated for testing purpose..."), SuggestionMatcher.matchSuggestion("scopus", itemFirst, "Suggestion scopus 2", "2", 0.5, "MockEvidence", 0.5, "Generated for testing purpose...")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestions/search/findByTargetAndSource?"), (Matcher)Matchers.containsString((String)"source=scopus"), (Matcher)Matchers.containsString((String)("target=" + itemFirst.getID().toString()))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
        Item itemSecond = targetSecond.getTarget();
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestions/search/findByTargetAndSource", (Object[])new Object[0]).param("source", new String[]{"reciter"}).param("target", new String[]{itemSecond.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.suggestions", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SuggestionMatcher.matchSuggestion("reciter", itemSecond, "Suggestion reciter 1", "1"), SuggestionMatcher.matchSuggestion("reciter", itemSecond, "Suggestion reciter 2", "2"), SuggestionMatcher.matchSuggestion("reciter", itemSecond, "Suggestion reciter 3", "3"), SuggestionMatcher.matchSuggestion("reciter", itemSecond, "Suggestion reciter 4", "4"), SuggestionMatcher.matchSuggestion("reciter", itemSecond, "Suggestion reciter 5", "5"), SuggestionMatcher.matchSuggestion("reciter", itemSecond, "Suggestion reciter 6", "6"), SuggestionMatcher.matchSuggestion("reciter", itemSecond, "Suggestion reciter 7", "7"), SuggestionMatcher.matchSuggestion("reciter", itemSecond, "Suggestion reciter 8", "8"), SuggestionMatcher.matchSuggestion("reciter", itemSecond, "Suggestion reciter 9", "9"), SuggestionMatcher.matchSuggestion("reciter", itemSecond, "Suggestion reciter 10", "10"), SuggestionMatcher.matchSuggestion("reciter", itemSecond, "Suggestion reciter 11", "11")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestions/search/findByTargetAndSource?"), (Matcher)Matchers.containsString((String)"source=reciter"), (Matcher)Matchers.containsString((String)("target=" + itemSecond.getID().toString()))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)11)));
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestions/search/findByTargetAndSource", (Object[])new Object[0]).param("source", new String[]{"reciter"}).param("target", new String[]{itemSecond.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.suggestions", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SuggestionMatcher.matchSuggestion("reciter", itemSecond, "Suggestion reciter 1", "1"), SuggestionMatcher.matchSuggestion("reciter", itemSecond, "Suggestion reciter 2", "2"), SuggestionMatcher.matchSuggestion("reciter", itemSecond, "Suggestion reciter 3", "3"), SuggestionMatcher.matchSuggestion("reciter", itemSecond, "Suggestion reciter 4", "4"), SuggestionMatcher.matchSuggestion("reciter", itemSecond, "Suggestion reciter 5", "5"), SuggestionMatcher.matchSuggestion("reciter", itemSecond, "Suggestion reciter 6", "6"), SuggestionMatcher.matchSuggestion("reciter", itemSecond, "Suggestion reciter 7", "7"), SuggestionMatcher.matchSuggestion("reciter", itemSecond, "Suggestion reciter 8", "8"), SuggestionMatcher.matchSuggestion("reciter", itemSecond, "Suggestion reciter 9", "9"), SuggestionMatcher.matchSuggestion("reciter", itemSecond, "Suggestion reciter 10", "10"), SuggestionMatcher.matchSuggestion("reciter", itemSecond, "Suggestion reciter 11", "11")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestions/search/findByTargetAndSource?"), (Matcher)Matchers.containsString((String)"source=reciter"), (Matcher)Matchers.containsString((String)("target=" + itemSecond.getID().toString()))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)11)));
    }

    @Test
    public void findByTargetAndSourcePaginationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        SuggestionTarget targetSecond = SuggestionTargetBuilder.createTarget((Context)this.context, (Collection)this.colPeople, (String)"Digilio, Giuseppe", (EPerson)this.eperson).withSuggestionCount("reciter", 11).build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        Item itemSecond = targetSecond.getTarget();
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestions/search/findByTargetAndSource", (Object[])new Object[0]).param("source", new String[]{"reciter"}).param("size", new String[]{"5"}).param("target", new String[]{itemSecond.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.suggestions", (Matcher)Matchers.contains((Matcher[])new Matcher[]{SuggestionMatcher.matchSuggestion("reciter", itemSecond, "Suggestion reciter 1", "1"), SuggestionMatcher.matchSuggestion("reciter", itemSecond, "Suggestion reciter 3", "3"), SuggestionMatcher.matchSuggestion("reciter", itemSecond, "Suggestion reciter 5", "5"), SuggestionMatcher.matchSuggestion("reciter", itemSecond, "Suggestion reciter 7", "7"), SuggestionMatcher.matchSuggestion("reciter", itemSecond, "Suggestion reciter 9", "9")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestions/search/findByTargetAndSource?"), (Matcher)Matchers.containsString((String)"source=reciter"), (Matcher)Matchers.containsString((String)"size=5"), (Matcher)Matchers.containsString((String)("target=" + itemSecond.getID().toString()))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestions/search/findByTargetAndSource?"), (Matcher)Matchers.containsString((String)"source=reciter"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=5"), (Matcher)Matchers.containsString((String)("target=" + itemSecond.getID().toString()))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestions/search/findByTargetAndSource?"), (Matcher)Matchers.containsString((String)"source=reciter"), (Matcher)Matchers.containsString((String)"page=2"), (Matcher)Matchers.containsString((String)"size=5"), (Matcher)Matchers.containsString((String)("target=" + itemSecond.getID().toString()))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestions/search/findByTargetAndSource?"), (Matcher)Matchers.containsString((String)"source=reciter"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=5"), (Matcher)Matchers.containsString((String)("target=" + itemSecond.getID().toString()))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)5))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)11)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestions/search/findByTargetAndSource", (Object[])new Object[0]).param("source", new String[]{"reciter"}).param("size", new String[]{"5"}).param("page", new String[]{"1"}).param("target", new String[]{itemSecond.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.suggestions", (Matcher)Matchers.contains((Matcher[])new Matcher[]{SuggestionMatcher.matchSuggestion("reciter", itemSecond, "Suggestion reciter 11", "11"), SuggestionMatcher.matchSuggestion("reciter", itemSecond, "Suggestion reciter 10", "10"), SuggestionMatcher.matchSuggestion("reciter", itemSecond, "Suggestion reciter 8", "8"), SuggestionMatcher.matchSuggestion("reciter", itemSecond, "Suggestion reciter 6", "6"), SuggestionMatcher.matchSuggestion("reciter", itemSecond, "Suggestion reciter 4", "4")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestions/search/findByTargetAndSource?"), (Matcher)Matchers.containsString((String)"source=reciter"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=5"), (Matcher)Matchers.containsString((String)("target=" + itemSecond.getID().toString()))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestions/search/findByTargetAndSource?"), (Matcher)Matchers.containsString((String)"source=reciter"), (Matcher)Matchers.containsString((String)"page=2"), (Matcher)Matchers.containsString((String)"size=5"), (Matcher)Matchers.containsString((String)("target=" + itemSecond.getID().toString()))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestions/search/findByTargetAndSource?"), (Matcher)Matchers.containsString((String)"source=reciter"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=5"), (Matcher)Matchers.containsString((String)("target=" + itemSecond.getID().toString()))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestions/search/findByTargetAndSource?"), (Matcher)Matchers.containsString((String)"source=reciter"), (Matcher)Matchers.containsString((String)"page=2"), (Matcher)Matchers.containsString((String)"size=5"), (Matcher)Matchers.containsString((String)("target=" + itemSecond.getID().toString()))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestions/search/findByTargetAndSource?"), (Matcher)Matchers.containsString((String)"source=reciter"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=5"), (Matcher)Matchers.containsString((String)("target=" + itemSecond.getID().toString()))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)5))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)11)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestions/search/findByTargetAndSource", (Object[])new Object[0]).param("source", new String[]{"reciter"}).param("size", new String[]{"5"}).param("page", new String[]{"2"}).param("target", new String[]{itemSecond.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.suggestions", (Matcher)Matchers.contains(SuggestionMatcher.matchSuggestion("reciter", itemSecond, "Suggestion reciter 2", "2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestions/search/findByTargetAndSource?"), (Matcher)Matchers.containsString((String)"source=reciter"), (Matcher)Matchers.containsString((String)"page=2"), (Matcher)Matchers.containsString((String)"size=5"), (Matcher)Matchers.containsString((String)("target=" + itemSecond.getID().toString()))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestions/search/findByTargetAndSource?"), (Matcher)Matchers.containsString((String)"source=reciter"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=5"), (Matcher)Matchers.containsString((String)("target=" + itemSecond.getID().toString()))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestions/search/findByTargetAndSource?"), (Matcher)Matchers.containsString((String)"source=reciter"), (Matcher)Matchers.containsString((String)"page=2"), (Matcher)Matchers.containsString((String)"size=5"), (Matcher)Matchers.containsString((String)("target=" + itemSecond.getID().toString()))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestions/search/findByTargetAndSource?"), (Matcher)Matchers.containsString((String)"source=reciter"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=5"), (Matcher)Matchers.containsString((String)("target=" + itemSecond.getID().toString()))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)5))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)11)));
    }

    @Test
    public void findByTargetAndSourceNotAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item itemFirst = ItemBuilder.createItem((Context)this.context, (Collection)this.colPeople).withTitle("Bollini, Andrea").build();
        SuggestionTarget targetFirstReciter = SuggestionTargetBuilder.createTarget((Context)this.context, (Item)itemFirst).withSuggestionCount("reciter", 31).build();
        SuggestionTarget targetFirstScopus = SuggestionTargetBuilder.createTarget((Context)this.context, (Item)itemFirst).withSuggestionCount("scopus", 3).build();
        SuggestionTarget targetSecond = SuggestionTargetBuilder.createTarget((Context)this.context, (Collection)this.colPeople, (String)"Digilio, Giuseppe", (EPerson)this.eperson).withSuggestionCount("reciter", 11).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestions/search/findByTargetAndSource", (Object[])new Object[0]).param("target", new String[]{UUID.randomUUID().toString()}).param("source", new String[]{"reciter"})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestions/search/findByTargetAndSource", (Object[])new Object[0]).param("target", new String[]{UUID.randomUUID().toString()}).param("source", new String[]{"reciter"})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findOneTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item itemFirst = ItemBuilder.createItem((Context)this.context, (Collection)this.colPeople).withTitle("Bollini, Andrea").build();
        SuggestionTarget targetFirstReciter = SuggestionTargetBuilder.createTarget((Context)this.context, (Item)itemFirst).withSuggestionCount("reciter", 31).build();
        SuggestionTarget targetFirstScopus = SuggestionTargetBuilder.createTarget((Context)this.context, (Item)itemFirst).withSuggestionCount("scopus", 3).build();
        SuggestionTarget targetSecond = SuggestionTargetBuilder.createTarget((Context)this.context, (Collection)this.colPeople, (String)"Digilio, Giuseppe", (EPerson)this.eperson).withSuggestionCount("reciter", 11).build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String suggestionId = "reciter:" + itemFirst.getID().toString() + ":6";
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/suggestions/" + suggestionId), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", SuggestionMatcher.matchSuggestion("reciter", itemFirst, "Suggestion reciter 6", "6"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.endsWith((String)("/api/integration/suggestions/" + suggestionId))));
        Item itemSecond = targetSecond.getTarget();
        String epersonSuggestionId = "reciter:" + itemSecond.getID().toString() + ":2";
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/suggestions/" + epersonSuggestionId), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", SuggestionMatcher.matchSuggestion("reciter", itemSecond, "Suggestion reciter 2", "2"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.endsWith((String)("/api/integration/suggestions/" + epersonSuggestionId))));
    }

    @Test
    public void findOneNotAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item itemFirst = ItemBuilder.createItem((Context)this.context, (Collection)this.colPeople).withTitle("Bollini, Andrea").build();
        SuggestionTarget targetFirstReciter = SuggestionTargetBuilder.createTarget((Context)this.context, (Item)itemFirst).withSuggestionCount("reciter", 31).build();
        SuggestionTarget targetFirstScopus = SuggestionTargetBuilder.createTarget((Context)this.context, (Item)itemFirst).withSuggestionCount("scopus", 3).build();
        SuggestionTarget targetSecond = SuggestionTargetBuilder.createTarget((Context)this.context, (Collection)this.colPeople, (String)"Digilio, Giuseppe", (EPerson)this.eperson).withSuggestionCount("reciter", 11).build();
        this.context.restoreAuthSystemState();
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        String suggestionId = "reciter:" + itemFirst.getID().toString() + ":6";
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/suggestions/" + suggestionId), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestions/not-exist", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/suggestions/" + suggestionId), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestions/not-exist", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void acceptSuggestionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection colPublications = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Publications").build();
        Item itemFirst = ItemBuilder.createItem((Context)this.context, (Collection)this.colPeople).withTitle("Bollini, Andrea").build();
        SuggestionTarget targetFirstReciter = SuggestionTargetBuilder.createTarget((Context)this.context, (Item)itemFirst).withSuggestionCount("reciter", 2).build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String suggestionId = "reciter:" + itemFirst.getID().toString() + ":1";
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/suggestions/" + suggestionId), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", SuggestionMatcher.matchSuggestion("reciter", itemFirst, "Suggestion reciter 1", "1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.endsWith((String)("/api/integration/suggestions/" + suggestionId))));
        Integer workspaceItemId = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            MvcResult mvcResult = this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/submission/workspaceitems?owningCollection=" + colPublications.getID().toString()), (Object[])new Object[0]).param("embed", new String[]{"item"}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api/integration/externalsources/suggestion/entryValues/" + suggestionId)).andExpect(MockMvcResultMatchers.status().isCreated()).andReturn();
            String content = mvcResult.getResponse().getContentAsString();
            Map map = (Map)mapper.readValue(content, Map.class);
            workspaceItemId = (Integer)map.get("id");
            String itemUuidString = String.valueOf(((Map)((Map)map.get("_embedded")).get("item")).get("uuid"));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + workspaceItemId), (Object[])new Object[0]).param("embed", new String[]{"item"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)workspaceItemId)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"workspaceitem")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.item", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)itemUuidString)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)itemUuidString)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"item")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{MetadataMatcher.matchMetadata("dc.title", "Title Suggestion 1")})))))));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/suggestions/" + suggestionId), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestions/search/findByTargetAndSource", (Object[])new Object[0]).param("source", new String[]{"reciter"}).param("target", new String[]{itemFirst.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.suggestions", (Matcher)Matchers.contains(SuggestionMatcher.matchSuggestion("reciter", itemFirst, "Suggestion reciter 2", "2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
            if (workspaceItemId == null) return;
        }
        catch (Throwable throwable) {
            if (workspaceItemId == null) throw throwable;
            WorkspaceItemBuilder.deleteWorkspaceItem(workspaceItemId);
            throw throwable;
        }
        WorkspaceItemBuilder.deleteWorkspaceItem((Integer)workspaceItemId);
    }

    @Test
    public void rejectSuggestionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection colPublications = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Publications").build();
        Item itemFirst = ItemBuilder.createItem((Context)this.context, (Collection)this.colPeople).withTitle("Bollini, Andrea").build();
        SuggestionTarget targetFirstReciter = SuggestionTargetBuilder.createTarget((Context)this.context, (Item)itemFirst).withSuggestionCount("reciter", 2).build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String suggestionId = "reciter:" + itemFirst.getID().toString() + ":1";
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/integration/suggestions/" + suggestionId), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/suggestions/" + suggestionId), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestions/search/findByTargetAndSource", (Object[])new Object[0]).param("source", new String[]{"reciter"}).param("target", new String[]{itemFirst.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.suggestions", (Matcher)Matchers.contains(SuggestionMatcher.matchSuggestion("reciter", itemFirst, "Suggestion reciter 2", "2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }
}

