/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.util.UUID;
import org.dspace.app.rest.matcher.SuggestionTargetMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.suggestion.SuggestionTarget;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.SuggestionTargetBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class SuggestionTargetRestRepositoryIT
extends AbstractControllerIntegrationTest {
    private Collection colPeople;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        this.colPeople = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("People").withEntityType("Person").build();
        this.context.restoreAuthSystemState();
    }

    private void buildSuggestionTargetsList() {
        this.context.turnOffAuthorisationSystem();
        Item itemFirst = ItemBuilder.createItem((Context)this.context, (Collection)this.colPeople).withTitle("Bollini, Andrea").build();
        SuggestionTarget targetFirstReciter = SuggestionTargetBuilder.createTarget((Context)this.context, (Item)itemFirst).withSuggestionCount("reciter", 31).build();
        SuggestionTarget targetFirstScopus = SuggestionTargetBuilder.createTarget((Context)this.context, (Item)itemFirst).withSuggestionCount("scopus", 3).build();
        SuggestionTarget targetSecond = SuggestionTargetBuilder.createTarget((Context)this.context, (Collection)this.colPeople, (String)"Digilio, Giuseppe", (EPerson)this.eperson).withSuggestionCount("reciter", 11).build();
        for (int idx = 0; idx < 8; ++idx) {
            Item item = ItemBuilder.createItem((Context)this.context, (Collection)this.colPeople).withTitle("Test " + idx).build();
            SuggestionTargetBuilder.createTarget((Context)this.context, (Item)item).withSuggestionCount("reciter", idx + 3).build();
            if (idx % 3 != 0) continue;
            SuggestionTargetBuilder.createTarget((Context)this.context, (Item)item).withSuggestionCount("scopus", idx + 7).build();
        }
        Item itemLast = ItemBuilder.createItem((Context)this.context, (Collection)this.colPeople).withTitle("Lombardi, Corrado").build();
        SuggestionTarget targetLast = SuggestionTargetBuilder.createTarget((Context)this.context, (Item)itemLast).withSuggestionCount("scopus", 3).build();
        this.context.restoreAuthSystemState();
    }

    @Test
    public void findAllTest() throws Exception {
        this.buildSuggestionTargetsList();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestiontargets", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isMethodNotAllowed());
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestiontargets", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isMethodNotAllowed());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestiontargets", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isMethodNotAllowed());
    }

    @Test
    public void findBySourceTest() throws Exception {
        this.buildSuggestionTargetsList();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestiontargets/search/findBySource", (Object[])new Object[0]).param("source", new String[]{"reciter"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.suggestiontargets", (Matcher)Matchers.contains((Matcher[])new Matcher[]{SuggestionTargetMatcher.matchSuggestionTarget("Bollini, Andrea", "reciter", 31), SuggestionTargetMatcher.matchSuggestionTarget("Digilio, Giuseppe", "reciter", 11), SuggestionTargetMatcher.matchSuggestionTarget("Test 7", "reciter", 10), SuggestionTargetMatcher.matchSuggestionTarget("Test 6", "reciter", 9), SuggestionTargetMatcher.matchSuggestionTarget("Test 5", "reciter", 8), SuggestionTargetMatcher.matchSuggestionTarget("Test 4", "reciter", 7), SuggestionTargetMatcher.matchSuggestionTarget("Test 3", "reciter", 6), SuggestionTargetMatcher.matchSuggestionTarget("Test 2", "reciter", 5), SuggestionTargetMatcher.matchSuggestionTarget("Test 1", "reciter", 4), SuggestionTargetMatcher.matchSuggestionTarget("Test 0", "reciter", 3)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/integration/suggestiontargets/search/findBySource?source=reciter"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)10)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestiontargets/search/findBySource", (Object[])new Object[0]).param("source", new String[]{"scopus"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.suggestiontargets", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SuggestionTargetMatcher.matchSuggestionTarget("Test 6", "scopus", 13), SuggestionTargetMatcher.matchSuggestionTarget("Test 3", "scopus", 10), SuggestionTargetMatcher.matchSuggestionTarget("Test 0", "scopus", 7), SuggestionTargetMatcher.matchSuggestionTarget("Bollini, Andrea", "scopus", 3), SuggestionTargetMatcher.matchSuggestionTarget("Lombardi, Corrado", "scopus", 3)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/integration/suggestiontargets/search/findBySource?source=scopus"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)5)));
    }

    @Test
    public void findBySourcePaginationTest() throws Exception {
        this.buildSuggestionTargetsList();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestiontargets/search/findBySource", (Object[])new Object[0]).param("source", new String[]{"reciter"}).param("size", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.suggestiontargets", (Matcher)Matchers.contains(SuggestionTargetMatcher.matchSuggestionTarget("Bollini, Andrea", "reciter", 31)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestiontargets/search/findBySource?"), (Matcher)Matchers.containsString((String)"source=reciter"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestiontargets/search/findBySource?"), (Matcher)Matchers.containsString((String)"source=reciter"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestiontargets/search/findBySource?"), (Matcher)Matchers.containsString((String)"source=reciter"), (Matcher)Matchers.containsString((String)"page=9"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestiontargets/search/findBySource?"), (Matcher)Matchers.containsString((String)"source=reciter"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)10)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestiontargets/search/findBySource", (Object[])new Object[0]).param("source", new String[]{"reciter"}).param("size", new String[]{"1"}).param("page", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.suggestiontargets", (Matcher)Matchers.contains(SuggestionTargetMatcher.matchSuggestionTarget("Digilio, Giuseppe", "reciter", 11)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestiontargets/search/findBySource?"), (Matcher)Matchers.containsString((String)"source=reciter"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestiontargets/search/findBySource?"), (Matcher)Matchers.containsString((String)"source=reciter"), (Matcher)Matchers.containsString((String)"page=2"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestiontargets/search/findBySource?"), (Matcher)Matchers.containsString((String)"source=reciter"), (Matcher)Matchers.containsString((String)"page=9"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestiontargets/search/findBySource?"), (Matcher)Matchers.containsString((String)"source=reciter"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestiontargets/search/findBySource?"), (Matcher)Matchers.containsString((String)"source=reciter"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)10)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestiontargets/search/findBySource", (Object[])new Object[0]).param("source", new String[]{"reciter"}).param("size", new String[]{"1"}).param("page", new String[]{"9"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.suggestiontargets", (Matcher)Matchers.contains(SuggestionTargetMatcher.matchSuggestionTarget("Test 0", "reciter", 3)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestiontargets/search/findBySource?"), (Matcher)Matchers.containsString((String)"source=reciter"), (Matcher)Matchers.containsString((String)"page=9"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestiontargets/search/findBySource?"), (Matcher)Matchers.containsString((String)"source=reciter"), (Matcher)Matchers.containsString((String)"page=9"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestiontargets/search/findBySource?"), (Matcher)Matchers.containsString((String)"source=reciter"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestiontargets/search/findBySource?"), (Matcher)Matchers.containsString((String)"source=reciter"), (Matcher)Matchers.containsString((String)"page=8"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)10)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestiontargets/search/findBySource", (Object[])new Object[0]).param("source", new String[]{"scopus"}).param("size", new String[]{"3"}).param("page", new String[]{"0"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.suggestiontargets", (Matcher)Matchers.contains((Matcher[])new Matcher[]{SuggestionTargetMatcher.matchSuggestionTarget("Test 6", "scopus", 13), SuggestionTargetMatcher.matchSuggestionTarget("Test 3", "scopus", 10), SuggestionTargetMatcher.matchSuggestionTarget("Test 0", "scopus", 7)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestiontargets/search/findBySource?"), (Matcher)Matchers.containsString((String)"source=scopus"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=3")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestiontargets/search/findBySource?"), (Matcher)Matchers.containsString((String)"source=scopus"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=3")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestiontargets/search/findBySource?"), (Matcher)Matchers.containsString((String)"source=scopus"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=3")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestiontargets/search/findBySource?"), (Matcher)Matchers.containsString((String)"source=scopus"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=3")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)5)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestiontargets/search/findBySource", (Object[])new Object[0]).param("source", new String[]{"scopus"}).param("size", new String[]{"3"}).param("page", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.suggestiontargets", (Matcher)Matchers.iterableWithSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.suggestiontargets", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SuggestionTargetMatcher.matchSuggestionTarget("Bollini, Andrea", "scopus", 3), SuggestionTargetMatcher.matchSuggestionTarget("Lombardi, Corrado", "scopus", 3)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestiontargets/search/findBySource?"), (Matcher)Matchers.containsString((String)"source=scopus"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=3")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestiontargets/search/findBySource?"), (Matcher)Matchers.containsString((String)"source=scopus"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=3")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestiontargets/search/findBySource?"), (Matcher)Matchers.containsString((String)"source=scopus"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=3")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestiontargets/search/findBySource?"), (Matcher)Matchers.containsString((String)"source=scopus"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=3")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)5)));
    }

    @Test
    public void findBySourceUnAuthenticatedTest() throws Exception {
        this.buildSuggestionTargetsList();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestiontargets/search/findBySource", (Object[])new Object[0]).param("source", new String[]{"reciter"})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestiontargets/search/findBySource", (Object[])new Object[0]).param("source", new String[]{"not-exist"})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findBySourceForbiddenTest() throws Exception {
        this.buildSuggestionTargetsList();
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestiontargets/search/findBySource", (Object[])new Object[0]).param("source", new String[]{"reciter"})).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestiontargets/search/findBySource", (Object[])new Object[0]).param("source", new String[]{"not-exist"})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findBySourceBadRequestTest() throws Exception {
        String tokenEperson = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestiontargets/search/findBySource", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void findOneTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        SuggestionTarget target = SuggestionTargetBuilder.createTarget((Context)this.context, (Collection)this.colPeople, (String)"Bollini, Andrea").withSuggestionCount("scopus", 3).build();
        SuggestionTarget targetEPerson = SuggestionTargetBuilder.createTarget((Context)this.context, (Collection)this.colPeople, (String)"Digilio, Giuseppe", (EPerson)this.eperson).withSuggestionCount("reciter", 11).build();
        this.context.restoreAuthSystemState();
        String uuidStr = target.getID().toString();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/suggestiontargets/" + uuidStr), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", SuggestionTargetMatcher.matchSuggestionTarget("Bollini, Andrea", "scopus", 3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.endsWith((String)("/api/integration/suggestiontargets/" + uuidStr))));
        String uuidStrEpersonProfile = targetEPerson.getID().toString();
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/suggestiontargets/" + uuidStrEpersonProfile), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", SuggestionTargetMatcher.matchSuggestionTarget("Digilio, Giuseppe", "reciter", 11))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.endsWith((String)("/api/integration/suggestiontargets/" + uuidStrEpersonProfile))));
    }

    @Test
    public void findOneFullProjectionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        SuggestionTarget target = SuggestionTargetBuilder.createTarget((Context)this.context, (Collection)this.colPeople, (String)"Bollini, Andrea").withSuggestionCount("scopus", 3).build();
        SuggestionTarget targetEPerson = SuggestionTargetBuilder.createTarget((Context)this.context, (Collection)this.colPeople, (String)"Digilio, Giuseppe", (EPerson)this.eperson).withSuggestionCount("reciter", 11).build();
        this.context.restoreAuthSystemState();
        String uuidStrTarget = target.getID().toString();
        String uuidStrProfile = target.getTarget().getID().toString();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/suggestiontargets/" + uuidStrTarget), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", SuggestionTargetMatcher.matchSuggestionTarget("Bollini, Andrea", "scopus", 3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.endsWith((String)("/api/integration/suggestiontargets/" + uuidStrTarget)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.target.id", (Matcher)Matchers.is((Object)uuidStrProfile)));
        String uuidStrEpersonTarget = targetEPerson.getID().toString();
        String uuidStrEpersonProfile = targetEPerson.getTarget().getID().toString();
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/suggestiontargets/" + uuidStrEpersonTarget), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", SuggestionTargetMatcher.matchSuggestionTarget("Digilio, Giuseppe", "reciter", 11))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.endsWith((String)("/api/integration/suggestiontargets/" + uuidStrEpersonTarget)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.target.id", (Matcher)Matchers.is((Object)uuidStrEpersonProfile)));
    }

    @Test
    public void findOneUnAuthenticatedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        SuggestionTarget target = SuggestionTargetBuilder.createTarget((Context)this.context, (Collection)this.colPeople, (String)"Bollini, Andrea").withSuggestionCount("reciter", 31).build();
        this.context.restoreAuthSystemState();
        String uuidStr = target.getID().toString();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/suggestiontargets/" + uuidStr), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOneForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        SuggestionTarget target = SuggestionTargetBuilder.createTarget((Context)this.context, (Collection)this.colPeople, (String)"Bollini, Andrea").withSuggestionCount("reciter", 31).build();
        this.context.restoreAuthSystemState();
        String uuidStr = target.getID().toString();
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/suggestiontargets/" + uuidStr), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findOneTestWrongID() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestiontargets/not-an-uuid", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/suggestiontargets/" + UUID.randomUUID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/suggestiontargets/scopus:" + UUID.randomUUID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/suggestiontargets/invalid:" + UUID.randomUUID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestiontargets/not-an-uuid", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/suggestiontargets/" + UUID.randomUUID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/suggestiontargets/scopus:" + UUID.randomUUID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/suggestiontargets/invalid:" + UUID.randomUUID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestiontargets/not-an-uuid", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/suggestiontargets/" + UUID.randomUUID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/suggestiontargets/scopus:" + UUID.randomUUID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/suggestiontargets/invalid:" + UUID.randomUUID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findByTargetTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item itemFirst = ItemBuilder.createItem((Context)this.context, (Collection)this.colPeople).withTitle("Bollini, Andrea").build();
        SuggestionTarget targetFirstReciter = SuggestionTargetBuilder.createTarget((Context)this.context, (Item)itemFirst).withSuggestionCount("reciter", 31).build();
        SuggestionTarget targetFirstScopus = SuggestionTargetBuilder.createTarget((Context)this.context, (Item)itemFirst).withSuggestionCount("scopus", 3).build();
        Item itemLast = ItemBuilder.createItem((Context)this.context, (Collection)this.colPeople).withTitle("Lombardi, Corrado").withDSpaceObjectOwner(this.eperson.getFullName(), this.eperson.getID().toString()).build();
        SuggestionTarget targetLast = SuggestionTargetBuilder.createTarget((Context)this.context, (Item)itemLast).withSuggestionCount("scopus", 2).build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestiontargets/search/findByTarget", (Object[])new Object[0]).param("target", new String[]{itemFirst.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.suggestiontargets", (Matcher)Matchers.contains((Matcher[])new Matcher[]{SuggestionTargetMatcher.matchSuggestionTarget("Bollini, Andrea", "reciter", 31), SuggestionTargetMatcher.matchSuggestionTarget("Bollini, Andrea", "scopus", 3)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/integration/suggestiontargets/search/findByTarget?target=" + itemFirst.getID().toString())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestiontargets/search/findByTarget", (Object[])new Object[0]).param("target", new String[]{itemLast.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.suggestiontargets", (Matcher)Matchers.contains(SuggestionTargetMatcher.matchSuggestionTarget("Lombardi, Corrado", "scopus", 2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/integration/suggestiontargets/search/findByTarget?target=" + itemLast.getID().toString())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestiontargets/search/findByTarget", (Object[])new Object[0]).param("target", new String[]{itemLast.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.suggestiontargets", (Matcher)Matchers.contains(SuggestionTargetMatcher.matchSuggestionTarget("Lombardi, Corrado", "scopus", 2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/integration/suggestiontargets/search/findByTarget?target=" + itemLast.getID().toString())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void findByTargetPaginationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item itemFirst = ItemBuilder.createItem((Context)this.context, (Collection)this.colPeople).withTitle("Bollini, Andrea").build();
        SuggestionTarget targetFirstReciter = SuggestionTargetBuilder.createTarget((Context)this.context, (Item)itemFirst).withSuggestionCount("reciter", 31).build();
        SuggestionTarget targetFirstScopus = SuggestionTargetBuilder.createTarget((Context)this.context, (Item)itemFirst).withSuggestionCount("scopus", 3).build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestiontargets/search/findByTarget", (Object[])new Object[0]).param("size", new String[]{"1"}).param("target", new String[]{itemFirst.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.suggestiontargets", (Matcher)Matchers.contains(SuggestionTargetMatcher.matchSuggestionTarget("Bollini, Andrea", "reciter", 31)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestiontargets/search/findByTarget?"), (Matcher)Matchers.containsString((String)("target=" + itemFirst.getID().toString())), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestiontargets/search/findByTarget?"), (Matcher)Matchers.containsString((String)("target=" + itemFirst.getID().toString())), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestiontargets/search/findByTarget?"), (Matcher)Matchers.containsString((String)("target=" + itemFirst.getID().toString())), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestiontargets/search/findByTarget?"), (Matcher)Matchers.containsString((String)("target=" + itemFirst.getID().toString())), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestiontargets/search/findByTarget", (Object[])new Object[0]).param("size", new String[]{"1"}).param("page", new String[]{"1"}).param("target", new String[]{itemFirst.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.suggestiontargets", (Matcher)Matchers.contains(SuggestionTargetMatcher.matchSuggestionTarget("Bollini, Andrea", "scopus", 3)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestiontargets/search/findByTarget?"), (Matcher)Matchers.containsString((String)("target=" + itemFirst.getID().toString())), (Matcher)Matchers.containsString((String)"size=1"), (Matcher)Matchers.containsString((String)"page=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestiontargets/search/findByTarget?"), (Matcher)Matchers.containsString((String)("target=" + itemFirst.getID().toString())), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestiontargets/search/findByTarget?"), (Matcher)Matchers.containsString((String)("target=" + itemFirst.getID().toString())), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/integration/suggestiontargets/search/findByTarget?"), (Matcher)Matchers.containsString((String)("target=" + itemFirst.getID().toString())), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
    }

    @Test
    public void findByTargetUnAuthenticatedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item itemFirst = ItemBuilder.createItem((Context)this.context, (Collection)this.colPeople).withTitle("Bollini, Andrea").build();
        SuggestionTarget targetFirstReciter = SuggestionTargetBuilder.createTarget((Context)this.context, (Item)itemFirst).withSuggestionCount("reciter", 31).build();
        SuggestionTarget targetFirstScopus = SuggestionTargetBuilder.createTarget((Context)this.context, (Item)itemFirst).withSuggestionCount("scopus", 3).build();
        Item itemLast = ItemBuilder.createItem((Context)this.context, (Collection)this.colPeople).withTitle("Lombardi, Corrado").withDSpaceObjectOwner(this.eperson.getFullName(), this.eperson.getID().toString()).build();
        SuggestionTarget targetLast = SuggestionTargetBuilder.createTarget((Context)this.context, (Item)itemLast).withSuggestionCount("scopus", 2).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestiontargets/search/findByTarget", (Object[])new Object[0]).param("target", new String[]{itemFirst.getID().toString()})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestiontargets/search/findByTarget", (Object[])new Object[0]).param("target", new String[]{itemLast.getID().toString()})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findByTargetForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item itemFirst = ItemBuilder.createItem((Context)this.context, (Collection)this.colPeople).withTitle("Bollini, Andrea").build();
        SuggestionTarget targetFirstReciter = SuggestionTargetBuilder.createTarget((Context)this.context, (Item)itemFirst).withSuggestionCount("reciter", 31).build();
        SuggestionTarget targetFirstScopus = SuggestionTargetBuilder.createTarget((Context)this.context, (Item)itemFirst).withSuggestionCount("scopus", 3).build();
        Item itemLast = ItemBuilder.createItem((Context)this.context, (Collection)this.colPeople).withTitle("Lombardi, Corrado").withDSpaceObjectOwner(this.eperson.getFullName(), this.eperson.getID().toString()).build();
        SuggestionTarget targetLast = SuggestionTargetBuilder.createTarget((Context)this.context, (Item)itemLast).withSuggestionCount("scopus", 2).build();
        EPerson anotherEPerson = EPersonBuilder.createEPerson((Context)this.context).withEmail("another@example.com").withPassword(this.password).withNameInMetadata("Test", "Test").build();
        this.context.restoreAuthSystemState();
        String tokenAnother = this.getAuthToken(anotherEPerson.getEmail(), this.password);
        this.getClient(tokenAnother).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestiontargets/search/findByTarget", (Object[])new Object[0]).param("target", new String[]{itemFirst.getID().toString()})).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(tokenAnother).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestiontargets/search/findByTarget", (Object[])new Object[0]).param("target", new String[]{itemLast.getID().toString()})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findByTargetBadRequestTest() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestiontargets/search/findByTarget", (Object[])new Object[0]).param("target", new String[]{"not-exist"})).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestiontargets/search/findByTarget", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/suggestiontargets/search/findByTarget", (Object[])new Object[0]).param("target", new String[]{"not-exist"})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }
}

