/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.dspace.app.rest.model.ViewEventRest;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.SiteBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.Site;
import org.dspace.core.Context;
import org.dspace.statistics.SolrStatisticsCore;
import org.dspace.utils.DSpace;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class ViewEventRestRepositoryIT
extends AbstractControllerIntegrationTest {
    private final SolrStatisticsCore solrStatisticsCore = (SolrStatisticsCore)new DSpace().getSingletonService(SolrStatisticsCore.class);

    @Test
    public void findAllTestThrowNotImplementedException() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/statistics/viewevents", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(405));
    }

    @Test
    public void findOneTestThrowNotImplementedException() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/viewevents/" + UUID.randomUUID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(405));
    }

    @Test
    public void postTestSucces() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ViewEventRest viewEventRest = new ViewEventRest();
        viewEventRest.setTargetType("item");
        viewEventRest.setTargetId(publicItem1.getID());
        ObjectMapper mapper = new ObjectMapper();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
    }

    @Test
    public void postTestInvalidUUIDUnprocessableEntityException() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ViewEventRest viewEventRest = new ViewEventRest();
        viewEventRest.setTargetType("item");
        viewEventRest.setTargetId(UUID.randomUUID());
        ObjectMapper mapper = new ObjectMapper();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void postTestNoUUIDBadRequestException() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ViewEventRest viewEventRest = new ViewEventRest();
        viewEventRest.setTargetType("item");
        viewEventRest.setTargetId(null);
        ObjectMapper mapper = new ObjectMapper();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void postTestNoTargetTypeBadRequestException() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ViewEventRest viewEventRest = new ViewEventRest();
        viewEventRest.setTargetType(null);
        viewEventRest.setTargetId(publicItem1.getID());
        ObjectMapper mapper = new ObjectMapper();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void postTestWrongTargetTypeBadRequestException() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ViewEventRest viewEventRest = new ViewEventRest();
        viewEventRest.setTargetType("aezazeaezea");
        viewEventRest.setTargetId(publicItem1.getID());
        ObjectMapper mapper = new ObjectMapper();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void postBitstreamTestSucces() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream").withDescription("descr").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        ViewEventRest viewEventRest = new ViewEventRest();
        viewEventRest.setTargetType("bitstream");
        viewEventRest.setTargetId(bitstream.getID());
        ObjectMapper mapper = new ObjectMapper();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
    }

    @Test
    public void postCollectionTestSucces() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream").withDescription("descr").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        ViewEventRest viewEventRest = new ViewEventRest();
        viewEventRest.setTargetType("collection");
        viewEventRest.setTargetId(col1.getID());
        ObjectMapper mapper = new ObjectMapper();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
    }

    @Test
    public void postCommunityTestSucces() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream").withDescription("descr").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        ViewEventRest viewEventRest = new ViewEventRest();
        viewEventRest.setTargetType("community");
        viewEventRest.setTargetId(child1.getID());
        ObjectMapper mapper = new ObjectMapper();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
    }

    @Test
    public void postSiteTestSucces() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream").withDescription("descr").withMimeType("text/plain").build();
        }
        Site site = SiteBuilder.createSite((Context)this.context).build();
        this.context.restoreAuthSystemState();
        ViewEventRest viewEventRest = new ViewEventRest();
        viewEventRest.setTargetType("site");
        viewEventRest.setTargetId(site.getID());
        ObjectMapper mapper = new ObjectMapper();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
    }

    @Test
    public void postTestAuthenticatedUserSuccess() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ViewEventRest viewEventRest = new ViewEventRest();
        viewEventRest.setTargetType("item");
        viewEventRest.setTargetId(publicItem1.getID());
        ObjectMapper mapper = new ObjectMapper();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
    }

    @Test
    public void postTestReferrer() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ViewEventRest viewEventRest = new ViewEventRest();
        viewEventRest.setTargetType("item");
        viewEventRest.setTargetId(publicItem1.getID());
        viewEventRest.setReferrer("test-referrer");
        ObjectMapper mapper = new ObjectMapper();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.solrStatisticsCore.getSolr().commit();
        SolrQuery solrQuery = new SolrQuery("*:*");
        QueryResponse queryResponse = this.solrStatisticsCore.getSolr().query((SolrParams)solrQuery);
        SolrDocumentList responseList = queryResponse.getResults();
        Assert.assertEquals((long)1L, (long)responseList.size());
        Assert.assertEquals((Object)"test-referrer", (Object)((SolrDocument)responseList.get(0)).get((Object)"referrer"));
    }
}

