/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.jayway.jsonpath.matchers.JsonPathMatchers;
import org.dspace.app.rest.matcher.CollectionMatcher;
import org.dspace.app.rest.matcher.EPersonMatcher;
import org.dspace.app.rest.matcher.ItemMatcher;
import org.dspace.app.rest.matcher.WorkspaceItemMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.WorkspaceItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class WorkspaceItemRestLinkRepositoryIT
extends AbstractControllerIntegrationTest {
    @Test
    public void findOneEmbedSubmitterTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@dspace.org").withNameInMetadata("Sub", "Mitter").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withSubmitter(submitter).withTitle("Workspace Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Workspace Item 1", "2017-10-17", "ExtraEntry")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)JsonPathMatchers.hasNoJsonPath((String)"$._embedded.submitter")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).param("embed", new String[]{"submitter"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Workspace Item 1", "2017-10-17", "ExtraEntry")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.submitter", (Matcher)Matchers.is(EPersonMatcher.matchEPersonEntry(submitter))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID() + "/submitter"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", EPersonMatcher.matchEPersonEntry(submitter)));
    }

    @Test
    public void findOneEmbedCollectionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@dspace.org").withNameInMetadata("Sub", "Mitter").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withSubmitter(submitter).withTitle("Workspace Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Workspace Item 1", "2017-10-17", "ExtraEntry")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)JsonPathMatchers.hasNoJsonPath((String)"$._embedded.collection")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).param("embed", new String[]{"collection"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Workspace Item 1", "2017-10-17", "ExtraEntry")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collection", (Matcher)Matchers.is(CollectionMatcher.matchCollection(col1))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID() + "/collection"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CollectionMatcher.matchCollection(col1)));
    }

    @Test
    public void findOneEmbedItemTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@dspace.org").withNameInMetadata("Sub", "Mitter").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withSubmitter(submitter).withTitle("Workspace Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Workspace Item 1", "2017-10-17", "ExtraEntry")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)JsonPathMatchers.hasNoJsonPath((String)"$._embedded.item")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).param("embed", new String[]{"item"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Workspace Item 1", "2017-10-17", "ExtraEntry")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.item", (Matcher)Matchers.is(ItemMatcher.matchItemProperties(witem.getItem()))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID() + "/item"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ItemMatcher.matchItemProperties(witem.getItem())));
    }
}

