/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization;

import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureService;
import org.dspace.app.rest.converter.ItemConverter;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.rest.utils.Utils;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class CanSynchronizeWithORCIDIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private Utils utils;
    @Autowired
    private ItemConverter itemConverter;
    @Autowired
    private AuthorizationFeatureService authorizationFeatureService;
    @Autowired
    private ConfigurationService configurationService;
    final String feature = "canSynchronizeWithORCID";
    private Item itemA;
    private ItemRest itemARest;
    private Community communityA;
    private Collection collectionA;
    private AuthorizationFeature canSynchronizeWithORCID;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.canSynchronizeWithORCID = this.authorizationFeatureService.find("canSynchronizeWithORCID");
        this.communityA = CommunityBuilder.createCommunity((Context)this.context).withName("communityA").build();
        this.collectionA = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityA).withName("collectionA").build();
        this.itemA = ItemBuilder.createItem((Context)this.context, (Collection)this.collectionA).withTitle("itemA").withDspaceObjectOwner("user", this.context.getCurrentUser().getID().toString()).build();
        this.context.restoreAuthSystemState();
        this.itemARest = this.itemConverter.convert(this.itemA, Projection.DEFAULT);
    }

    @Test
    public void anonymousHasNotAccessTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("embed", new String[]{"feature"}).param("feature", new String[]{"canSynchronizeWithORCID"}).param("uri", new String[]{this.utils.linkToSingleResource((RestAddressableModel)this.itemARest, "self").getHref()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testCanSynchronizeWithORCIDIfItemDoesNotHasDspaceObjectOwner() throws Exception {
        EPerson user = this.context.getCurrentUser();
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)this.collectionA).withTitle("item").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(user.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{this.uri(item)}).param("eperson", new String[]{user.getID().toString()}).param("feature", new String[]{this.canSynchronizeWithORCID.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testCanSynchronizeWithORCIDIfItemHasDspaceObjectOwnerOfAnotherUUID() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson anotherUser = EPersonBuilder.createEPerson((Context)this.context).withEmail("user@example.com").withPassword(this.password).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(anotherUser.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{this.uri(this.itemA)}).param("eperson", new String[]{anotherUser.getID().toString()}).param("feature", new String[]{this.canSynchronizeWithORCID.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testCanSynchronizeWithORCIDIfItemHasDspaceObjectOwner() throws Exception {
        EPerson user = this.context.getCurrentUser();
        String token = this.getAuthToken(user.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{this.uri(this.itemA)}).param("eperson", new String[]{user.getID().toString()}).param("feature", new String[]{this.canSynchronizeWithORCID.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).exists()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1))));
    }

    @Test
    public void testCanSynchronizeWithORCIDWithSynchronizationDisabled() throws Exception {
        this.configurationService.setProperty("orcid.synchronization-enabled", (Object)false);
        EPerson user = this.context.getCurrentUser();
        String token = this.getAuthToken(user.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{this.uri(this.itemA)}).param("eperson", new String[]{user.getID().toString()}).param("feature", new String[]{this.canSynchronizeWithORCID.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    private String uri(Item item) {
        ItemRest itemRest = this.itemConverter.convert(item, Projection.DEFAULT);
        String itemRestURI = this.utils.linkToSingleResource((RestAddressableModel)itemRest, "self").getHref();
        return itemRestURI;
    }
}

