/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.BundleBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.ResourcePolicyBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.services.ConfigurationService;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class GenericAuthorizationFeatureIT
extends AbstractControllerIntegrationTest {
    private static final int SIZE = 100;
    @Autowired
    ConfigurationService configurationService;
    private Community communityA;
    private Community communityAA;
    private Community communityB;
    private Community communityBB;
    private Collection collectionX;
    private Collection collectionY;
    private Item item1;
    private Item item2;
    private Bundle bundle1;
    private Bundle bundle2;
    private Bitstream bitstream1;
    private Bitstream bitstream2;
    private Group item1AdminGroup;
    private EPerson communityAAdmin;
    private EPerson collectionXAdmin;
    private EPerson item1Admin;
    private EPerson communityAWriter;
    private EPerson collectionXWriter;
    private EPerson item1Writer;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.communityAAdmin = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("communityAAdmin@my.edu").withPassword(this.password).build();
        this.collectionXAdmin = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("collectionXAdmin@my.edu").withPassword(this.password).build();
        this.item1Admin = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("item1Admin@my.edu").withPassword(this.password).build();
        this.communityAWriter = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("communityAWriter@my.edu").withPassword(this.password).build();
        this.collectionXWriter = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("collectionXWriter@my.edu").withPassword(this.password).build();
        this.item1Writer = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("item1Writer@my.edu").withPassword(this.password).build();
        this.communityA = CommunityBuilder.createCommunity((Context)this.context).withName("communityA").withAdminGroup(new EPerson[]{this.communityAAdmin}).build();
        this.communityAA = CommunityBuilder.createCommunity((Context)this.context).withName("communityAA").addParentCommunity(this.context, this.communityA).build();
        this.collectionX = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityAA).withName("collectionX").withAdminGroup(new EPerson[]{this.collectionXAdmin}).build();
        this.item1 = ItemBuilder.createItem((Context)this.context, (Collection)this.collectionX).withTitle("item1").withIssueDate("2020-07-08").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("item1Entry").build();
        this.bundle1 = BundleBuilder.createBundle((Context)this.context, (Item)this.item1).withName("bundle1").build();
        try (InputStream is = IOUtils.toInputStream((String)"randomContent", (String)"UTF-8");){
            this.bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)this.bundle1, (InputStream)is).withName("bitstream1").withMimeType("text/plain").build();
        }
        this.item1AdminGroup = GroupBuilder.createGroup((Context)this.context).withName("item1AdminGroup").addMember(this.item1Admin).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)this.item1AdminGroup).withDspaceObject((DSpaceObject)this.item1).withAction(11).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.communityAWriter, null).withDspaceObject((DSpaceObject)this.communityA).withAction(1).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.collectionXWriter, null).withDspaceObject((DSpaceObject)this.collectionX).withAction(1).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.item1Writer, null).withDspaceObject((DSpaceObject)this.item1).withAction(1).build();
        this.communityB = CommunityBuilder.createCommunity((Context)this.context).withName("communityB").build();
        this.communityBB = CommunityBuilder.createCommunity((Context)this.context).withName("communityBB").addParentCommunity(this.context, this.communityB).build();
        this.collectionY = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityBB).withName("collectionY").build();
        this.item2 = ItemBuilder.createItem((Context)this.context, (Collection)this.collectionY).withTitle("item2").withIssueDate("2020-07-08").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("item2Entry").build();
        this.bundle2 = BundleBuilder.createBundle((Context)this.context, (Item)this.item2).withName("bundle2").build();
        is = IOUtils.toInputStream((String)"randomContent", (String)"UTF-8");
        try {
            this.bitstream2 = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)this.bundle2, (InputStream)is).withName("bitstream2").withMimeType("text/plain").build();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        this.context.restoreAuthSystemState();
        this.configurationService.setProperty("org.dspace.app.rest.authorization.AlwaysThrowExceptionFeature.turnoff", (Object)"true");
    }

    private void testAdminsHavePermissionsAllDso(String feature) throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String communityAAdminToken = this.getAuthToken(this.communityAAdmin.getEmail(), this.password);
        String collectionXAdminToken = this.getAuthToken(this.collectionXAdmin.getEmail(), this.password);
        String item1AdminToken = this.getAuthToken(this.item1Admin.getEmail(), this.password);
        String siteId = ContentServiceFactory.getInstance().getSiteService().findSite(this.context).getID().toString();
        this.getAuthorizationFeatures(adminToken, "http://localhost/api/core/sites/" + siteId).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(communityAAdminToken, "http://localhost/api/core/sites/" + siteId).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(adminToken, "http://localhost/api/core/communities/" + this.communityA.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(communityAAdminToken, "http://localhost/api/core/communities/" + this.communityA.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(communityAAdminToken, "http://localhost/api/core/communities/" + this.communityAA.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(collectionXAdminToken, "http://localhost/api/core/communities/" + this.communityA.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(communityAAdminToken, "http://localhost/api/core/communities/" + this.communityB.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(adminToken, "http://localhost/api/core/collections/" + this.collectionX.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(communityAAdminToken, "http://localhost/api/core/collections/" + this.collectionX.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(collectionXAdminToken, "http://localhost/api/core/collections/" + this.collectionX.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(item1AdminToken, "http://localhost/api/core/collections/" + this.collectionX.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(collectionXAdminToken, "http://localhost/api/core/collections/" + this.collectionY.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(adminToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(communityAAdminToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(collectionXAdminToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(item1AdminToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(item1AdminToken, "http://localhost/api/core/items/" + this.item2.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(adminToken, "http://localhost/api/core/bundles/" + this.bundle1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(communityAAdminToken, "http://localhost/api/core/bundles/" + this.bundle1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(collectionXAdminToken, "http://localhost/api/core/bundles/" + this.bundle1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(item1AdminToken, "http://localhost/api/core/bundles/" + this.bundle1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(item1AdminToken, "http://localhost/api/core/bundles/" + this.bundle2.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(adminToken, "http://localhost/api/core/bitstreams/" + this.bitstream1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(communityAAdminToken, "http://localhost/api/core/bitstreams/" + this.bitstream1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(collectionXAdminToken, "http://localhost/api/core/bitstreams/" + this.bitstream1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(item1AdminToken, "http://localhost/api/core/bitstreams/" + this.bitstream1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(item1AdminToken, "http://localhost/api/core/bitstreams/" + this.bitstream2.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
    }

    private void testAdminsHavePermissionsItem(String feature) throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String communityAAdminToken = this.getAuthToken(this.communityAAdmin.getEmail(), this.password);
        String collectionXAdminToken = this.getAuthToken(this.collectionXAdmin.getEmail(), this.password);
        String item1AdminToken = this.getAuthToken(this.item1Admin.getEmail(), this.password);
        this.getAuthorizationFeatures(adminToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(communityAAdminToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(collectionXAdminToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(item1AdminToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(communityAAdminToken, "http://localhost/api/core/items/" + this.item2.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
    }

    private void testWriteUsersHavePermissionsAllDso(String feature, boolean hasDSOAccess) throws Exception {
        String communityAWriterToken = this.getAuthToken(this.communityAWriter.getEmail(), this.password);
        String collectionXWriterToken = this.getAuthToken(this.collectionXWriter.getEmail(), this.password);
        String item1WriterToken = this.getAuthToken(this.item1Writer.getEmail(), this.password);
        if (hasDSOAccess) {
            this.getAuthorizationFeatures(communityAWriterToken, "http://localhost/api/core/communities/" + this.communityA.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        } else {
            this.getAuthorizationFeatures(communityAWriterToken, "http://localhost/api/core/communities/" + this.communityA.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        }
        this.getAuthorizationFeatures(communityAWriterToken, "http://localhost/api/core/communities/" + this.communityAA.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(communityAWriterToken, "http://localhost/api/core/collections/" + this.collectionX.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(communityAWriterToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(communityAWriterToken, "http://localhost/api/core/bundles/" + this.bundle1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(communityAWriterToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(collectionXWriterToken, "http://localhost/api/core/communities/" + this.communityA.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(collectionXWriterToken, "http://localhost/api/core/communities/" + this.communityAA.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        if (hasDSOAccess) {
            this.getAuthorizationFeatures(collectionXWriterToken, "http://localhost/api/core/collections/" + this.collectionX.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        } else {
            this.getAuthorizationFeatures(collectionXWriterToken, "http://localhost/api/core/collections/" + this.collectionX.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        }
        this.getAuthorizationFeatures(collectionXWriterToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(collectionXWriterToken, "http://localhost/api/core/bundles/" + this.bundle1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(collectionXWriterToken, "http://localhost/api/core/bitstreams/" + this.bitstream1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(item1WriterToken, "http://localhost/api/core/communities/" + this.communityA.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(item1WriterToken, "http://localhost/api/core/communities/" + this.communityAA.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(item1WriterToken, "http://localhost/api/core/collections/" + this.collectionX.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        if (hasDSOAccess) {
            this.getAuthorizationFeatures(item1WriterToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        } else {
            this.getAuthorizationFeatures(item1WriterToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        }
        this.getAuthorizationFeatures(item1WriterToken, "http://localhost/api/core/bundles/" + this.bundle1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(item1WriterToken, "http://localhost/api/core/bitstreams/" + this.bitstream1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(communityAWriterToken, "http://localhost/api/core/communities/" + this.communityB.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(collectionXWriterToken, "http://localhost/api/core/collections/" + this.collectionY.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(item1WriterToken, "http://localhost/api/core/items/" + this.item2.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
    }

    private void testWriteUsersHavePermissionsItem(String feature, boolean hasDSOAccess) throws Exception {
        String communityAWriterToken = this.getAuthToken(this.communityAWriter.getEmail(), this.password);
        String collectionXWriterToken = this.getAuthToken(this.collectionXWriter.getEmail(), this.password);
        String item1WriterToken = this.getAuthToken(this.item1Writer.getEmail(), this.password);
        this.getAuthorizationFeatures(communityAWriterToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(collectionXWriterToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        if (hasDSOAccess) {
            this.getAuthorizationFeatures(item1WriterToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        } else {
            this.getAuthorizationFeatures(item1WriterToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        }
        this.getAuthorizationFeatures(item1WriterToken, "http://localhost/api/core/items/" + this.item2.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testCanManagePoliciesAdmin() throws Exception {
        this.testWriteUsersHavePermissionsAllDso("canManagePolicies", false);
    }

    @Test
    public void testCanManagePoliciesWriter() throws Exception {
        this.testWriteUsersHavePermissionsAllDso("canManagePolicies", false);
    }

    @Test
    public void testCanEditMetadataAdmin() throws Exception {
        this.testAdminsHavePermissionsAllDso("canEditMetadata");
    }

    @Test
    public void testCanEditMetadataWriter() throws Exception {
        this.testWriteUsersHavePermissionsAllDso("canEditMetadata", true);
    }

    @Test
    public void testCanMoveAdmin() throws Exception {
        String item1WriterToken = this.getAuthToken(this.item1Writer.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String communityAAdminToken = this.getAuthToken(this.communityAAdmin.getEmail(), this.password);
        String collectionXAdminToken = this.getAuthToken(this.collectionXAdmin.getEmail(), this.password);
        String item1AdminToken = this.getAuthToken(this.item1Admin.getEmail(), this.password);
        String feature = "canMove";
        this.getAuthorizationFeatures(adminToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canMove')]", (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(communityAAdminToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canMove')]", (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(collectionXAdminToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canMove')]", (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(item1AdminToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canMove')]", (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(communityAAdminToken, "http://localhost/api/core/items/" + this.item2.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canMove')]", (Object[])new Object[0]).doesNotExist());
        this.context.turnOffAuthorisationSystem();
        ResourcePolicy removePermission = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.item1Writer, null).withDspaceObject((DSpaceObject)this.collectionX).withAction(4).build();
        this.context.restoreAuthSystemState();
        this.getAuthorizationFeatures(item1WriterToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canMove')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testCanMoveWriter() throws Exception {
        this.testWriteUsersHavePermissionsItem("canMove", false);
        this.context.turnOffAuthorisationSystem();
        ResourcePolicy removePermission = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.item1Writer, null).withDspaceObject((DSpaceObject)this.collectionX).withAction(4).build();
        this.context.restoreAuthSystemState();
        String item1WriterToken = this.getAuthToken(this.item1Writer.getEmail(), this.password);
        this.getAuthorizationFeatures(item1WriterToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canMove')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testCanMakePrivateAdmin() throws Exception {
        this.testAdminsHavePermissionsItem("canMakePrivate");
    }

    @Test
    public void testCanMakePrivateWriter() throws Exception {
        this.testWriteUsersHavePermissionsItem("canMakePrivate", true);
    }

    @Test
    public void testCanMakeDiscoverableAdmin() throws Exception {
        this.testAdminsHavePermissionsItem("canMakeDiscoverable");
    }

    @Test
    public void testCanMakeDiscoverableWriter() throws Exception {
        this.testWriteUsersHavePermissionsItem("canMakeDiscoverable", true);
    }

    @Test
    public void testCanDeleteAdmin() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String communityAAdminToken = this.getAuthToken(this.communityAAdmin.getEmail(), this.password);
        String collectionXAdminToken = this.getAuthToken(this.collectionXAdmin.getEmail(), this.password);
        String item1AdminToken = this.getAuthToken(this.item1Admin.getEmail(), this.password);
        String siteId = ContentServiceFactory.getInstance().getSiteService().findSite(this.context).getID().toString();
        String feature = "canDelete";
        this.getAuthorizationFeatures(adminToken, "http://localhost/api/core/sites/" + siteId).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(adminToken, "http://localhost/api/core/communities/" + this.communityA.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(communityAAdminToken, "http://localhost/api/core/communities/" + this.communityA.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(communityAAdminToken, "http://localhost/api/core/communities/" + this.communityAA.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.context.turnOffAuthorisationSystem();
        EPerson communityAAAdmin = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("communityAAAdmin@my.edu").withPassword(this.password).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)communityAAAdmin, null).withDspaceObject((DSpaceObject)this.communityAA).withAction(11).build();
        this.context.restoreAuthSystemState();
        String communityAAAdminToken = this.getAuthToken(communityAAAdmin.getEmail(), this.password);
        this.getAuthorizationFeatures(communityAAAdminToken, "http://localhost/api/core/communities/" + this.communityAA.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(collectionXAdminToken, "http://localhost/api/core/communities/" + this.communityA.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(communityAAdminToken, "http://localhost/api/core/communities/" + this.communityB.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(adminToken, "http://localhost/api/core/collections/" + this.collectionX.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(communityAAdminToken, "http://localhost/api/core/collections/" + this.collectionX.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(collectionXAdminToken, "http://localhost/api/core/collections/" + this.collectionX.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(item1AdminToken, "http://localhost/api/core/collections/" + this.collectionX.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(collectionXAdminToken, "http://localhost/api/core/collections/" + this.collectionY.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(adminToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(communityAAdminToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(collectionXAdminToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(item1AdminToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(item1AdminToken, "http://localhost/api/core/items/" + this.item2.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(adminToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(communityAAdminToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(collectionXAdminToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(item1AdminToken, "http://localhost/api/core/bundles/" + this.bundle1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(item1AdminToken, "http://localhost/api/core/bundles/" + this.bundle2.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(adminToken, "http://localhost/api/core/bitstreams/" + this.bitstream1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(communityAAdminToken, "http://localhost/api/core/bitstreams/" + this.bitstream1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(collectionXAdminToken, "http://localhost/api/core/bitstreams/" + this.bitstream1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(item1AdminToken, "http://localhost/api/core/bitstreams/" + this.bitstream1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(item1AdminToken, "http://localhost/api/core/bitstreams/" + this.bitstream2.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testCanDeleteAdminParent() throws Exception {
        String collectionXAdminToken = this.getAuthToken(this.collectionXAdmin.getEmail(), this.password);
        String item1AdminToken = this.getAuthToken(this.item1Admin.getEmail(), this.password);
        String feature = "canDelete";
        this.context.turnOffAuthorisationSystem();
        EPerson communityAAAdmin = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("communityAAAdmin@my.edu").withPassword(this.password).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)communityAAAdmin, null).withDspaceObject((DSpaceObject)this.communityA).withAction(4).build();
        this.context.restoreAuthSystemState();
        String communityAAAdminToken = this.getAuthToken(communityAAAdmin.getEmail(), this.password);
        this.getAuthorizationFeatures(communityAAAdminToken, "http://localhost/api/core/communities/" + this.communityAA.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.context.turnOffAuthorisationSystem();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.collectionXAdmin, null).withDspaceObject((DSpaceObject)this.communityAA).withAction(4).build();
        this.context.restoreAuthSystemState();
        this.getAuthorizationFeatures(collectionXAdminToken, "http://localhost/api/core/collections/" + this.collectionX.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.context.turnOffAuthorisationSystem();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.item1Admin, null).withDspaceObject((DSpaceObject)this.collectionX).withAction(4).build();
        this.context.restoreAuthSystemState();
        this.getAuthorizationFeatures(item1AdminToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testCanDeleteWriter() throws Exception {
        this.testWriteUsersHavePermissionsAllDso("canManagePolicies", false);
    }

    @Test
    public void testCanDeleteMinimalPermissions() throws Exception {
        String feature = "canDelete";
        this.context.turnOffAuthorisationSystem();
        EPerson communityADeleter = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("communityADeleter@my.edu").withPassword(this.password).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)communityADeleter, null).withDspaceObject((DSpaceObject)this.communityA).withAction(2).build();
        this.context.restoreAuthSystemState();
        String communityADeleterToken = this.getAuthToken(communityADeleter.getEmail(), this.password);
        this.getAuthorizationFeatures(communityADeleterToken, "http://localhost/api/core/communities/" + this.communityA.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(communityADeleterToken, "http://localhost/api/core/communities/" + this.communityAA.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.context.turnOffAuthorisationSystem();
        EPerson communityARemover = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("communityARemover@my.edu").withPassword(this.password).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)communityARemover, null).withDspaceObject((DSpaceObject)this.communityA).withAction(4).build();
        this.context.restoreAuthSystemState();
        String communityARemoverToken = this.getAuthToken(communityARemover.getEmail(), this.password);
        this.getAuthorizationFeatures(communityARemoverToken, "http://localhost/api/core/communities/" + this.communityAA.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(communityARemoverToken, "http://localhost/api/core/communities/" + this.communityA.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(communityARemoverToken, "http://localhost/api/core/collections/" + this.collectionX.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.context.turnOffAuthorisationSystem();
        EPerson communityAARemover = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("communityAARemover@my.edu").withPassword(this.password).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)communityAARemover, null).withDspaceObject((DSpaceObject)this.communityAA).withAction(4).build();
        this.context.restoreAuthSystemState();
        String communityAARemoverToken = this.getAuthToken(communityAARemover.getEmail(), this.password);
        this.getAuthorizationFeatures(communityAARemoverToken, "http://localhost/api/core/collections/" + this.collectionX.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(communityAARemoverToken, "http://localhost/api/core/communities/" + this.communityAA.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(communityAARemoverToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.context.turnOffAuthorisationSystem();
        EPerson collectionXRemover = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("communityXRemover@my.edu").withPassword(this.password).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)collectionXRemover, null).withDspaceObject((DSpaceObject)this.collectionX).withAction(4).build();
        this.context.restoreAuthSystemState();
        String collectionXRemoverToken = this.getAuthToken(collectionXRemover.getEmail(), this.password);
        this.getAuthorizationFeatures(collectionXRemoverToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.context.turnOffAuthorisationSystem();
        EPerson item1Deleter = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("item1Deleter@my.edu").withPassword(this.password).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)item1Deleter, null).withDspaceObject((DSpaceObject)this.item1).withAction(2).build();
        this.context.restoreAuthSystemState();
        String item1DeleterToken = this.getAuthToken(item1Deleter.getEmail(), this.password);
        this.getAuthorizationFeatures(item1DeleterToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.context.turnOffAuthorisationSystem();
        EPerson collectionXRemoverItem1Deleter = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("collectionXDeleter@my.edu").withPassword(this.password).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)collectionXRemoverItem1Deleter, null).withDspaceObject((DSpaceObject)this.collectionX).withAction(4).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)collectionXRemoverItem1Deleter, null).withDspaceObject((DSpaceObject)this.item1).withAction(2).build();
        this.context.restoreAuthSystemState();
        String collectionXRemoverItem1DeleterToken = this.getAuthToken(collectionXRemoverItem1Deleter.getEmail(), this.password);
        this.getAuthorizationFeatures(collectionXRemoverItem1DeleterToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(collectionXRemoverItem1DeleterToken, "http://localhost/api/core/collections/" + this.collectionX.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(collectionXRemoverItem1DeleterToken, "http://localhost/api/core/bundles/" + this.bundle1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.context.turnOffAuthorisationSystem();
        EPerson item1Remover = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("item1Remover@my.edu").withPassword(this.password).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)item1Remover, null).withDspaceObject((DSpaceObject)this.item1).withAction(4).build();
        this.context.restoreAuthSystemState();
        String item1RemoverToken = this.getAuthToken(item1Remover.getEmail(), this.password);
        this.getAuthorizationFeatures(item1RemoverToken, "http://localhost/api/core/bundles/" + this.bundle1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(item1RemoverToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(item1RemoverToken, "http://localhost/api/core/bitstreams/" + this.bitstream1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.context.turnOffAuthorisationSystem();
        EPerson bundle1Remover = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("bundle1Remover@my.edu").withPassword(this.password).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)bundle1Remover, null).withDspaceObject((DSpaceObject)this.bundle1).withAction(4).build();
        this.context.restoreAuthSystemState();
        String bundle1RemoverToken = this.getAuthToken(bundle1Remover.getEmail(), this.password);
        this.getAuthorizationFeatures(bundle1RemoverToken, "http://localhost/api/core/bitstreams/" + this.bitstream1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.context.turnOffAuthorisationSystem();
        EPerson bundle1item1Remover = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("bundle1item1Remover@my.edu").withPassword(this.password).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)bundle1item1Remover, null).withDspaceObject((DSpaceObject)this.bundle1).withAction(4).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)bundle1item1Remover, null).withDspaceObject((DSpaceObject)this.item1).withAction(4).build();
        this.context.restoreAuthSystemState();
        String bundle1item1RemoverToken = this.getAuthToken(bundle1item1Remover.getEmail(), this.password);
        this.getAuthorizationFeatures(bundle1item1RemoverToken, "http://localhost/api/core/bitstreams/" + this.bitstream1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testCanReorderBitstreamsAdmin() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String communityAAdminToken = this.getAuthToken(this.communityAAdmin.getEmail(), this.password);
        String collectionXAdminToken = this.getAuthToken(this.collectionXAdmin.getEmail(), this.password);
        String item1AdminToken = this.getAuthToken(this.item1Admin.getEmail(), this.password);
        String feature = "canReorderBitstreams";
        this.getAuthorizationFeatures(adminToken, "http://localhost/api/core/bundles/" + this.bundle1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canReorderBitstreams')]", (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(communityAAdminToken, "http://localhost/api/core/bundles/" + this.bundle1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canReorderBitstreams')]", (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(collectionXAdminToken, "http://localhost/api/core/bundles/" + this.bundle1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canReorderBitstreams')]", (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(item1AdminToken, "http://localhost/api/core/bundles/" + this.bundle1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canReorderBitstreams')]", (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(communityAAdminToken, "http://localhost/api/core/bundles/" + this.bundle2.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canReorderBitstreams')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testCanReorderBitstreamsWriter() throws Exception {
        String communityAWriterToken = this.getAuthToken(this.communityAWriter.getEmail(), this.password);
        String collectionXWriterToken = this.getAuthToken(this.collectionXWriter.getEmail(), this.password);
        String item1WriterToken = this.getAuthToken(this.item1Writer.getEmail(), this.password);
        String feature = "canReorderBitstreams";
        this.getAuthorizationFeatures(communityAWriterToken, "http://localhost/api/core/bundles/" + this.bundle1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canReorderBitstreams')]", (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(collectionXWriterToken, "http://localhost/api/core/bundles/" + this.bundle1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canReorderBitstreams')]", (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(item1WriterToken, "http://localhost/api/core/bundles/" + this.bundle1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canReorderBitstreams')]", (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(communityAWriterToken, "http://localhost/api/core/bundles/" + this.bundle1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canReorderBitstreams')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testCanCreateBitstreamAdmin() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String communityAAdminToken = this.getAuthToken(this.communityAAdmin.getEmail(), this.password);
        String collectionXAdminToken = this.getAuthToken(this.collectionXAdmin.getEmail(), this.password);
        String item1AdminToken = this.getAuthToken(this.item1Admin.getEmail(), this.password);
        String feature = "canCreateBitstream";
        this.getAuthorizationFeatures(adminToken, "http://localhost/api/core/bundles/" + this.bundle1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canCreateBitstream')]", (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(communityAAdminToken, "http://localhost/api/core/bundles/" + this.bundle1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canCreateBitstream')]", (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(collectionXAdminToken, "http://localhost/api/core/bundles/" + this.bundle1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canCreateBitstream')]", (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(item1AdminToken, "http://localhost/api/core/bundles/" + this.bundle1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canCreateBitstream')]", (Object[])new Object[0]).exists());
        this.getAuthorizationFeatures(communityAAdminToken, "http://localhost/api/core/bundles/" + this.bundle2.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canCreateBitstream')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testCanCreateBitstreamWriter() throws Exception {
        String communityAWriterToken = this.getAuthToken(this.communityAWriter.getEmail(), this.password);
        String collectionXWriterToken = this.getAuthToken(this.collectionXWriter.getEmail(), this.password);
        String item1WriterToken = this.getAuthToken(this.item1Writer.getEmail(), this.password);
        String feature = "canCreateBitstream";
        this.getAuthorizationFeatures(communityAWriterToken, "http://localhost/api/core/bundles/" + this.bundle1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canCreateBitstream')]", (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(collectionXWriterToken, "http://localhost/api/core/bundles/" + this.bundle1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canCreateBitstream')]", (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(item1WriterToken, "http://localhost/api/core/bundles/" + this.bundle1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canCreateBitstream')]", (Object[])new Object[0]).doesNotExist());
        this.context.turnOffAuthorisationSystem();
        EPerson bundle1Writer = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("bundle1Writer@my.edu").withPassword(this.password).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)bundle1Writer, null).withDspaceObject((DSpaceObject)this.bundle1).withAction(1).build();
        this.context.restoreAuthSystemState();
        String bundle1WriterToken = this.getAuthToken(bundle1Writer.getEmail(), this.password);
        this.getAuthorizationFeatures(bundle1WriterToken, "http://localhost/api/core/bundles/" + this.bundle1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canCreateBitstream')]", (Object[])new Object[0]).doesNotExist());
        this.context.turnOffAuthorisationSystem();
        EPerson bundle1Adder = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("bundle1Adder@my.edu").withPassword(this.password).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)bundle1Adder, null).withDspaceObject((DSpaceObject)this.bundle1).withAction(3).build();
        this.context.restoreAuthSystemState();
        String bundle1AdderToken = this.getAuthToken(bundle1Adder.getEmail(), this.password);
        this.getAuthorizationFeatures(bundle1AdderToken, "http://localhost/api/core/bundles/" + this.bundle1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canCreateBitstream')]", (Object[])new Object[0]).doesNotExist());
        this.context.turnOffAuthorisationSystem();
        EPerson bundle1WriterAdder = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("bundle1WriterAdder@my.edu").withPassword(this.password).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)bundle1WriterAdder, null).withDspaceObject((DSpaceObject)this.bundle1).withAction(3).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)bundle1WriterAdder, null).withDspaceObject((DSpaceObject)this.bundle1).withAction(1).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)bundle1WriterAdder, null).withDspaceObject((DSpaceObject)this.item1).withAction(3).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)bundle1WriterAdder, null).withDspaceObject((DSpaceObject)this.item1).withAction(1).build();
        this.context.restoreAuthSystemState();
        String bundle1WriterAdderToken = this.getAuthToken(bundle1WriterAdder.getEmail(), this.password);
        this.getAuthorizationFeatures(bundle1WriterAdderToken, "http://localhost/api/core/bundles/" + this.bundle1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canCreateBitstream')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testCanCreateBundleAdmin() throws Exception {
        this.testAdminsHavePermissionsItem("canCreateBundle");
    }

    @Test
    public void testCanCreateBundleWriter() throws Exception {
        String communityAWriterToken = this.getAuthToken(this.communityAWriter.getEmail(), this.password);
        String collectionXWriterToken = this.getAuthToken(this.collectionXWriter.getEmail(), this.password);
        String item1WriterToken = this.getAuthToken(this.item1Writer.getEmail(), this.password);
        String feature = "canCreateBundle";
        this.getAuthorizationFeatures(communityAWriterToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canCreateBundle')]", (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(collectionXWriterToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canCreateBundle')]", (Object[])new Object[0]).doesNotExist());
        this.getAuthorizationFeatures(item1WriterToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canCreateBundle')]", (Object[])new Object[0]).doesNotExist());
        this.context.turnOffAuthorisationSystem();
        EPerson item1AdderWriter = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("item1AdderWriter@my.edu").withPassword(this.password).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)item1AdderWriter, null).withDspaceObject((DSpaceObject)this.item1).withAction(3).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)item1AdderWriter, null).withDspaceObject((DSpaceObject)this.item1).withAction(1).build();
        this.context.restoreAuthSystemState();
        String item1AdderWriterToken = this.getAuthToken(item1AdderWriter.getEmail(), this.password);
        this.getAuthorizationFeatures(item1AdderWriterToken, "http://localhost/api/core/items/" + this.item1.getID()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canCreateBundle')]", (Object[])new Object[0]).exists());
    }

    private ResultActions getAuthorizationFeatures(String adminToken, String uri) throws Exception {
        return this.getAuthorizationFeatures(adminToken, uri, 100);
    }

    private ResultActions getAuthorizationFeatures(String adminToken, String uri, int size) throws Exception {
        return this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?size=" + size + "&embed=feature&uri=" + uri), (Object[])new Object[0]));
    }
}

