/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization;

import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.service.SiteService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.dspace.services.ConfigurationService;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class ManageGroupsFeatureIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private SiteService siteService;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private GroupService groupService;
    private Community topLevelCommunity;
    private Community subCommunity;
    private Collection collection;
    private EPerson communityAdmin;
    private EPerson subCommunityAdmin;
    private EPerson collectionAdmin;
    private EPerson submitter;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.communityAdmin = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("communityAdmin@my.edu").withPassword(this.password).build();
        this.topLevelCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("topLevelCommunity").withAdminGroup(new EPerson[]{this.communityAdmin}).build();
        this.subCommunityAdmin = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("subCommunityAdmin@my.edu").withPassword(this.password).build();
        this.subCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("subCommunity").withAdminGroup(new EPerson[]{this.subCommunityAdmin}).addParentCommunity(this.context, this.topLevelCommunity).build();
        this.submitter = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("submitter@my.edu").withPassword(this.password).build();
        this.collectionAdmin = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("collectionAdmin@my.edu").withPassword(this.password).build();
        this.collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.subCommunity).withName("collection").withAdminGroup(new EPerson[]{this.collectionAdmin}).withSubmitterGroup(new EPerson[]{this.submitter}).build();
        this.context.restoreAuthSystemState();
        this.configurationService.setProperty("org.dspace.app.rest.authorization.AlwaysThrowExceptionFeature.turnoff", (Object)"true");
    }

    @Test
    public void testAdmin() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testCommunityAdmin() throws Exception {
        String token = this.getAuthToken(this.communityAdmin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubCommunityAdmin() throws Exception {
        String token = this.getAuthToken(this.subCommunityAdmin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testCollectionAdmin() throws Exception {
        String token = this.getAuthToken(this.collectionAdmin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubmitter() throws Exception {
        String token = this.getAuthToken(this.submitter.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubGroupOfAdminGroup() throws Exception {
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("userGroup").withParent(this.groupService.findByName(this.context, "Administrator")).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubGroupOfCommunityAdminGroup() throws Exception {
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("userGroup").withParent(this.groupService.findByName(this.context, "COMMUNITY_" + this.topLevelCommunity.getID() + "_ADMIN")).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubGroupOfSubCommunityAdminGroup() throws Exception {
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("userGroup").withParent(this.groupService.findByName(this.context, "COMMUNITY_" + this.subCommunity.getID() + "_ADMIN")).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubGroupOfCollectionAdminGroup() throws Exception {
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("userGroup").withParent(this.groupService.findByName(this.context, "COLLECTION_" + this.collection.getID() + "_ADMIN")).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubGroupOfSubmitterGroup() throws Exception {
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("userGroup").withParent(this.groupService.findByName(this.context, "COLLECTION_" + this.collection.getID() + "_SUBMIT")).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubSubGroupOfAdminGroup() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group groupB = GroupBuilder.createGroup((Context)this.context).withName("GroupB").withParent(this.groupService.findByName(this.context, "Administrator")).build();
        GroupBuilder.createGroup((Context)this.context).withName("GroupA").withParent(groupB).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubSubGroupOfCommunityAdminGroup() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group groupB = GroupBuilder.createGroup((Context)this.context).withName("GroupB").withParent(this.groupService.findByName(this.context, "COMMUNITY_" + this.topLevelCommunity.getID() + "_ADMIN")).build();
        GroupBuilder.createGroup((Context)this.context).withName("GroupA").withParent(groupB).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubSubGroupOfSubCommunityAdminGroup() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group groupB = GroupBuilder.createGroup((Context)this.context).withName("GroupB").withParent(this.groupService.findByName(this.context, "COMMUNITY_" + this.subCommunity.getID() + "_ADMIN")).build();
        GroupBuilder.createGroup((Context)this.context).withName("GroupA").withParent(groupB).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubSubGroupOfCollectionAdminGroup() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group groupB = GroupBuilder.createGroup((Context)this.context).withName("GroupB").withParent(this.groupService.findByName(this.context, "COLLECTION_" + this.collection.getID() + "_ADMIN")).build();
        GroupBuilder.createGroup((Context)this.context).withName("GroupA").withParent(groupB).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubSubGroupOfSubmitterGroup() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group groupB = GroupBuilder.createGroup((Context)this.context).withName("GroupB").withParent(this.groupService.findByName(this.context, "COLLECTION_" + this.collection.getID() + "_SUBMIT")).build();
        GroupBuilder.createGroup((Context)this.context).withName("GroupA").withParent(groupB).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testAdminNoCommunityGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.admin-group", (Object)"false");
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testCommunityAdminNoCommunityGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.admin-group", (Object)"false");
        String token = this.getAuthToken(this.communityAdmin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubCommunityAdminNoCommunityGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.admin-group", (Object)"false");
        String token = this.getAuthToken(this.subCommunityAdmin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testCollectionAdminNoCommunityGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.admin-group", (Object)"false");
        String token = this.getAuthToken(this.collectionAdmin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubmitterNoCommunityGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.admin-group", (Object)"false");
        String token = this.getAuthToken(this.submitter.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubGroupOfAdminGroupNoCommunityGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.admin-group", (Object)"false");
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("userGroup").withParent(this.groupService.findByName(this.context, "Administrator")).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubGroupOfCommunityAdminGroupNoCommunityGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.admin-group", (Object)"false");
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("userGroup").withParent(this.groupService.findByName(this.context, "COMMUNITY_" + this.topLevelCommunity.getID() + "_ADMIN")).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubGroupOfSubCommunityAdminGroupNoCommunityGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.admin-group", (Object)"false");
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("userGroup").withParent(this.groupService.findByName(this.context, "COMMUNITY_" + this.subCommunity.getID() + "_ADMIN")).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubGroupOfCollectionAdminGroupNoCommunityGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.admin-group", (Object)"false");
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("userGroup").withParent(this.groupService.findByName(this.context, "COLLECTION_" + this.collection.getID() + "_ADMIN")).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubGroupOfSubmitterGroupNoCommunityGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.admin-group", (Object)"false");
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("userGroup").withParent(this.groupService.findByName(this.context, "COLLECTION_" + this.collection.getID() + "_SUBMIT")).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubSubGroupOfAdminGroupNoCommunityGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.admin-group", (Object)"false");
        this.context.turnOffAuthorisationSystem();
        Group groupB = GroupBuilder.createGroup((Context)this.context).withName("GroupB").withParent(this.groupService.findByName(this.context, "Administrator")).build();
        GroupBuilder.createGroup((Context)this.context).withName("GroupA").withParent(groupB).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubSubGroupOfCommunityAdminGroupNoCommunityGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.admin-group", (Object)"false");
        this.context.turnOffAuthorisationSystem();
        Group groupB = GroupBuilder.createGroup((Context)this.context).withName("GroupB").withParent(this.groupService.findByName(this.context, "COMMUNITY_" + this.topLevelCommunity.getID() + "_ADMIN")).build();
        GroupBuilder.createGroup((Context)this.context).withName("GroupA").withParent(groupB).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubSubGroupOfSubCommunityAdminGroupNoCommunityGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.admin-group", (Object)"false");
        this.context.turnOffAuthorisationSystem();
        Group groupB = GroupBuilder.createGroup((Context)this.context).withName("GroupB").withParent(this.groupService.findByName(this.context, "COMMUNITY_" + this.subCommunity.getID() + "_ADMIN")).build();
        GroupBuilder.createGroup((Context)this.context).withName("GroupA").withParent(groupB).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubSubGroupOfCollectionAdminGroupNoCommunityGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.admin-group", (Object)"false");
        this.context.turnOffAuthorisationSystem();
        Group groupB = GroupBuilder.createGroup((Context)this.context).withName("GroupB").withParent(this.groupService.findByName(this.context, "COLLECTION_" + this.collection.getID() + "_ADMIN")).build();
        GroupBuilder.createGroup((Context)this.context).withName("GroupA").withParent(groupB).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubSubGroupOfSubmitterGroupNoCommunityGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.admin-group", (Object)"false");
        this.context.turnOffAuthorisationSystem();
        Group groupB = GroupBuilder.createGroup((Context)this.context).withName("GroupB").withParent(this.groupService.findByName(this.context, "COLLECTION_" + this.collection.getID() + "_SUBMIT")).build();
        GroupBuilder.createGroup((Context)this.context).withName("GroupA").withParent(groupB).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testAdminNoCollectionGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.collection.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.submitters", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.workflows", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)"false");
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testCommunityAdminNoCollectionGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.collection.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.submitters", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.workflows", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)"false");
        String token = this.getAuthToken(this.communityAdmin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubCommunityAdminNoCollectionGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.collection.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.submitters", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.workflows", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)"false");
        String token = this.getAuthToken(this.subCommunityAdmin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testCollectionAdminNoCollectionGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.collection.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.submitters", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.workflows", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)"false");
        String token = this.getAuthToken(this.collectionAdmin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubmitterNoCollectionGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.collection.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.submitters", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.workflows", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)"false");
        String token = this.getAuthToken(this.submitter.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubGroupOfAdminGroupNoCollectionGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.collection.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.submitters", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.workflows", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)"false");
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("userGroup").withParent(this.groupService.findByName(this.context, "Administrator")).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubGroupOfCommunityAdminGroupNoCollectionGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.collection.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.submitters", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.workflows", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)"false");
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("userGroup").withParent(this.groupService.findByName(this.context, "COMMUNITY_" + this.topLevelCommunity.getID() + "_ADMIN")).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubGroupOfSubCommunityAdminGroupNoCollectionGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.collection.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.submitters", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.workflows", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)"false");
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("userGroup").withParent(this.groupService.findByName(this.context, "COMMUNITY_" + this.subCommunity.getID() + "_ADMIN")).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubGroupOfCollectionAdminGroupNoCollectionGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.collection.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.submitters", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.workflows", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)"false");
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("userGroup").withParent(this.groupService.findByName(this.context, "COLLECTION_" + this.collection.getID() + "_ADMIN")).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubGroupOfSubmitterGroupNoCollectionGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.collection.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.submitters", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.workflows", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)"false");
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("userGroup").withParent(this.groupService.findByName(this.context, "COLLECTION_" + this.collection.getID() + "_SUBMIT")).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubSubGroupOfAdminGroupNoCollectionGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.collection.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.submitters", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.workflows", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)"false");
        this.context.turnOffAuthorisationSystem();
        Group groupB = GroupBuilder.createGroup((Context)this.context).withName("GroupB").withParent(this.groupService.findByName(this.context, "Administrator")).build();
        GroupBuilder.createGroup((Context)this.context).withName("GroupA").withParent(groupB).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubSubGroupOfCommunityAdminGroupNoCollectionGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.collection.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.submitters", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.workflows", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)"false");
        this.context.turnOffAuthorisationSystem();
        Group groupB = GroupBuilder.createGroup((Context)this.context).withName("GroupB").withParent(this.groupService.findByName(this.context, "COMMUNITY_" + this.topLevelCommunity.getID() + "_ADMIN")).build();
        GroupBuilder.createGroup((Context)this.context).withName("GroupA").withParent(groupB).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubSubGroupOfSubCommunityAdminGroupNoCollectionGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.collection.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.submitters", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.workflows", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)"false");
        this.context.turnOffAuthorisationSystem();
        Group groupB = GroupBuilder.createGroup((Context)this.context).withName("GroupB").withParent(this.groupService.findByName(this.context, "COMMUNITY_" + this.subCommunity.getID() + "_ADMIN")).build();
        GroupBuilder.createGroup((Context)this.context).withName("GroupA").withParent(groupB).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubSubGroupOfCollectionAdminGroupNoCollectionGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.collection.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.submitters", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.workflows", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)"false");
        this.context.turnOffAuthorisationSystem();
        Group groupB = GroupBuilder.createGroup((Context)this.context).withName("GroupB").withParent(this.groupService.findByName(this.context, "COLLECTION_" + this.collection.getID() + "_ADMIN")).build();
        GroupBuilder.createGroup((Context)this.context).withName("GroupA").withParent(groupB).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubSubGroupOfSubmitterGroupNoCollectionGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.collection.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.submitters", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.workflows", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)"false");
        this.context.turnOffAuthorisationSystem();
        Group groupB = GroupBuilder.createGroup((Context)this.context).withName("GroupB").withParent(this.groupService.findByName(this.context, "COLLECTION_" + this.collection.getID() + "_SUBMIT")).build();
        GroupBuilder.createGroup((Context)this.context).withName("GroupA").withParent(groupB).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testAdminNoComColGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.admin-group", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.submitters", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.workflows", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)"false");
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testCommunityAdminNoComColGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.admin-group", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.submitters", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.workflows", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)"false");
        String token = this.getAuthToken(this.communityAdmin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubCommunityAdminNoComColGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.admin-group", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.submitters", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.workflows", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)"false");
        String token = this.getAuthToken(this.subCommunityAdmin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testCollectionAdminNoComColGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.admin-group", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.submitters", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.workflows", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)"false");
        String token = this.getAuthToken(this.collectionAdmin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubmitterNoComColGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.admin-group", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.submitters", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.workflows", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)"false");
        String token = this.getAuthToken(this.submitter.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubGroupOfAdminGroupNoComColGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.admin-group", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.submitters", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.workflows", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)"false");
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("userGroup").withParent(this.groupService.findByName(this.context, "Administrator")).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubGroupOfCommunityAdminGroupNoComColGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.admin-group", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.submitters", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.workflows", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)"false");
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("userGroup").withParent(this.groupService.findByName(this.context, "COMMUNITY_" + this.topLevelCommunity.getID() + "_ADMIN")).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubGroupOfSubCommunityAdminGroupNoComColGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.admin-group", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.submitters", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.workflows", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)"false");
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("userGroup").withParent(this.groupService.findByName(this.context, "COMMUNITY_" + this.subCommunity.getID() + "_ADMIN")).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubGroupOfCollectionAdminGroupNoComColGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.admin-group", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.submitters", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.workflows", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)"false");
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("userGroup").withParent(this.groupService.findByName(this.context, "COLLECTION_" + this.collection.getID() + "_ADMIN")).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubGroupOfSubmitterGroupNoComColGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.admin-group", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.submitters", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.workflows", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)"false");
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("userGroup").withParent(this.groupService.findByName(this.context, "COLLECTION_" + this.collection.getID() + "_SUBMIT")).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubSubGroupOfAdminGroupNoComColGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.admin-group", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.submitters", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.workflows", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)"false");
        this.context.turnOffAuthorisationSystem();
        Group groupB = GroupBuilder.createGroup((Context)this.context).withName("GroupB").withParent(this.groupService.findByName(this.context, "Administrator")).build();
        GroupBuilder.createGroup((Context)this.context).withName("GroupA").withParent(groupB).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testSubSubGroupOfCommunityAdminGroupNoComColGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.admin-group", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.submitters", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.workflows", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)"false");
        this.context.turnOffAuthorisationSystem();
        Group groupB = GroupBuilder.createGroup((Context)this.context).withName("GroupB").withParent(this.groupService.findByName(this.context, "COMMUNITY_" + this.topLevelCommunity.getID() + "_ADMIN")).build();
        GroupBuilder.createGroup((Context)this.context).withName("GroupA").withParent(groupB).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubSubGroupOfSubCommunityAdminGroupNoComColGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.admin-group", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.submitters", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.workflows", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)"false");
        this.context.turnOffAuthorisationSystem();
        Group groupB = GroupBuilder.createGroup((Context)this.context).withName("GroupB").withParent(this.groupService.findByName(this.context, "COMMUNITY_" + this.subCommunity.getID() + "_ADMIN")).build();
        GroupBuilder.createGroup((Context)this.context).withName("GroupA").withParent(groupB).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubSubGroupOfCollectionAdminGroupNoComColGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.admin-group", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.submitters", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.workflows", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)"false");
        this.context.turnOffAuthorisationSystem();
        Group groupB = GroupBuilder.createGroup((Context)this.context).withName("GroupB").withParent(this.groupService.findByName(this.context, "COLLECTION_" + this.collection.getID() + "_ADMIN")).build();
        GroupBuilder.createGroup((Context)this.context).withName("GroupA").withParent(groupB).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubSubGroupOfSubmitterGroupNoComColGroupPermission() throws Exception {
        this.configurationService.setProperty("core.authorization.community-admin.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.admin-group", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.policies", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.submitters", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.workflows", (Object)"false");
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)"false");
        this.context.turnOffAuthorisationSystem();
        Group groupB = GroupBuilder.createGroup((Context)this.context).withName("GroupB").withParent(this.groupService.findByName(this.context, "COLLECTION_" + this.collection.getID() + "_SUBMIT")).build();
        GroupBuilder.createGroup((Context)this.context).withName("GroupA").withParent(groupB).addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + this.siteService.findSite(this.context).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canManageGroups')]", (Object[])new Object[0]).doesNotExist());
    }
}

