/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.util.LinkedList;
import junit.framework.TestCase;
import org.dspace.app.rest.converter.DiscoverConfigurationConverter;
import org.dspace.app.rest.model.SearchConfigurationRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoverySearchFilter;
import org.dspace.discovery.configuration.DiscoverySortConfiguration;
import org.dspace.discovery.configuration.DiscoverySortFieldConfiguration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DiscoverConfigurationConverterTest {
    SearchConfigurationRest searchConfigurationRest;
    @InjectMocks
    private DiscoverConfigurationConverter discoverConfigurationConverter;
    @Mock
    private DiscoverySortConfiguration discoverySortConfiguration;
    @Mock
    private DiscoveryConfiguration discoveryConfiguration;

    @Before
    public void setUp() throws Exception {
    }

    public void populateDiscoveryConfigurationWithEmptyList() {
        this.discoveryConfiguration.setSearchFilters(new LinkedList());
        this.discoveryConfiguration.setSearchSortConfiguration(new DiscoverySortConfiguration());
    }

    @Test
    public void testReturnType() throws Exception {
        this.populateDiscoveryConfigurationWithEmptyList();
        this.searchConfigurationRest = this.discoverConfigurationConverter.convert(this.discoveryConfiguration, Projection.DEFAULT);
        Assert.assertTrue((boolean)this.searchConfigurationRest.getFilters().isEmpty());
        Assert.assertEquals(SearchConfigurationRest.class, this.searchConfigurationRest.getClass());
    }

    @Test
    public void testConvertWithNullParamter() throws Exception {
        Assert.assertNotNull((Object)this.discoverConfigurationConverter.convert(null, Projection.DEFAULT));
    }

    @Test
    public void testNoSearchSortConfigurationReturnObjectNotNull() throws Exception {
        this.discoveryConfiguration.setSearchFilters(new LinkedList());
        this.searchConfigurationRest = this.discoverConfigurationConverter.convert(this.discoveryConfiguration, Projection.DEFAULT);
        Assert.assertTrue((boolean)this.discoveryConfiguration.getSearchFilters().isEmpty());
        Assert.assertTrue((boolean)this.searchConfigurationRest.getFilters().isEmpty());
        Assert.assertNotNull((Object)this.searchConfigurationRest);
    }

    @Test
    public void testNoSearchFilterReturnObjectNotNull() throws Exception {
        this.discoveryConfiguration.setSearchSortConfiguration(new DiscoverySortConfiguration());
        this.searchConfigurationRest = this.discoverConfigurationConverter.convert(this.discoveryConfiguration, Projection.DEFAULT);
        Assert.assertTrue((boolean)this.searchConfigurationRest.getFilters().isEmpty());
        Assert.assertNotNull((Object)this.searchConfigurationRest);
    }

    @Test
    public void testNoSearchSortConfigurationAndNoSearchFilterReturnObjectNotNull() throws Exception {
        this.searchConfigurationRest = this.discoverConfigurationConverter.convert(this.discoveryConfiguration, Projection.DEFAULT);
        Assert.assertNotNull((Object)this.searchConfigurationRest);
    }

    @Test
    public void testCorrectSortOptionsAfterConvert() throws Exception {
        this.populateDiscoveryConfigurationWithEmptyList();
        DiscoverySortFieldConfiguration discoverySortFieldConfiguration = new DiscoverySortFieldConfiguration();
        discoverySortFieldConfiguration.setMetadataField("title");
        discoverySortFieldConfiguration.setType("text");
        discoverySortFieldConfiguration.setDefaultSortOrder(DiscoverySortFieldConfiguration.SORT_ORDER.asc);
        DiscoverySortFieldConfiguration discoverySortFieldConfiguration1 = new DiscoverySortFieldConfiguration();
        discoverySortFieldConfiguration1.setMetadataField("author");
        discoverySortFieldConfiguration1.setType("text");
        discoverySortFieldConfiguration1.setDefaultSortOrder(DiscoverySortFieldConfiguration.SORT_ORDER.asc);
        LinkedList<DiscoverySortFieldConfiguration> mockedList = new LinkedList<DiscoverySortFieldConfiguration>();
        mockedList.add(discoverySortFieldConfiguration);
        mockedList.add(discoverySortFieldConfiguration1);
        Mockito.when((Object)this.discoveryConfiguration.getSearchSortConfiguration()).thenReturn((Object)this.discoverySortConfiguration);
        Mockito.when((Object)this.discoverySortConfiguration.getSortFields()).thenReturn(mockedList);
        this.searchConfigurationRest = this.discoverConfigurationConverter.convert(this.discoveryConfiguration, Projection.DEFAULT);
        int counter = 0;
        for (SearchConfigurationRest.SortOption sortOption : this.searchConfigurationRest.getSortOptions()) {
            Assert.assertEquals((Object)((DiscoverySortFieldConfiguration)mockedList.get(counter)).getMetadataField(), (Object)sortOption.getName());
            Assert.assertEquals((Object)((DiscoverySortFieldConfiguration)mockedList.get(counter)).getType(), (Object)sortOption.getActualName());
            ++counter;
        }
        TestCase.assertFalse((boolean)this.searchConfigurationRest.getSortOptions().isEmpty());
    }

    @Test
    public void testEmptySortOptionsAfterConvertWithConfigurationWithEmptySortFields() throws Exception {
        this.populateDiscoveryConfigurationWithEmptyList();
        this.searchConfigurationRest = this.discoverConfigurationConverter.convert(this.discoveryConfiguration, Projection.DEFAULT);
        Assert.assertEquals((long)0L, (long)this.searchConfigurationRest.getSortOptions().size());
    }

    @Test
    public void testEmptySortOptionsAfterConvertWithConfigurationWithNullSortFields() throws Exception {
        this.populateDiscoveryConfigurationWithEmptyList();
        Mockito.when((Object)this.discoveryConfiguration.getSearchSortConfiguration()).thenReturn(null);
        this.searchConfigurationRest = this.discoverConfigurationConverter.convert(this.discoveryConfiguration, Projection.DEFAULT);
        Assert.assertEquals((long)0L, (long)this.searchConfigurationRest.getSortOptions().size());
    }

    @Test
    public void testCorrectSearchFiltersAfterConvert() throws Exception {
        this.populateDiscoveryConfigurationWithEmptyList();
        LinkedList<DiscoverySearchFilter> mockedList = new LinkedList<DiscoverySearchFilter>();
        DiscoverySearchFilter discoverySearchFilter = new DiscoverySearchFilter();
        discoverySearchFilter.setIndexFieldName("title");
        DiscoverySearchFilter discoverySearchFilter1 = new DiscoverySearchFilter();
        discoverySearchFilter1.setIndexFieldName("title2");
        mockedList.add(discoverySearchFilter);
        mockedList.add(discoverySearchFilter1);
        Mockito.when((Object)this.discoveryConfiguration.getSearchFilters()).thenReturn(mockedList);
        this.searchConfigurationRest = this.discoverConfigurationConverter.convert(this.discoveryConfiguration, Projection.DEFAULT);
        int counter = 0;
        for (SearchConfigurationRest.Filter filter : this.searchConfigurationRest.getFilters()) {
            DiscoverySearchFilter searchFilter = (DiscoverySearchFilter)mockedList.get(counter);
            Assert.assertEquals((Object)searchFilter.getIndexFieldName(), (Object)filter.getFilter());
            SearchConfigurationRest.Filter.Operator operator = new SearchConfigurationRest.Filter.Operator("testing");
            filter.addOperator(operator);
            Assert.assertEquals(filter.getOperators().get(filter.getOperators().size() - 1), (Object)operator);
            ++counter;
        }
        Assert.assertTrue((!this.searchConfigurationRest.getFilters().isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testEmptySearchFilterAfterConvertWithConfigurationWithEmptySearchFilters() throws Exception {
        this.populateDiscoveryConfigurationWithEmptyList();
        this.searchConfigurationRest = this.discoverConfigurationConverter.convert(this.discoveryConfiguration, Projection.DEFAULT);
        Assert.assertEquals((long)0L, (long)this.searchConfigurationRest.getFilters().size());
    }

    @Test
    public void testEmptySearchFiltersAfterConvertWithConfigurationWithNullSearchFilters() throws Exception {
        this.populateDiscoveryConfigurationWithEmptyList();
        Mockito.when((Object)this.discoveryConfiguration.getSearchFilters()).thenReturn(null);
        this.searchConfigurationRest = this.discoverConfigurationConverter.convert(this.discoveryConfiguration, Projection.DEFAULT);
        Assert.assertEquals((long)0L, (long)this.searchConfigurationRest.getFilters().size());
    }
}

