/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.csv;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.dspace.app.rest.converter.DSpaceRunnableParameterConverter;
import org.dspace.app.rest.matcher.ProcessMatcher;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.ProcessBuilder;
import org.dspace.content.ProcessStatus;
import org.dspace.scripts.DSpaceCommandLineParameter;
import org.dspace.scripts.Process;
import org.dspace.scripts.ProcessQueryParameterContainer;
import org.dspace.scripts.factory.ScriptServiceFactory;
import org.dspace.scripts.service.ProcessService;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class CsvSearchExportIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private DSpaceRunnableParameterConverter dSpaceRunnableParameterConverter;
    private ProcessService processService = ScriptServiceFactory.getInstance().getProcessService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void exportSearchQueryTest() throws Exception {
        AtomicReference idRef = new AtomicReference();
        ArrayList<DSpaceCommandLineParameter> parameterList = new ArrayList<DSpaceCommandLineParameter>();
        parameterList.add(new DSpaceCommandLineParameter("-q", "subject:subject1"));
        List restparams = parameterList.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        try {
            String token = this.getAuthToken(this.admin.getEmail(), this.password);
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)"/api/system/scripts/metadata-export-search/processes", (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(restparams)})).andExpect(MockMvcResultMatchers.status().isAccepted()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ProcessMatcher.matchProcess("metadata-export-search", this.admin.getID().toString(), parameterList, ProcessStatus.COMPLETED))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.processId", (Predicate[])new Predicate[0])));
        }
        finally {
            ProcessBuilder.deleteProcess((Integer)((Integer)idRef.get()));
        }
    }

    @Test
    public void exportSearchUnauthorizedTest() throws Exception {
        ArrayList<DSpaceCommandLineParameter> parameterList = new ArrayList<DSpaceCommandLineParameter>();
        parameterList.add(new DSpaceCommandLineParameter("-q", "subject:subject1"));
        List restparams = parameterList.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)"/api/system/scripts/metadata-export-search/processes", (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(restparams)})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void exportSearchForbiddenTest() throws Exception {
        ArrayList<DSpaceCommandLineParameter> parameterList = new ArrayList<DSpaceCommandLineParameter>();
        parameterList.add(new DSpaceCommandLineParameter("-q", "subject:subject1"));
        List restparams = parameterList.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)"/api/system/scripts/metadata-export-search/processes", (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(restparams)})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void exportSearchInvalidQuery() throws Exception {
        AtomicReference idRef = new AtomicReference();
        ArrayList<DSpaceCommandLineParameter> parameterList = new ArrayList<DSpaceCommandLineParameter>();
        parameterList.add(new DSpaceCommandLineParameter("-q", "blabla"));
        List restparams = parameterList.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        try {
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)"/api/system/scripts/metadata-export-search/processes", (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(restparams)})).andExpect(MockMvcResultMatchers.status().isAccepted()).andDo(result -> System.out.println(result.getResponse().getContentAsString())).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.processId", (Predicate[])new Predicate[0])));
        }
        finally {
            ProcessBuilder.deleteProcess((Integer)((Integer)idRef.get()));
        }
    }

    @Test
    public void exportSearchInvalidDiscoveryFacets() throws Exception {
        ArrayList<DSpaceCommandLineParameter> parameterList = new ArrayList<DSpaceCommandLineParameter>();
        parameterList.add(new DSpaceCommandLineParameter("-f", "nonExisting,equals=bla"));
        List restparams = parameterList.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)"/api/system/scripts/metadata-export-search/processes", (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(restparams)})).andExpect(MockMvcResultMatchers.status().isInternalServerError());
        ProcessQueryParameterContainer processQueryParameterContainer = new ProcessQueryParameterContainer();
        processQueryParameterContainer.addToQueryParameterMap("name", (Object)"metadata-export-search");
        processQueryParameterContainer.addToQueryParameterMap("ePerson", (Object)this.admin);
        List processes = this.processService.search(this.context, processQueryParameterContainer, -1, -1);
        for (Process process : processes) {
            ProcessBuilder.deleteProcess((Integer)process.getID());
        }
    }
}

