/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security.jwt;

import com.nimbusds.jwt.JWTClaimsSet;
import jakarta.servlet.http.HttpServletRequest;
import java.util.UUID;
import org.dspace.app.rest.security.jwt.EPersonClaimProvider;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.service.EPersonService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class EPersonClaimProviderTest {
    @InjectMocks
    private EPersonClaimProvider ePersonClaimProvider;
    @Mock
    private EPerson ePerson;
    private Context context;
    @Mock
    private HttpServletRequest httpServletRequest;
    @Mock
    private EPersonService ePersonService;
    private JWTClaimsSet jwtClaimsSet;

    @Before
    public void setUp() throws Exception {
        this.context = (Context)Mockito.mock(Context.class);
        ((Context)Mockito.doCallRealMethod().when((Object)this.context)).setCurrentUser((EPerson)ArgumentMatchers.any(EPerson.class));
        Mockito.when((Object)this.ePerson.getID()).thenReturn((Object)UUID.fromString("c3bae216-a481-496b-a524-7df5aabdb609"));
        this.jwtClaimsSet = new JWTClaimsSet.Builder().claim("eid", (Object)"c3bae216-a481-496b-a524-7df5aabdb609").build();
        Mockito.when((Object)((EPerson)this.ePersonService.find((Context)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(UUID.class)))).thenReturn((Object)this.ePerson);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testParseClaim() throws Exception {
        this.ePersonClaimProvider.parseClaim(this.context, this.httpServletRequest, this.jwtClaimsSet);
        ((Context)Mockito.verify((Object)this.context)).setCurrentUser(this.ePerson);
    }

    @Test
    public void testGetEPerson() throws Exception {
        EPerson parsed = this.ePersonClaimProvider.getEPerson(this.context, this.jwtClaimsSet);
        Assert.assertEquals((Object)parsed.getID(), (Object)UUID.fromString("c3bae216-a481-496b-a524-7df5aabdb609"));
    }
}

