/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.rest.utils.Utils;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/eperson/groups"})
public class GroupRestController {
    @Autowired
    private GroupService groupService;
    @Autowired
    private EPersonService ePersonService;
    @Autowired
    Utils utils;

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    @RequestMapping(method={RequestMethod.POST}, path={"/{uuid}/subgroups"}, consumes={"text/uri-list"})
    public void addChildGroups(@PathVariable UUID uuid, HttpServletResponse response, HttpServletRequest request) throws SQLException, AuthorizeException {
        Context context = ContextUtil.obtainContext(request);
        Group parentGroup = (Group)this.groupService.find(context, uuid);
        if (parentGroup == null) {
            throw new ResourceNotFoundException("parent group is not found for uuid: " + uuid);
        }
        AuthorizeUtil.authorizeManageGroup((Context)context, (Group)parentGroup);
        List<String> groupLinks = this.utils.getStringListFromRequest(request);
        ArrayList<Group> childGroups = new ArrayList<Group>();
        for (String groupLink : groupLinks) {
            Optional<Group> childGroup = this.findGroup(context, groupLink);
            if (!childGroup.isPresent() || !this.canAddGroup(context, parentGroup, childGroup.get())) {
                throw new UnprocessableEntityException("cannot add child group: " + groupLink);
            }
            childGroups.add(childGroup.get());
        }
        for (Group childGroup : childGroups) {
            this.groupService.addMember(context, parentGroup, childGroup);
        }
        this.groupService.update(context, (DSpaceObject)parentGroup);
        context.complete();
        response.setStatus(204);
    }

    private Optional<Group> findGroup(Context context, String groupLink) throws SQLException {
        Group group = null;
        Pattern linkPattern = Pattern.compile("^.*/([0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12})/?$");
        Matcher matcher = linkPattern.matcher(groupLink);
        if (matcher.matches()) {
            group = (Group)this.groupService.find(context, UUID.fromString(matcher.group(1)));
        }
        return Optional.ofNullable(group);
    }

    private boolean canAddGroup(Context context, Group parentGroup, Group childGroup) throws SQLException {
        return !this.groupService.isParentOf(context, childGroup, parentGroup);
    }

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    @RequestMapping(method={RequestMethod.POST}, path={"/{uuid}/epersons"}, consumes={"text/uri-list"})
    public void addMembers(@PathVariable UUID uuid, HttpServletResponse response, HttpServletRequest request) throws SQLException, AuthorizeException {
        Context context = ContextUtil.obtainContext(request);
        Group parentGroup = (Group)this.groupService.find(context, uuid);
        if (parentGroup == null) {
            throw new ResourceNotFoundException("parent group is not found for uuid: " + uuid);
        }
        AuthorizeUtil.authorizeManageGroup((Context)context, (Group)parentGroup);
        List<String> memberLinks = this.utils.getStringListFromRequest(request);
        ArrayList<EPerson> members = new ArrayList<EPerson>();
        for (String memberLink : memberLinks) {
            Optional<EPerson> member = this.findEPerson(context, memberLink);
            if (!member.isPresent()) {
                throw new UnprocessableEntityException("cannot add child group: " + memberLink);
            }
            members.add(member.get());
        }
        for (EPerson member : members) {
            this.groupService.addMember(context, parentGroup, member);
        }
        context.complete();
        response.setStatus(204);
    }

    private Optional<EPerson> findEPerson(Context context, String groupLink) throws SQLException {
        EPerson ePerson = null;
        Pattern linkPattern = Pattern.compile("^.*/([0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12})/?$");
        Matcher matcher = linkPattern.matcher(groupLink);
        if (matcher.matches()) {
            ePerson = (EPerson)this.ePersonService.find(context, UUID.fromString(matcher.group(1)));
        }
        return Optional.ofNullable(ePerson);
    }

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    @RequestMapping(method={RequestMethod.DELETE}, path={"/{parentUUID}/subgroups/{childUUID}"})
    public void removeChildGroup(@PathVariable UUID parentUUID, @PathVariable UUID childUUID, HttpServletResponse response, HttpServletRequest request) throws IOException, SQLException, AuthorizeException {
        Context context = ContextUtil.obtainContext(request);
        Group parentGroup = (Group)this.groupService.find(context, parentUUID);
        if (parentGroup == null) {
            throw new ResourceNotFoundException("parent group is not found for uuid: " + parentUUID);
        }
        AuthorizeUtil.authorizeManageGroup((Context)context, (Group)parentGroup);
        Group childGroup = (Group)this.groupService.find(context, childUUID);
        if (childGroup == null) {
            response.sendError(422);
        }
        this.groupService.removeMember(context, parentGroup, childGroup);
        this.groupService.update(context, (DSpaceObject)parentGroup);
        context.complete();
        response.setStatus(204);
    }

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    @RequestMapping(method={RequestMethod.DELETE}, path={"/{parentUUID}/epersons/{memberUUID}"})
    public void removeMember(@PathVariable UUID parentUUID, @PathVariable UUID memberUUID, HttpServletResponse response, HttpServletRequest request) throws IOException, SQLException, AuthorizeException {
        Context context = ContextUtil.obtainContext(request);
        Group parentGroup = (Group)this.groupService.find(context, parentUUID);
        if (parentGroup == null) {
            throw new ResourceNotFoundException("parent group is not found for uuid: " + parentUUID);
        }
        AuthorizeUtil.authorizeManageGroup((Context)context, (Group)parentGroup);
        EPerson childGroup = (EPerson)this.ePersonService.find(context, memberUUID);
        if (childGroup == null) {
            response.sendError(422);
        }
        this.groupService.removeMember(context, parentGroup, childGroup);
        context.complete();
        response.setStatus(204);
    }
}

