/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization.impl;

import java.sql.SQLException;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureDocumentation;
import org.dspace.app.rest.authorization.AuthorizeServiceRestUtil;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.security.DSpaceRestPermission;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AuthorizationFeatureDocumentation(name="canSeeVersions", description="It can be used to verify if the user can view the versions of an Item")
public class CanSeeVersionsFeature
implements AuthorizationFeature {
    public static final String NAME = "canSeeVersions";
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private AuthorizeServiceRestUtil authorizeServiceRestUtil;

    @Override
    public boolean isAuthorized(Context context, BaseObjectRest object) throws SQLException {
        if (object instanceof ItemRest) {
            if (this.configurationService.getBooleanProperty("versioning.item.history.view.admin", false)) {
                return this.authorizeServiceRestUtil.authorizeActionBoolean(context, object, DSpaceRestPermission.ADMIN);
            }
            return this.authorizeServiceRestUtil.authorizeActionBoolean(context, object, DSpaceRestPermission.READ);
        }
        return false;
    }

    @Override
    public String[] getSupportedTypes() {
        return new String[]{"core.item"};
    }
}

