/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization.impl;

import java.sql.SQLException;
import java.util.Objects;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureDocumentation;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AuthorizationFeatureDocumentation(name="canSubscribeDso", description="Used to verify if the given user can subscribe to a DSpace object")
public class CanSubscribeFeature
implements AuthorizationFeature {
    public static final String NAME = "canSubscribeDso";
    @Autowired
    private Utils utils;
    @Autowired
    private AuthorizeService authorizeService;

    @Override
    public boolean isAuthorized(Context context, BaseObjectRest object) throws SQLException {
        if (Objects.isNull(context.getCurrentUser())) {
            return false;
        }
        DSpaceObject dSpaceObject = (DSpaceObject)this.utils.getDSpaceAPIObjectFromRest(context, object);
        return this.authorizeService.authorizeActionBoolean(context, context.getCurrentUser(), dSpaceObject, 0, true);
    }

    @Override
    public String[] getSupportedTypes() {
        return new String[]{"core.community", "core.collection"};
    }
}

