/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.converter.DiscoverFacetsConverter;
import org.dspace.app.rest.converter.IndexableObjectConverter;
import org.dspace.app.rest.converter.SearchFilterToAppliedFilterConverter;
import org.dspace.app.rest.converter.query.SearchQueryConverter;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.model.SearchResultEntryRest;
import org.dspace.app.rest.model.SearchResultsRest;
import org.dspace.app.rest.parameter.SearchFilter;
import org.dspace.app.rest.projection.Projection;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;

@Component
public class DiscoverResultConverter {
    private static final Logger log = LogManager.getLogger();
    @Autowired
    private List<IndexableObjectConverter> converters;
    @Autowired
    protected ConverterService converter;
    @Autowired
    private DiscoverFacetsConverter facetConverter;
    @Autowired
    private SearchFilterToAppliedFilterConverter searchFilterToAppliedFilterConverter;

    public SearchResultsRest convert(Context context, String query, List<String> dsoTypes, String configurationName, String scope, List<SearchFilter> searchFilters, Pageable page, DiscoverResult searchResult, DiscoveryConfiguration configuration, Projection projection) {
        SearchResultsRest resultsRest = new SearchResultsRest();
        resultsRest.setProjection(projection);
        this.setRequestInformation(context, query, dsoTypes, configurationName, scope, searchFilters, page, resultsRest);
        this.addSearchResults(searchResult, resultsRest, projection);
        this.addFacetValues(context, searchResult, resultsRest, configuration, projection);
        resultsRest.setTotalNumberOfResults(searchResult.getTotalSearchResults());
        return resultsRest;
    }

    private void addFacetValues(Context context, DiscoverResult searchResult, SearchResultsRest resultsRest, DiscoveryConfiguration configuration, Projection projection) {
        this.facetConverter.addFacetValues(context, searchResult, resultsRest, configuration, projection);
    }

    private void addSearchResults(DiscoverResult searchResult, SearchResultsRest resultsRest, Projection projection) {
        for (IndexableObject dspaceObject : CollectionUtils.emptyIfNull((Collection)searchResult.getIndexableObjects())) {
            SearchResultEntryRest resultEntry = new SearchResultEntryRest();
            resultEntry.setProjection(projection);
            resultEntry.setIndexableObject(this.convertDSpaceObject(dspaceObject, projection));
            DiscoverResult.IndexableObjectHighlightResult highlightedResults = searchResult.getHighlightedResults(dspaceObject);
            if (highlightedResults != null && MapUtils.isNotEmpty((Map)highlightedResults.getHighlightResults())) {
                for (Map.Entry metadataHighlight : highlightedResults.getHighlightResults().entrySet()) {
                    resultEntry.addHitHighlights((String)metadataHighlight.getKey(), (List)metadataHighlight.getValue());
                }
            }
            resultsRest.addSearchResult(resultEntry);
        }
    }

    private RestAddressableModel convertDSpaceObject(IndexableObject indexableObject, Projection projection) {
        return (RestAddressableModel)this.converter.toRest(indexableObject.getIndexedObject(), projection);
    }

    private void setRequestInformation(Context context, String query, List<String> dsoTypes, String configurationName, String scope, List<SearchFilter> searchFilters, Pageable page, SearchResultsRest resultsRest) {
        resultsRest.setQuery(query);
        resultsRest.setConfiguration(configurationName);
        resultsRest.setDsoTypes(dsoTypes);
        resultsRest.setScope(scope);
        if (page != null && page.getSort() != null && page.getSort().iterator().hasNext()) {
            Sort.Order order = (Sort.Order)page.getSort().iterator().next();
            resultsRest.setSort(order.getProperty(), order.getDirection().name());
        }
        SearchQueryConverter searchQueryConverter = new SearchQueryConverter();
        List<SearchFilter> transformedFilters = searchQueryConverter.convert(searchFilters);
        for (SearchFilter searchFilter : CollectionUtils.emptyIfNull(transformedFilters)) {
            resultsRest.addAppliedFilter(this.searchFilterToAppliedFilterConverter.convertSearchFilter(context, searchFilter));
        }
    }
}

