/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.util.Arrays;
import java.util.List;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.model.PropertyRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="config.properties")
public class ConfigurationRestRepository
extends DSpaceRestRepository<PropertyRest, String> {
    private ConfigurationService configurationService;
    private List<String> exposedProperties;

    @Autowired
    public ConfigurationRestRepository(ConfigurationService configurationService) {
        this.configurationService = configurationService;
        this.exposedProperties = Arrays.asList(configurationService.getArrayProperty("rest.properties.exposed"));
    }

    @Override
    @PreAuthorize(value="permitAll()")
    public PropertyRest findOne(Context context, String property) {
        if (!this.exposedProperties.contains(property) || !this.configurationService.hasProperty(property)) {
            throw new ResourceNotFoundException("No such configuration property: " + property);
        }
        String[] propertyValues = this.configurationService.getArrayProperty(property);
        PropertyRest propertyRest = new PropertyRest();
        propertyRest.setName(property);
        propertyRest.setValues(Arrays.asList(propertyValues));
        return propertyRest;
    }

    @Override
    public Page<PropertyRest> findAll(Context context, Pageable pageable) {
        throw new RepositoryMethodNotImplementedException("No implementation found; Method not allowed", "");
    }

    @Override
    public Class<PropertyRest> getDomainClass() {
        return PropertyRest.class;
    }
}

