/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation;

import java.sql.SQLException;
import org.dspace.app.rest.exception.RESTAuthorizationException;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.orcid.service.OrcidSynchronizationService;
import org.dspace.profile.OrcidProfileDisconnectionMode;
import org.dspace.profile.ResearcherProfile;
import org.dspace.profile.service.ResearcherProfileService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ResearcherProfileRemoveOrcidOperation
extends PatchOperation<ResearcherProfile> {
    private static final String OPERATION_ORCID = "/orcid";
    @Autowired
    private ResearcherProfileService profileService;
    @Autowired
    private OrcidSynchronizationService synchronizationService;
    @Autowired
    private AuthorizeService authorizeService;

    @Override
    public ResearcherProfile perform(Context context, ResearcherProfile profile, Operation operation) throws SQLException {
        this.checkProfileDisconnectionPermissions(context, profile);
        this.synchronizationService.unlinkProfile(context, profile.getItem());
        try {
            return this.profileService.findById(context, profile.getId());
        }
        catch (AuthorizeException e) {
            throw new RESTAuthorizationException(e);
        }
    }

    private void checkProfileDisconnectionPermissions(Context context, ResearcherProfile profile) throws SQLException {
        OrcidProfileDisconnectionMode mode = this.synchronizationService.getDisconnectionMode();
        if (mode == OrcidProfileDisconnectionMode.ADMIN_AND_OWNER) {
            return;
        }
        if (mode == OrcidProfileDisconnectionMode.DISABLED) {
            throw new RESTAuthorizationException("Profile disconnection from ORCID is disabled");
        }
        if (mode == OrcidProfileDisconnectionMode.ONLY_OWNER && this.isNotOwner(context, profile)) {
            throw new RESTAuthorizationException("Only the profile's owner can perform the ORCID disconnection");
        }
        if (mode == OrcidProfileDisconnectionMode.ONLY_ADMIN && this.isNotAdmin(context)) {
            throw new RESTAuthorizationException("Only admins can perform the profile disconnection from ORCID");
        }
    }

    private boolean isNotAdmin(Context context) throws SQLException {
        return !this.authorizeService.isAdmin(context);
    }

    private boolean isNotOwner(Context context, ResearcherProfile profile) {
        EPerson currentUser = context.getCurrentUser();
        return currentUser == null || !currentUser.getID().equals(profile.getId());
    }

    @Override
    public boolean supports(Object objectToMatch, Operation operation) {
        return objectToMatch instanceof ResearcherProfile && operation.getOp().trim().equalsIgnoreCase("remove") && operation.getPath().trim().toLowerCase().startsWith(OPERATION_ORCID);
    }
}

