/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation.ldn;

import java.sql.SQLException;
import java.util.List;
import org.dspace.app.ldn.NotifyServiceEntity;
import org.dspace.app.ldn.NotifyServiceInboundPattern;
import org.dspace.app.ldn.service.NotifyServiceInboundPatternService;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.app.rest.repository.patch.operation.ldn.NotifyServicePatchUtils;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotifyServiceInboundPatternConstraintAddOperation
extends PatchOperation<NotifyServiceEntity> {
    @Autowired
    private NotifyServiceInboundPatternService inboundPatternService;
    @Autowired
    private NotifyServicePatchUtils notifyServicePatchUtils;
    private static final String OPERATION_PATH = "/constraint";

    @Override
    public NotifyServiceEntity perform(Context context, NotifyServiceEntity notifyServiceEntity, Operation operation) {
        this.checkOperationValue(operation.getValue());
        if (this.supports(notifyServiceEntity, operation)) {
            try {
                int index = this.notifyServicePatchUtils.extractIndexFromOperation(operation);
                List inboundPatterns = notifyServiceEntity.getInboundPatterns();
                if (index >= inboundPatterns.size()) {
                    throw new DSpaceBadRequestException("the provided index[" + index + "] is out of the rang");
                }
                NotifyServiceInboundPattern inboundPattern = (NotifyServiceInboundPattern)inboundPatterns.get(index);
                Object constraint = operation.getValue();
                if (constraint == null | !(constraint instanceof String)) {
                    throw new UnprocessableEntityException("The /constraint value must be a string");
                }
                this.checkNonExistingConstraintValue(inboundPattern);
                inboundPattern.setConstraint((String)constraint);
                this.inboundPatternService.update(context, inboundPattern);
            }
            catch (SQLException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return notifyServiceEntity;
        }
        throw new DSpaceBadRequestException("NotifyServiceInboundPatternConstraintAddOperation does not support this operation");
    }

    private void checkNonExistingConstraintValue(NotifyServiceInboundPattern inboundPattern) {
        if (inboundPattern.getConstraint() != null) {
            throw new DSpaceBadRequestException("Attempting to add a value to an already existing path.");
        }
    }

    @Override
    public boolean supports(Object objectToMatch, Operation operation) {
        String path = operation.getPath().trim();
        return objectToMatch instanceof NotifyServiceEntity && operation.getOp().trim().equalsIgnoreCase("add") && path.startsWith("notifyServiceInboundPatterns[") && path.endsWith(OPERATION_PATH);
    }
}

