/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation.ldn;

import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.ldn.NotifyServiceEntity;
import org.dspace.app.ldn.NotifyServiceInboundPattern;
import org.dspace.app.ldn.service.NotifyServiceInboundPatternService;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.app.rest.repository.patch.operation.ldn.NotifyServicePatchUtils;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotifyServiceInboundPatternsAddOperation
extends PatchOperation<NotifyServiceEntity> {
    @Autowired
    private NotifyServiceInboundPatternService inboundPatternService;
    @Autowired
    private NotifyServicePatchUtils notifyServicePatchUtils;
    private static final String OPERATION_PATH = "notifyServiceInboundPatterns/-";

    @Override
    public NotifyServiceEntity perform(Context context, NotifyServiceEntity notifyServiceEntity, Operation operation) {
        this.checkOperationValue(operation.getValue());
        if (this.supports(notifyServiceEntity, operation)) {
            try {
                NotifyServiceInboundPattern patchInboundPattern = this.notifyServicePatchUtils.extractNotifyServiceInboundPatternFromOperation(operation);
                NotifyServiceInboundPattern persistInboundPattern = this.inboundPatternService.findByServiceAndPattern(context, notifyServiceEntity, patchInboundPattern.getPattern());
                if (persistInboundPattern != null && StringUtils.isNotBlank((CharSequence)persistInboundPattern.getConstraint()) && persistInboundPattern.getConstraint().equals(patchInboundPattern.getConstraint())) {
                    throw new DSpaceBadRequestException("the provided InboundPattern is already existed");
                }
                NotifyServiceInboundPattern inboundPattern = this.inboundPatternService.create(context, notifyServiceEntity);
                inboundPattern.setPattern(patchInboundPattern.getPattern());
                inboundPattern.setConstraint(patchInboundPattern.getConstraint());
                inboundPattern.setAutomatic(patchInboundPattern.isAutomatic());
            }
            catch (SQLException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return notifyServiceEntity;
        }
        throw new DSpaceBadRequestException("NotifyServiceInboundPatternsAddOperation does not support this operation");
    }

    @Override
    public boolean supports(Object objectToMatch, Operation operation) {
        return objectToMatch instanceof NotifyServiceEntity && operation.getOp().trim().equalsIgnoreCase("add") && operation.getPath().trim().equalsIgnoreCase(OPERATION_PATH);
    }
}

