/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation.ldn;

import java.math.BigDecimal;
import java.sql.SQLException;
import org.dspace.app.ldn.NotifyServiceEntity;
import org.dspace.app.ldn.service.NotifyService;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotifyServiceScoreReplaceOperation
extends PatchOperation<NotifyServiceEntity> {
    @Autowired
    private NotifyService notifyService;
    private static final String OPERATION_PATH = "/score";

    @Override
    public NotifyServiceEntity perform(Context context, NotifyServiceEntity notifyServiceEntity, Operation operation) throws SQLException {
        this.checkOperationValue(operation.getValue());
        Object score = operation.getValue();
        if (score == null) {
            throw new DSpaceBadRequestException("The /score value must be a decimal number");
        }
        BigDecimal scoreBigDecimal = null;
        try {
            scoreBigDecimal = new BigDecimal(score.toString());
        }
        catch (Exception e) {
            throw new DSpaceBadRequestException(String.format("Score out of range [0, 1] %s", score));
        }
        if (scoreBigDecimal.compareTo(BigDecimal.ZERO) == -1 || scoreBigDecimal.compareTo(BigDecimal.ONE) == 1) {
            throw new UnprocessableEntityException(String.format("Score out of range [0, 1] %s", score));
        }
        this.checkModelForExistingValue(notifyServiceEntity);
        notifyServiceEntity.setScore(new BigDecimal((String)score));
        this.notifyService.update(context, notifyServiceEntity);
        return notifyServiceEntity;
    }

    private void checkModelForExistingValue(NotifyServiceEntity notifyServiceEntity) {
        if (notifyServiceEntity.getDescription() == null) {
            throw new DSpaceBadRequestException("Attempting to replace a non-existent value (description).");
        }
    }

    @Override
    public boolean supports(Object objectToMatch, Operation operation) {
        return objectToMatch instanceof NotifyServiceEntity && operation.getOp().trim().equalsIgnoreCase("replace") && operation.getPath().trim().toLowerCase().equalsIgnoreCase(OPERATION_PATH);
    }
}

