/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.UUID;
import java.util.function.Consumer;
import org.springframework.http.ResponseCookie;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.DefaultCsrfToken;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.util.WebUtils;

public class DSpaceCsrfTokenRepository
implements CsrfTokenRepository {
    public static final String DEFAULT_CSRF_COOKIE_NAME = "DSPACE-XSRF-COOKIE";
    public static final String DSPACE_CSRF_HEADER_NAME = "DSPACE-XSRF-TOKEN";
    public static final String DEFAULT_CSRF_PARAMETER_NAME = "_csrf";
    public static final String DEFAULT_CSRF_HEADER_NAME = "X-XSRF-TOKEN";
    private static final String CSRF_TOKEN_REMOVED_ATTRIBUTE_NAME = CookieCsrfTokenRepository.class.getName().concat(".REMOVED");
    private String parameterName = "_csrf";
    private String headerName = "X-XSRF-TOKEN";
    private String cookieName = "DSPACE-XSRF-COOKIE";
    private boolean cookieHttpOnly = true;
    private String cookiePath;
    private String cookieDomain;
    private Boolean secure;
    private int cookieMaxAge = -1;
    private Consumer<ResponseCookie.ResponseCookieBuilder> cookieCustomizer = builder -> {};

    public void setCookieCustomizer(Consumer<ResponseCookie.ResponseCookieBuilder> cookieCustomizer) {
        Assert.notNull(cookieCustomizer, (String)"cookieCustomizer must not be null");
        this.cookieCustomizer = cookieCustomizer;
    }

    public CsrfToken generateToken(HttpServletRequest request) {
        return new DefaultCsrfToken(this.headerName, this.parameterName, this.createNewToken());
    }

    public void saveToken(CsrfToken token, HttpServletRequest request, HttpServletResponse response) {
        String tokenValue = token != null ? token.getToken() : "";
        ResponseCookie.ResponseCookieBuilder cookieBuilder = ResponseCookie.from((String)this.cookieName, (String)tokenValue).secure(this.secure != null ? this.secure.booleanValue() : request.isSecure()).path(StringUtils.hasLength((String)this.cookiePath) ? this.cookiePath : this.getRequestContext(request)).maxAge(token != null ? (long)this.cookieMaxAge : 0L).httpOnly(this.cookieHttpOnly).domain(this.cookieDomain).sameSite(request.isSecure() ? "None" : "Lax");
        this.cookieCustomizer.accept(cookieBuilder);
        if (StringUtils.hasLength((String)tokenValue)) {
            response.setHeader(DSPACE_CSRF_HEADER_NAME, tokenValue);
        }
        Cookie cookie = this.mapToCookie(cookieBuilder.build());
        response.addCookie(cookie);
        if (!StringUtils.hasLength((String)tokenValue)) {
            request.setAttribute(CSRF_TOKEN_REMOVED_ATTRIBUTE_NAME, (Object)Boolean.TRUE);
        } else {
            request.removeAttribute(CSRF_TOKEN_REMOVED_ATTRIBUTE_NAME);
        }
    }

    public CsrfToken loadToken(HttpServletRequest request) {
        if (Boolean.TRUE.equals(request.getAttribute(CSRF_TOKEN_REMOVED_ATTRIBUTE_NAME))) {
            return null;
        }
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)request, (String)this.cookieName);
        if (cookie == null) {
            return null;
        }
        String token = cookie.getValue();
        if (!StringUtils.hasLength((String)token)) {
            return null;
        }
        return new DefaultCsrfToken(this.headerName, this.parameterName, token);
    }

    public void setParameterName(String parameterName) {
        Assert.notNull((Object)parameterName, (String)"parameterName cannot be null");
        this.parameterName = parameterName;
    }

    public void setHeaderName(String headerName) {
        Assert.notNull((Object)headerName, (String)"headerName cannot be null");
        this.headerName = headerName;
    }

    public void setCookieName(String cookieName) {
        Assert.notNull((Object)cookieName, (String)"cookieName cannot be null");
        this.cookieName = cookieName;
    }

    @Deprecated
    public void setCookieHttpOnly(boolean cookieHttpOnly) {
        this.cookieHttpOnly = cookieHttpOnly;
    }

    private String getRequestContext(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        return contextPath.length() > 0 ? contextPath : "/";
    }

    public static DSpaceCsrfTokenRepository withHttpOnlyFalse() {
        DSpaceCsrfTokenRepository result = new DSpaceCsrfTokenRepository();
        result.cookieHttpOnly = false;
        return result;
    }

    private String createNewToken() {
        return UUID.randomUUID().toString();
    }

    private Cookie mapToCookie(ResponseCookie responseCookie) {
        Cookie cookie = new Cookie(responseCookie.getName(), responseCookie.getValue());
        cookie.setSecure(responseCookie.isSecure());
        cookie.setPath(responseCookie.getPath());
        cookie.setMaxAge((int)responseCookie.getMaxAge().getSeconds());
        cookie.setHttpOnly(responseCookie.isHttpOnly());
        if (StringUtils.hasLength((String)responseCookie.getDomain())) {
            cookie.setDomain(responseCookie.getDomain());
        }
        if (StringUtils.hasText((String)responseCookie.getSameSite())) {
            cookie.setAttribute("SameSite", responseCookie.getSameSite());
        }
        return cookie;
    }

    public void setCookiePath(String path) {
        this.cookiePath = path;
    }

    public String getCookiePath() {
        return this.cookiePath;
    }

    @Deprecated
    public void setCookieDomain(String cookieDomain) {
        this.cookieDomain = cookieDomain;
    }

    @Deprecated
    public void setSecure(Boolean secure) {
        this.secure = secure;
    }

    @Deprecated
    public void setCookieMaxAge(int cookieMaxAge) {
        Assert.isTrue((cookieMaxAge != 0 ? 1 : 0) != 0, (String)"cookieMaxAge cannot be zero");
        this.cookieMaxAge = cookieMaxAge;
    }
}

