/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.matcher;

import org.dspace.google.GoogleAnalyticsEvent;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public class GoogleAnalyticsEventMatcher
extends TypeSafeMatcher<GoogleAnalyticsEvent> {
    private final Matcher<String> clientIdMatcher;
    private final Matcher<String> userIpMatcher;
    private final Matcher<String> userAgentMatcher;
    private final Matcher<String> documentReferrerMatcher;
    private final Matcher<String> documentPathMatcher;
    private final Matcher<String> documentTitleMatcher;
    private final Matcher<Long> timeMatcher;

    public static GoogleAnalyticsEventMatcher event(String clientId, String userIp, String userAgent, String documentReferrer, String documentPath, String documentTitle) {
        return new GoogleAnalyticsEventMatcher((Matcher<String>)Matchers.is((Object)clientId), (Matcher<String>)Matchers.is((Object)userIp), (Matcher<String>)Matchers.is((Object)userAgent), (Matcher<String>)Matchers.is((Object)documentReferrer), (Matcher<String>)Matchers.is((Object)documentPath), (Matcher<String>)Matchers.is((Object)documentTitle), (Matcher<Long>)Matchers.any(Long.class));
    }

    private GoogleAnalyticsEventMatcher(Matcher<String> clientIdMatcher, Matcher<String> userIpMatcher, Matcher<String> userAgentMatcher, Matcher<String> documentReferrerMatcher, Matcher<String> documentPathMatcher, Matcher<String> documentTitleMatcher, Matcher<Long> timeMatcher) {
        this.clientIdMatcher = clientIdMatcher;
        this.userIpMatcher = userIpMatcher;
        this.userAgentMatcher = userAgentMatcher;
        this.documentReferrerMatcher = documentReferrerMatcher;
        this.documentPathMatcher = documentPathMatcher;
        this.documentTitleMatcher = documentTitleMatcher;
        this.timeMatcher = timeMatcher;
    }

    public void describeTo(Description description) {
        description.appendText("a Google Analytics event with the following attributes:").appendText(" client id ").appendDescriptionOf(this.clientIdMatcher).appendText(", user ip address ").appendDescriptionOf(this.userIpMatcher).appendText(", user agent ").appendDescriptionOf(this.userAgentMatcher).appendText(", document referrer ").appendDescriptionOf(this.documentReferrerMatcher).appendText(", document path ").appendDescriptionOf(this.documentPathMatcher).appendText(", document title ").appendDescriptionOf(this.documentTitleMatcher).appendText(" and time ").appendDescriptionOf(this.timeMatcher);
    }

    protected boolean matchesSafely(GoogleAnalyticsEvent event) {
        return this.clientIdMatcher.matches((Object)event.getClientId()) && this.userIpMatcher.matches((Object)event.getUserIp()) && this.userAgentMatcher.matches((Object)event.getUserAgent()) && this.documentReferrerMatcher.matches((Object)event.getDocumentReferrer()) && this.documentPathMatcher.matches((Object)event.getDocumentPath()) && this.documentTitleMatcher.matches((Object)event.getDocumentTitle()) && this.timeMatcher.matches((Object)event.getTime());
    }
}

