/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.oai;

import com.lyncode.xoai.dataprovider.core.XOAIManager;
import com.lyncode.xoai.dataprovider.exceptions.ConfigurationException;
import com.lyncode.xoai.dataprovider.services.api.FilterResolver;
import com.lyncode.xoai.dataprovider.services.api.ResourceResolver;
import com.lyncode.xoai.dataprovider.services.impl.BaseDateProvider;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.Configuration;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.ContextConfiguration;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.content.Community;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.xoai.services.api.EarliestDateResolver;
import org.dspace.xoai.services.api.cache.XOAICacheService;
import org.dspace.xoai.services.api.config.XOAIManagerResolver;
import org.dspace.xoai.services.api.xoai.DSpaceFilterResolver;
import org.hamcrest.Matchers;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

@TestPropertySource(properties={"oai.enabled = true"})
public class OAIpmhIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private ConfigurationService configurationService;
    private final String ROOT_PATH = "/oai/";
    private final String DEFAULT_CONTEXT_PATH = "request";
    private final String DEFAULT_CONTEXT = "/oai/request";
    @MockBean
    private XOAICacheService xoaiCacheService;
    @SpyBean
    private EarliestDateResolver earliestDateResolver;
    private static final BaseDateProvider baseDateProvider = new BaseDateProvider();
    @SpyBean
    private XOAIManagerResolver xoaiManagerResolver;
    @Autowired
    private ResourceResolver resourceResolver;
    @Autowired
    private DSpaceFilterResolver filterResolver;

    @Before
    public void onlyRunIfConfigExists() {
        try {
            Class.forName("org.dspace.app.configuration.OAIWebConfig");
        }
        catch (ClassNotFoundException ce) {
            Assume.assumeNoException((Throwable)ce);
        }
        Mockito.when((Object)this.xoaiCacheService.isActive()).thenReturn((Object)false);
        Mockito.when((Object)this.xoaiCacheService.hasCache(ArgumentMatchers.anyString())).thenReturn((Object)false);
    }

    @Test
    public void requestToRootShouldGiveListOfContextsWithBadRequestError() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/oai/", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest()).andExpect(MockMvcResultMatchers.model().attributeExists(new String[]{"contexts"}));
    }

    @Test
    public void requestForUnknownContextShouldGiveListOfContextsWithBadRequestError() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/oai//nonexistentContext", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest()).andExpect(MockMvcResultMatchers.model().attributeExists(new String[]{"contexts"}));
    }

    @Test
    public void requestForIdentifyWithoutRequiredConfigShouldFail() throws Exception {
        this.configurationService.setProperty("mail.admin", null);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/oai/request", (Object[])new Object[0]).param("verb", new String[]{"Identify"})).andExpect(MockMvcResultMatchers.status().isInternalServerError());
    }

    @Test
    public void requestForIdentifyShouldReturnTheConfiguredValues() throws Exception {
        Date now = new Date();
        Date nowToNearestSecond = DateUtils.round((Date)now, (int)13);
        ((EarliestDateResolver)Mockito.doReturn((Object)nowToNearestSecond).when((Object)this.earliestDateResolver)).getEarliestDate((Context)ArgumentMatchers.any());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/oai/request", (Object[])new Object[0]).param("verb", new String[]{"Identify"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType("text/xml;charset=UTF-8")).andExpect(MockMvcResultMatchers.xpath((String)"OAI-PMH/Identify/description/oai-identifier/scheme", (Object[])new Object[0]).string("oai")).andExpect(MockMvcResultMatchers.xpath((String)"OAI-PMH/Identify/protocolVersion", (Object[])new Object[0]).string("2.0")).andExpect(MockMvcResultMatchers.xpath((String)"OAI-PMH/Identify/repositoryName", (Object[])new Object[0]).string(this.configurationService.getProperty("dspace.name"))).andExpect(MockMvcResultMatchers.xpath((String)"OAI-PMH/Identify/adminEmail", (Object[])new Object[0]).string(this.configurationService.getProperty("mail.admin"))).andExpect(MockMvcResultMatchers.xpath((String)"OAI-PMH/Identify/baseURL", (Object[])new Object[0]).string(this.configurationService.getProperty("oai.url") + "/request")).andExpect(MockMvcResultMatchers.xpath((String)"OAI-PMH/Identify/earliestDatestamp", (Object[])new Object[0]).string(baseDateProvider.format(nowToNearestSecond)));
    }

    @Test
    public void listSetsWithLessSetsThenMaxSetsPerPage() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        CollectionBuilder.createCollection((Context)this.context, (Community)parentCommunity).withName("Child Collection").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/oai/request", (Object[])new Object[0]).param("verb", new String[]{"ListSets"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.xpath((String)"OAI-PMH/responseDate", (Object[])new Object[0]).exists()).andExpect(MockMvcResultMatchers.xpath((String)"OAI-PMH/request/@verb", (Object[])new Object[0]).string("ListSets")).andExpect(MockMvcResultMatchers.xpath((String)"//set", (Object[])new Object[0]).nodeCount(2)).andExpect(MockMvcResultMatchers.xpath((String)"(//set/setSpec)[1]", (Object[])new Object[0]).string(Matchers.startsWith((String)"com_"))).andExpect(MockMvcResultMatchers.xpath((String)"(//set/setName)[1]", (Object[])new Object[0]).string("Parent Community")).andExpect(MockMvcResultMatchers.xpath((String)"(//set/setSpec)[2]", (Object[])new Object[0]).string(Matchers.startsWith((String)"col_"))).andExpect(MockMvcResultMatchers.xpath((String)"(//set/setName)[2]", (Object[])new Object[0]).string("Child Collection")).andExpect(MockMvcResultMatchers.xpath((String)"//resumptionToken", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void listSetsWithMoreSetsThenMaxSetsPerPage() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community firstCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("First Community").build();
        Community secondCommunity = CommunityBuilder.createSubCommunity((Context)this.context, (Community)firstCommunity).withName("Second Community").build();
        CommunityBuilder.createCommunity((Context)this.context).withName("Third Community").build();
        CollectionBuilder.createCollection((Context)this.context, (Community)firstCommunity).withName("First Collection").build();
        CollectionBuilder.createCollection((Context)this.context, (Community)secondCommunity).withName("Second Collection").build();
        this.context.restoreAuthSystemState();
        Configuration xoaiConfig = new Configuration().withMaxListSetsSize(3).withContextConfigurations(new ContextConfiguration[]{new ContextConfiguration("request")});
        ((XOAIManagerResolver)Mockito.doReturn((Object)this.createMockXOAIManager(xoaiConfig)).when((Object)this.xoaiManagerResolver)).getManager();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/oai/request", (Object[])new Object[0]).param("verb", new String[]{"ListSets"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.xpath((String)"OAI-PMH/responseDate", (Object[])new Object[0]).exists()).andExpect(MockMvcResultMatchers.xpath((String)"OAI-PMH/request/@verb", (Object[])new Object[0]).string("ListSets")).andExpect(MockMvcResultMatchers.xpath((String)"//set", (Object[])new Object[0]).nodeCount(3)).andExpect(MockMvcResultMatchers.xpath((String)"//resumptionToken", (Object[])new Object[0]).string("////3")).andExpect(MockMvcResultMatchers.xpath((String)"//resumptionToken/@completeListSize", (Object[])new Object[0]).number(Double.valueOf(5.0)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/oai/request", (Object[])new Object[0]).param("verb", new String[]{"ListSets"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.xpath((String)"OAI-PMH/responseDate", (Object[])new Object[0]).exists()).andExpect(MockMvcResultMatchers.xpath((String)"OAI-PMH/request/@verb", (Object[])new Object[0]).string("ListSets")).andExpect(MockMvcResultMatchers.xpath((String)"//set", (Object[])new Object[0]).nodeCount(3)).andExpect(MockMvcResultMatchers.xpath((String)"//resumptionToken", (Object[])new Object[0]).string("////3")).andExpect(MockMvcResultMatchers.xpath((String)"//resumptionToken/@completeListSize", (Object[])new Object[0]).number(Double.valueOf(5.0)));
    }

    private XOAIManager createMockXOAIManager(Configuration xoaiConfig) throws ConfigurationException {
        return new XOAIManager((FilterResolver)this.filterResolver, this.resourceResolver, xoaiConfig);
    }
}

